/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp.grads;

import java.util.ArrayList;
import java.util.List;
import ucar.nc2.iosp.grads.GradsUtil;

public class GradsDimension {
    public static final String LINEAR = "LINEAR";
    public static final String LEVELS = "LEVELS";
    private String name;
    private int size;
    private String mapping;
    private List<String> levels;
    private double[] levelVals;
    private String unitName = "";

    public GradsDimension(String name, int size, String mapping) {
        this.name = name;
        this.size = size;
        this.mapping = mapping;
        this.levels = new ArrayList<String>();
        if (name.equalsIgnoreCase("XDEF")) {
            this.unitName = "degrees_east";
        } else if (name.equalsIgnoreCase("YDEF")) {
            this.unitName = "degrees_north";
        } else if (name.equalsIgnoreCase("ZDEF")) {
            this.unitName = "hPa";
        }
    }

    protected void addLevel(String level) {
        this.levels.add(level);
    }

    protected List<String> getLevels() {
        return this.levels;
    }

    public String getName() {
        return this.name;
    }

    public int getSize() {
        return this.size;
    }

    public double[] getValues() {
        if (this.levelVals == null) {
            this.levelVals = this.makeLevelValues();
        }
        return this.levelVals;
    }

    public String getUnit() {
        return this.unitName;
    }

    protected void setUnit(String unit) {
        this.unitName = unit;
    }

    public String getType() {
        return this.mapping;
    }

    protected double[] makeLevelValues() {
        if (this.levels == null) {
            return null;
        }
        if (this.levels.size() != this.size) {
            // empty if block
        }
        double[] vals = new double[this.size];
        if (this.mapping.equalsIgnoreCase(LEVELS)) {
            for (int i = 0; i < vals.length; ++i) {
                vals[i] = Double.parseDouble(this.levels.get(i));
            }
        } else if (this.mapping.equalsIgnoreCase(LINEAR)) {
            double start = Double.parseDouble(this.levels.get(0));
            double inc = Double.parseDouble(this.levels.get(1));
            for (int i = 0; i < this.size; ++i) {
                vals[i] = start + (double)i * inc;
            }
        } else if (this.mapping.toLowerCase().startsWith("gaus")) {
            vals = GradsUtil.getGaussianLatitudes(this.mapping, (int)Double.parseDouble(this.levels.get(0)), this.size);
        }
        if (this.name.equals("ZDEF")) {
            for (double val : vals) {
                if (val > 1050.0) {
                    this.unitName = "Pa";
                    break;
                }
                if (!(val < 10.0)) continue;
                this.unitName = "";
                break;
            }
        }
        return vals;
    }

    public String toString() {
        String buf = "Dimension: " + this.name.toUpperCase() + "\n\tSize: " + this.size + "\n\tLevels Size: " + this.levels.size() + "\n\tMappingType: " + this.mapping.toUpperCase() + "\n\tLevels: " + this.levels + "\n\tUnits: " + this.unitName + "\n";
        return buf;
    }
}

