/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp.netcdf3;

import com.google.re2j.Matcher;
import com.google.re2j.Pattern;
import java.io.File;
import java.io.IOException;
import java.nio.channels.WritableByteChannel;
import java.util.Formatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.ma2.Array;
import ucar.ma2.ArrayChar;
import ucar.ma2.ArrayObject;
import ucar.ma2.ArrayStructure;
import ucar.ma2.ArrayStructureBB;
import ucar.ma2.DataType;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.Range;
import ucar.ma2.Section;
import ucar.ma2.StructureData;
import ucar.ma2.StructureMembers;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Structure;
import ucar.nc2.Variable;
import ucar.nc2.constants.DataFormatType;
import ucar.nc2.iosp.AbstractIOServiceProvider;
import ucar.nc2.iosp.IOServiceProviderWriter;
import ucar.nc2.iosp.Layout;
import ucar.nc2.iosp.LayoutRegular;
import ucar.nc2.iosp.LayoutRegularSegmented;
import ucar.nc2.iosp.netcdf3.N3header;
import ucar.nc2.util.CancelTask;
import ucar.nc2.write.NetcdfFileFormat;
import ucar.unidata.io.RandomAccessFile;

@Deprecated
public abstract class N3iosp
extends AbstractIOServiceProvider
implements IOServiceProviderWriter {
    private static Logger log = LoggerFactory.getLogger(N3iosp.class);
    public static final byte NC_FILL_BYTE = -127;
    public static final char NC_FILL_CHAR = '\u0000';
    public static final short NC_FILL_SHORT = -32767;
    public static final int NC_FILL_INT = -2147483647;
    public static final float NC_FILL_FLOAT = 9.96921E36f;
    public static final double NC_FILL_DOUBLE = (double)9.96921E36f;
    public static final byte NC_FILL_UBYTE = -1;
    public static final short NC_FILL_USHORT = -1;
    public static final int NC_FILL_UINT = -1;
    public static final long NC_FILL_INT64 = -9223372036854775806L;
    public static final long NC_FILL_UINT64 = -2L;
    public static final String NC_FILL_STRING = "";
    public static final long MAX_VARSIZE = 0xFFFFFFFCL;
    public static final int MAX_NUMRECS = Integer.MAX_VALUE;
    private static final String NC_FORMATX_NC3 = String.valueOf(NetcdfFileFormat.NETCDF3.version());
    private static boolean syncExtendOnly;
    private static final Pattern objectNamePatternOld;
    private static final Pattern objectNamePattern;
    protected boolean readonly;
    protected N3header header;
    protected long lastModified;
    protected boolean debug;
    protected boolean debugSize;
    protected boolean debugSPIO;
    protected boolean debugRecord;
    protected boolean debugRead;
    protected boolean showHeaderBytes;
    protected boolean useRecordStructure;
    protected boolean fill = true;

    public static Number getFillValueDefault(DataType dtype) {
        if (dtype == DataType.BYTE || dtype == DataType.ENUM1) {
            return (byte)-127;
        }
        if (dtype == DataType.UBYTE) {
            return (byte)-1;
        }
        if (dtype == DataType.CHAR) {
            return (byte)0;
        }
        if (dtype == DataType.SHORT || dtype == DataType.ENUM2) {
            return (short)-32767;
        }
        if (dtype == DataType.USHORT) {
            return (short)-1;
        }
        if (dtype == DataType.INT || dtype == DataType.ENUM4) {
            return -2147483647;
        }
        if (dtype == DataType.UINT) {
            return -1;
        }
        if (dtype == DataType.LONG) {
            return -9223372036854775806L;
        }
        if (dtype == DataType.ULONG) {
            return -2L;
        }
        if (dtype == DataType.FLOAT) {
            return Float.valueOf(9.96921E36f);
        }
        if (dtype == DataType.DOUBLE) {
            return (double)9.96921E36f;
        }
        return null;
    }

    public static void setProperty(String name, String value) {
        if (name.equalsIgnoreCase("syncExtendOnly")) {
            syncExtendOnly = value.equalsIgnoreCase("true");
        }
    }

    public static boolean isValidNetcdfObjectName(String name) {
        if (name == null || name.isEmpty()) {
            return false;
        }
        int cp = name.codePointAt(0);
        if (!(cp > 127 || 65 <= cp && cp <= 90 || 97 <= cp && cp <= 122 || 48 <= cp && cp <= 57 || cp == 95)) {
            return false;
        }
        for (int i = 1; i < name.length(); ++i) {
            cp = name.codePointAt(i);
            if (cp > 127 || cp >= 32 && cp <= 126 && cp != 47) continue;
            return false;
        }
        return cp > 127 || !Character.isWhitespace(cp);
    }

    public static String makeValidNetcdfObjectName(String name) {
        int cp;
        StringBuilder sb = new StringBuilder(name);
        while (!(sb.length() <= 0 || (cp = sb.codePointAt(0)) > 127 || 65 <= cp && cp <= 90 || 97 <= cp && cp <= 122 || 48 <= cp && cp <= 57 || cp == 95)) {
            sb.deleteCharAt(0);
        }
        for (int pos = 1; pos < sb.length(); ++pos) {
            int cp2 = sb.codePointAt(pos);
            if (cp2 > 127 || cp2 >= 32 && cp2 <= 126 && cp2 != 47) continue;
            sb.deleteCharAt(pos);
            --pos;
        }
        while (sb.length() > 0 && (cp = sb.codePointAt(sb.length() - 1)) <= 127 && Character.isWhitespace(cp)) {
            sb.deleteCharAt(sb.length() - 1);
        }
        if (sb.length() == 0) {
            throw new IllegalArgumentException(String.format("Illegal NetCDF object name: '%s'", name));
        }
        return sb.toString();
    }

    public static String makeValidNetcdf3ObjectName(String name) {
        char c;
        StringBuilder sb = new StringBuilder(name);
        while (sb.length() > 0 && !Character.isLetter(c = sb.charAt(0)) && c != '_') {
            if (Character.isDigit(c)) {
                sb.insert(0, 'N');
                break;
            }
            sb.deleteCharAt(0);
        }
        for (int i = 1; i < sb.length(); ++i) {
            boolean ok;
            char c2 = sb.charAt(i);
            if (c2 == ' ') {
                sb.setCharAt(i, '_');
                continue;
            }
            boolean bl = ok = Character.isLetterOrDigit(c2) || c2 == '-' || c2 == '_';
            if (ok) continue;
            sb.delete(i, i + 1);
            --i;
        }
        return sb.toString();
    }

    public static boolean isValidNetcdf3ObjectName(String name) {
        Matcher m3 = objectNamePatternOld.matcher(name);
        return m3.matches();
    }

    public static Pattern getValidNetcdf3ObjectNamePattern() {
        return objectNamePattern;
    }

    public static String createValidNetcdf3ObjectName(String name) {
        char c;
        StringBuilder sb = new StringBuilder(name);
        while (sb.length() > 0 && !Character.isLetter(c = sb.charAt(0)) && c != '_') {
            if (Character.isDigit(c)) {
                sb.insert(0, 'N');
                break;
            }
            sb.deleteCharAt(0);
        }
        for (int i = 1; i < sb.length(); ++i) {
            boolean ok;
            char c2 = sb.charAt(i);
            if (c2 == ' ' || c2 == '/') {
                sb.setCharAt(i, '_');
                continue;
            }
            boolean bl = ok = Character.isLetterOrDigit(c2) || c2 == '-' || c2 == '_' || c2 == '@' || c2 == ':' || c2 == '(' || c2 == ')' || c2 == '+' || c2 == '.';
            if (ok) continue;
            sb.delete(i, i + 1);
            --i;
        }
        return sb.toString();
    }

    @Override
    public boolean isValidFile(RandomAccessFile raf) throws IOException {
        return N3header.isValidFile(raf);
    }

    @Override
    public String getDetailInfo() {
        Formatter f = new Formatter();
        f.format("%s", super.getDetailInfo());
        try {
            this.header.showDetail(f);
        }
        catch (IOException e) {
            return e.getMessage();
        }
        return f.toString();
    }

    @Override
    public void openForWriting(RandomAccessFile raf, NetcdfFile ncfile, CancelTask cancelTask) throws IOException {
        this.open(raf, ncfile, cancelTask);
    }

    @Override
    public void open(RandomAccessFile raf, NetcdfFile ncfile, CancelTask cancelTask) throws IOException {
        File file;
        super.open(raf, ncfile, cancelTask);
        String location = raf.getLocation();
        if (!location.startsWith("http:") && (file = new File(location)).exists()) {
            this.lastModified = file.lastModified();
        }
        raf.order(0);
        this.header = new N3header();
        this.header.read(raf, ncfile, null);
        this._open(raf);
        ncfile.finish();
    }

    @Override
    public void setFill(boolean fill) {
        this.fill = fill;
    }

    @Override
    public Array readData(Variable v2, Section section) throws IOException, InvalidRangeException {
        Layout layout;
        if (v2 instanceof Structure) {
            return this.readRecordData((Structure)v2, section);
        }
        N3header.Vinfo vinfo = (N3header.Vinfo)v2.getSPobject();
        DataType dataType = v2.getDataType();
        Layout layout2 = layout = !v2.isUnlimited() ? new LayoutRegular(vinfo.begin, v2.getElementSize(), v2.getShape(), section) : new LayoutRegularSegmented(vinfo.begin, v2.getElementSize(), this.header.recsize, v2.getShape(), section);
        if (layout.getTotalNelems() == 0L) {
            return Array.factory(dataType, section.getShape());
        }
        Object data = this.readData(layout, dataType);
        return Array.factory(dataType, section.getShape(), data);
    }

    private Array readRecordData(Structure s2, Section section) throws IOException {
        Range recordRange = section.getRange(0);
        StructureMembers members = s2.makeStructureMembers();
        for (StructureMembers.Member m3 : members.getMembers()) {
            Variable v2 = s2.findVariable(m3.getName());
            N3header.Vinfo vinfo = (N3header.Vinfo)v2.getSPobject();
            m3.setDataParam((int)(vinfo.begin - this.header.recStart));
        }
        if (this.header.recsize > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Cant read records when recsize > 2147483647");
        }
        long nrecs = section.computeSize();
        if (nrecs * this.header.recsize > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Too large read: nrecs * recsize= " + nrecs * this.header.recsize + "bytes exceeds " + Integer.MAX_VALUE);
        }
        members.setStructureSize((int)this.header.recsize);
        ArrayStructureBB structureArray = new ArrayStructureBB(members, new int[]{recordRange.length()});
        byte[] result = structureArray.getByteBuffer().array();
        int count = 0;
        for (int recnum : recordRange) {
            if (this.debugRecord) {
                System.out.println(" read record " + recnum);
            }
            this.raf.seek(this.header.recStart + (long)recnum * this.header.recsize);
            if (recnum != this.header.numrecs - 1) {
                this.raf.readFully(result, (int)((long)count * this.header.recsize), (int)this.header.recsize);
            } else {
                this.raf.read(result, (int)((long)count * this.header.recsize), (int)this.header.recsize);
            }
            ++count;
        }
        return structureArray;
    }

    private Array readRecordDataSubset(Structure s2, Section section) {
        Range recordRange = section.getRange(0);
        int nrecords = recordRange.length();
        StructureMembers members = s2.makeStructureMembers();
        for (StructureMembers.Member m3 : members.getMembers()) {
            Variable v2 = s2.findVariable(m3.getName());
            N3header.Vinfo vinfo = (N3header.Vinfo)v2.getSPobject();
            m3.setDataParam((int)(vinfo.begin - this.header.recStart));
            int rank = m3.getShape().length;
            int[] fullShape = new int[rank + 1];
            fullShape[0] = nrecords;
            System.arraycopy(m3.getShape(), 0, fullShape, 1, rank);
            Array data = Array.factory(m3.getDataType(), fullShape);
            m3.setDataArray(data);
            m3.setDataObject(data.getIndexIterator());
        }
        return null;
    }

    private Array readNestedData(Variable v2, Section section) throws IOException, InvalidRangeException {
        N3header.Vinfo vinfo = (N3header.Vinfo)v2.getSPobject();
        DataType dataType = v2.getDataType();
        int[] fullShape = new int[v2.getRank() + 1];
        fullShape[0] = this.header.numrecs;
        System.arraycopy(v2.getShape(), 0, fullShape, 1, v2.getRank());
        LayoutRegularSegmented layout = new LayoutRegularSegmented(vinfo.begin, v2.getElementSize(), this.header.recsize, fullShape, section);
        Object dataObject = this.readData(layout, dataType);
        return Array.factory(dataType, section.getShape(), dataObject);
    }

    @Override
    public long readToByteChannel(Variable v2, Section section, WritableByteChannel channel) throws IOException, InvalidRangeException {
        if (v2 instanceof Structure) {
            return this.readRecordData((Structure)v2, section, channel);
        }
        N3header.Vinfo vinfo = (N3header.Vinfo)v2.getSPobject();
        DataType dataType = v2.getDataType();
        Layout layout = !v2.isUnlimited() ? new LayoutRegular(vinfo.begin, v2.getElementSize(), v2.getShape(), section) : new LayoutRegularSegmented(vinfo.begin, v2.getElementSize(), this.header.recsize, v2.getShape(), section);
        return this.readData(layout, dataType, channel);
    }

    private long readRecordData(Structure s2, Section section, WritableByteChannel out) throws IOException {
        long count = 0L;
        Range recordRange = section.getRange(0);
        for (int recnum : recordRange) {
            if (this.debugRecord) {
                System.out.println(" read record " + recnum);
            }
            this.raf.seek(this.header.recStart + (long)recnum * this.header.recsize);
            count += this.raf.readToByteChannel(out, this.header.recStart + (long)recnum * this.header.recsize, this.header.recsize);
        }
        return count;
    }

    @Override
    public void create(String filename, NetcdfFile ncfile, int extra, long preallocateSize, boolean largeFile) throws IOException {
        this.ncfile = ncfile;
        this.readonly = false;
        ncfile.finish();
        this.raf = new RandomAccessFile(filename, "rw");
        this.raf.order(0);
        if (preallocateSize > 0L) {
            java.io.RandomAccessFile myRaf = this.raf.getRandomAccessFile();
            myRaf.setLength(preallocateSize);
        }
        this.header = new N3header();
        this.header.create(this.raf, ncfile, extra, largeFile, null);
        this._create(this.raf);
        if (this.fill) {
            this.fillNonRecordVariables();
        }
    }

    @Override
    public boolean rewriteHeader(boolean largeFile) throws IOException {
        return this.header.rewriteHeader(largeFile, null);
    }

    @Override
    public void writeData(Variable v2, Section section, Array values) throws IOException, InvalidRangeException {
        N3header.Vinfo vinfo = (N3header.Vinfo)v2.getSPobject();
        DataType dataType = v2.getDataType();
        if (v2.isUnlimited()) {
            Range firstRange = section.getRange(0);
            this.setNumrecs(firstRange.last() + 1);
        }
        if (v2 instanceof Structure) {
            if (!(values instanceof ArrayStructure)) {
                throw new IllegalArgumentException("writeData for Structure: data must be ArrayStructure");
            }
            if (v2.getRank() == 0) {
                throw new IllegalArgumentException("writeData for Structure: must have rank > 0");
            }
            Dimension d = v2.getDimension(0);
            if (!d.isUnlimited()) {
                throw new IllegalArgumentException("writeData for Structure: must have unlimited dimension");
            }
            this.writeRecordData((Structure)v2, section, (ArrayStructure)values);
        } else {
            Layout layout = !v2.isUnlimited() ? new LayoutRegular(vinfo.begin, v2.getElementSize(), v2.getShape(), section) : new LayoutRegularSegmented(vinfo.begin, v2.getElementSize(), this.header.recsize, v2.getShape(), section);
            this.writeData(values, layout, dataType);
        }
    }

    @Override
    public int appendStructureData(Structure s2, StructureData sdata) throws IOException, InvalidRangeException {
        int recnum = this.header.numrecs;
        this.setNumrecs(recnum + 1);
        this.writeRecordData(s2, recnum, sdata);
        return recnum;
    }

    private void writeRecordData(Structure s2, Section section, ArrayStructure structureArray) throws IOException, InvalidRangeException {
        int countSrcRecnum = 0;
        Range recordRange = section.getRange(0);
        for (int recnum : recordRange) {
            StructureData sdata = structureArray.getStructureData(countSrcRecnum);
            this.writeRecordData(s2, recnum, sdata);
            ++countSrcRecnum;
        }
    }

    private void writeRecordData(Structure s2, int recnum, StructureData sdata) throws IOException, InvalidRangeException {
        StructureMembers members = sdata.getStructureMembers();
        for (Variable vm : s2.getVariables()) {
            StructureMembers.Member m3 = members.findMember(vm.getShortName());
            if (null == m3) continue;
            Array data = sdata.getArray(m3);
            if (data instanceof ArrayObject && vm.getDataType() == DataType.CHAR && vm.getRank() > 0) {
                int strlen = vm.getShape(vm.getRank() - 1);
                data = ArrayChar.makeFromStringArray((ArrayObject)data, strlen);
            }
            N3header.Vinfo vinfo = (N3header.Vinfo)vm.getSPobject();
            long begin = vinfo.begin + (long)recnum * this.header.recsize;
            Section memberSection = vm.getShapeAsSection();
            LayoutRegular layout = new LayoutRegular(begin, vm.getElementSize(), vm.getShape(), memberSection);
            try {
                this.writeData(data, layout, vm.getDataType());
            }
            catch (Exception e) {
                log.error("Error writing member=" + vm.getShortName() + " in struct=" + s2.getFullName(), e);
                throw new IOException(e);
            }
        }
    }

    protected void setNumrecs(int n) throws IOException, InvalidRangeException {
        if (n <= this.header.numrecs) {
            return;
        }
        int startRec = this.header.numrecs;
        if (this.debugSize) {
            System.out.println("extend records to = " + n);
        }
        this.header.setNumrecs(n);
        for (Dimension dim : this.ncfile.getDimensions()) {
            if (!dim.isUnlimited()) continue;
            dim.setLength(n);
        }
        for (Variable v : this.ncfile.getVariables()) {
            if (!v.isUnlimited()) continue;
            v.resetShape();
            v.setCachedData(null, false);
        }
        if (this.fill) {
            this.fillRecordVariables(startRec, n);
        } else {
            this.raf.setMinLength(this.header.calcFileSize());
        }
    }

    @Override
    public void updateAttribute(Variable v2, Attribute att) throws IOException {
        this.header.updateAttribute(v2, att);
    }

    protected void fillNonRecordVariables() throws IOException {
        for (Variable v : this.ncfile.getVariables()) {
            if (v.isUnlimited()) continue;
            try {
                this.writeData(v, v.getShapeAsSection(), this.makeConstantArray(v));
            }
            catch (InvalidRangeException e) {
                e.printStackTrace();
            }
        }
    }

    protected void fillRecordVariables(int recStart, int recEnd) throws IOException, InvalidRangeException {
        for (int i = recStart; i < recEnd; ++i) {
            Range r = new Range(i, i);
            for (Variable v : this.ncfile.getVariables()) {
                if (!v.isUnlimited() || v instanceof Structure) continue;
                Section.Builder recordSection = Section.builder().appendRanges(v.getRanges());
                recordSection.setRange(0, r);
                this.writeData(v, recordSection.build(), this.makeConstantArray(v));
            }
        }
    }

    private Array makeConstantArray(Variable v) {
        Class classType = v.getDataType().getPrimitiveClassType();
        Attribute att = v.findAttribute("_FillValue");
        Object[] storage = null;
        if (classType == Double.TYPE) {
            double[] storageP = new double[]{att == null ? (double)9.96921E36f : att.getNumericValue().doubleValue()};
            storage = storageP;
        } else if (classType == Float.TYPE) {
            float[] storageP = new float[]{att == null ? 9.96921E36f : att.getNumericValue().floatValue()};
            storage = storageP;
        } else if (classType == Integer.TYPE) {
            int[] storageP = new int[]{att == null ? -2147483647 : att.getNumericValue().intValue()};
            storage = storageP;
        } else if (classType == Short.TYPE) {
            short[] storageP = new short[]{att == null ? (short)-32767 : (short)att.getNumericValue().shortValue()};
            storage = storageP;
        } else if (classType == Byte.TYPE) {
            byte[] storageP = new byte[]{att == null ? (byte)-127 : (byte)att.getNumericValue().byteValue()};
            storage = storageP;
        } else if (classType == Character.TYPE) {
            char[] storageP = new char[]{att != null && !att.getStringValue().isEmpty() ? att.getStringValue().charAt(0) : (char)'\u0000'};
            storage = storageP;
        }
        return Array.factoryConstant(v.getDataType(), v.getShape(), storage);
    }

    @Override
    public boolean syncExtend() throws IOException {
        boolean result = this.header.synchNumrecs();
        if (result && log.isDebugEnabled()) {
            log.debug(" N3iosp syncExtend " + this.raf.getLocation() + " numrecs =" + this.header.numrecs);
        }
        return result;
    }

    @Override
    public void flush() throws IOException {
        if (this.raf != null) {
            this.raf.flush();
            this.header.writeNumrecs();
            this.raf.flush();
        }
    }

    @Override
    public void close() throws IOException {
        if (this.raf != null) {
            long size = this.header.calcFileSize();
            this.raf.setMinLength(size);
            this.raf.close();
        }
        this.raf = null;
    }

    @Override
    public void reacquire() throws IOException {
        super.reacquire();
        this.header.raf = this.raf;
    }

    @Override
    public String toStringDebug(Object o) {
        return null;
    }

    @Override
    public Object sendIospMessage(Object message) {
        if (null == this.header) {
            return null;
        }
        if (message == "AddRecordStructure") {
            return this.header.makeRecordStructure();
        }
        if (message == "RemoveRecordStructure") {
            return this.header.removeRecordStructure();
        }
        if (message.equals("NetcdfFileFormat")) {
            return this.header.useLongOffset ? NetcdfFileFormat.NETCDF3_64BIT_OFFSET : NetcdfFileFormat.NETCDF3;
        }
        return super.sendIospMessage(message);
    }

    @Override
    public String getFileTypeId() {
        return DataFormatType.NETCDF.getDescription();
    }

    @Override
    public String getFileTypeDescription() {
        return "NetCDF-3/CDM";
    }

    @Override
    public String getFileTypeVersion() {
        return NC_FORMATX_NC3;
    }

    protected abstract Object readData(Layout var1, DataType var2) throws IOException;

    protected abstract long readData(Layout var1, DataType var2, WritableByteChannel var3) throws IOException;

    protected abstract void writeData(Array var1, Layout var2, DataType var3) throws IOException;

    protected abstract void _open(RandomAccessFile var1);

    protected abstract void _create(RandomAccessFile var1);

    static {
        objectNamePatternOld = Pattern.compile("[a-zA-Z0-9_][a-zA-Z0-9_@\\:\\(\\)\\.\\-\\+]*");
        objectNamePattern = Pattern.compile("[a-zA-Z0-9_][^\\x00-\\x1F\\x2F\\x7F]*");
    }
}

