/*
 * Decompiled with CFR 0.152.
 */
package opendap.dap;

import java.io.Serializable;

public class ServerVersion
implements Serializable {
    static final long serialVersionUID = 1L;
    private int major;
    private int minor;
    private String versionString;

    public ServerVersion(String ver) {
        int dotIndex;
        this.versionString = ver;
        this.minor = 0;
        this.major = 0;
        int verIndex = ver.indexOf("/");
        if (verIndex != -1 && (dotIndex = ver.indexOf(46, ++verIndex)) != -1) {
            String majorString = ver.substring(verIndex, dotIndex);
            this.major = Integer.parseInt(majorString);
            String minorString = ver.substring(dotIndex + 1);
            int minorDotIndex = minorString.indexOf(46);
            this.minor = minorDotIndex != -1 ? Integer.parseInt(minorString.substring(0, minorDotIndex)) : Integer.parseInt(minorString);
        }
    }

    public ServerVersion(int major, int minor) {
        this.versionString = "DODS/" + major + "." + minor;
        this.major = major;
        this.minor = minor;
    }

    public final int getMajor() {
        return this.major;
    }

    public final int getMinor() {
        return this.minor;
    }

    public final String toString() {
        return this.versionString;
    }

    public static String getCurrentVersion() {
        return "DODS/2.18";
    }
}

