/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.pds.label.jaxb;

import com.sun.xml.bind.marshaller.NamespacePrefixMapper;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.io.IOUtils;

public class PDSNamespacePrefixMapper
extends NamespacePrefixMapper {
    public static final String FILE = "namespaces.properties";
    private String defaultNamespaceURI;
    private Map<String, String> namespaceURIMapping = new LinkedHashMap<String, String>();

    public PDSNamespacePrefixMapper() throws IOException {
        Properties properties = this.parseProperties();
        for (Object key : properties.keySet()) {
            this.namespaceURIMapping.put(key.toString(), properties.get(key).toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties parseProperties() throws IOException {
        URL propertyFile = PDSNamespacePrefixMapper.class.getResource(FILE);
        if (propertyFile == null) {
            throw new IOException("namespaces.properties could not be found.");
        }
        InputStream inputStream = null;
        Properties properties = new Properties();
        try {
            inputStream = propertyFile.openStream();
            properties.load(inputStream);
        }
        finally {
            IOUtils.closeQuietly((InputStream)inputStream);
        }
        return properties;
    }

    public void setDefaultNamespaceURI(String defaultNamespaceURI) {
        this.defaultNamespaceURI = defaultNamespaceURI;
    }

    public String getDefaultNamespaceURI() {
        return this.defaultNamespaceURI;
    }

    public void addNamespaceURIMapping(String prefix, String URI2) {
        this.namespaceURIMapping.put(prefix, URI2);
    }

    public String getPreferredPrefix(String namespaceUri, String suggestion, boolean requirePrefix) {
        if (namespaceUri.equalsIgnoreCase(this.defaultNamespaceURI)) {
            return "";
        }
        for (Map.Entry<String, String> entry : this.namespaceURIMapping.entrySet()) {
            if (!entry.getValue().equals(namespaceUri)) continue;
            return entry.getKey();
        }
        return null;
    }
}

