/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record.formula.functions;

import org.apache.poi.hssf.record.formula.eval.BlankEval;
import org.apache.poi.hssf.record.formula.eval.ErrorEval;
import org.apache.poi.hssf.record.formula.eval.Eval;
import org.apache.poi.hssf.record.formula.eval.NumberEval;
import org.apache.poi.hssf.record.formula.eval.NumericValueEval;
import org.apache.poi.hssf.record.formula.eval.ValueEval;
import org.apache.poi.hssf.record.formula.functions.NumericFunction;

public class Odd
extends NumericFunction {
    public Eval evaluate(Eval[] operands, int srcRow, short srcCol) {
        double d = 0.0;
        ErrorEval retval = null;
        switch (operands.length) {
            default: {
                retval = ErrorEval.VALUE_INVALID;
                break;
            }
            case 1: {
                ValueEval ve = this.singleOperandEvaluate(operands[0], srcRow, srcCol);
                if (ve instanceof NumericValueEval) {
                    NumericValueEval ne = (NumericValueEval)ve;
                    d = ne.getNumberValue();
                    break;
                }
                if (ve instanceof BlankEval) break;
                retval = ErrorEval.NUM_ERROR;
            }
        }
        if (retval == null) {
            if (!Double.isNaN(d) && !Double.isInfinite(d)) {
                d = d == 0.0 ? 1.0 : (((long)d - 1L) % 2L == 0L ? d : (d < 0.0 ? (double)(((long)(d / 2.0) << 1) - 1L) : (double)(((long)(d / 2.0) << 1) + 1L)));
            }
            retval = Double.isNaN(d) || Double.isInfinite(d) ? ErrorEval.VALUE_INVALID : new NumberEval(d);
        }
        return retval;
    }
}

