/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hwpf.model;

import org.apache.poi.util.BitField;
import org.apache.poi.util.BitFieldFactory;
import org.apache.poi.util.LittleEndian;

public class FSPA {
    public static final int FSPA_SIZE = 26;
    private int spid;
    private int xaLeft;
    private int yaTop;
    private int xaRight;
    private int yaBottom;
    private short options;
    private static BitField fHdr = BitFieldFactory.getInstance((int)1);
    private static BitField bx = BitFieldFactory.getInstance((int)6);
    private static BitField by = BitFieldFactory.getInstance((int)24);
    private static BitField wr = BitFieldFactory.getInstance((int)480);
    private static BitField wrk = BitFieldFactory.getInstance((int)7680);
    private static BitField fRcaSimple = BitFieldFactory.getInstance((int)8192);
    private static BitField fBelowText = BitFieldFactory.getInstance((int)16384);
    private static BitField fAnchorLock = BitFieldFactory.getInstance((int)32768);
    private int cTxbx;

    public FSPA() {
    }

    public FSPA(byte[] bytes, int offset) {
        this.spid = LittleEndian.getInt((byte[])bytes, (int)offset);
        this.xaLeft = LittleEndian.getInt((byte[])bytes, (int)(offset += 4));
        this.yaTop = LittleEndian.getInt((byte[])bytes, (int)(offset += 4));
        this.xaRight = LittleEndian.getInt((byte[])bytes, (int)(offset += 4));
        this.yaBottom = LittleEndian.getInt((byte[])bytes, (int)(offset += 4));
        this.options = LittleEndian.getShort((byte[])bytes, (int)(offset += 4));
        this.cTxbx = LittleEndian.getInt((byte[])bytes, (int)(offset += 2));
    }

    public int getSpid() {
        return this.spid;
    }

    public int getXaLeft() {
        return this.xaLeft;
    }

    public int getYaTop() {
        return this.yaTop;
    }

    public int getXaRight() {
        return this.xaRight;
    }

    public int getYaBottom() {
        return this.yaBottom;
    }

    public boolean isFHdr() {
        return fHdr.isSet((int)this.options);
    }

    public short getBx() {
        return bx.getShortValue(this.options);
    }

    public short getBy() {
        return by.getShortValue(this.options);
    }

    public short getWr() {
        return wr.getShortValue(this.options);
    }

    public short getWrk() {
        return wrk.getShortValue(this.options);
    }

    public boolean isFRcaSimple() {
        return fRcaSimple.isSet((int)this.options);
    }

    public boolean isFBelowText() {
        return fBelowText.isSet((int)this.options);
    }

    public boolean isFAnchorLock() {
        return fAnchorLock.isSet((int)this.options);
    }

    public int getCTxbx() {
        return this.cTxbx;
    }

    public byte[] toByteArray() {
        int offset = 0;
        byte[] buf = new byte[26];
        LittleEndian.putInt((byte[])buf, (int)offset, (int)this.spid);
        LittleEndian.putInt((byte[])buf, (int)(offset += 4), (int)this.xaLeft);
        LittleEndian.putInt((byte[])buf, (int)(offset += 4), (int)this.yaTop);
        LittleEndian.putInt((byte[])buf, (int)(offset += 4), (int)this.xaRight);
        LittleEndian.putInt((byte[])buf, (int)(offset += 4), (int)this.yaBottom);
        LittleEndian.putShort((byte[])buf, (int)(offset += 4), (short)this.options);
        LittleEndian.putInt((byte[])buf, (int)(offset += 2), (int)this.cTxbx);
        offset += 4;
        return buf;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("spid: ").append(this.spid);
        buf.append(", xaLeft: ").append(this.xaLeft);
        buf.append(", yaTop: ").append(this.yaTop);
        buf.append(", xaRight: ").append(this.xaRight);
        buf.append(", yaBottom: ").append(this.yaBottom);
        buf.append(", options: ").append(this.options);
        buf.append(" (fHdr: ").append(this.isFHdr());
        buf.append(", bx: ").append(this.getBx());
        buf.append(", by: ").append(this.getBy());
        buf.append(", wr: ").append(this.getWr());
        buf.append(", wrk: ").append(this.getWrk());
        buf.append(", fRcaSimple: ").append(this.isFRcaSimple());
        buf.append(", fBelowText: ").append(this.isFBelowText());
        buf.append(", fAnchorLock: ").append(this.isFAnchorLock());
        buf.append("), cTxbx: ").append(this.cTxbx);
        return buf.toString();
    }
}

