/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.attribute.annotation.visitor;

import proguard.classfile.Clazz;
import proguard.classfile.Field;
import proguard.classfile.Method;
import proguard.classfile.attribute.annotation.Annotation;
import proguard.classfile.attribute.annotation.visitor.AnnotationVisitor;
import proguard.classfile.util.SimplifiedVisitor;
import proguard.util.ClassNameParser;
import proguard.util.ListParser;
import proguard.util.StringMatcher;

public class AnnotationTypeFilter
extends SimplifiedVisitor
implements AnnotationVisitor {
    private final StringMatcher regularExpressionMatcher;
    private final AnnotationVisitor annotationVisitor;

    public AnnotationTypeFilter(String string, AnnotationVisitor annotationVisitor) {
        this.regularExpressionMatcher = new ListParser(new ClassNameParser()).parse(string);
        this.annotationVisitor = annotationVisitor;
    }

    @Override
    public void visitAnnotation(Clazz clazz, Annotation annotation) {
        if (this.accepted(annotation.getType(clazz))) {
            this.annotationVisitor.visitAnnotation(clazz, annotation);
        }
    }

    @Override
    public void visitAnnotation(Clazz clazz, Field field, Annotation annotation) {
        if (this.accepted(annotation.getType(clazz))) {
            this.annotationVisitor.visitAnnotation(clazz, field, annotation);
        }
    }

    @Override
    public void visitAnnotation(Clazz clazz, Method method, Annotation annotation) {
        if (this.accepted(annotation.getType(clazz))) {
            this.annotationVisitor.visitAnnotation(clazz, method, annotation);
        }
    }

    @Override
    public void visitAnnotation(Clazz clazz, Method method, int n, Annotation annotation) {
        if (this.accepted(annotation.getType(clazz))) {
            this.annotationVisitor.visitAnnotation(clazz, method, n, annotation);
        }
    }

    private boolean accepted(String string) {
        return this.regularExpressionMatcher.matches(string);
    }
}

