/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.editor;

import proguard.classfile.Clazz;
import proguard.classfile.Field;
import proguard.classfile.Method;
import proguard.classfile.ProgramClass;
import proguard.classfile.ProgramMember;
import proguard.classfile.attribute.Attribute;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.attribute.ConstantValueAttribute;
import proguard.classfile.attribute.DeprecatedAttribute;
import proguard.classfile.attribute.EnclosingMethodAttribute;
import proguard.classfile.attribute.ExceptionInfo;
import proguard.classfile.attribute.ExceptionsAttribute;
import proguard.classfile.attribute.InnerClassesAttribute;
import proguard.classfile.attribute.LineNumberTableAttribute;
import proguard.classfile.attribute.LocalVariableTableAttribute;
import proguard.classfile.attribute.LocalVariableTypeTableAttribute;
import proguard.classfile.attribute.SignatureAttribute;
import proguard.classfile.attribute.SourceDirAttribute;
import proguard.classfile.attribute.SourceFileAttribute;
import proguard.classfile.attribute.SyntheticAttribute;
import proguard.classfile.attribute.UnknownAttribute;
import proguard.classfile.attribute.annotation.Annotation;
import proguard.classfile.attribute.annotation.AnnotationDefaultAttribute;
import proguard.classfile.attribute.annotation.RuntimeInvisibleAnnotationsAttribute;
import proguard.classfile.attribute.annotation.RuntimeInvisibleParameterAnnotationsAttribute;
import proguard.classfile.attribute.annotation.RuntimeVisibleAnnotationsAttribute;
import proguard.classfile.attribute.annotation.RuntimeVisibleParameterAnnotationsAttribute;
import proguard.classfile.attribute.preverification.StackMapAttribute;
import proguard.classfile.attribute.preverification.StackMapTableAttribute;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.editor.AnnotationAdder;
import proguard.classfile.editor.AttributesEditor;
import proguard.classfile.editor.CodeAttributeComposer;
import proguard.classfile.editor.ConstantAdder;
import proguard.classfile.editor.ElementValueAdder;
import proguard.classfile.editor.ExceptionAdder;
import proguard.classfile.editor.ExceptionInfoAdder;
import proguard.classfile.editor.InstructionAdder;
import proguard.classfile.util.SimplifiedVisitor;

public class AttributeAdder
extends SimplifiedVisitor
implements AttributeVisitor {
    private static final byte[] EMPTY_BYTES = new byte[0];
    private static final int[] EMPTY_INTS = new int[0];
    private static final Attribute[] EMPTY_ATTRIBUTES = new Attribute[0];
    private static final ExceptionInfo[] EMPTY_EXCEPTIONS = new ExceptionInfo[0];
    private final ProgramClass targetClass;
    private final ProgramMember targetMember;
    private final CodeAttribute targetCodeAttribute;
    private final boolean replaceAttributes;
    private final ConstantAdder constantAdder;
    private final AttributesEditor attributesEditor;

    public AttributeAdder(ProgramClass programClass, boolean bl) {
        this(programClass, null, null, bl);
    }

    public AttributeAdder(ProgramClass programClass, ProgramMember programMember, boolean bl) {
        this(programClass, programMember, null, bl);
    }

    public AttributeAdder(ProgramClass programClass, ProgramMember programMember, CodeAttribute codeAttribute, boolean bl) {
        this.targetClass = programClass;
        this.targetMember = programMember;
        this.targetCodeAttribute = codeAttribute;
        this.replaceAttributes = bl;
        this.constantAdder = new ConstantAdder(programClass);
        this.attributesEditor = new AttributesEditor(programClass, programMember, codeAttribute, bl);
    }

    @Override
    public void visitUnknownAttribute(Clazz clazz, UnknownAttribute unknownAttribute) {
        UnknownAttribute unknownAttribute2 = new UnknownAttribute(this.constantAdder.addConstant(clazz, unknownAttribute.u2attributeNameIndex), unknownAttribute.u4attributeLength, unknownAttribute.info);
        this.attributesEditor.addAttribute(unknownAttribute2);
    }

    @Override
    public void visitSourceFileAttribute(Clazz clazz, SourceFileAttribute sourceFileAttribute) {
        SourceFileAttribute sourceFileAttribute2 = new SourceFileAttribute(this.constantAdder.addConstant(clazz, sourceFileAttribute.u2attributeNameIndex), this.constantAdder.addConstant(clazz, sourceFileAttribute.u2sourceFileIndex));
        this.attributesEditor.addAttribute(sourceFileAttribute2);
    }

    @Override
    public void visitSourceDirAttribute(Clazz clazz, SourceDirAttribute sourceDirAttribute) {
        SourceDirAttribute sourceDirAttribute2 = new SourceDirAttribute(this.constantAdder.addConstant(clazz, sourceDirAttribute.u2attributeNameIndex), this.constantAdder.addConstant(clazz, sourceDirAttribute.u2sourceDirIndex));
        this.attributesEditor.addAttribute(sourceDirAttribute2);
    }

    @Override
    public void visitInnerClassesAttribute(Clazz clazz, InnerClassesAttribute innerClassesAttribute) {
    }

    @Override
    public void visitEnclosingMethodAttribute(Clazz clazz, EnclosingMethodAttribute enclosingMethodAttribute) {
        EnclosingMethodAttribute enclosingMethodAttribute2 = new EnclosingMethodAttribute(this.constantAdder.addConstant(clazz, enclosingMethodAttribute.u2attributeNameIndex), this.constantAdder.addConstant(clazz, enclosingMethodAttribute.u2classIndex), enclosingMethodAttribute.u2nameAndTypeIndex == 0 ? 0 : this.constantAdder.addConstant(clazz, enclosingMethodAttribute.u2nameAndTypeIndex));
        enclosingMethodAttribute2.referencedClass = enclosingMethodAttribute.referencedClass;
        enclosingMethodAttribute2.referencedMethod = enclosingMethodAttribute.referencedMethod;
        this.attributesEditor.addAttribute(enclosingMethodAttribute2);
    }

    @Override
    public void visitDeprecatedAttribute(Clazz clazz, DeprecatedAttribute deprecatedAttribute) {
        DeprecatedAttribute deprecatedAttribute2 = new DeprecatedAttribute(this.constantAdder.addConstant(clazz, deprecatedAttribute.u2attributeNameIndex));
        this.attributesEditor.addAttribute(deprecatedAttribute2);
    }

    @Override
    public void visitSyntheticAttribute(Clazz clazz, SyntheticAttribute syntheticAttribute) {
        SyntheticAttribute syntheticAttribute2 = new SyntheticAttribute(this.constantAdder.addConstant(clazz, syntheticAttribute.u2attributeNameIndex));
        this.attributesEditor.addAttribute(syntheticAttribute2);
    }

    @Override
    public void visitSignatureAttribute(Clazz clazz, SignatureAttribute signatureAttribute) {
        SignatureAttribute signatureAttribute2 = new SignatureAttribute(this.constantAdder.addConstant(clazz, signatureAttribute.u2attributeNameIndex), this.constantAdder.addConstant(clazz, signatureAttribute.u2signatureIndex));
        signatureAttribute2.referencedClasses = signatureAttribute.referencedClasses;
        this.attributesEditor.addAttribute(signatureAttribute2);
    }

    @Override
    public void visitConstantValueAttribute(Clazz clazz, Field field, ConstantValueAttribute constantValueAttribute) {
        ConstantValueAttribute constantValueAttribute2 = new ConstantValueAttribute(this.constantAdder.addConstant(clazz, constantValueAttribute.u2attributeNameIndex), this.constantAdder.addConstant(clazz, constantValueAttribute.u2constantValueIndex));
        this.attributesEditor.addAttribute(constantValueAttribute2);
    }

    @Override
    public void visitExceptionsAttribute(Clazz clazz, Method method, ExceptionsAttribute exceptionsAttribute) {
        ExceptionsAttribute exceptionsAttribute2 = new ExceptionsAttribute(this.constantAdder.addConstant(clazz, exceptionsAttribute.u2attributeNameIndex), 0, exceptionsAttribute.u2exceptionIndexTableLength > 0 ? new int[exceptionsAttribute.u2exceptionIndexTableLength] : EMPTY_INTS);
        exceptionsAttribute.exceptionEntriesAccept((ProgramClass)clazz, new ExceptionAdder(this.targetClass, exceptionsAttribute2));
        this.attributesEditor.addAttribute(exceptionsAttribute2);
    }

    @Override
    public void visitCodeAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute) {
        CodeAttribute codeAttribute2 = new CodeAttribute(this.constantAdder.addConstant(clazz, codeAttribute.u2attributeNameIndex), codeAttribute.u2maxStack, codeAttribute.u2maxLocals, 0, EMPTY_BYTES, 0, codeAttribute.u2exceptionTableLength > 0 ? new ExceptionInfo[codeAttribute.u2exceptionTableLength] : EMPTY_EXCEPTIONS, 0, codeAttribute.u2attributesCount > 0 ? new Attribute[codeAttribute.u2attributesCount] : EMPTY_ATTRIBUTES);
        CodeAttributeComposer codeAttributeComposer = new CodeAttributeComposer();
        codeAttributeComposer.beginCodeFragment(codeAttribute.u4codeLength + 1024);
        codeAttribute.instructionsAccept(clazz, method, new InstructionAdder(this.targetClass, codeAttributeComposer));
        codeAttribute.exceptionsAccept(clazz, method, new ExceptionInfoAdder(this.targetClass, codeAttributeComposer));
        codeAttributeComposer.endCodeFragment();
        codeAttribute.attributesAccept(clazz, method, new AttributeAdder(this.targetClass, this.targetMember, codeAttribute2, this.replaceAttributes));
        codeAttributeComposer.visitCodeAttribute(this.targetClass, (Method)((Object)this.targetMember), codeAttribute2);
        this.attributesEditor.addAttribute(codeAttribute2);
    }

    @Override
    public void visitStackMapAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute, StackMapAttribute stackMapAttribute) {
    }

    @Override
    public void visitStackMapTableAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute, StackMapTableAttribute stackMapTableAttribute) {
    }

    @Override
    public void visitLineNumberTableAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute, LineNumberTableAttribute lineNumberTableAttribute) {
    }

    @Override
    public void visitLocalVariableTableAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute, LocalVariableTableAttribute localVariableTableAttribute) {
    }

    @Override
    public void visitLocalVariableTypeTableAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute, LocalVariableTypeTableAttribute localVariableTypeTableAttribute) {
    }

    @Override
    public void visitRuntimeVisibleAnnotationsAttribute(Clazz clazz, RuntimeVisibleAnnotationsAttribute runtimeVisibleAnnotationsAttribute) {
        RuntimeVisibleAnnotationsAttribute runtimeVisibleAnnotationsAttribute2 = new RuntimeVisibleAnnotationsAttribute(this.constantAdder.addConstant(clazz, runtimeVisibleAnnotationsAttribute.u2attributeNameIndex), 0, new Annotation[runtimeVisibleAnnotationsAttribute.u2annotationsCount]);
        runtimeVisibleAnnotationsAttribute.annotationsAccept(clazz, new AnnotationAdder(this.targetClass, runtimeVisibleAnnotationsAttribute2));
        this.attributesEditor.addAttribute(runtimeVisibleAnnotationsAttribute2);
    }

    @Override
    public void visitRuntimeInvisibleAnnotationsAttribute(Clazz clazz, RuntimeInvisibleAnnotationsAttribute runtimeInvisibleAnnotationsAttribute) {
        RuntimeInvisibleAnnotationsAttribute runtimeInvisibleAnnotationsAttribute2 = new RuntimeInvisibleAnnotationsAttribute(this.constantAdder.addConstant(clazz, runtimeInvisibleAnnotationsAttribute.u2attributeNameIndex), 0, new Annotation[runtimeInvisibleAnnotationsAttribute.u2annotationsCount]);
        runtimeInvisibleAnnotationsAttribute.annotationsAccept(clazz, new AnnotationAdder(this.targetClass, runtimeInvisibleAnnotationsAttribute2));
        this.attributesEditor.addAttribute(runtimeInvisibleAnnotationsAttribute2);
    }

    @Override
    public void visitRuntimeVisibleParameterAnnotationsAttribute(Clazz clazz, Method method, RuntimeVisibleParameterAnnotationsAttribute runtimeVisibleParameterAnnotationsAttribute) {
    }

    @Override
    public void visitRuntimeInvisibleParameterAnnotationsAttribute(Clazz clazz, Method method, RuntimeInvisibleParameterAnnotationsAttribute runtimeInvisibleParameterAnnotationsAttribute) {
    }

    @Override
    public void visitAnnotationDefaultAttribute(Clazz clazz, Method method, AnnotationDefaultAttribute annotationDefaultAttribute) {
        AnnotationDefaultAttribute annotationDefaultAttribute2 = new AnnotationDefaultAttribute(this.constantAdder.addConstant(clazz, annotationDefaultAttribute.u2attributeNameIndex), null);
        annotationDefaultAttribute.defaultValueAccept(clazz, new ElementValueAdder(this.targetClass, annotationDefaultAttribute2, false));
        this.attributesEditor.addAttribute(annotationDefaultAttribute2);
    }
}

