/*
 * Decompiled with CFR 0.152.
 */
package proguard.evaluation.value;

import proguard.evaluation.value.Category1Value;
import proguard.evaluation.value.Value;

public class InstructionOffsetValue
extends Category1Value {
    public static final InstructionOffsetValue EMPTY_VALUE = new InstructionOffsetValue();
    private int[] values;

    private InstructionOffsetValue() {
    }

    public InstructionOffsetValue(int n) {
        this.values = new int[]{n};
    }

    public InstructionOffsetValue(int[] nArray) {
        this.values = nArray;
    }

    public int instructionOffsetCount() {
        return this.values == null ? 0 : this.values.length;
    }

    public int instructionOffset(int n) {
        return this.values[n];
    }

    public boolean contains(int n) {
        if (this.values != null) {
            for (int i = 0; i < this.values.length; ++i) {
                if (this.values[i] != n) continue;
                return true;
            }
        }
        return false;
    }

    public int minimumValue() {
        int n = Integer.MAX_VALUE;
        if (this.values != null) {
            for (int i = 0; i < this.values.length; ++i) {
                int n2 = this.values[i];
                if (n <= n2) continue;
                n = n2;
            }
        }
        return n;
    }

    public int maximumValue() {
        int n = Integer.MIN_VALUE;
        if (this.values != null) {
            for (int i = 0; i < this.values.length; ++i) {
                int n2 = this.values[i];
                if (n >= n2) continue;
                n = n2;
            }
        }
        return n;
    }

    public final Value generalize(InstructionOffsetValue instructionOffsetValue) {
        int n;
        if (this.values == null) {
            return instructionOffsetValue;
        }
        if (instructionOffsetValue.values == null) {
            return this;
        }
        int n2 = this.values.length;
        for (int i = 0; i < instructionOffsetValue.values.length; ++i) {
            if (this.contains(instructionOffsetValue.values[i])) continue;
            ++n2;
        }
        if (n2 == instructionOffsetValue.values.length) {
            return instructionOffsetValue;
        }
        int[] nArray = new int[n2];
        int n3 = 0;
        for (n = 0; n < this.values.length; ++n) {
            if (instructionOffsetValue.contains(this.values[n])) continue;
            nArray[n3++] = this.values[n];
        }
        for (n = 0; n < instructionOffsetValue.values.length; ++n) {
            nArray[n3++] = instructionOffsetValue.values[n];
        }
        return new InstructionOffsetValue(nArray);
    }

    @Override
    public final InstructionOffsetValue instructionOffsetValue() {
        return this;
    }

    @Override
    public boolean isSpecific() {
        return true;
    }

    @Override
    public boolean isParticular() {
        return true;
    }

    @Override
    public final Value generalize(Value value) {
        return this.generalize(value.instructionOffsetValue());
    }

    @Override
    public final int computationalType() {
        return 6;
    }

    @Override
    public final String internalType() {
        return String.valueOf('I');
    }

    public boolean equals(Object object) {
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        InstructionOffsetValue instructionOffsetValue = (InstructionOffsetValue)object;
        if (this.values == instructionOffsetValue.values) {
            return true;
        }
        if (this.values == null || instructionOffsetValue.values == null || this.values.length != instructionOffsetValue.values.length) {
            return false;
        }
        for (int i = 0; i < instructionOffsetValue.values.length; ++i) {
            if (this.contains(instructionOffsetValue.values[i])) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int n = this.getClass().hashCode();
        if (this.values != null) {
            for (int i = 0; i < this.values.length; ++i) {
                n ^= this.values[i];
            }
        }
        return n;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.values != null) {
            for (int i = 0; i < this.values.length; ++i) {
                if (i > 0) {
                    stringBuffer.append(',');
                }
                stringBuffer.append(this.values[i]);
            }
        }
        return stringBuffer.append(':').toString();
    }
}

