/*
 * Decompiled with CFR 0.152.
 */
package proguard.evaluation.value;

import proguard.evaluation.value.DoubleValue;
import proguard.evaluation.value.FloatValue;
import proguard.evaluation.value.IntegerValue;
import proguard.evaluation.value.LongValue;
import proguard.evaluation.value.ParticularFloatValue;
import proguard.evaluation.value.ParticularIntegerValue;
import proguard.evaluation.value.ParticularLongValue;
import proguard.evaluation.value.SpecificDoubleValue;
import proguard.evaluation.value.SpecificValueFactory;
import proguard.evaluation.value.ValueFactory;

final class ParticularDoubleValue
extends SpecificDoubleValue {
    private final double value;

    public ParticularDoubleValue(double d) {
        this.value = d;
    }

    @Override
    public double value() {
        return this.value;
    }

    @Override
    public DoubleValue negate() {
        return new ParticularDoubleValue(-this.value);
    }

    @Override
    public IntegerValue convertToInteger() {
        return new ParticularIntegerValue((int)this.value);
    }

    @Override
    public LongValue convertToLong() {
        return new ParticularLongValue((long)this.value);
    }

    @Override
    public FloatValue convertToFloat() {
        return new ParticularFloatValue((float)this.value);
    }

    @Override
    public DoubleValue generalize(DoubleValue doubleValue) {
        return doubleValue.generalize(this);
    }

    @Override
    public DoubleValue add(DoubleValue doubleValue) {
        return this.value == 0.0 ? doubleValue : doubleValue.add(this);
    }

    @Override
    public DoubleValue subtract(DoubleValue doubleValue) {
        return this.value == 0.0 ? doubleValue.negate() : doubleValue.subtractFrom(this);
    }

    @Override
    public DoubleValue subtractFrom(DoubleValue doubleValue) {
        return this.value == 0.0 ? doubleValue : doubleValue.subtract(this);
    }

    @Override
    public DoubleValue multiply(DoubleValue doubleValue) {
        return doubleValue.multiply(this);
    }

    @Override
    public DoubleValue divide(DoubleValue doubleValue) {
        return doubleValue.divideOf(this);
    }

    @Override
    public DoubleValue divideOf(DoubleValue doubleValue) {
        return doubleValue.divide(this);
    }

    @Override
    public DoubleValue remainder(DoubleValue doubleValue) {
        return doubleValue.remainderOf(this);
    }

    @Override
    public DoubleValue remainderOf(DoubleValue doubleValue) {
        return doubleValue.remainder(this);
    }

    @Override
    public IntegerValue compare(DoubleValue doubleValue) {
        return doubleValue.compareReverse(this);
    }

    @Override
    public DoubleValue generalize(ParticularDoubleValue particularDoubleValue) {
        return this.value == particularDoubleValue.value ? this : ValueFactory.DOUBLE_VALUE;
    }

    @Override
    public DoubleValue add(ParticularDoubleValue particularDoubleValue) {
        return new ParticularDoubleValue(this.value + particularDoubleValue.value);
    }

    @Override
    public DoubleValue subtract(ParticularDoubleValue particularDoubleValue) {
        return new ParticularDoubleValue(this.value - particularDoubleValue.value);
    }

    @Override
    public DoubleValue subtractFrom(ParticularDoubleValue particularDoubleValue) {
        return new ParticularDoubleValue(particularDoubleValue.value - this.value);
    }

    @Override
    public DoubleValue multiply(ParticularDoubleValue particularDoubleValue) {
        return new ParticularDoubleValue(this.value * particularDoubleValue.value);
    }

    @Override
    public DoubleValue divide(ParticularDoubleValue particularDoubleValue) {
        return new ParticularDoubleValue(this.value / particularDoubleValue.value);
    }

    @Override
    public DoubleValue divideOf(ParticularDoubleValue particularDoubleValue) {
        return new ParticularDoubleValue(particularDoubleValue.value / this.value);
    }

    @Override
    public DoubleValue remainder(ParticularDoubleValue particularDoubleValue) {
        return new ParticularDoubleValue(this.value % particularDoubleValue.value);
    }

    @Override
    public DoubleValue remainderOf(ParticularDoubleValue particularDoubleValue) {
        return new ParticularDoubleValue(particularDoubleValue.value % this.value);
    }

    @Override
    public IntegerValue compare(ParticularDoubleValue particularDoubleValue) {
        return this.value < particularDoubleValue.value ? SpecificValueFactory.INTEGER_VALUE_M1 : (this.value == particularDoubleValue.value ? SpecificValueFactory.INTEGER_VALUE_0 : SpecificValueFactory.INTEGER_VALUE_1);
    }

    @Override
    public boolean isParticular() {
        return true;
    }

    @Override
    public boolean equals(Object object) {
        return super.equals(object) && this.value == ((ParticularDoubleValue)object).value;
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ (int)Double.doubleToLongBits(this.value);
    }

    public String toString() {
        return this.value + "d";
    }
}

