/*
 * Decompiled with CFR 0.152.
 */
package proguard.optimize.peephole;

import java.util.Stack;
import proguard.classfile.Clazz;
import proguard.classfile.Member;
import proguard.classfile.Method;
import proguard.classfile.ProgramClass;
import proguard.classfile.ProgramMethod;
import proguard.classfile.attribute.Attribute;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.attribute.visitor.StackSizeComputer;
import proguard.classfile.constant.InterfaceMethodrefConstant;
import proguard.classfile.constant.MethodrefConstant;
import proguard.classfile.constant.visitor.ConstantVisitor;
import proguard.classfile.editor.CodeAttributeComposer;
import proguard.classfile.editor.ConstantAdder;
import proguard.classfile.editor.ExceptionInfoAdder;
import proguard.classfile.instruction.BranchInstruction;
import proguard.classfile.instruction.ConstantInstruction;
import proguard.classfile.instruction.Instruction;
import proguard.classfile.instruction.SimpleInstruction;
import proguard.classfile.instruction.VariableInstruction;
import proguard.classfile.instruction.visitor.InstructionVisitor;
import proguard.classfile.util.ClassUtil;
import proguard.classfile.util.InternalTypeEnumeration;
import proguard.classfile.util.SimplifiedVisitor;
import proguard.classfile.visitor.MemberVisitor;
import proguard.optimize.info.AccessMethodMarker;
import proguard.optimize.info.BackwardBranchMarker;
import proguard.optimize.info.CatchExceptionMarker;
import proguard.optimize.info.MethodInvocationMarker;
import proguard.optimize.info.SuperInvocationMarker;

public class MethodInliner
extends SimplifiedVisitor
implements AttributeVisitor,
InstructionVisitor,
ConstantVisitor,
MemberVisitor {
    private static final int MAXIMUM_INLINED_CODE_LENGTH = Integer.parseInt(System.getProperty("maximum.inlined.code.length", "8"));
    private static final int MAXIMUM_RESULTING_CODE_LENGTH_JSE = Integer.parseInt(System.getProperty("maximum.resulting.code.length", "8000"));
    private static final int MAXIMUM_RESULTING_CODE_LENGTH_JME = Integer.parseInt(System.getProperty("maximum.resulting.code.length", "2000"));
    private static final int MAXIMUM_CODE_EXPANSION = 2;
    private static final int MAXIMUM_EXTRA_CODE_LENGTH = 128;
    private static final boolean DEBUG = false;
    private final boolean microEdition;
    private final boolean allowAccessModification;
    private final boolean inlineSingleInvocations;
    private final InstructionVisitor extraInlinedInvocationVisitor;
    private final CodeAttributeComposer codeAttributeComposer = new CodeAttributeComposer();
    private final AccessMethodMarker accessMethodMarker = new AccessMethodMarker();
    private final CatchExceptionMarker catchExceptionMarker = new CatchExceptionMarker();
    private final StackSizeComputer stackSizeComputer = new StackSizeComputer();
    private ProgramClass targetClass;
    private ProgramMethod targetMethod;
    private ConstantAdder constantAdder;
    private ExceptionInfoAdder exceptionInfoAdder;
    private int estimatedResultingCodeLength;
    private boolean inlining;
    private Stack inliningMethods = new Stack();
    private boolean emptyInvokingStack;
    private int uninitializedObjectCount;
    private int variableOffset;
    private boolean inlined;
    private boolean inlinedAny;

    public MethodInliner(boolean bl, boolean bl2, boolean bl3) {
        this(bl, bl2, bl3, null);
    }

    public MethodInliner(boolean bl, boolean bl2, boolean bl3, InstructionVisitor instructionVisitor) {
        this.microEdition = bl;
        this.allowAccessModification = bl2;
        this.inlineSingleInvocations = bl3;
        this.extraInlinedInvocationVisitor = instructionVisitor;
    }

    @Override
    public void visitAnyAttribute(Clazz clazz, Attribute attribute) {
    }

    @Override
    public void visitCodeAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute) {
        if (!this.inlining) {
            this.targetClass = (ProgramClass)clazz;
            this.targetMethod = (ProgramMethod)method;
            this.constantAdder = new ConstantAdder(this.targetClass);
            this.exceptionInfoAdder = new ExceptionInfoAdder(this.targetClass, this.codeAttributeComposer);
            this.estimatedResultingCodeLength = codeAttribute.u4codeLength;
            this.inliningMethods.clear();
            this.uninitializedObjectCount = method.getName(clazz).equals("<init>") ? 1 : 0;
            this.inlinedAny = false;
            this.codeAttributeComposer.reset();
            this.stackSizeComputer.visitCodeAttribute(clazz, method, codeAttribute);
            this.copyCode(clazz, method, codeAttribute);
            this.targetClass = null;
            this.targetMethod = null;
            this.constantAdder = null;
            if (this.inlinedAny) {
                this.codeAttributeComposer.visitCodeAttribute(clazz, method, codeAttribute);
                codeAttribute.instructionsAccept(clazz, method, this.accessMethodMarker);
                this.catchExceptionMarker.visitCodeAttribute(clazz, method, codeAttribute);
            }
        } else if ((this.inlineSingleInvocations ? MethodInvocationMarker.getInvocationCount(method) == 1 : codeAttribute.u4codeLength <= MAXIMUM_INLINED_CODE_LENGTH) && this.estimatedResultingCodeLength + codeAttribute.u4codeLength < (this.microEdition ? MAXIMUM_RESULTING_CODE_LENGTH_JME : MAXIMUM_RESULTING_CODE_LENGTH_JSE)) {
            this.estimatedResultingCodeLength += codeAttribute.u4codeLength;
            this.storeParameters(clazz, method);
            this.copyCode(clazz, method, codeAttribute);
            this.inlined = true;
            this.inlinedAny = true;
        }
    }

    private void storeParameters(Clazz clazz, Method method) {
        String string;
        int n;
        String string2 = method.getDescriptor(clazz);
        boolean bl = (method.getAccessFlags() & 8) != 0;
        int n2 = ClassUtil.internalMethodParameterCount(string2);
        int n3 = ClassUtil.internalMethodParameterSize(string2);
        int n4 = bl ? 0 : 1;
        String[] stringArray = new String[n3];
        InternalTypeEnumeration internalTypeEnumeration = new InternalTypeEnumeration(string2);
        for (n = 0; n < n3; ++n) {
            stringArray[n] = string = internalTypeEnumeration.nextType();
            if (ClassUtil.internalTypeSize(string) != 2) continue;
            ++n;
        }
        this.codeAttributeComposer.beginCodeFragment((n4 + n2) * 4);
        for (n = n3 - 1; n >= 0; --n) {
            byte by;
            string = stringArray[n];
            if (string == null) continue;
            switch (string.charAt(0)) {
                case 'B': 
                case 'C': 
                case 'I': 
                case 'S': 
                case 'Z': {
                    by = 54;
                    break;
                }
                case 'J': {
                    by = 55;
                    break;
                }
                case 'F': {
                    by = 56;
                    break;
                }
                case 'D': {
                    by = 57;
                    break;
                }
                default: {
                    by = 58;
                }
            }
            this.codeAttributeComposer.appendInstruction(n3 - n - 1, new VariableInstruction(by, this.variableOffset + n4 + n).shrink());
        }
        if (!bl) {
            this.codeAttributeComposer.appendInstruction(n3, new VariableInstruction(58, this.variableOffset).shrink());
        }
        this.codeAttributeComposer.endCodeFragment();
    }

    private void copyCode(Clazz clazz, Method method, CodeAttribute codeAttribute) {
        this.codeAttributeComposer.beginCodeFragment(codeAttribute.u4codeLength * 2 + 128);
        codeAttribute.instructionsAccept(clazz, method, this);
        codeAttribute.exceptionsAccept(clazz, method, this.exceptionInfoAdder);
        this.codeAttributeComposer.appendLabel(codeAttribute.u4codeLength);
        this.codeAttributeComposer.endCodeFragment();
    }

    @Override
    public void visitAnyInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, Instruction instruction) {
        this.codeAttributeComposer.appendInstruction(n, instruction.shrink());
    }

    @Override
    public void visitSimpleInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, SimpleInstruction simpleInstruction) {
        if (this.inlining) {
            switch (simpleInstruction.opcode) {
                case -84: 
                case -83: 
                case -82: 
                case -81: 
                case -80: 
                case -79: {
                    if (n < codeAttribute.u4codeLength - 1) {
                        BranchInstruction branchInstruction = new BranchInstruction(-56, codeAttribute.u4codeLength - n);
                        this.codeAttributeComposer.appendInstruction(n, ((Instruction)branchInstruction).shrink());
                    } else {
                        this.codeAttributeComposer.appendLabel(n);
                    }
                    return;
                }
            }
        }
        this.codeAttributeComposer.appendInstruction(n, simpleInstruction.shrink());
    }

    @Override
    public void visitVariableInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, VariableInstruction variableInstruction) {
        if (this.inlining) {
            variableInstruction.variableIndex += this.variableOffset;
        }
        this.codeAttributeComposer.appendInstruction(n, variableInstruction.shrink());
    }

    @Override
    public void visitConstantInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, ConstantInstruction constantInstruction) {
        switch (constantInstruction.opcode) {
            case -69: {
                ++this.uninitializedObjectCount;
                break;
            }
            case -74: 
            case -73: 
            case -72: 
            case -71: {
                this.inlined = false;
                this.codeAttributeComposer.appendLabel(n);
                this.emptyInvokingStack = !this.inlining && this.stackSizeComputer.isReachable(n) && this.stackSizeComputer.getStackSize(n) == 0;
                this.variableOffset += codeAttribute.u2maxLocals;
                clazz.constantPoolEntryAccept(constantInstruction.constantIndex, this);
                this.variableOffset -= codeAttribute.u2maxLocals;
                if (!this.inlined) break;
                if (this.extraInlinedInvocationVisitor != null) {
                    this.extraInlinedInvocationVisitor.visitConstantInstruction(clazz, method, codeAttribute, n, constantInstruction);
                }
                return;
            }
        }
        if (this.inlining) {
            constantInstruction.constantIndex = this.constantAdder.addConstant(clazz, constantInstruction.constantIndex);
        }
        this.codeAttributeComposer.appendInstruction(n, constantInstruction.shrink());
    }

    @Override
    public void visitInterfaceMethodrefConstant(Clazz clazz, InterfaceMethodrefConstant interfaceMethodrefConstant) {
    }

    @Override
    public void visitMethodrefConstant(Clazz clazz, MethodrefConstant methodrefConstant) {
        methodrefConstant.referencedMemberAccept(this);
    }

    @Override
    public void visitAnyMember(Clazz clazz, Member member) {
    }

    @Override
    public void visitProgramMethod(ProgramClass programClass, ProgramMethod programMethod) {
        int n = programMethod.getAccessFlags();
        if (!((n & 0x1A) == 0 || (n & 0x720) != 0 || programMethod.getName(programClass).equals("<init>") || programMethod.equals(this.targetMethod) && programClass.equals(this.targetClass) || this.inliningMethods.contains(programMethod) || this.targetClass.u4version < programClass.u4version || SuperInvocationMarker.invokesSuperMethods(programMethod) && !programClass.equals(this.targetClass) || BackwardBranchMarker.branchesBackward(programMethod) && this.uninitializedObjectCount != 0 || !this.allowAccessModification && (AccessMethodMarker.accessesPrivateCode(programMethod) && !programClass.equals(this.targetClass) || AccessMethodMarker.accessesPackageCode(programMethod) && !ClassUtil.internalPackageName(programClass.getName()).equals(ClassUtil.internalPackageName(this.targetClass.getName()))) || AccessMethodMarker.accessesProtectedCode(programMethod) && !programClass.equals(this.targetClass) || CatchExceptionMarker.catchesExceptions(programMethod) && !this.emptyInvokingStack || !programClass.equals(this.targetClass) && programClass.findMethod("<clinit>", "()V") != null)) {
            boolean bl = this.inlining;
            this.inlining = true;
            this.inliningMethods.push(programMethod);
            programMethod.attributesAccept(programClass, this);
            this.inlining = bl;
            this.inliningMethods.pop();
        } else if (programMethod.getName(programClass).equals("<init>")) {
            --this.uninitializedObjectCount;
        }
    }
}

