/*
 * Decompiled with CFR 0.152.
 */
package dods.dap;

import dods.dap.BadSemanticsException;
import dods.dap.BaseType;
import dods.dap.BaseTypeFactory;
import dods.dap.BaseTypePrimitiveVector;
import dods.dap.DConstructor;
import dods.dap.DDSException;
import dods.dap.DVector;
import dods.dap.DefaultFactory;
import dods.dap.NoSuchVariableException;
import dods.dap.Util;
import dods.dap.parser.DDSParser;
import dods.dap.parser.ParseException;
import java.io.BufferedWriter;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Stack;
import java.util.Vector;

public class DDS
implements Cloneable {
    protected String name;
    protected Vector vars;
    private BaseTypeFactory factory;

    public DDS() {
        this(null, new DefaultFactory());
    }

    public DDS(String n) {
        this(n, new DefaultFactory());
    }

    public DDS(BaseTypeFactory factory) {
        this(null, factory);
    }

    public DDS(String n, BaseTypeFactory factory) {
        this.name = n;
        this.vars = new Vector();
        this.factory = factory;
    }

    public Object clone() {
        try {
            DDS d = (DDS)super.clone();
            d.vars = new Vector();
            for (int i = 0; i < this.vars.size(); ++i) {
                BaseType element = (BaseType)this.vars.elementAt(i);
                d.vars.addElement(element.clone());
            }
            d.name = new String(this.name);
            d.factory = this.factory;
            return d;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    public final BaseTypeFactory getFactory() {
        return this.factory;
    }

    public final String getName() {
        return this.name;
    }

    public final void setName(String name) {
        this.name = name;
    }

    public final void addVariable(BaseType bt) {
        this.vars.addElement(bt);
    }

    public final void delVariable(String name) {
        try {
            BaseType bt = this.getVariable(name);
            this.vars.removeElement(bt);
        }
        catch (NoSuchVariableException noSuchVariableException) {
            // empty catch block
        }
    }

    private DConstructor isVectorOfDConstructor(BaseType var) {
        if (!(var instanceof DVector)) {
            return null;
        }
        if (!(((DVector)var).getPrimitiveVector() instanceof BaseTypePrimitiveVector)) {
            return null;
        }
        BaseTypePrimitiveVector btpv = (BaseTypePrimitiveVector)((DVector)var).getPrimitiveVector();
        if (btpv.getTemplate() instanceof DConstructor) {
            return (DConstructor)btpv.getTemplate();
        }
        return this.isVectorOfDConstructor(btpv.getTemplate());
    }

    public BaseType getVariable(String name) throws NoSuchVariableException {
        Stack s = new Stack();
        s = this.search(name, s);
        return (BaseType)s.pop();
    }

    public Stack search(String name, Stack compStack) throws NoSuchVariableException {
        DDSSearch ddsSearch = new DDSSearch(compStack);
        if (ddsSearch.deepSearch(name)) {
            return ddsSearch.components;
        }
        throw new NoSuchVariableException("The variable `" + name + "' was not found in the dataset.");
    }

    public final Enumeration getVariables() {
        return this.vars.elements();
    }

    public final int numVariables() {
        return this.vars.size();
    }

    public void parse(InputStream is) throws ParseException, DDSException {
        DDSParser dp = new DDSParser(is);
        dp.Dataset(this, this.factory);
    }

    public void checkSemantics(boolean all) throws BadSemanticsException {
        if (this.name == null) {
            System.err.println("A dataset must have a name");
            throw new BadSemanticsException("DDS.checkSemantics(): A dataset must have a name");
        }
        Util.uniqueNames(this.vars, this.name, "Dataset");
        if (all) {
            Enumeration e = this.vars.elements();
            while (e.hasMoreElements()) {
                BaseType bt = (BaseType)e.nextElement();
                bt.checkSemantics(true);
            }
        }
    }

    public final void checkSemantics() throws BadSemanticsException {
        this.checkSemantics(false);
    }

    public void print(PrintWriter os) {
        os.println("Dataset {");
        Enumeration e = this.vars.elements();
        while (e.hasMoreElements()) {
            BaseType bt = (BaseType)e.nextElement();
            bt.printDecl(os);
        }
        os.print("} ");
        if (this.name != null) {
            os.print(this.name);
        }
        os.println(";");
    }

    public final void print(OutputStream os) {
        PrintWriter pw = new PrintWriter(new BufferedWriter(new OutputStreamWriter(os)));
        this.print(pw);
        pw.flush();
    }

    private final class DDSSearch {
        Stack components;

        DDSSearch(Stack c) {
            this.components = c;
        }

        BaseType simpleSearch(String name, BaseType start) {
            Enumeration e = null;
            if (start == null) {
                e = DDS.this.getVariables();
            } else if (start instanceof DConstructor) {
                e = ((DConstructor)start).getVariables();
            } else {
                DConstructor dcv = DDS.this.isVectorOfDConstructor(start);
                if (dcv != null) {
                    e = dcv.getVariables();
                } else {
                    return null;
                }
            }
            while (e.hasMoreElements()) {
                BaseType v = (BaseType)e.nextElement();
                if (!v.getName().equals(name)) continue;
                return v;
            }
            return null;
        }

        /*
         * WARNING - void declaration
         */
        boolean deepSearch(String name) throws NoSuchVariableException {
            void var4_4;
            Enumeration e;
            BaseType start = this.components.empty() ? null : (BaseType)this.components.peek();
            BaseType found = this.simpleSearch(name, start);
            if (found != null) {
                this.components.push(found);
                return true;
            }
            if (start == null) {
                e = DDS.this.getVariables();
            } else if (start instanceof DConstructor) {
                e = ((DConstructor)start).getVariables();
            } else {
                DConstructor dcv = DDS.this.isVectorOfDConstructor(start);
                if (dcv != null) {
                    e = dcv.getVariables();
                } else {
                    return false;
                }
            }
            while (var4_4.hasMoreElements()) {
                BaseType v = (BaseType)var4_4.nextElement();
                this.components.push(v);
                if (this.deepSearch(name)) {
                    return true;
                }
                this.components.pop();
            }
            return false;
        }
    }
}

