/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.pds.label.io;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class LengthLimitedInputStream
extends FilterInputStream {
    private long available;

    public LengthLimitedInputStream(InputStream in, long offset, long size) throws IOException {
        super(in);
        this.available = size;
        in.skip(offset);
    }

    @Override
    public int available() throws IOException {
        return (int)Math.min(this.available, Integer.MAX_VALUE);
    }

    @Override
    public int read() throws IOException {
        if (this.available <= 0L) {
            return -1;
        }
        int c = super.read();
        this.available = c >= 0 ? --this.available : 0L;
        return c;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int chunkSize = (int)Math.min((long)len, this.available);
        int nRead = super.read(b, off, chunkSize);
        this.available = nRead >= 0 ? (this.available -= (long)nRead) : 0L;
        return nRead;
    }

    @Override
    public long skip(long n) throws IOException {
        long actualSkip = super.skip(Math.min(n, this.available));
        this.available -= actualSkip;
        return actualSkip;
    }
}

