/*
 * Decompiled with CFR 0.152.
 */
package dropincoming;

import dropincoming.ShortCutsPanel;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;

public final class DropPanel
extends JPanel {
    Color color0;
    File currentDirectory = null;
    File currentFile = null;
    String pathDelim;
    boolean dropActive = false;
    private JButton copyDirectoryButton;
    private JLabel currentDirectoryLabel;
    private JLabel currentFileLabel;
    private JButton jButton1;
    private JButton saveToButton;
    private JLabel statusLabel;

    public DropPanel() {
        this.initComponents();
        this.addDropTarget();
        this.color0 = this.getBackground();
        this.pathDelim = FileSystems.getDefault().getSeparator();
    }

    @Override
    protected void paintComponent(Graphics g1) {
        super.paintComponent(g1);
        if (this.dropActive) {
            Graphics2D g = (Graphics2D)g1;
            Stroke stroke0 = g.getStroke();
            Color color0 = g.getColor();
            g.setColor(new Color(128, 128, 128));
            g.setStroke(new BasicStroke(10.0f, 1, 1, 0.0f, new float[]{60.0f, 20.0f}, 0.0f));
            g.drawRoundRect(30, 30, this.getWidth() - 60, this.getHeight() - 60, 30, 30);
            g.setStroke(stroke0);
            g.setColor(color0);
        }
    }

    void addDropTarget() {
        DropTargetListener listener = new DropTargetListener(){

            @Override
            public void dragEnter(DropTargetDragEvent dtde) {
                DropPanel.this.dropActive = true;
                DropPanel.this.repaint();
            }

            @Override
            public void dragOver(DropTargetDragEvent dtde) {
            }

            @Override
            public void dropActionChanged(DropTargetDragEvent dtde) {
            }

            @Override
            public void dragExit(DropTargetEvent dte) {
                DropPanel.this.dropActive = false;
                DropPanel.this.repaint();
            }

            @Override
            public void drop(DropTargetDropEvent dtde) {
                DataFlavor[] ff;
                DropPanel.this.dropActive = false;
                for (DataFlavor f : ff = dtde.getCurrentDataFlavors()) {
                    Object o;
                    if (f.getMimeType().startsWith("application/x-java-file-list")) {
                        dtde.acceptDrop(1);
                        try {
                            List l;
                            o = dtde.getTransferable().getTransferData(f);
                            if (!(o instanceof List) || (l = (List)o).size() <= 0) continue;
                            final File file = (File)l.get(0);
                            if (DropPanel.this.currentDirectory != null) {
                                Runnable run = new Runnable(){

                                    @Override
                                    public void run() {
                                        try {
                                            DropPanel.this.dropWithCurrentDirectory(file);
                                        }
                                        catch (IOException ex) {
                                            Logger.getLogger(DropPanel.class.getName()).log(Level.SEVERE, null, ex);
                                        }
                                    }
                                };
                                SwingUtilities.invokeLater(run);
                            } else {
                                DropPanel.this.statusLabel.setText("file in temporary area");
                                DropPanel.this.currentFile = file;
                            }
                            DropPanel.this.currentFileLabel.setText(DropPanel.this.currentFile.toString());
                        }
                        catch (UnsupportedFlavorException ex) {
                            Logger.getLogger(DropPanel.class.getName()).log(Level.SEVERE, null, ex);
                        }
                        catch (IOException ex) {
                            Logger.getLogger(DropPanel.class.getName()).log(Level.SEVERE, null, ex);
                        }
                        continue;
                    }
                    if (f.getMimeType().startsWith("application/x-moz-custom-clipdata")) {
                        dtde.acceptDrop(1);
                        try {
                            o = dtde.getTransferable().getTransferData(f);
                            ByteArrayInputStream in = (ByteArrayInputStream)o;
                            File ftmp = new File("/tmp/dropPanel.dat");
                            Files.copy(in, ftmp.toPath(), new CopyOption[0]);
                            DropPanel.this.currentFile = ftmp;
                            DropPanel.this.currentFileLabel.setText(DropPanel.this.currentFile.toString());
                        }
                        catch (UnsupportedFlavorException | IOException ex) {
                            Logger.getLogger(DropPanel.class.getName()).log(Level.SEVERE, null, ex);
                        }
                        System.err.println("ignore " + f.getMimeType());
                        continue;
                    }
                    System.err.println("ignore " + f.getMimeType());
                }
                DropPanel.this.repaint();
            }
        };
        new DropTarget(this, 1, listener, true);
    }

    public void dropWithCurrentDirectory(File file) throws IOException {
        int opt = JOptionPane.showInternalConfirmDialog(this, "drop into " + this.currentDirectory + "?", "Drop here", 1);
        if (0 == opt) {
            this.currentFile = new File(this.currentDirectory, file.getName());
            Files.copy(file.toPath(), this.currentFile.toPath(), new CopyOption[0]);
            file = this.currentFile;
            this.statusLabel.setText("file copied to current");
        } else if (1 == opt) {
            this.currentDirectory = null;
            this.currentDirectoryLabel.setText("");
            this.statusLabel.setText("file in temporary area");
            this.currentFile = file;
        } else {
            this.statusLabel.setText("cancelled");
        }
    }

    private void initComponents() {
        this.jButton1 = new JButton();
        this.currentFileLabel = new JLabel();
        this.saveToButton = new JButton();
        this.copyDirectoryButton = new JButton();
        this.currentDirectoryLabel = new JLabel();
        this.statusLabel = new JLabel();
        this.jButton1.setText("Copy");
        this.jButton1.setToolTipText("Copy Filename to Clipboard");
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DropPanel.this.jButton1ActionPerformed(evt);
            }
        });
        this.currentFileLabel.setText("(no current file)");
        this.saveToButton.setText("Save to...");
        this.saveToButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DropPanel.this.saveToButtonActionPerformed(evt);
            }
        });
        this.copyDirectoryButton.setText("Copy Directory");
        this.copyDirectoryButton.setToolTipText("Copy directory name to clipboard");
        this.copyDirectoryButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DropPanel.this.copyDirectoryButtonActionPerformed(evt);
            }
        });
        this.currentDirectoryLabel.setText("(no current directory)");
        this.statusLabel.setText("ready for drops");
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(12, 12, 12).addComponent(this.currentDirectoryLabel).addContainerGap(-1, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(12, 12, 12).addComponent(this.currentFileLabel, -1, 639, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.statusLabel, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.saveToButton)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jButton1).addComponent(this.copyDirectoryButton)).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()))));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jButton1).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.currentFileLabel).addGap(4, 4, 4).addComponent(this.copyDirectoryButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.currentDirectoryLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 336, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.saveToButton).addGroup(layout.createSequentialGroup().addGap(5, 5, 5).addComponent(this.statusLabel, -1, -1, Short.MAX_VALUE))).addContainerGap()));
    }

    private void saveToButtonActionPerformed(ActionEvent evt) {
        int opt;
        final JFileChooser chooser = new JFileChooser();
        chooser.setMultiSelectionEnabled(false);
        chooser.setFileSelectionMode(1);
        final ShortCutsPanel p = new ShortCutsPanel();
        chooser.setAccessory(p);
        p.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                File f = chooser.getCurrentDirectory();
                try {
                    chooser.setCurrentDirectory(p.doAction(e.getActionCommand(), f));
                }
                catch (IOException ex) {
                    System.err.println(ex.getMessage());
                }
            }
        });
        if (this.currentFile != null) {
            chooser.setCurrentDirectory(this.currentFile.getParentFile());
        }
        if (this.currentDirectory != null) {
            chooser.setCurrentDirectory(this.currentDirectory);
        }
        if (0 == (opt = chooser.showSaveDialog(this))) {
            this.currentDirectory = chooser.getSelectedFile();
            if (this.currentFile != null) {
                File currentFileT = new File(this.currentDirectory, this.currentFile.getName());
                try {
                    Files.copy(this.currentFile.toPath(), currentFileT.toPath(), new CopyOption[0]);
                    this.statusLabel.setText("file copied to current");
                    this.currentFileLabel.setText(this.currentFile.toString());
                    this.currentFile = currentFileT;
                    this.currentFileLabel.setText(this.currentFile.toString());
                }
                catch (IOException ex) {
                    this.statusLabel.setText(ex.getMessage());
                }
            } else {
                this.statusLabel.setText("files will be saved here");
            }
            this.currentDirectoryLabel.setText(this.currentDirectory.toString());
        }
    }

    private void copyToClipBoard(String text) {
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(text), null);
    }

    private void copyDirectoryButtonActionPerformed(ActionEvent evt) {
        this.copyToClipBoard(this.currentDirectory.toString() + this.pathDelim);
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        this.copyToClipBoard(this.currentFileLabel.getText());
    }
}

