/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.inline;

import java.net.URI;
import java.text.ParseException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.das2.datum.Units;
import org.das2.util.monitor.ProgressMonitor;
import org.python.core.PyList;
import org.python.core.PyObject;
import org.python.core.PyTuple;
import org.python.util.InteractiveInterpreter;
import org.virbo.dataset.ArrayDataSet;
import org.virbo.dataset.BundleDataSet;
import org.virbo.dataset.DDataSet;
import org.virbo.dataset.DataSetOps;
import org.virbo.dataset.MutablePropertyDataSet;
import org.virbo.dataset.QDataSet;
import org.virbo.dataset.SemanticOps;
import org.virbo.datasource.AbstractDataSource;
import org.virbo.datasource.URISplit;
import org.virbo.dsops.Ops;
import org.virbo.jythonsupport.JythonOps;
import org.virbo.jythonsupport.JythonUtil;

public class InlineDataSource
extends AbstractDataSource {
    public InlineDataSource(URI uri) {
        super(uri);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private MutablePropertyDataSet jyCommand(String c) throws Exception {
        QDataSet res;
        InteractiveInterpreter interp = JythonUtil.createInterpreter((boolean)false);
        PyObject result = interp.eval(c);
        if (result instanceof PyList) {
            res = JythonOps.coerceToDs((PyObject)((PyList)result));
            return DataSetOps.makePropertiesMutable((QDataSet)res);
        } else if (result instanceof PyTuple && ((PyTuple)result).size() < 3) {
            PyTuple tres = (PyTuple)result;
            if (tres.size() == 2) {
                res = Ops.link((QDataSet)((QDataSet)tres.get(0)), (QDataSet)((QDataSet)tres.get(1)));
                return DataSetOps.makePropertiesMutable((QDataSet)res);
            } else if (tres.size() == 3) {
                res = Ops.link((QDataSet)((QDataSet)tres.get(0)), (QDataSet)((QDataSet)tres.get(1)), (QDataSet)((QDataSet)tres.get(2)));
                return DataSetOps.makePropertiesMutable((QDataSet)res);
            } else {
                if (tres.size() != 1) throw new ParseException("unable to parse command: " + c, 0);
                res = (QDataSet)tres.get(0);
            }
            return DataSetOps.makePropertiesMutable((QDataSet)res);
        } else {
            res = (QDataSet)result.__tojava__(QDataSet.class);
        }
        return DataSetOps.makePropertiesMutable((QDataSet)res);
    }

    private MutablePropertyDataSet parseInlineDs(String s) throws Exception {
        if (s.equals("None") || s.equals("null") || s.equals("")) {
            return null;
        }
        boolean isCommand = s.length() > 0 && s.charAt(0) >= 'a' && s.charAt(0) <= 'z';
        String linkCommand = "link( " + s + ")";
        InteractiveInterpreter interp = JythonUtil.createInterpreter((boolean)false);
        try {
            PyObject result = interp.eval(linkCommand);
            QDataSet res = (QDataSet)result.__tojava__(QDataSet.class);
            return DataSetOps.makePropertiesMutable((QDataSet)res);
        }
        catch (RuntimeException ex) {
            if (isCommand) {
                return this.jyCommand(s);
            }
            String[] ss = s.split(";");
            Units u = Units.dimensionless;
            if (ss.length > 1) {
                BundleDataSet bds = BundleDataSet.createRank1Bundle();
                for (int i = 0; i < ss.length; ++i) {
                    String[] ss2 = ss[i].split(",");
                    DDataSet result = DDataSet.createRank1((int)ss2.length);
                    for (int j = 0; j < ss2.length; ++j) {
                        result.putValue(j, u.parse(ss2[j]).doubleValue(u));
                    }
                    bds.bundle((QDataSet)result);
                }
                bds.putProperty("BUNDLE_1", null);
                return bds;
            }
            String[] ss2 = ss[0].split(",");
            DDataSet result = DDataSet.createRank1((int)ss2.length);
            for (int j = 0; j < ss2.length; ++j) {
                result.putValue(j, u.parse(ss2[j]).doubleValue(u));
            }
            return result;
        }
    }

    public QDataSet getDataSet(ProgressMonitor mon) throws Exception {
        MutablePropertyDataSet bundle1;
        MutablePropertyDataSet ds;
        block25: {
            MutablePropertyDataSet[] depn;
            block23: {
                ArrayDataSet zz;
                ArrayDataSet xx;
                block24: {
                    String s = this.getURI();
                    s = s.replaceAll("%20", " ");
                    URISplit split = URISplit.parse((String)s);
                    String noFile = split.file != null ? (split.file.startsWith("file:///") ? split.file.substring("file:///".length()) : split.file) : split.params;
                    String[] ss = noFile.split("&");
                    ds = null;
                    bundle1 = null;
                    depn = new MutablePropertyDataSet[4];
                    Map[] deppropn = new Map[4];
                    LinkedHashMap<String, String> p = new LinkedHashMap<String, String>();
                    Pattern depPat = Pattern.compile("DEPEND_(\\d+)(\\.([A-Z]+))?");
                    Matcher m = null;
                    for (int i = 0; i < ss.length; ++i) {
                        String arg = ss[i];
                        if (arg.length() == 0) continue;
                        if (arg.charAt(0) >= 'A' && arg.charAt(0) <= 'Z') {
                            String[] sss = arg.split("=");
                            if (sss.length > 1) {
                                String propName = sss[0];
                                String propValue = sss[1];
                                m = depPat.matcher(propName);
                                if (m.matches()) {
                                    int idep = Integer.parseInt(m.group(1));
                                    if (m.group(3) != null) {
                                        HashMap<String, String> map = deppropn[idep];
                                        if (map == null) {
                                            deppropn[idep] = map = new HashMap<String, String>();
                                        }
                                        map.put(m.group(3), propValue);
                                        continue;
                                    }
                                    depn[idep] = this.parseInlineDs(propValue);
                                    continue;
                                }
                                if (propName.startsWith("BUNDLE_1")) {
                                    if (propValue.equals("") || propValue.equals("None") || propValue.equals("null")) {
                                        p.put(propName, propValue);
                                        continue;
                                    }
                                    bundle1 = this.parseInlineDs(propValue);
                                    continue;
                                }
                                p.put(propName, propValue);
                                continue;
                            }
                            throw new ParseException("expected = for non-number", 0);
                        }
                        ds = arg.charAt(0) >= 'a' && arg.charAt(0) <= 'z' ? this.parseInlineDs(arg) : this.parseInlineDs(arg);
                    }
                    for (int idep = 0; idep < 4; ++idep) {
                        Map depp = deppropn[idep];
                        if (depp == null) continue;
                        for (String prop : depp.keySet()) {
                            MutablePropertyDataSet dep0 = depn[idep];
                            if (dep0 == null) {
                                throw new IllegalArgumentException("DEPEND_" + idep + "." + prop + " specified, but no DEPEND_" + idep + " ds");
                            }
                            String propValue = (String)depp.get(prop);
                            if (prop.equals("UNITS")) {
                                dep0.putProperty(prop, (Object)SemanticOps.lookupUnits((String)propValue));
                                continue;
                            }
                            if (prop.equals("FILL_VALUE") || prop.equals("VALID_MIN") || prop.equals("VALID_MAX") || prop.equals("TYPICAL_MIN") || prop.equals("TYPICAL_MAX")) {
                                dep0.putProperty(prop, (Object)Double.parseDouble(propValue));
                                continue;
                            }
                            if (prop.equals("MONOTONIC")) {
                                dep0.putProperty(prop, (Object)Boolean.parseBoolean(propValue));
                                continue;
                            }
                            dep0.putProperty(prop, (Object)propValue);
                        }
                    }
                    for (String prop : p.keySet()) {
                        String propValue = (String)p.get(prop);
                        if (prop.equals("UNITS")) {
                            ds.putProperty(prop, (Object)SemanticOps.lookupUnits((String)propValue));
                            continue;
                        }
                        if (prop.equals("FILL_VALUE") || prop.equals("VALID_MIN") || prop.equals("VALID_MAX") || prop.equals("TYPICAL_MIN") || prop.equals("TYPICAL_MAX")) {
                            ds.putProperty(prop, (Object)Double.parseDouble(propValue));
                            continue;
                        }
                        if (prop.equals("MONOTONIC")) {
                            ds.putProperty(prop, (Object)Boolean.parseBoolean(propValue));
                            continue;
                        }
                        if (prop.startsWith("DEPEND_")) {
                            if (!propValue.equals("") && !propValue.equals("None") && !propValue.equals("null")) continue;
                            ds.putProperty(prop, null);
                            continue;
                        }
                        ds.putProperty(prop, (Object)propValue);
                    }
                    if (depn[0] != null) break block23;
                    if (bundle1 != null || ds.rank() != 2 || ds.length() != 2) break block24;
                    xx = DDataSet.copy((QDataSet)DataSetOps.slice0((QDataSet)ds, (int)0));
                    zz = DDataSet.copy((QDataSet)DataSetOps.slice0((QDataSet)ds, (int)(ds.length() - 1)));
                    zz.putProperty("DEPEND_0", (Object)xx);
                    ds = zz;
                    break block25;
                }
                if (bundle1 != null || ds.rank() != 2 || ds.length(1) != 2) break block25;
                if (Ops.isBundle((QDataSet)ds)) {
                    xx = (MutablePropertyDataSet)DataSetOps.unbundle((QDataSet)ds, (int)0);
                    zz = (MutablePropertyDataSet)DataSetOps.unbundle((QDataSet)ds, (int)(ds.length(0) - 1));
                    zz.putProperty("DEPEND_0", (Object)xx);
                    ds = zz;
                } else {
                    xx = DDataSet.copy((QDataSet)DataSetOps.slice1((QDataSet)ds, (int)0));
                    zz = DDataSet.copy((QDataSet)DataSetOps.slice1((QDataSet)ds, (int)(ds.length(0) - 1)));
                    zz.putProperty("DEPEND_0", (Object)xx);
                    ds = zz;
                }
                break block25;
            }
            for (int idep = 0; idep < 4; ++idep) {
                ds.putProperty("DEPEND_" + idep, (Object)depn[idep]);
            }
        }
        if (bundle1 != null) {
            ds.putProperty("BUNDLE_1", bundle1);
        }
        return ds;
    }
}

