/*
 * Decompiled with CFR 0.152.
 */
package org.virbo.datasource.jython;

import java.beans.ExceptionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.LineNumberReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.ParseException;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.das2.dataset.CacheTag;
import org.das2.datum.Datum;
import org.das2.datum.DatumRange;
import org.das2.datum.DatumRangeUtil;
import org.das2.util.monitor.NullProgressMonitor;
import org.das2.util.monitor.ProgressMonitor;
import org.python.core.Py;
import org.python.core.PyDictionary;
import org.python.core.PyException;
import org.python.core.PyList;
import org.python.core.PyObject;
import org.python.util.PythonInterpreter;
import org.virbo.dataset.DataSetOps;
import org.virbo.dataset.MutablePropertyDataSet;
import org.virbo.dataset.QDataSet;
import org.virbo.datasource.AbstractDataSource;
import org.virbo.datasource.DataSetURI;
import org.virbo.datasource.URISplit;
import org.virbo.datasource.capability.Caching;
import org.virbo.datasource.capability.TimeSeriesBrowse;
import org.virbo.datasource.jython.JythonDataSourceFactory;
import org.virbo.jythonsupport.JythonOps;
import org.virbo.jythonsupport.JythonUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JythonDataSource
extends AbstractDataSource
implements Caching {
    ExceptionListener listener;
    private Map<String, Object> metadata;
    private static final String PARAM_SCRIPT = "script";
    private static final Logger logger = Logger.getLogger("vap.jythondatasource");
    private boolean notCheckedTsb = true;
    PythonInterpreter interp = null;
    TimeSeriesBrowse tsb = null;
    Date cacheDate = null;
    String cacheUrl = null;

    public JythonDataSource(URI uri, JythonDataSourceFactory factory) {
        super(uri);
        this.addCability(Caching.class, (Object)this);
        this.listener = factory.listener;
    }

    private File getScript() throws IOException {
        File jythonScript;
        if (this.params.get(PARAM_SCRIPT) != null) {
            jythonScript = this.getFile(new URL((String)this.params.get(PARAM_SCRIPT)), (ProgressMonitor)new NullProgressMonitor());
        } else {
            Object resourceURI = null;
            jythonScript = this.getFile((ProgressMonitor)new NullProgressMonitor());
        }
        return jythonScript;
    }

    private String nextExec(LineNumberReader reader, String[] nextLine) throws IOException {
        StringBuilder s;
        if (nextLine[0] != null) {
            s = new StringBuilder(nextLine[0]);
            nextLine[0] = null;
        } else {
            String ss = reader.readLine();
            if (ss == null) {
                ss = "";
            }
            s = new StringBuilder(ss);
        }
        String stest = s.toString();
        if (stest.startsWith("def ") || stest.startsWith("if") || stest.startsWith("else")) {
            String s1 = reader.readLine();
            while (s1 != null && (s1.length() == 0 || Character.isWhitespace(s1.charAt(0)))) {
                s.append("\n").append(s1);
                s1 = reader.readLine();
            }
            while (s1 != null && s1.startsWith("else")) {
                s.append("\n").append(s1);
                s1 = reader.readLine();
                while (s1 != null && (s1.length() == 0 || Character.isWhitespace(s1.charAt(0)))) {
                    s.append("\n").append(s1);
                    s1 = reader.readLine();
                }
            }
            nextLine[0] = s1;
        }
        return s.toString();
    }

    private synchronized QDataSet getInlineDataSet(URI uri) throws Exception {
        this.interp = JythonUtil.createInterpreter((boolean)false);
        PyObject result = this.interp.eval(uri.getRawSchemeSpecificPart());
        QDataSet res = result instanceof PyList ? JythonOps.coerceToDs((PyObject)((PyList)result)) : (QDataSet)result.__tojava__(QDataSet.class);
        return res;
    }

    public synchronized QDataSet getDataSet(ProgressMonitor mon) throws Exception {
        boolean allowCaching;
        String resourceURI;
        File jythonScript;
        mon.started();
        String suri = DataSetURI.fromUri((URI)this.uri);
        if (this.tsb != null) {
            suri = this.tsb.getURI();
        }
        URISplit split = URISplit.parse((String)suri);
        LinkedHashMap paramsl = URISplit.parseParams((String)split.params);
        if (split.scheme.equals("inline")) {
            return this.getInlineDataSet(new URI(this.uri.getRawSchemeSpecificPart()));
        }
        if (this.params.get(PARAM_SCRIPT) != null) {
            jythonScript = this.getFile(new URL((String)this.params.get(PARAM_SCRIPT)), (ProgressMonitor)new NullProgressMonitor());
            mon.setProgressMessage("loading " + this.uri);
            split.params = null;
            resourceURI = DataSetURI.fromUri((URI)DataSetURI.getResourceURI((String)URISplit.format((URISplit)split)));
        } else {
            resourceURI = null;
            jythonScript = this.getFile((ProgressMonitor)new NullProgressMonitor());
        }
        boolean bl = allowCaching = !"F".equals(this.params.get("allowCaching"));
        if (!allowCaching) {
            this.interp = null;
        }
        PyException causedBy = null;
        try {
            CacheTag tag;
            QDataSet dep0;
            PyObject result;
            if (this.interp == null) {
                mon.started();
                mon.setProgressMessage("initialize Jython interpreter...");
                this.interp = JythonUtil.createInterpreter((boolean)false);
                mon.setProgressMessage("done initializing Jython interpreter");
                this.interp.set("monitor", (Object)mon);
                this.interp.exec("params=dict()");
                for (Map.Entry e : paramsl.entrySet()) {
                    String s = (String)e.getKey();
                    if (s.equals("arg_0") || s.equals(PARAM_SCRIPT)) continue;
                    String sval = (String)e.getValue();
                    sval = this.maybeQuoteString(sval);
                    logger.log(Level.FINE, "params[''{0}'']={1}", new Object[]{s, sval});
                    this.interp.exec("params['" + s + "']=" + sval);
                }
                this.interp.set("resourceURI", (Object)resourceURI);
                mon.setProgressMessage("executing script");
                LineNumberReader reader = null;
                try {
                    boolean debug = false;
                    if (debug) {
                        reader = new LineNumberReader(new FileReader(jythonScript));
                        String[] nextLine = new String[1];
                        String s = this.nextExec(reader, nextLine);
                        long t0 = System.currentTimeMillis();
                        while (s != null) {
                            Logger.getLogger("virbo.jythondatasource").fine("" + reader.getLineNumber() + ": " + s);
                            this.interp.exec(s);
                            System.err.printf("line=%d time=%dms  %s\n", reader.getLineNumber(), System.currentTimeMillis() - t0, s);
                            if (!mon.isCancelled()) {
                                mon.setProgressMessage("exec line " + reader.getLineNumber());
                                s = this.nextExec(reader, nextLine);
                                t0 = System.currentTimeMillis();
                                continue;
                            }
                            break;
                        }
                    } else {
                        this.interp.execfile((InputStream)new FileInputStream(jythonScript));
                    }
                    mon.setProgressMessage("done executing script");
                }
                catch (PyException ex) {
                    if (reader != null) {
                        System.err.println("debugging line number=" + reader.getLineNumber());
                    }
                    causedBy = ex;
                    ex.printStackTrace();
                    if (this.listener != null) {
                        this.listener.exceptionThrown((Exception)((Object)ex));
                    }
                }
                catch (Exception ex) {
                    throw ex;
                }
                reader = null;
                if (causedBy == null && allowCaching) {
                    this.cacheDate = this.resourceDate(this.uri);
                    this.cacheUrl = this.cacheUrl(this.uri);
                }
            } else {
                System.err.println("using existing interpreter to provide caching");
            }
            String expr = (String)this.params.get("arg_0");
            String label = null;
            if (expr == null) {
                try {
                    result = this.interp.eval("result");
                }
                catch (PyException ex) {
                    try {
                        result = this.interp.eval("data");
                    }
                    catch (PyException ex2) {
                        if (causedBy != null) {
                            throw ex2;
                        }
                        throw new IllegalArgumentException("neither \"data\" nor \"result\" is defined");
                    }
                }
            } else {
                result = this.interp.eval(expr);
                label = expr;
            }
            this.metadata = new LinkedHashMap<String, Object>();
            try {
                PyObject pymeta = this.interp.eval("metadata");
                if (pymeta instanceof PyDictionary) {
                    PyDictionary dict = (PyDictionary)pymeta;
                    PyList keys = dict.keys();
                    for (Object key : keys) {
                        String name = key.toString();
                        String val = dict.get(Py.java2py(key)).toString();
                        this.metadata.put(name, val);
                    }
                }
            }
            catch (PyException ex) {
                // empty catch block
            }
            QDataSet res = result instanceof PyList ? JythonOps.coerceToDs((PyObject)((PyList)result)) : (QDataSet)result.__tojava__(QDataSet.class);
            if (label != null && res instanceof MutablePropertyDataSet && res.property("LABEL") == null) {
                ((MutablePropertyDataSet)res).putProperty("LABEL", (Object)label);
            }
            if (this.notCheckedTsb) {
                PyObject tr = this.interp.eval("getParam('timerange','x')");
                TimeSeriesBrowse tsb1 = this.checkForTimeSeriesBrowse(this.uri.toString(), jythonScript);
                if (tsb1 != null) {
                    if (!tr.toString().equals("x")) {
                        tsb1.setTimeRange(DatumRangeUtil.parseTimeRange((String)tr.toString()));
                    }
                    this.addCability(TimeSeriesBrowse.class, tsb1);
                    this.tsb = tsb1;
                }
                this.notCheckedTsb = false;
            }
            if (this.tsb != null && (dep0 = (QDataSet)res.property("DEPEND_0")) != null && (tag = (CacheTag)dep0.property("CACHE_TAG")) == null) {
                tag = new CacheTag(this.tsb.getTimeRange(), null);
                MutablePropertyDataSet mdep0 = DataSetOps.makePropertiesMutable((QDataSet)dep0);
                mdep0.putProperty("CACHE_TAG", (Object)tag);
                MutablePropertyDataSet mres = DataSetOps.makePropertiesMutable((QDataSet)res);
                mres.putProperty("DEPEND_0", (Object)mdep0);
                res = mres;
            }
            if (causedBy != null) {
                this.interp = null;
                this.cacheUrl = null;
                this.cacheDate = null;
                Logger.getLogger("virbo.jythonDataSouce").log(Level.WARNING, "exception in processing: {0}", causedBy);
                throw causedBy;
            }
            if (!allowCaching) {
                this.interp = null;
            }
            mon.finished();
            QDataSet qDataSet = res;
            return qDataSet;
        }
        catch (PyException ex) {
            String msg = "PyException: " + (Object)((Object)ex);
            if (causedBy != null) {
                throw causedBy;
            }
            this.interp = null;
            this.cacheUrl = null;
            this.cacheDate = null;
            throw ex;
        }
        finally {
            mon.finished();
        }
    }

    public Map<String, Object> getMetadata(ProgressMonitor mon) throws Exception {
        return this.metadata;
    }

    private String cacheUrl(URI uri) {
        URISplit split = URISplit.parse((URI)uri);
        LinkedHashMap params2 = URISplit.parseParams((String)split.params);
        params2.remove("arg_0");
        split.params = URISplit.formatParams((Map)params2);
        return URISplit.format((URISplit)split);
    }

    private Date resourceDate(URI uri) throws IOException {
        File src = DataSetURI.getFile((URI)uri, (ProgressMonitor)new NullProgressMonitor());
        return new Date(src.lastModified());
    }

    private synchronized boolean useCache(URI uri) {
        try {
            if (this.cacheDate != null && !this.resourceDate(uri).after(this.cacheDate) && this.cacheUrl != null && this.cacheUrl.equals(this.cacheUrl(uri))) {
                return !uri.toString().contains("allowCaching=F");
            }
            return false;
        }
        catch (IOException ex) {
            return false;
        }
    }

    public boolean satisfies(String surl) {
        try {
            return this.useCache(new URI(surl));
        }
        catch (URISyntaxException ex) {
            return false;
        }
    }

    public void resetURI(String surl) {
        try {
            this.uri = new URI(surl);
            URISplit split = URISplit.parse((URI)this.uri);
            this.params = URISplit.parseParams((String)split.params);
            this.resourceURI = new URI(split.file);
        }
        catch (URISyntaxException ex) {
            throw new RuntimeException(ex);
        }
    }

    private String maybeQuoteString(String sval) {
        boolean isNumber = false;
        try {
            Double.parseDouble(sval);
        }
        catch (NumberFormatException ex) {
            isNumber = false;
        }
        if (!(sval.length() <= 0 || isNumber || sval.equals("True") || sval.equals("False") || sval.startsWith("'") && sval.endsWith("'"))) {
            sval = String.format("'%s'", sval);
        }
        return sval;
    }

    private TimeSeriesBrowse checkForTimeSeriesBrowse(String uri, File jythonScript) throws IOException, ParseException {
        LineNumberReader reader = new LineNumberReader(new FileReader(jythonScript));
        String line = ((BufferedReader)reader).readLine();
        Pattern s = Pattern.compile(".*getParam\\(\\s*\\'timerange\\',\\s*\\'([-0-9a-zA-Z]+)\\'\\s*(,\\s*\\'.*\\')?\\s*\\).*");
        while (line != null) {
            Matcher m = s.matcher(line);
            if (m.matches()) {
                JythonDataSourceTimeSeriesBrowse tsb1 = new JythonDataSourceTimeSeriesBrowse(uri);
                String str = m.group(1);
                DatumRange tr = DatumRangeUtil.parseTimeRange((String)str);
                tsb1.setTimeRange(tr);
                reader.close();
                return tsb1;
            }
            line = ((BufferedReader)reader).readLine();
        }
        reader.close();
        return null;
    }

    public class JythonDataSourceTimeSeriesBrowse
    implements TimeSeriesBrowse {
        DatumRange timeRange;
        String uri;

        JythonDataSourceTimeSeriesBrowse(String uri) {
            this.uri = uri;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setTimeRange(DatumRange dr) {
            if (this.timeRange == null || !this.timeRange.equals((Object)dr)) {
                JythonDataSource jythonDataSource = JythonDataSource.this;
                synchronized (jythonDataSource) {
                    JythonDataSource.this.interp = null;
                }
            }
            this.timeRange = dr;
            URISplit split = URISplit.parse((String)this.uri);
            LinkedHashMap params = URISplit.parseParams((String)split.params);
            params.put("timerange", dr.toString());
            split.params = URISplit.formatParams((Map)params);
            this.uri = URISplit.format((URISplit)split);
        }

        public DatumRange getTimeRange() {
            return this.timeRange;
        }

        public void setTimeResolution(Datum d) {
        }

        public Datum getTimeResolution() {
            return null;
        }

        public String getURI() {
            return this.uri;
        }

        public void setURI(String suri) throws ParseException {
            this.uri = suri;
            this.timeRange = URISplit.parseTimeRange((String)this.uri);
        }
    }
}

