/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.csv;

import com.csvreader.CsvReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import org.autoplot.csv.CsvDataSource;
import org.das2.util.monitor.ProgressMonitor;
import org.virbo.datasource.CompletionContext;
import org.virbo.datasource.DataSetURI;
import org.virbo.datasource.DataSource;
import org.virbo.datasource.DataSourceFactory;
import org.virbo.datasource.URISplit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CsvDataSourceFactory
implements DataSourceFactory {
    public DataSource getDataSource(URI uri) throws Exception {
        return new CsvDataSource(uri);
    }

    public List<CompletionContext> getCompletions(CompletionContext cc, ProgressMonitor mon) throws Exception {
        if (cc.context == CompletionContext.CONTEXT_PARAMETER_NAME) {
            ArrayList<CompletionContext> result = new ArrayList<CompletionContext>();
            result.add(new CompletionContext(CompletionContext.CONTEXT_PARAMETER_NAME, "column="));
            result.add(new CompletionContext(CompletionContext.CONTEXT_PARAMETER_NAME, "bundle=", "read in more than one column to create a rank 2 bundle dataset."));
            result.add(new CompletionContext(CompletionContext.CONTEXT_PARAMETER_NAME, "depend0="));
            result.add(new CompletionContext(CompletionContext.CONTEXT_PARAMETER_NAME, "validMin=", "values less than this value are treated as fill."));
            result.add(new CompletionContext(CompletionContext.CONTEXT_PARAMETER_NAME, "validMax=", "values greater than this value are treated as fill."));
            return result;
        }
        if (cc.context == CompletionContext.CONTEXT_PARAMETER_VALUE) {
            String paramName = CompletionContext.get((Object)CompletionContext.CONTEXT_PARAMETER_NAME, (CompletionContext)cc);
            if (paramName.equals("bundle")) {
                ArrayList<CompletionContext> result = new ArrayList<CompletionContext>();
                result.add(new CompletionContext(CompletionContext.CONTEXT_PARAMETER_VALUE, "<int>", "number of columns to expect"));
                result.add(new CompletionContext(CompletionContext.CONTEXT_PARAMETER_VALUE, "Bx-Bz", "three named columns"));
                result.add(new CompletionContext(CompletionContext.CONTEXT_PARAMETER_VALUE, "1:", "all but first column"));
                result.add(new CompletionContext(CompletionContext.CONTEXT_PARAMETER_VALUE, "1:5", "second through 5th columns"));
                result.add(new CompletionContext(CompletionContext.CONTEXT_PARAMETER_VALUE, "-5:", "last five columns"));
                return result;
            }
            if (paramName.equals("column")) {
                List<CompletionContext> result = this.getFieldNames(cc, mon);
                return result;
            }
            if (paramName.equals("depend0")) {
                List<CompletionContext> result = this.getFieldNames(cc, mon);
                return result;
            }
            return Collections.emptyList();
        }
        return Collections.emptyList();
    }

    private List<CompletionContext> getFieldNames(CompletionContext cc, ProgressMonitor mon) throws IOException {
        String[] columns;
        LinkedHashMap params = URISplit.parseParams((String)cc.params);
        File f = DataSetURI.getFile((URI)cc.resourceURI, (ProgressMonitor)mon);
        CsvReader reader = new CsvReader((Reader)new FileReader(f));
        if (reader.readHeaders()) {
            int ncol = reader.getHeaderCount();
            columns = reader.getHeaders();
        } else {
            columns = new String[reader.getColumnCount()];
            for (int i = 0; i < columns.length; ++i) {
                columns[i] = "field" + i;
            }
        }
        ArrayList<CompletionContext> result = new ArrayList<CompletionContext>();
        for (int i = 0; i < columns.length; ++i) {
            String s;
            String label = s = columns[i];
            result.add(new CompletionContext(CompletionContext.CONTEXT_PARAMETER_VALUE, s, label, null));
        }
        return result;
    }

    public boolean reject(String surl, ProgressMonitor mon) {
        return false;
    }

    public <T> T getCapability(Class<T> clazz) {
        return null;
    }
}

