/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.csv;

import java.util.regex.Pattern;

public class TableOps {
    public static int getFieldIndex(String string, String[] fieldNames) {
        for (int i = 0; i < fieldNames.length; ++i) {
            if (!fieldNames[i].equalsIgnoreCase(string)) continue;
            return i;
        }
        int icol = -1;
        if (Pattern.matches("field[0-9]+", string)) {
            icol = Integer.parseInt(string.substring(5));
        } else if (Pattern.matches("[0-9]+", string)) {
            icol = Integer.parseInt(string);
        }
        if (icol >= fieldNames.length) {
            throw new IllegalArgumentException("bad column parameter: the record parser only expects " + fieldNames.length + " columns");
        }
        return icol;
    }

    public static int columnIndex(String name, String[] fieldNames) {
        if (Pattern.matches("\\d+", name)) {
            return Integer.parseInt(name);
        }
        if (Pattern.matches("-\\d+", name)) {
            return fieldNames.length + Integer.parseInt(name);
        }
        if (Pattern.matches("field\\d+", name)) {
            return Integer.parseInt(name.substring(5));
        }
        int idx = TableOps.getFieldIndex(name, fieldNames);
        return idx;
    }

    public static int[] parseRangeStr(String o, String[] fieldNames) throws NumberFormatException {
        String s = o;
        int first = 0;
        int last = fieldNames.length;
        if (s.contains(":")) {
            String[] ss = s.split(":", -2);
            if (ss[0].length() > 0) {
                first = TableOps.columnIndex(ss[0], fieldNames);
            }
            if (ss[1].length() > 0) {
                last = TableOps.columnIndex(ss[1], fieldNames);
            }
        } else if (s.contains("--")) {
            int isplit = s.indexOf("--", 1);
            if (isplit > 0) {
                first = TableOps.columnIndex(s.substring(0, isplit), fieldNames);
            }
            if (isplit < s.length() - 2) {
                last = 1 + TableOps.columnIndex(s.substring(isplit + 1), fieldNames);
            }
        } else if (s.contains("-")) {
            String[] ss = s.split("-", -2);
            if (ss[0].length() > 0) {
                first = TableOps.columnIndex(ss[0], fieldNames);
            }
            if (ss[1].length() > 0) {
                last = 1 + TableOps.columnIndex(ss[1], fieldNames);
            }
        }
        return new int[]{first, last};
    }
}

