/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.html;

import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToggleButton;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import org.autoplot.html.HtmlTableParser;
import org.das2.util.filesystem.FileSystem;
import org.das2.util.monitor.NullProgressMonitor;
import org.das2.util.monitor.ProgressMonitor;
import org.jdesktop.layout.GroupLayout;
import org.virbo.dataset.QDataSet;
import org.virbo.datasource.DataSetURI;
import org.virbo.datasource.DataSourceEditorPanel;
import org.virbo.datasource.URISplit;
import org.virbo.datasource.ui.TableRowHeader;
import org.virbo.dsutil.QDataSetTableModel;

public class HtmlTableDataSourceEditorPanel
extends JPanel
implements DataSourceEditorPanel {
    Map<Integer, String> columns;
    boolean focusDepend0 = false;
    Map<String, String> params;
    URISplit split;
    Tool currentTool = Tool.NONE;
    JToggleButton currentToolButton;
    protected File file = null;
    public static final String PROP_FILE = "file";
    protected String table;
    public static final String PROP_TABLE = "table";
    public static final String PROP_FIRST_ROW = "firstRow";
    public static final String PROP_COLUMN = "column";
    public static final String PROP_DEP0 = "depend0";
    public JComboBox columnsComboBox;
    public JComboBox dep0Columns;
    public JFormattedTextField firstRowTextField;
    public JLabel jLabel1;
    public JLabel jLabel2;
    public JLabel jLabel3;
    public JLabel jLabel4;
    public JPanel jPanel1;
    public JScrollPane jScrollPane1;
    public JTable jTable1;
    public JToggleButton jToggleButton1;
    public JToggleButton jToggleButton2;
    public JToggleButton jToggleButton3;
    public JComboBox tableComboBox;

    public boolean reject(String url) throws IOException, URISyntaxException {
        this.split = URISplit.parse((String)url);
        FileSystem fs = FileSystem.create((URI)DataSetURI.getWebURL((URI)DataSetURI.toUri((String)this.split.path)).toURI());
        return fs.isDirectory(this.split.file.substring(this.split.path.length()));
    }

    public boolean prepare(String uri, Window parent, ProgressMonitor mon) throws Exception {
        this.split = URISplit.parse((String)uri);
        this.params = URISplit.parseParams((String)this.split.params);
        DataSetURI.getFile((URL)new URL(this.split.file), (ProgressMonitor)mon);
        return true;
    }

    public HtmlTableDataSourceEditorPanel() {
        this.initComponents();
        this.jTable1.setCellSelectionEnabled(true);
        this.jTable1.getColumnModel().getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                HtmlTableDataSourceEditorPanel.this.doSelect(HtmlTableDataSourceEditorPanel.this.currentTool);
            }
        });
        this.jTable1.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                HtmlTableDataSourceEditorPanel.this.doSelect(HtmlTableDataSourceEditorPanel.this.currentTool);
            }
        });
        this.jScrollPane1.setRowHeaderView((Component)new TableRowHeader(this.jTable1));
        this.jTable1.getTableHeader().setReorderingAllowed(false);
        this.jTable1.getTableHeader().addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                super.mouseClicked(e);
                int col = HtmlTableDataSourceEditorPanel.this.jTable1.getTableHeader().columnAtPoint(e.getPoint());
                String name = HtmlTableDataSourceEditorPanel.this.columns.get(col);
                if (name == null) {
                    name = String.valueOf((char)(65 + col));
                }
                if (HtmlTableDataSourceEditorPanel.this.currentTool == Tool.DEPEND_0) {
                    HtmlTableDataSourceEditorPanel.this.params.put(HtmlTableDataSourceEditorPanel.PROP_DEP0, name);
                    HtmlTableDataSourceEditorPanel.this.dep0Columns.setSelectedItem(name);
                    HtmlTableDataSourceEditorPanel.this.clearTool();
                } else if (HtmlTableDataSourceEditorPanel.this.currentTool == Tool.COLUMN) {
                    HtmlTableDataSourceEditorPanel.this.params.put(HtmlTableDataSourceEditorPanel.PROP_COLUMN, name);
                    HtmlTableDataSourceEditorPanel.this.columnsComboBox.setSelectedItem(name);
                    HtmlTableDataSourceEditorPanel.this.clearTool();
                }
            }
        });
    }

    private void doSelect(Tool tool) {
        if (tool == Tool.FIRSTROW) {
            if (this.jTable1.getSelectedRow() > 0) {
                this.params.put(PROP_FIRST_ROW, String.valueOf(this.jTable1.getSelectedRow() + 1));
            } else {
                this.params.remove(PROP_FIRST_ROW);
            }
            this.firstRowTextField.setValue(this.jTable1.getSelectedRow() + 1);
        } else if (this.jTable1.getColumnModel().getSelectedColumnCount() != 0) {
            if (this.jTable1.getColumnModel().getSelectedColumnCount() == 1) {
                int col = this.jTable1.getColumnModel().getSelectedColumns()[0];
                String name = this.columns.get(col);
                if (name == null) {
                    name = String.valueOf((char)(65 + col));
                }
                if (this.currentTool == Tool.DEPEND_0) {
                    this.params.put(PROP_DEP0, name);
                    this.dep0Columns.setSelectedItem(name);
                } else if (this.currentTool == Tool.COLUMN) {
                    this.params.put(PROP_COLUMN, name);
                    this.columnsComboBox.setSelectedItem(name);
                }
            } else {
                int[] cols = this.jTable1.getColumnModel().getSelectedColumns();
                int first = cols[0];
                int last = cols[cols.length - 1];
                String sfirst = this.columns.get(first);
                if (sfirst == null) {
                    sfirst = "" + first;
                }
                boolean haveColumnNames = true;
                String slast = this.columns.get(last);
                if (slast == null) {
                    slast = "" + last;
                    haveColumnNames = false;
                }
                if (this.currentTool != Tool.DEPEND_0 && this.currentTool == Tool.COLUMN) {
                    if (haveColumnNames) {
                        this.params.put(PROP_COLUMN, sfirst + "-" + slast);
                    } else {
                        this.params.put(PROP_COLUMN, "" + first + ":" + (last + 1));
                    }
                }
            }
        }
        this.clearTool();
    }

    Action createToolAction(String label, final Tool t) {
        return new AbstractAction(label){

            public void actionPerformed(ActionEvent e) {
                if (e.getSource() instanceof JToggleButton) {
                    if (HtmlTableDataSourceEditorPanel.this.jTable1.getSelectionModel().isSelectionEmpty()) {
                        HtmlTableDataSourceEditorPanel.this.jTable1.getSelectionModel().clearSelection();
                        HtmlTableDataSourceEditorPanel.this.jTable1.getColumnModel().getSelectionModel().clearSelection();
                        HtmlTableDataSourceEditorPanel.this.currentToolButton = (JToggleButton)e.getSource();
                        HtmlTableDataSourceEditorPanel.this.currentTool = t;
                    } else {
                        HtmlTableDataSourceEditorPanel.this.currentToolButton = (JToggleButton)e.getSource();
                        HtmlTableDataSourceEditorPanel.this.currentTool = t;
                        HtmlTableDataSourceEditorPanel.this.doSelect(t);
                        HtmlTableDataSourceEditorPanel.this.jTable1.getSelectionModel().clearSelection();
                        HtmlTableDataSourceEditorPanel.this.jTable1.getColumnModel().getSelectionModel().clearSelection();
                    }
                }
            }
        };
    }

    private void clearTool() {
        if (this.currentTool != Tool.NONE) {
            this.currentTool = Tool.NONE;
            this.currentToolButton.setSelected(false);
            this.currentToolButton = null;
        }
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.jTable1 = new JTable();
        this.jPanel1 = new JPanel();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.dep0Columns = new JComboBox();
        this.columnsComboBox = new JComboBox();
        this.jToggleButton2 = new JToggleButton();
        this.jToggleButton3 = new JToggleButton();
        this.jLabel2 = new JLabel();
        this.tableComboBox = new JComboBox();
        this.jLabel1 = new JLabel();
        this.firstRowTextField = new JFormattedTextField();
        this.jToggleButton1 = new JToggleButton();
        this.jTable1.setAutoResizeMode(0);
        this.jScrollPane1.setViewportView(this.jTable1);
        this.jLabel3.setText("Column:");
        this.jLabel3.setToolTipText("Select the column to plot");
        this.jLabel4.setText("Depends On:");
        this.jLabel4.setEnabled(false);
        this.dep0Columns.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.dep0Columns.setEnabled(false);
        this.dep0Columns.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                HtmlTableDataSourceEditorPanel.this.dep0ColumnsItemStateChanged(evt);
            }
        });
        this.dep0Columns.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent evt) {
                HtmlTableDataSourceEditorPanel.this.dep0ColumnsFocusGained(evt);
            }
        });
        this.columnsComboBox.setEditable(true);
        this.columnsComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.columnsComboBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                HtmlTableDataSourceEditorPanel.this.columnsComboBoxItemStateChanged(evt);
            }
        });
        this.columnsComboBox.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent evt) {
                HtmlTableDataSourceEditorPanel.this.columnsComboBoxFocusGained(evt);
            }
        });
        this.jToggleButton2.setAction(this.createToolAction(PROP_COLUMN, Tool.COLUMN));
        this.jToggleButton2.setText("Select");
        this.jToggleButton2.setToolTipText("Select the column to plot by pushing this button and then clicking on a column of the table.\n");
        this.jToggleButton3.setAction(this.createToolAction(PROP_DEP0, Tool.DEPEND_0));
        this.jToggleButton3.setText("Select");
        this.jToggleButton3.setToolTipText("Select the column containing the indepenent variable to plot against by pressing this button and then clicking on the table.\n");
        this.jToggleButton3.setEnabled(false);
        this.jLabel2.setText("Table:");
        this.jLabel2.setToolTipText("Select the table within the html to use.  Note tables are often used for layout on web pages, so \nthere will probably be more tables than expected.\n");
        this.tableComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.tableComboBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                HtmlTableDataSourceEditorPanel.this.tableComboBoxItemStateChanged(evt);
            }
        });
        this.jLabel1.setText("First Row:");
        this.jLabel1.setEnabled(false);
        this.firstRowTextField.setText("jFormattedTextField1");
        this.firstRowTextField.setEnabled(false);
        this.jToggleButton1.setAction(this.createToolAction(PROP_FIRST_ROW, Tool.FIRSTROW));
        this.jToggleButton1.setText("Select");
        this.jToggleButton1.setToolTipText("Select the first row to start the data by clicking on this button then a row of the table.\n");
        this.jToggleButton1.setEnabled(false);
        GroupLayout jPanel1Layout = new GroupLayout((Container)this.jPanel1);
        this.jPanel1.setLayout((LayoutManager)jPanel1Layout);
        jPanel1Layout.setHorizontalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().add((GroupLayout.Group)jPanel1Layout.createParallelGroup(2).add((Component)this.jLabel4).add((Component)this.jLabel3)).addPreferredGap(0).add((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().add((Component)this.dep0Columns, 0, 447, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.jToggleButton3).add(18, 18, 18).add((Component)this.jLabel1).addPreferredGap(0).add((Component)this.firstRowTextField, -1, 94, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.jToggleButton1)).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().add((Component)this.columnsComboBox, -2, 190, -2).addPreferredGap(0).add((Component)this.jToggleButton2).add(36, 36, 36).add((Component)this.jLabel2).addPreferredGap(0).add((Component)this.tableComboBox, -2, 158, -2))).addContainerGap()));
        jPanel1Layout.setVerticalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().add((GroupLayout.Group)jPanel1Layout.createParallelGroup(3).add((Component)this.jLabel3).add((Component)this.columnsComboBox, -2, -1, -2).add((Component)this.jToggleButton2, -2, 27, -2).add((Component)this.jLabel2).add((Component)this.tableComboBox, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)jPanel1Layout.createParallelGroup(3).add((Component)this.jLabel4).add((Component)this.dep0Columns, -2, -1, -2).add((Component)this.jToggleButton3, -2, 24, -2).add((Component)this.jToggleButton1).add((Component)this.firstRowTextField, -2, -1, -2).add((Component)this.jLabel1)).addContainerGap(12, Short.MAX_VALUE)));
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jPanel1, -1, -1, Short.MAX_VALUE).add((Component)this.jScrollPane1, -1, 823, Short.MAX_VALUE));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jPanel1, -2, -1, -2).addPreferredGap(0).add((Component)this.jScrollPane1, -1, 381, Short.MAX_VALUE).addContainerGap()));
    }

    private void resetFile() {
        if (this.file == null) {
            return;
        }
        String uri = this.getURI();
        URISplit split = URISplit.parse((String)uri);
        LinkedHashMap params = URISplit.parseParams((String)split.params);
        try {
            HtmlTableParser parser = new HtmlTableParser(DataSetURI.getURIValid((String)uri));
            this.tableComboBox.setModel(new DefaultComboBoxModel<Object>(parser.getTables().toArray()));
            String table = (String)params.get(PROP_TABLE);
            if (table != null) {
                this.tableComboBox.setSelectedItem(table);
            } else {
                this.tableComboBox.setSelectedIndex(0);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void resetTable() {
        if (this.file == null) {
            return;
        }
        String uri = this.getURI();
        URISplit split = URISplit.parse((String)uri);
        LinkedHashMap params = URISplit.parseParams((String)split.params);
        try {
            HtmlTableParser parser = new HtmlTableParser(DataSetURI.getURIValid((String)uri));
            QDataSet tds = parser.getTable((ProgressMonitor)new NullProgressMonitor());
            this.jTable1.setModel((TableModel)new QDataSetTableModel(tds));
            if (tds.length() > 0) {
                String[] columnNames = new String[tds.length(0)];
                this.columns = new LinkedHashMap<Integer, String>();
                for (int i = 0; i < tds.length(0); ++i) {
                    columnNames[i] = "" + i;
                    this.jTable1.getColumnModel().getColumn(i).setHeaderValue(columnNames[i]);
                    this.columns.put(i, "" + i);
                }
                this.columnsComboBox.setModel(new DefaultComboBoxModel<String>(columnNames));
            } else {
                this.columnsComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"(no records found)"}));
            }
            String column = (String)params.get(PROP_COLUMN);
            if (column != null) {
                this.columnsComboBox.setSelectedItem(params.get(PROP_COLUMN));
            }
        }
        catch (Exception ex) {
            this.columnsComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"(no records found)"}));
            DefaultTableModel dtm = new DefaultTableModel(1, 1);
            dtm.setValueAt("no records found", 0, 0);
            this.jTable1.setModel(dtm);
            ex.printStackTrace();
        }
    }

    private void tableComboBoxItemStateChanged(ItemEvent evt) {
        String table = (String)this.tableComboBox.getSelectedItem();
        this.params.put(PROP_TABLE, table);
        this.setTable(table);
    }

    private void dep0ColumnsItemStateChanged(ItemEvent evt) {
        this.params.put(PROP_DEP0, (String)this.dep0Columns.getSelectedItem());
    }

    private void dep0ColumnsFocusGained(FocusEvent evt) {
    }

    private void columnsComboBoxItemStateChanged(ItemEvent evt) {
        this.params.put(PROP_COLUMN, (String)this.columnsComboBox.getSelectedItem());
    }

    private void columnsComboBoxFocusGained(FocusEvent evt) {
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) throws IOException {
        this.file = file;
        this.resetTable();
    }

    public String getTable() {
        return this.table;
    }

    public void setTable(String table) {
        String oldTable = this.table;
        this.table = table;
        this.resetTable();
        this.firePropertyChange(PROP_TABLE, oldTable, table);
    }

    public JPanel getPanel() {
        return this;
    }

    private int getIntValue(String name, int def) {
        if (this.params.get(name) == null) {
            return def;
        }
        return Integer.parseInt(this.params.get(name));
    }

    public void setURI(String url) {
        try {
            this.split = URISplit.parse((String)url);
            this.params = URISplit.parseParams((String)this.split.params);
            File f = DataSetURI.getFile((URL)new URL(this.split.file), (ProgressMonitor)new NullProgressMonitor());
            this.setFile(f);
            if (this.params.get(PROP_TABLE) != null) {
                this.tableComboBox.setSelectedItem(this.params.get(PROP_TABLE));
                this.setTable(this.params.get(PROP_TABLE));
            }
            if (this.params.get(PROP_COLUMN) != null) {
                this.columnsComboBox.setSelectedItem(this.params.get(PROP_COLUMN));
            }
            if (this.params.get(PROP_DEP0) != null) {
                this.dep0Columns.setSelectedItem(this.params.get(PROP_DEP0));
            }
            this.firstRowTextField.setValue(this.getIntValue(PROP_FIRST_ROW, 1));
            this.resetFile();
            this.resetTable();
        }
        catch (IOException ex) {
            Logger.getLogger(HtmlTableDataSourceEditorPanel.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public String getURI() {
        this.split.params = URISplit.formatParams(this.params);
        return URISplit.format((URISplit)this.split);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Tool {
        NONE,
        FIRSTROW,
        COLUMN,
        DEPEND_0,
        TIMEFORMAT;

    }
}

