/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.html;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.net.URI;
import java.util.List;
import javax.swing.text.html.parser.ParserDelegator;
import org.autoplot.html.HtmlParserCallback;
import org.das2.util.monitor.NullProgressMonitor;
import org.das2.util.monitor.ProgressMonitor;
import org.virbo.dataset.DataSetOps;
import org.virbo.dataset.QDataSet;
import org.virbo.datasource.AbstractDataSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HtmlTableParser
extends AbstractDataSource {
    public static final String PARAM_COLUMN = "column";
    public static final String PARAM_TABLE = "table";
    String cacheUri;
    String stable;
    String cacheFile = null;
    QDataSet cacheDs = null;

    public HtmlTableParser(URI uri) {
        super(uri);
    }

    public QDataSet getTable(ProgressMonitor mon) throws Exception {
        File f = this.getHtmlFile(this.resourceURI.toURL(), mon);
        BufferedReader reader = new BufferedReader(new FileReader(f));
        HtmlParserCallback callback = new HtmlParserCallback();
        String stable = (String)this.getParams().get(PARAM_TABLE);
        if (stable != null) {
            callback.setTable(stable);
        }
        new ParserDelegator().parse(reader, callback, true);
        QDataSet ds = callback.getDataSet();
        return ds;
    }

    public QDataSet getDataSet(ProgressMonitor mon) throws Exception {
        QDataSet ds = this.getTable(mon);
        String column = (String)this.getParams().get(PARAM_COLUMN);
        if (column == null) {
            return ds;
        }
        try {
            int icol = Integer.parseInt(column);
            return DataSetOps.unbundle((QDataSet)ds, (int)icol);
        }
        catch (NumberFormatException ex) {
            return DataSetOps.unbundle((QDataSet)ds, (String)column);
        }
    }

    public List<String> getTables() throws IOException {
        File f = this.getHtmlFile(this.resourceURI.toURL(), (ProgressMonitor)new NullProgressMonitor());
        BufferedReader reader = new BufferedReader(new FileReader(f));
        HtmlParserCallback callback = new HtmlParserCallback();
        String stable = (String)this.getParams().get(PARAM_TABLE);
        if (stable != null) {
            callback.setTable(stable);
        }
        new ParserDelegator().parse(reader, callback, true);
        List<String> tables = callback.getTables();
        return tables;
    }
}

