/*
 * Decompiled with CFR 0.152.
 */
package org.virbo.ascii;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.das2.util.monitor.ProgressMonitor;
import org.virbo.ascii.AsciiTableDataSource;
import org.virbo.datasource.CompletionContext;
import org.virbo.datasource.DataSetURI;
import org.virbo.datasource.DataSource;
import org.virbo.datasource.DataSourceFactory;
import org.virbo.datasource.MetadataModel;
import org.virbo.datasource.URISplit;
import org.virbo.dsutil.AsciiParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AsciiTableDataSourceFactory
implements DataSourceFactory {
    public DataSource getDataSource(URI uri) throws FileNotFoundException, IOException {
        return new AsciiTableDataSource(uri);
    }

    public String editPanel(String surl) throws Exception {
        return surl;
    }

    public MetadataModel getMetadataModel(URL url) {
        return MetadataModel.createNullModel();
    }

    public List<CompletionContext> getCompletions(CompletionContext cc, ProgressMonitor mon) throws Exception {
        if (cc.context == CompletionContext.CONTEXT_PARAMETER_NAME) {
            ArrayList<CompletionContext> result = new ArrayList<CompletionContext>();
            result.add(new CompletionContext(CompletionContext.CONTEXT_PARAMETER_NAME, "skip="));
            result.add(new CompletionContext(CompletionContext.CONTEXT_PARAMETER_NAME, "recCount="));
            result.add(new CompletionContext(CompletionContext.CONTEXT_PARAMETER_NAME, "column="));
            result.add(new CompletionContext(CompletionContext.CONTEXT_PARAMETER_NAME, "fixedColumns="));
            result.add(new CompletionContext(CompletionContext.CONTEXT_PARAMETER_NAME, "rank2=", "read in more than one column to create a rank 2 dataset."));
            result.add(new CompletionContext(CompletionContext.CONTEXT_PARAMETER_NAME, "bundle=", "read in more than one column to create a rank 2 bundle dataset."));
            result.add(new CompletionContext(CompletionContext.CONTEXT_PARAMETER_NAME, "depend1Labels=", "label each of the columns, bundling different data together in rank 2 dataset"));
            result.add(new CompletionContext(CompletionContext.CONTEXT_PARAMETER_NAME, "depend1Values=", "values for each column, making a rank 2 table of values."));
            result.add(new CompletionContext(CompletionContext.CONTEXT_PARAMETER_NAME, "time="));
            result.add(new CompletionContext(CompletionContext.CONTEXT_PARAMETER_NAME, "timeFormat=", "template for parsing time digits, default is ISO8601."));
            result.add(new CompletionContext(CompletionContext.CONTEXT_PARAMETER_NAME, "intervalTag=", "indicate how measurement intervals are tagged."));
            result.add(new CompletionContext(CompletionContext.CONTEXT_PARAMETER_NAME, "depend0="));
            result.add(new CompletionContext(CompletionContext.CONTEXT_PARAMETER_NAME, "fill="));
            result.add(new CompletionContext(CompletionContext.CONTEXT_PARAMETER_NAME, "comment=", "comment line prefix, default is hash (#)"));
            result.add(new CompletionContext(CompletionContext.CONTEXT_PARAMETER_NAME, "headerDelim=", "string indicating the end of the header (a regular expression)"));
            result.add(new CompletionContext(CompletionContext.CONTEXT_PARAMETER_NAME, "validMin=", "values less than this value are treated as fill."));
            result.add(new CompletionContext(CompletionContext.CONTEXT_PARAMETER_NAME, "validMax=", "values greater than this value are treated as fill."));
            result.add(new CompletionContext(CompletionContext.CONTEXT_PARAMETER_NAME, "delim=", "parse records by splitting on delimiter."));
            result.add(new CompletionContext(CompletionContext.CONTEXT_PARAMETER_NAME, "tail=", "read the last n records."));
            return result;
        }
        if (cc.context == CompletionContext.CONTEXT_PARAMETER_VALUE) {
            String paramName = CompletionContext.get((Object)CompletionContext.CONTEXT_PARAMETER_NAME, (CompletionContext)cc);
            if (paramName.equals("skip")) {
                return Collections.singletonList(new CompletionContext(CompletionContext.CONTEXT_PARAMETER_VALUE, "<int>", "the number of lines to skip before attempting to parse."));
            }
            if (paramName.equals("headerDelim")) {
                ArrayList<CompletionContext> result = new ArrayList<CompletionContext>();
                result.add(new CompletionContext(CompletionContext.CONTEXT_PARAMETER_VALUE, "<string>"));
                result.add(new CompletionContext(CompletionContext.CONTEXT_PARAMETER_VALUE, "#####"));
                result.add(new CompletionContext(CompletionContext.CONTEXT_PARAMETER_VALUE, "DATA_UNTIL", "Cluster CEF uses these"));
                return result;
            }
            if (paramName.equals("recCount")) {
                return Collections.singletonList(new CompletionContext(CompletionContext.CONTEXT_PARAMETER_VALUE, "<int>", "limit number of records to parse."));
            }
            if (paramName.equals("rank2")) {
                ArrayList<CompletionContext> result = new ArrayList<CompletionContext>();
                result.add(new CompletionContext(CompletionContext.CONTEXT_PARAMETER_VALUE, "<int>", "number of columns to expect"));
                result.add(new CompletionContext(CompletionContext.CONTEXT_PARAMETER_VALUE, "1:", "all but first column"));
                result.add(new CompletionContext(CompletionContext.CONTEXT_PARAMETER_VALUE, "1:5", "second through 5th columns"));
                result.add(new CompletionContext(CompletionContext.CONTEXT_PARAMETER_VALUE, "-5:", "last five columns"));
                return result;
            }
            if (paramName.equals("bundle")) {
                ArrayList<CompletionContext> result = new ArrayList<CompletionContext>();
                result.add(new CompletionContext(CompletionContext.CONTEXT_PARAMETER_VALUE, "<int>", "number of columns to expect"));
                result.add(new CompletionContext(CompletionContext.CONTEXT_PARAMETER_VALUE, "Bx-Bz", "three named columns"));
                result.add(new CompletionContext(CompletionContext.CONTEXT_PARAMETER_VALUE, "1:", "all but first column"));
                result.add(new CompletionContext(CompletionContext.CONTEXT_PARAMETER_VALUE, "1:5", "second through 5th columns"));
                result.add(new CompletionContext(CompletionContext.CONTEXT_PARAMETER_VALUE, "-5:", "last five columns"));
                return result;
            }
            if (paramName.equals("depend1Labels")) {
                ArrayList<CompletionContext> result = new ArrayList<CompletionContext>();
                result.add(new CompletionContext(CompletionContext.CONTEXT_PARAMETER_VALUE, "<int>:<int>", "labels for each column"));
                return result;
            }
            if (paramName.equals("depend1Values")) {
                ArrayList<CompletionContext> result = new ArrayList<CompletionContext>();
                result.add(new CompletionContext(CompletionContext.CONTEXT_PARAMETER_VALUE, "<int>:<int>", "values for each column"));
                return result;
            }
            if (paramName.equals("column")) {
                List<CompletionContext> result = this.getFieldNames(cc, mon);
                return result;
            }
            if (paramName.equals("fixedColumns")) {
                return Collections.singletonList(new CompletionContext(CompletionContext.CONTEXT_PARAMETER_VALUE, "<int>", "Hint at the number of columns to expect, then use fast parser that assumes fixed columns."));
            }
            if (paramName.equals("time")) {
                List<CompletionContext> result = this.getFieldNames(cc, mon);
                return result;
            }
            if (paramName.equals("intervalTag")) {
                ArrayList<CompletionContext> result = new ArrayList<CompletionContext>();
                result.add(new CompletionContext(CompletionContext.CONTEXT_PARAMETER_VALUE, "start", "tag values indicate the start of measurement interval"));
                result.add(new CompletionContext(CompletionContext.CONTEXT_PARAMETER_VALUE, "center", "tag values indicate the start of measurement interval."));
                return result;
            }
            if (paramName.equals("depend0")) {
                List<CompletionContext> result = this.getFieldNames(cc, mon);
                return result;
            }
            if (paramName.equals("timeFormat")) {
                ArrayList<CompletionContext> result = new ArrayList<CompletionContext>();
                result.add(new CompletionContext(CompletionContext.CONTEXT_PARAMETER_VALUE, "$Y+$j+$H+$M", "times can span multiple fields"));
                result.add(new CompletionContext(CompletionContext.CONTEXT_PARAMETER_VALUE, "ISO8601", "parse ISO8601 times in one field."));
                return result;
            }
            if (paramName.equals("fill")) {
                return Collections.singletonList(new CompletionContext(CompletionContext.CONTEXT_PARAMETER_VALUE, "<double>"));
            }
            if (paramName.equals("validMin")) {
                return Collections.singletonList(new CompletionContext(CompletionContext.CONTEXT_PARAMETER_VALUE, "<double>"));
            }
            if (paramName.equals("validMax")) {
                return Collections.singletonList(new CompletionContext(CompletionContext.CONTEXT_PARAMETER_VALUE, "<double>"));
            }
            if (paramName.equals("tail")) {
                return Collections.singletonList(new CompletionContext(CompletionContext.CONTEXT_PARAMETER_VALUE, "<int>"));
            }
            return Collections.emptyList();
        }
        return Collections.emptyList();
    }

    public boolean reject(String surl, ProgressMonitor mon) {
        try {
            URISplit split = URISplit.parse((String)surl);
            LinkedHashMap params = URISplit.parseParams((String)split.params);
            if (params.get("rank2") != null) {
                return false;
            }
            if (params.get("bundle") != null) {
                return false;
            }
            if (params.get("group") != null) {
                return false;
            }
            String arg_0 = (String)params.get("arg_0");
            if (arg_0 != null && (arg_0.equals("rank2") || arg_0.equals("bundle"))) {
                return false;
            }
            File file = DataSetURI.getFile((URI)split.resourceUri, (ProgressMonitor)mon);
            if (!file.isFile()) {
                return true;
            }
            List<CompletionContext> cc = this.getFieldNames(file, params, mon);
            if (cc.size() <= 2) {
                return false;
            }
            return params.get("column") == null;
        }
        catch (IOException ex) {
            return false;
        }
    }

    private List<CompletionContext> getFieldNames(File file, Map<String, String> params, ProgressMonitor mon) throws IOException {
        AsciiParser parser = AsciiParser.newParser((int)5);
        if (params.containsKey("skip")) {
            parser.setSkipLines(Integer.parseInt(params.get("skip")));
        }
        if (params.containsKey("skipLines")) {
            parser.setSkipLines(Integer.parseInt(params.get("skipLines")));
        }
        if (params.containsKey("comment")) {
            parser.setCommentPrefix(params.get("comment"));
        }
        if (params.containsKey("headerDelim")) {
            parser.setHeaderDelimiter(params.get("headerDelim"));
        }
        AsciiParser.DelimParser dp = parser.guessSkipAndDelimParser(file.toString());
        String line = parser.readFirstParseableRecord(file.toString());
        if (line == null) {
            throw new IllegalArgumentException("unable to find parseable record");
        }
        String[] fields = new String[dp.fieldCount()];
        dp.splitRecord(line, fields);
        String[] columns = parser.getFieldNames();
        ArrayList<CompletionContext> result = new ArrayList<CompletionContext>();
        for (int i = 0; i < columns.length; ++i) {
            String s = columns[i];
            String label = s;
            if (!label.equals(fields[i]) && label.startsWith("field")) {
                label = label + " (" + fields[i] + ")";
            }
            result.add(new CompletionContext(CompletionContext.CONTEXT_PARAMETER_VALUE, s, label, null));
        }
        return result;
    }

    private List<CompletionContext> getFieldNames(CompletionContext cc, ProgressMonitor mon) throws IOException {
        LinkedHashMap params = URISplit.parseParams((String)cc.params);
        File file = DataSetURI.getFile((URI)cc.resourceURI, (ProgressMonitor)mon);
        return this.getFieldNames(file, params, mon);
    }

    public <T> T getCapability(Class<T> clazz) {
        return null;
    }
}

