/*
 * Decompiled with CFR 0.152.
 */
package org.virbo.dataset;

import org.das2.datum.Datum;
import org.das2.datum.Units;
import org.virbo.dataset.AbstractDataSet;
import org.virbo.dataset.DataSetUtil;
import org.virbo.dataset.RankZeroDataSet;

public class DRank0DataSet
extends AbstractDataSet
implements RankZeroDataSet {
    double d;
    Units u;

    private DRank0DataSet(double d, Units u) {
        if (u != null && u != Units.dimensionless) {
            this.putProperty("UNITS", u);
        }
        this.d = d;
    }

    public static DRank0DataSet create(double d) {
        return new DRank0DataSet(d, null);
    }

    public static DRank0DataSet create(double d, Units u) {
        return new DRank0DataSet(d, u);
    }

    public static DRank0DataSet create(Datum d) {
        Units u = d.getUnits();
        return new DRank0DataSet(d.doubleValue(u), u);
    }

    public int rank() {
        return 0;
    }

    public double value() {
        return this.d;
    }

    public String toString() {
        return DataSetUtil.toString(this);
    }

    public int hashCode() {
        int hash = 7;
        hash = 97 * hash + (int)(Double.doubleToLongBits(this.d) ^ Double.doubleToLongBits(this.d) >>> 32);
        hash = 97 * hash + (this.u != null ? this.u.hashCode() : 0);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DRank0DataSet) {
            DRank0DataSet d0 = (DRank0DataSet)obj;
            return this.d == d0.d && this.u == d0.u;
        }
        return super.equals(obj);
    }
}

