/*
 * Decompiled with CFR 0.152.
 */
package org.virbo.dataset;

import org.virbo.dataset.DDataSet;
import org.virbo.dataset.DataSetIterator;
import org.virbo.dataset.QDataSet;
import org.virbo.dataset.WritableDataSet;

public class IndexListDataSetIterator
implements DataSetIterator {
    QDataSet indeces;
    int rank;
    int dsrank;
    int index;

    public IndexListDataSetIterator(QDataSet indeces) {
        this.indeces = indeces;
        this.index = -1;
        if (indeces.length() > 0) {
            this.dsrank = indeces.length(0);
        }
        this.rank = 1;
    }

    public boolean hasNext() {
        return this.index + 1 < this.indeces.length();
    }

    public int index(int dim) {
        return (int)this.indeces.value(this.index, dim);
    }

    public int length(int dim) {
        return this.indeces.length();
    }

    public void next() {
        ++this.index;
    }

    public int rank() {
        return 1;
    }

    public final double getValue(QDataSet ds) {
        switch (this.dsrank) {
            case 1: {
                return ds.value(this.index(0));
            }
            case 2: {
                return ds.value(this.index(0), this.index(1));
            }
            case 3: {
                return ds.value(this.index(0), this.index(1), this.index(2));
            }
        }
        throw new IllegalArgumentException("rank limit");
    }

    public final void putValue(WritableDataSet ds, double v) {
        switch (this.dsrank) {
            case 1: {
                ds.putValue(this.index(0), v);
                return;
            }
            case 2: {
                ds.putValue(this.index(0), this.index(1), v);
                return;
            }
            case 3: {
                ds.putValue(this.index(0), this.index(1), this.index(2), v);
                return;
            }
        }
        throw new IllegalArgumentException("rank limit");
    }

    public String toString() {
        String ats;
        String its = "" + this.index + " of " + this.indeces.length();
        if (this.index == -1) {
            ats = "-1";
            for (int i = 1; i < this.dsrank; ++i) {
                ats = ats + "," + this.index(i);
            }
        } else {
            ats = "" + this.index(0);
        }
        return "ListIter [" + its + "] @ [" + ats + "] ";
    }

    public DDataSet createEmptyDs() {
        return DDataSet.createRank1(this.indeces.length());
    }
}

