/*
 * Decompiled with CFR 0.152.
 */
package org.virbo.demos;

import java.text.ParseException;
import java.util.Random;
import org.das2.datum.Datum;
import org.das2.datum.DatumVector;
import org.das2.datum.TimeLocationUnits;
import org.das2.datum.Units;
import org.virbo.dataset.DDataSet;
import org.virbo.dataset.QDataSet;
import org.virbo.dsutil.DataSetBuilder;
import org.virbo.math.PoissonDistribution;

public class PlasmaModel {
    public QDataSet getRank2() {
        try {
            PlasmaModelSpec model = new PlasmaModelSpec();
            Random random = new Random(5330L);
            TimeLocationUnits xunits = Units.us2000;
            Datum start = Units.us2000.parse("2000-017T00:00");
            Datum end = Units.us2000.parse("2000-018T00:00");
            double xTagWidth = Units.seconds.convertDoubleTo(Units.microseconds, 13.8);
            double x = start.doubleValue((Units)xunits);
            DataSetBuilder builder = new DataSetBuilder(2, 1000, 20);
            DataSetBuilder xx = new DataSetBuilder(1, 1000);
            boolean i = false;
            boolean ylog = false;
            boolean zlog = false;
            DatumVector[] yTags = new DatumVector[1];
            Random s = new Random(234567L);
            double n = 2.0;
            while (x < end.doubleValue((Units)xunits)) {
                int nj;
                int whichYTags = s.nextInt(yTags.length);
                if (yTags[whichYTags] == null) {
                    nj = whichYTags * 10 + 20;
                    double[] yy = new double[nj];
                    for (int j = 0; j < nj; ++j) {
                        if (ylog) {
                            yy[j] = (double)(nj / 300) + (double)j * 0.05;
                            yy[j] = Math.pow(10.0, yy[j]);
                            continue;
                        }
                        yy[j] = (double)(nj / 3) + (double)j * 1.2;
                    }
                    yTags[whichYTags] = DatumVector.newDatumVector((double[])yy, (Units)Units.dimensionless);
                } else {
                    nj = yTags[whichYTags].getLength();
                }
                double[] zz = new double[nj];
                int ncol = s.nextInt(4) + 1;
                DatumVector ydv = yTags[whichYTags];
                for (int icol = 0; icol < ncol; ++icol) {
                    model.setDensity(Units.pcm3.createDatum(n *= Math.pow(10.0, (random.nextDouble() - 0.5) / 100.0)));
                    for (int j = 0; j < nj; ++j) {
                        zz[j] = model.counts(ydv.get(j).doubleValue(Units.dimensionless), Units.eV, random);
                        builder.putValue(-1, j, zz[j]);
                    }
                    xx.putValue(-1, x);
                    System.err.println(Units.us2000.createDatum(x += xTagWidth));
                }
                builder.nextRecord();
                xx.nextRecord();
            }
            xx.putProperty("UNITS", Units.us2000);
            builder.putProperty("DEPEND_0", xx.getDataSet());
            DDataSet yy = DDataSet.wrap(yTags[0].toDoubleArray(Units.dimensionless));
            yy.putProperty("UNITS", Units.eV);
            builder.putProperty("DEPEND_1", yy);
            return builder.getDataSet();
        }
        catch (ParseException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static void main(String[] args) {
        QDataSet ds = new PlasmaModel().getRank2();
        System.err.println(ds);
    }

    private class PlasmaModelSpec {
        double nc = 1.2;
        double wcperp = 8.0E8;
        double wcparl = 8.0E8;
        double mass = 9.11E-28;
        boolean isotropic = true;
        double geomFactor = 1.0E-37;

        public void setDensity(Datum density) {
            this.nc = density.doubleValue(Units.pcm3);
        }

        public Datum getDensity() {
            return Units.pcm3.createDatum(this.nc);
        }

        public double f(double energy, Units units) {
            if (units != Units.eV) {
                throw new IllegalArgumentException("units must be in eV");
            }
            if (!this.isotropic) {
                throw new IllegalArgumentException("distribution is not isotropic, need theta,phi");
            }
            double v = Math.sqrt(2.0 * energy * 1.6E-19 * 1.0E7 / this.mass);
            double logfc = Math.log10(this.nc / (Math.pow(Math.PI, 1.5) * this.wcparl * this.wcparl)) - 3.0 * Math.pow(v / this.wcparl, 2.0);
            return Math.pow(10.0, logfc);
        }

        public double fcounts(double energy, Units units, Random random) {
            if (units != Units.eV) {
                throw new IllegalArgumentException("units must be in eV");
            }
            double fcount = 2.0 * (energy / this.mass) * (energy / this.mass) * this.geomFactor * this.f(energy, units);
            return fcount;
        }

        public int counts(double energy, Units units, Random random) {
            if (units != Units.eV) {
                throw new IllegalArgumentException("units must be in eV");
            }
            double fcount = 2.0 * (energy / this.mass) * (energy / this.mass) * this.geomFactor * this.f(energy, units);
            return PoissonDistribution.poisson(fcount, random);
        }
    }
}

