/*
 * Decompiled with CFR 0.152.
 */
package org.virbo.demos;

import org.virbo.dataset.AbstractDataSet;

public class RipplesDataSet
extends AbstractDataSet {
    double x1;
    double y1;
    double p1;
    double x2;
    double y2;
    double p2;
    int xlen;
    int ylen;
    int rank;
    double fill = -1.0E31;

    public RipplesDataSet() {
        this(2.0, 3.0, 1.0, 13.0, 15.0, 2.0, 30, 30);
    }

    public RipplesDataSet(int len0) {
        this((double)len0 / 10.0, (double)len0 / 10.0, (double)len0 / 20.0, (double)len0 / 2.0, (double)len0 / 2.0, (double)len0 / 10.0, len0, len0);
        this.rank = 1;
    }

    public RipplesDataSet(int len0, int len1) {
        this((double)len0 / 10.0, (double)len1 / 10.0, (double)len1 / 20.0, (double)len0 / 2.0, (double)len1 / 2.0, (double)len1 / 10.0, len0, len1);
    }

    public RipplesDataSet(double x1, double y1, double p1, double x2, double y2, double p2, int xlength, int ylength) {
        this.x1 = x1;
        this.y1 = y1;
        this.p1 = p1;
        this.x2 = x2;
        this.y2 = y2;
        this.p2 = p2;
        this.xlen = xlength;
        this.ylen = ylength;
        this.rank = 2;
        this.putProperty("QUBE", Boolean.TRUE);
        this.putProperty("FILL_VALUE", this.fill);
    }

    public int rank() {
        return this.rank;
    }

    public int length() {
        return this.xlen;
    }

    public int length(int i) {
        return this.ylen;
    }

    public double value(int i) {
        return this.value(i, this.xlen * 130 / 400);
    }

    public double value(int i0, int i1) {
        double x = i0;
        double y = i1;
        if (12.0 < x && x < 14.0) {
            return this.fill;
        }
        double rad1 = Math.sqrt((x - this.x1) * (x - this.x1) + (y - this.y1) * (y - this.y1));
        double exp1 = Math.exp(-rad1 / this.p1) * Math.cos(Math.PI * rad1 / this.p1);
        double rad2 = Math.sqrt((x - this.x2) * (x - this.x2) + (y - this.y2) * (y - this.y2));
        double exp2 = Math.exp(-rad2 / this.p2) * Math.cos(Math.PI * rad2 / this.p2);
        double z = exp1 + exp2;
        return z;
    }
}

