/*
 * Decompiled with CFR 0.152.
 */
package org.virbo.dsops;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.regex.Pattern;
import org.das2.datum.Datum;
import org.das2.datum.DatumUtil;
import org.das2.datum.EnumerationUnits;
import org.das2.datum.TimeUtil;
import org.das2.datum.Units;
import org.das2.datum.UnitsConverter;
import org.das2.datum.UnitsUtil;
import org.das2.util.monitor.NullProgressMonitor;
import org.das2.util.monitor.ProgressMonitor;
import org.das2.util.monitor.SubTaskMonitor;
import org.virbo.dataset.ArrayDataSet;
import org.virbo.dataset.BundleDataSet;
import org.virbo.dataset.DDataSet;
import org.virbo.dataset.DRank0DataSet;
import org.virbo.dataset.DataSetOps;
import org.virbo.dataset.DataSetUtil;
import org.virbo.dataset.FDataSet;
import org.virbo.dataset.IDataSet;
import org.virbo.dataset.JoinDataSet;
import org.virbo.dataset.LDataSet;
import org.virbo.dataset.MutablePropertyDataSet;
import org.virbo.dataset.QDataSet;
import org.virbo.dataset.QubeDataSetIterator;
import org.virbo.dataset.RankZeroDataSet;
import org.virbo.dataset.ReverseDataSet;
import org.virbo.dataset.SDataSet;
import org.virbo.dataset.SemanticOps;
import org.virbo.dataset.TransposeRank2DataSet;
import org.virbo.dataset.WritableDataSet;
import org.virbo.demos.RipplesDataSet;
import org.virbo.dsops.CoerceUtil;
import org.virbo.dsutil.AutoHistogram;
import org.virbo.dsutil.BinAverage;
import org.virbo.dsutil.DataSetBuilder;
import org.virbo.dsutil.FFTUtil;
import org.virbo.math.Contour;
import org.virbo.math.fft.ComplexArray;
import org.virbo.math.fft.GeneralFFT;
import org.virbo.math.fft.WaveformToSpectrum;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Ops {
    public static final double PI = Math.PI;
    public static final double E = Math.E;

    public static MutablePropertyDataSet applyUnaryOp(QDataSet ds1, UnaryOp op) {
        DDataSet result = DDataSet.create(DataSetUtil.qubeDims(ds1));
        QDataSet wds = DataSetUtil.weightsDataSet(ds1);
        QubeDataSetIterator it1 = new QubeDataSetIterator(ds1);
        double fill = -1.0E38;
        while (it1.hasNext()) {
            it1.next();
            double d1 = it1.getValue(ds1);
            double w1 = it1.getValue(wds);
            it1.putValue(result, w1 == 0.0 ? fill : op.op(d1));
        }
        HashMap<String, Object> m = new HashMap<String, Object>();
        m.put("DEPEND_0", ds1.property("DEPEND_0"));
        m.put("DEPEND_1", ds1.property("DEPEND_1"));
        m.put("DEPEND_2", ds1.property("DEPEND_2"));
        m.put("DEPEND_3", ds1.property("DEPEND_3"));
        m.remove("VALID_MIN");
        m.remove("VALID_MAX");
        m.remove("TITLE");
        m.remove("LABEL");
        m.remove("MONOTONIC");
        m.remove("METADATA_MODEL");
        m.remove("METADATA");
        DataSetUtil.putProperties(m, result);
        result.putProperty("FILL_VALUE", fill);
        return result;
    }

    public static MutablePropertyDataSet applyBinaryOp(QDataSet ds1, QDataSet ds2, BinaryOp op) {
        if (ds1.rank() == ds2.rank() && ds1.rank() > 0 && ds1.length() != ds2.length()) {
            throw new IllegalArgumentException("binary option on datasets of different lengths: " + ds1 + " " + ds2);
        }
        QDataSet[] operands = new QDataSet[2];
        WritableDataSet result = CoerceUtil.coerce(ds1, ds2, true, operands);
        QubeDataSetIterator it1 = new QubeDataSetIterator(operands[0]);
        QubeDataSetIterator it2 = new QubeDataSetIterator(operands[1]);
        QDataSet w1 = DataSetUtil.weightsDataSet(operands[0]);
        QDataSet w2 = DataSetUtil.weightsDataSet(operands[1]);
        double fill = -1.0E38;
        while (it1.hasNext()) {
            it1.next();
            it2.next();
            double d1 = it1.getValue(operands[0]);
            double d2 = it2.getValue(operands[1]);
            double w = it1.getValue(w1) * it2.getValue(w2);
            it1.putValue(result, w == 0.0 ? fill : op.op(d1, d2));
        }
        Map<String, Object> m1 = DataSetUtil.getProperties(ds1);
        Map<String, Object> m2 = DataSetUtil.getProperties(ds2);
        if (m2.isEmpty() && !m1.isEmpty() && ds2.rank() == 0) {
            m2.put("DEPEND_0", m1.get("DEPEND_0"));
            m2.put("DEPEND_1", m1.get("DEPEND_1"));
            m2.put("DEPEND_2", m1.get("DEPEND_2"));
            m2.put("DEPEND_3", m1.get("DEPEND_3"));
        }
        if (m1.isEmpty() && !m2.isEmpty() && ds1.rank() == 0) {
            m1.put("DEPEND_0", m2.get("DEPEND_0"));
            m1.put("DEPEND_1", m2.get("DEPEND_1"));
            m1.put("DEPEND_2", m2.get("DEPEND_2"));
            m1.put("DEPEND_3", m2.get("DEPEND_3"));
        }
        HashMap<String, Object> m3 = Ops.equalProperties(m1, m2);
        m3.remove("VALID_MIN");
        m3.remove("VALID_MAX");
        m3.remove("TITLE");
        m3.remove("LABEL");
        m3.remove("MONOTONIC");
        m3.remove("METADATA_MODEL");
        m3.remove("METADATA");
        m3.remove("UNITS");
        DataSetUtil.putProperties(m3, result);
        result.putProperty("FILL_VALUE", fill);
        return result;
    }

    public static MutablePropertyDataSet applyBinaryOp(QDataSet ds1, double d2, BinaryOp op) {
        DDataSet result = DDataSet.create(DataSetUtil.qubeDims(ds1));
        QubeDataSetIterator it1 = new QubeDataSetIterator(ds1);
        QDataSet w1 = DataSetUtil.weightsDataSet(ds1);
        double fill = -1.0E38;
        while (it1.hasNext()) {
            it1.next();
            double w = it1.getValue(w1);
            it1.putValue(result, w == 0.0 ? fill : op.op(it1.getValue(ds1), d2));
        }
        Map<String, Object> props = DataSetUtil.getProperties(ds1);
        props.remove("VALID_MIN");
        props.remove("VALID_MAX");
        props.remove("TITLE");
        props.remove("LABEL");
        props.remove("MONOTONIC");
        props.remove("METADATA_MODEL");
        props.remove("METADATA");
        DataSetUtil.putProperties(props, result);
        result.putProperty("FILL_VALUE", fill);
        return result;
    }

    private static HashMap<String, Object> equalProperties(Map<String, Object> m1, Map<String, Object> m2) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (Map.Entry<String, Object> e : m1.entrySet()) {
            String k = e.getKey();
            Object v = e.getValue();
            if (v == null) continue;
            Object v2 = m2.get(k);
            if (v.equals(v2)) {
                result.put(k, v);
                continue;
            }
            if (!(v instanceof QDataSet) || !(v2 instanceof QDataSet) || !Ops.equivalent((QDataSet)v, (QDataSet)v2)) continue;
            result.put(k, v);
        }
        return result;
    }

    public static QDataSet add(QDataSet ds1, QDataSet ds2) {
        MutablePropertyDataSet result;
        Units units1 = SemanticOps.getUnits(ds1);
        Units units2 = SemanticOps.getUnits(ds2);
        if (units2.isConvertableTo(units1) && UnitsUtil.isRatioMeasurement((Units)units1)) {
            final UnitsConverter uc = UnitsConverter.getConverter((Units)units2, (Units)units1);
            result = Ops.applyBinaryOp(ds1, ds2, new BinaryOp(){

                public double op(double d1, double d2) {
                    return d1 + uc.convert(d2);
                }
            });
            if (units1 != Units.dimensionless) {
                result.putProperty("UNITS", units1);
            }
        } else if (UnitsUtil.isIntervalMeasurement((Units)units1)) {
            final UnitsConverter uc = UnitsConverter.getConverter((Units)units2, (Units)units1.getOffsetUnits());
            result = Ops.applyBinaryOp(ds1, ds2, new BinaryOp(){

                public double op(double d1, double d2) {
                    return d1 + uc.convert(d2);
                }
            });
            result.putProperty("UNITS", units1);
        } else if (UnitsUtil.isIntervalMeasurement((Units)units2)) {
            final UnitsConverter uc = UnitsConverter.getConverter((Units)units1, (Units)units2.getOffsetUnits());
            result = Ops.applyBinaryOp(ds1, ds2, new BinaryOp(){

                public double op(double d1, double d2) {
                    return uc.convert(d1) + d2;
                }
            });
            result.putProperty("UNITS", units2);
        } else {
            throw new IllegalArgumentException("units cannot be added: " + units1 + ", " + units2);
        }
        result.putProperty("NAME", null);
        result.putProperty("LABEL", Ops.maybeLabelInfixOp(ds1, ds2, "+"));
        return result;
    }

    public static QDataSet subtract(QDataSet ds1, QDataSet ds2) {
        MutablePropertyDataSet result;
        Units units1 = SemanticOps.getUnits(ds1);
        Units units2 = SemanticOps.getUnits(ds2);
        if (units2.isConvertableTo(units1) && UnitsUtil.isRatioMeasurement((Units)units1)) {
            final UnitsConverter uc = UnitsConverter.getConverter((Units)units2, (Units)units1);
            result = Ops.applyBinaryOp(ds1, ds2, new BinaryOp(){

                public double op(double d1, double d2) {
                    return d1 - uc.convert(d2);
                }
            });
            if (units1 != Units.dimensionless) {
                result.putProperty("UNITS", units1);
            }
        } else if (UnitsUtil.isIntervalMeasurement((Units)units1) && UnitsUtil.isIntervalMeasurement((Units)units2)) {
            final UnitsConverter uc = UnitsConverter.getConverter((Units)units2, (Units)units1);
            result = Ops.applyBinaryOp(ds1, ds2, new BinaryOp(){

                public double op(double d1, double d2) {
                    return d1 - uc.convert(d2);
                }
            });
            result.putProperty("UNITS", units1.getOffsetUnits());
        } else if (UnitsUtil.isIntervalMeasurement((Units)units1) && !UnitsUtil.isIntervalMeasurement((Units)units2)) {
            final UnitsConverter uc = UnitsConverter.getConverter((Units)units2, (Units)units1.getOffsetUnits());
            result = Ops.applyBinaryOp(ds1, ds2, new BinaryOp(){

                public double op(double d1, double d2) {
                    return d1 - uc.convert(d2);
                }
            });
            result.putProperty("UNITS", units1);
        } else {
            if (UnitsUtil.isIntervalMeasurement((Units)units2) && !UnitsUtil.isIntervalMeasurement((Units)units1)) {
                throw new IllegalArgumentException("cannot subtract interval measurement from ratio measurement: " + units1 + " - " + units2);
            }
            throw new IllegalArgumentException("cannot subtract: " + units1 + " - " + units2);
        }
        result.putProperty("NAME", null);
        result.putProperty("MONOTONIC", null);
        result.putProperty("LABEL", Ops.maybeLabelInfixOp(ds1, ds2, "-"));
        return result;
    }

    private static String maybeLabelUnaryOp(QDataSet ds1, String opStr) {
        String label1 = (String)ds1.property("LABEL");
        if (label1 == null) {
            label1 = (String)ds1.property("NAME");
        }
        if (label1 == null) {
            return null;
        }
        String l1Str = label1;
        if (l1Str != null) {
            return opStr + "(" + l1Str + ")";
        }
        return null;
    }

    private static String maybeLabelBinaryOp(QDataSet ds1, QDataSet ds2, String opStr) {
        String label2;
        String label1 = (String)ds1.property("LABEL");
        if (label1 == null) {
            label1 = (String)ds1.property("NAME");
        }
        if ((label2 = (String)ds2.property("LABEL")) == null) {
            label2 = (String)ds2.property("NAME");
        }
        if (label1 == null || label2 == null) {
            return null;
        }
        String l1Str = label1;
        String l2Str = label2;
        if (l1Str != null && l2Str != null) {
            return opStr + "(" + l1Str + "," + l2Str + ")";
        }
        return null;
    }

    private static String maybeLabelInfixOp(QDataSet ds1, QDataSet ds2, String opStr) {
        String l2Str;
        String label2;
        String label1 = (String)ds1.property("LABEL");
        if (label1 == null) {
            label1 = (String)ds1.property("NAME");
        }
        if ((label2 = (String)ds2.property("LABEL")) == null) {
            label2 = (String)ds2.property("NAME");
        }
        if (label1 == null || label2 == null) {
            return null;
        }
        if (label1.equals(label2)) {
            return null;
        }
        Pattern idpat = Pattern.compile("[a-zA-Z_][a-zA-Z_0-9]*");
        String l1Str = label1;
        if (l1Str != null && !idpat.matcher(l1Str).matches()) {
            l1Str = "(" + l1Str + ")";
        }
        if ((l2Str = label2) != null && !idpat.matcher(l2Str).matches()) {
            l2Str = "(" + l2Str + ")";
        }
        if (l1Str != null && l2Str != null) {
            return l1Str + opStr + l2Str;
        }
        return null;
    }

    public static QDataSet negate(QDataSet ds1) {
        Units u = SemanticOps.getUnits(ds1);
        if (!UnitsUtil.isRatioMeasurement((Units)u)) {
            throw new IllegalArgumentException("Units are not ratiometric units");
        }
        MutablePropertyDataSet mpds = Ops.applyUnaryOp(ds1, new UnaryOp(){

            public double op(double d1) {
                return -d1;
            }
        });
        mpds.putProperty("UNITS", u);
        return mpds;
    }

    public static QDataSet magnitude(QDataSet ds) {
        int r = ds.rank();
        QDataSet depn = (QDataSet)ds.property("DEPEND_" + (r - 1));
        boolean isCart = false;
        if (depn != null) {
            isCart = depn.property("COORDINATE_FRAME") != null ? true : ("cartesian".equals(depn.property("NAME")) ? true : ds.length(0) < 4);
        } else {
            boolean bl = isCart = ds.length(0) < 4;
        }
        if (isCart) {
            Units u = (Units)ds.property("UNITS");
            ds = Ops.pow(ds, 2.0);
            ds = Ops.total(ds, r - 1);
            ds = Ops.sqrt(ds);
            if (u != null) {
                ((MutablePropertyDataSet)ds).putProperty("UNITS", u);
            }
            return ds;
        }
        throw new IllegalArgumentException("last dim must have COORDINATE_FRAME property");
    }

    public static double total(QDataSet ds) {
        double s = 0.0;
        QubeDataSetIterator it1 = new QubeDataSetIterator(ds);
        QDataSet wds = DataSetUtil.weightsDataSet(ds);
        double fill = ((Number)wds.property("FILL_VALUE")).doubleValue();
        while (it1.hasNext()) {
            it1.next();
            double w = it1.getValue(wds);
            if (w == 0.0) {
                return fill;
            }
            s += it1.getValue(ds);
        }
        return s;
    }

    private static QDataSet averageGen(QDataSet ds, int dim, AverageOp op) {
        if (ds == null) {
            throw new NullPointerException("ds reference is null");
        }
        int[] qube = DataSetUtil.qubeDims(ds);
        if (qube == null) {
            throw new IllegalArgumentException("dataset is not a qube");
        }
        if (dim >= ds.rank()) {
            throw new IllegalArgumentException(String.format("dimension index (%d) exceeds rank (%d)", dim, ds.rank()));
        }
        int[] newQube = DataSetOps.removeElement(qube, dim);
        QDataSet wds = DataSetUtil.weightsDataSet(ds);
        DDataSet result = DDataSet.create(newQube);
        QubeDataSetIterator it1 = new QubeDataSetIterator(result);
        double fill = ((Number)wds.property("FILL_VALUE")).doubleValue();
        double[] store = new double[2];
        while (it1.hasNext()) {
            it1.next();
            op.initStore(store);
            QubeDataSetIterator it0 = new QubeDataSetIterator(ds);
            for (int i = 0; i < ds.rank(); ++i) {
                int ndim;
                int n = ndim = i < dim ? i : i - 1;
                if (i == dim) continue;
                it0.setIndexIteratorFactory(i, new QubeDataSetIterator.SingletonIteratorFactory(it1.index(ndim)));
            }
            while (it0.hasNext()) {
                it0.next();
                op.accum(it0.getValue(ds), it0.getValue(wds), store);
            }
            op.normalize(store);
            it1.putValue(result, store[1] > 0.0 ? store[0] : fill);
        }
        Map<String, Object> props = DataSetUtil.getProperties(ds);
        props = DataSetOps.sliceProperties(props, dim);
        DataSetUtil.putProperties(props, result);
        result.putProperty("FILL_VALUE", fill);
        return result;
    }

    public static QDataSet total(QDataSet ds, int dim) {
        int[] qube = DataSetUtil.qubeDims(ds);
        if (qube == null) {
            throw new IllegalArgumentException("argument does not appear to be qube");
        }
        int[] newQube = DataSetOps.removeElement(qube, dim);
        QDataSet wds = DataSetUtil.weightsDataSet(ds);
        DDataSet result = DDataSet.create(newQube);
        DDataSet weights = DDataSet.create(newQube);
        QubeDataSetIterator it1 = new QubeDataSetIterator(result);
        double fill = ((Number)wds.property("FILL_VALUE")).doubleValue();
        while (it1.hasNext()) {
            it1.next();
            int n = ds.length(dim);
            double s = 0.0;
            double w = 0.0;
            QubeDataSetIterator it0 = new QubeDataSetIterator(ds);
            for (int i = 0; i < ds.rank(); ++i) {
                int ndim;
                int n2 = ndim = i < dim ? i : i - 1;
                if (i == dim) continue;
                it0.setIndexIteratorFactory(i, new QubeDataSetIterator.SingletonIteratorFactory(it1.index(ndim)));
            }
            while (it0.hasNext()) {
                it0.next();
                double w1 = it0.getValue(wds);
                s += w1 * it0.getValue(ds);
                w += w1;
            }
            it1.putValue(result, w > 0.0 ? s : fill);
            it1.putValue(weights, w);
        }
        Ops.sliceProperties(dim, ds, result);
        result.putProperty("WEIGHTS", weights);
        result.putProperty("FILL_VALUE", fill);
        return result;
    }

    public static QDataSet reduceMax(QDataSet ds, int dim) {
        return Ops.averageGen(ds, dim, new AverageOp(){

            public void accum(double d1, double w1, double[] accum) {
                if (w1 > 0.0) {
                    accum[0] = Math.max(d1, accum[0]);
                    accum[1] = w1;
                }
            }

            public void initStore(double[] store) {
                store[0] = Double.NEGATIVE_INFINITY;
                store[1] = 0.0;
            }

            public void normalize(double[] accum) {
            }
        });
    }

    public static QDataSet reduceMin(QDataSet ds, int dim) {
        return Ops.averageGen(ds, dim, new AverageOp(){

            public void accum(double d1, double w1, double[] accum) {
                if (w1 > 0.0) {
                    accum[0] = Math.min(d1, accum[0]);
                    accum[1] = w1;
                }
            }

            public void initStore(double[] store) {
                store[0] = Double.POSITIVE_INFINITY;
                store[1] = 0.0;
            }

            public void normalize(double[] accum) {
            }
        });
    }

    public static QDataSet reduceMean(QDataSet ds, int dim) {
        return Ops.averageGen(ds, dim, new AverageOp(){

            public void accum(double d1, double w1, double[] accum) {
                accum[0] = accum[0] + w1 * d1;
                accum[1] = accum[1] + w1;
            }

            public void initStore(double[] store) {
                store[0] = 0.0;
                store[1] = 0.0;
            }

            public void normalize(double[] accum) {
                if (accum[1] > 0.0) {
                    accum[0] = accum[0] / accum[1];
                }
            }
        });
    }

    public static QDataSet sqrt(QDataSet ds) {
        MutablePropertyDataSet result = (MutablePropertyDataSet)Ops.pow(ds, 0.5);
        result.putProperty("LABEL", Ops.maybeLabelUnaryOp(ds, "sqrt"));
        return result;
    }

    public static int abs(int x) {
        return Math.abs(x);
    }

    public static long abs(long x) {
        return Math.abs(x);
    }

    public static double abs(double x) {
        return Math.abs(x);
    }

    public static QDataSet abs(QDataSet ds1) {
        MutablePropertyDataSet result = Ops.applyUnaryOp(ds1, new UnaryOp(){

            public double op(double d1) {
                return Math.abs(d1);
            }
        });
        result.putProperty("LABEL", Ops.maybeLabelUnaryOp(ds1, "abs"));
        return result;
    }

    public static long pow(long x, long y) {
        return (long)Math.pow(x, y);
    }

    public static double pow(double x, double y) {
        return Math.pow(x, y);
    }

    public static QDataSet pow(QDataSet ds1, double pow) {
        MutablePropertyDataSet result = Ops.applyBinaryOp(ds1, pow, new BinaryOp(){

            public double op(double d1, double d2) {
                return Math.pow(d1, d2);
            }
        });
        result.putProperty("LABEL", Ops.maybeLabelBinaryOp(ds1, DataSetUtil.asDataSet(pow), "pow"));
        return result;
    }

    public static QDataSet pow(QDataSet ds1, QDataSet pow) {
        MutablePropertyDataSet result = Ops.applyBinaryOp(ds1, pow, new BinaryOp(){

            public double op(double d1, double d2) {
                return Math.pow(d1, d2);
            }
        });
        result.putProperty("LABEL", Ops.maybeLabelBinaryOp(ds1, pow, "pow"));
        return result;
    }

    public static QDataSet exp(QDataSet ds) {
        MutablePropertyDataSet result = Ops.applyUnaryOp(ds, new UnaryOp(){

            public double op(double d1) {
                return Math.pow(Math.E, d1);
            }
        });
        result.putProperty("LABEL", Ops.maybeLabelUnaryOp(ds, "exp"));
        return result;
    }

    public static QDataSet exp10(QDataSet ds) {
        MutablePropertyDataSet result = Ops.applyUnaryOp(ds, new UnaryOp(){

            public double op(double d1) {
                return Math.pow(10.0, d1);
            }
        });
        result.putProperty("LABEL", Ops.maybeLabelUnaryOp(ds, "exp10"));
        return result;
    }

    public static QDataSet log(QDataSet ds) {
        MutablePropertyDataSet result = Ops.applyUnaryOp(ds, new UnaryOp(){

            public double op(double d1) {
                return Math.log(d1);
            }
        });
        result.putProperty("LABEL", Ops.maybeLabelUnaryOp(ds, "log"));
        return result;
    }

    public static QDataSet log10(QDataSet ds) {
        MutablePropertyDataSet result = Ops.applyUnaryOp(ds, new UnaryOp(){

            public double op(double d1) {
                return Math.log10(d1);
            }
        });
        result.putProperty("LABEL", Ops.maybeLabelUnaryOp(ds, "log10"));
        return result;
    }

    public static QDataSet multiply(QDataSet ds1, QDataSet ds2) {
        Units resultUnits;
        Units units1 = SemanticOps.getUnits(ds1);
        Units units2 = SemanticOps.getUnits(ds2);
        if (units1 == Units.dimensionless && units2 == Units.dimensionless) {
            resultUnits = Units.dimensionless;
        } else if (units2 == Units.dimensionless && UnitsUtil.isRatioMeasurement((Units)units1)) {
            resultUnits = units1;
        } else if (units1 == Units.dimensionless && UnitsUtil.isRatioMeasurement((Units)units2)) {
            resultUnits = units2;
        } else {
            if (!UnitsUtil.isRatioMeasurement((Units)units1)) {
                throw new IllegalArgumentException("ds1 units are not ratio units: " + units1);
            }
            if (!UnitsUtil.isRatioMeasurement((Units)units2)) {
                throw new IllegalArgumentException("ds2 units are not ratio units: " + units2);
            }
            System.err.println("throwing out units until we improve the units library, arguments have unequal units");
            resultUnits = null;
        }
        MutablePropertyDataSet result = Ops.applyBinaryOp(ds1, ds2, new BinaryOp(){

            public double op(double d1, double d2) {
                return d1 * d2;
            }
        });
        if (resultUnits != Units.dimensionless) {
            result.putProperty("UNITS", resultUnits);
        }
        result.putProperty("LABEL", Ops.maybeLabelInfixOp(ds1, ds2, "*"));
        return result;
    }

    public static QDataSet divide(QDataSet ds1, QDataSet ds2) {
        Units resultUnits;
        Units units2;
        Units units1 = SemanticOps.getUnits(ds1);
        if (units1 == (units2 = SemanticOps.getUnits(ds2))) {
            resultUnits = Units.dimensionless;
        } else if (units2 == Units.dimensionless && UnitsUtil.isRatioMeasurement((Units)units1)) {
            resultUnits = units1;
        } else {
            if (!UnitsUtil.isRatioMeasurement((Units)units1)) {
                throw new IllegalArgumentException("ds1 units are not ratio units: " + units1);
            }
            if (!UnitsUtil.isRatioMeasurement((Units)units2)) {
                throw new IllegalArgumentException("ds2 units are not ratio units: " + units2);
            }
            System.err.println("throwing out units until we improve the units library, arguments have unequal units");
            resultUnits = null;
        }
        MutablePropertyDataSet result = Ops.applyBinaryOp(ds1, ds2, new BinaryOp(){

            public double op(double d1, double d2) {
                return d1 / d2;
            }
        });
        if (resultUnits != Units.dimensionless) {
            result.putProperty("UNITS", resultUnits);
        }
        result.putProperty("LABEL", Ops.maybeLabelInfixOp(ds1, ds2, "/"));
        return result;
    }

    public static QDataSet mod(QDataSet ds1, QDataSet ds2) {
        MutablePropertyDataSet result = Ops.applyBinaryOp(ds1, ds2, new BinaryOp(){

            public double op(double d1, double d2) {
                return d1 % d2;
            }
        });
        Units u = (Units)ds2.property("UNITS");
        if (u != null) {
            result.putProperty("UNITS", u);
        }
        return result;
    }

    public static QDataSet div(QDataSet ds1, QDataSet ds2) {
        return Ops.applyBinaryOp(ds1, ds2, new BinaryOp(){

            public double op(double d1, double d2) {
                return (int)(d1 / d2);
            }
        });
    }

    public static QDataSet eq(QDataSet ds1, QDataSet ds2) {
        final UnitsConverter uc = SemanticOps.getLooseUnitsConverter(ds1, ds2);
        return Ops.applyBinaryOp(ds1, ds2, new BinaryOp(){

            public double op(double d1, double d2) {
                return uc.convert(d1) == d2 ? 1.0 : 0.0;
            }
        });
    }

    public static QDataSet ne(QDataSet ds1, QDataSet ds2) {
        final UnitsConverter uc = SemanticOps.getLooseUnitsConverter(ds1, ds2);
        return Ops.applyBinaryOp(ds1, ds2, new BinaryOp(){

            public double op(double d1, double d2) {
                return uc.convert(d1) != d2 ? 1.0 : 0.0;
            }
        });
    }

    public static QDataSet gt(QDataSet ds1, QDataSet ds2) {
        final UnitsConverter uc = SemanticOps.getLooseUnitsConverter(ds1, ds2);
        return Ops.applyBinaryOp(ds1, ds2, new BinaryOp(){

            public double op(double d1, double d2) {
                return uc.convert(d1) > d2 ? 1.0 : 0.0;
            }
        });
    }

    public static QDataSet ge(QDataSet ds1, QDataSet ds2) {
        final UnitsConverter uc = SemanticOps.getLooseUnitsConverter(ds1, ds2);
        return Ops.applyBinaryOp(ds1, ds2, new BinaryOp(){

            public double op(double d1, double d2) {
                return uc.convert(d1) >= d2 ? 1.0 : 0.0;
            }
        });
    }

    public static QDataSet lt(QDataSet ds1, QDataSet ds2) {
        final UnitsConverter uc = SemanticOps.getLooseUnitsConverter(ds1, ds2);
        return Ops.applyBinaryOp(ds1, ds2, new BinaryOp(){

            public double op(double d1, double d2) {
                return uc.convert(d1) < d2 ? 1.0 : 0.0;
            }
        });
    }

    public static QDataSet le(QDataSet ds1, QDataSet ds2) {
        final UnitsConverter uc = SemanticOps.getLooseUnitsConverter(ds1, ds2);
        return Ops.applyBinaryOp(ds1, ds2, new BinaryOp(){

            public double op(double d1, double d2) {
                return uc.convert(d1) <= d2 ? 1.0 : 0.0;
            }
        });
    }

    public static QDataSet or(QDataSet ds1, QDataSet ds2) {
        return Ops.applyBinaryOp(ds1, ds2, new BinaryOp(){

            public double op(double d1, double d2) {
                return d1 != 0.0 || d2 != 0.0 ? 1.0 : 0.0;
            }
        });
    }

    public static QDataSet and(QDataSet ds1, QDataSet ds2) {
        return Ops.applyBinaryOp(ds1, ds2, new BinaryOp(){

            public double op(double d1, double d2) {
                return d1 != 0.0 && d2 != 0.0 ? 1.0 : 0.0;
            }
        });
    }

    public static QDataSet not(QDataSet ds1) {
        return Ops.applyUnaryOp(ds1, new UnaryOp(){

            public double op(double d1) {
                return d1 != 0.0 ? 0.0 : 1.0;
            }
        });
    }

    public static QDataSet dindgen(int len0) {
        int size = len0;
        double[] back = new double[size];
        for (int i = 0; i < size; ++i) {
            back[i] = i;
        }
        return DDataSet.wrap(back, 1, len0, 1, 1);
    }

    public static QDataSet dindgen(int len0, int len1) {
        int size = len0 * len1;
        double[] back = new double[size];
        for (int i = 0; i < size; ++i) {
            back[i] = i;
        }
        return DDataSet.wrap(back, 2, len0, len1, 1);
    }

    public static QDataSet dindgen(int len0, int len1, int len2) {
        int size = len0 * len1 * len2;
        double[] back = new double[size];
        for (int i = 0; i < size; ++i) {
            back[i] = i;
        }
        return DDataSet.wrap(back, 3, len0, len1, len2);
    }

    public static QDataSet findgen(int len0) {
        int size = len0;
        float[] back = new float[size];
        for (int i = 0; i < size; ++i) {
            back[i] = i;
        }
        return FDataSet.wrap(back, 1, len0, 1, 1);
    }

    public static QDataSet findgen(int len0, int len1) {
        int size = len0 * len1;
        float[] back = new float[size];
        for (int i = 0; i < size; ++i) {
            back[i] = i;
        }
        return FDataSet.wrap(back, 2, len0, len1, 1);
    }

    public static QDataSet findgen(int len0, int len1, int len2) {
        int size = len0 * len1 * len2;
        float[] back = new float[size];
        for (int i = 0; i < size; ++i) {
            back[i] = i;
        }
        return FDataSet.wrap(back, 3, len0, len1, len2);
    }

    public static QDataSet fltarr(int len0) {
        return Ops.replicate(0.0f, len0);
    }

    public static QDataSet fltarr(int len0, int len1) {
        return Ops.replicate(0.0f, len0, len1);
    }

    public static QDataSet fltarr(int len0, int len1, int len2) {
        return Ops.replicate(0.0f, len0, len1, len2);
    }

    public static QDataSet dblarr(int len0) {
        return Ops.replicate(0.0, len0);
    }

    public static QDataSet dblarr(int len0, int len1) {
        return Ops.replicate(0.0, len0, len1);
    }

    public static QDataSet dblarr(int len0, int len1, int len2) {
        return Ops.replicate(0.0, len0, len1, len2);
    }

    public static QDataSet timegen(String baseTime, String cadence, int len0) throws ParseException {
        double base = TimeUtil.create((String)baseTime).doubleValue((Units)Units.us2000);
        String[] ss = cadence.split(" ");
        Datum cad = null;
        if (ss.length == 2) {
            try {
                Units u = SemanticOps.lookupUnits(ss[1]);
                cad = u.parse(ss[0]);
            }
            catch (ParseException ex) {
                // empty catch block
            }
        }
        if (cad == null) {
            cad = Units.us2000.getOffsetUnits().parse(cadence);
        }
        double dcadence = cad.doubleValue(Units.us2000.getOffsetUnits());
        return Ops.taggen(base, dcadence, len0, (Units)Units.us2000);
    }

    public static MutablePropertyDataSet taggen(double base, double dcadence, int len0, Units units) {
        double[] back = new double[len0];
        for (int i = 0; i < len0; ++i) {
            back[i] = base + (double)i * dcadence;
        }
        DDataSet result = DDataSet.wrap(back, 1, len0, 1, 1);
        result.putProperty("UNITS", units);
        result.putProperty("MONOTONIC", Boolean.TRUE);
        return result;
    }

    public static QDataSet linspace(double min, double max, int len0) {
        double[] back = new double[len0];
        if (len0 < 1) {
            return DDataSet.wrap(new double[]{max});
        }
        double delta = (max - min) / (double)(len0 - 1);
        for (int i = 0; i < len0; ++i) {
            back[i] = min + (double)i * delta;
        }
        return DDataSet.wrap(back, 1, len0, 1, 1);
    }

    public static WritableDataSet replicate(long val, int len0) {
        int size = len0;
        long[] back = new long[size];
        for (int i = 0; i < size; ++i) {
            back[i] = val;
        }
        return LDataSet.wrap(back, 1, len0, 1, 1, 1);
    }

    public static WritableDataSet replicate(long val, int len0, int len1) {
        int size = len0 * len1;
        long[] back = new long[size];
        for (int i = 0; i < size; ++i) {
            back[i] = val;
        }
        return LDataSet.wrap(back, 2, len0, len1, 1, 1);
    }

    public static WritableDataSet replicate(long val, int len0, int len1, int len2) {
        int size = len0 * len1 * len2;
        long[] back = new long[size];
        for (int i = 0; i < size; ++i) {
            back[i] = val;
        }
        return LDataSet.wrap(back, 3, len0, len1, len2, 1);
    }

    public static WritableDataSet replicate(double val, int len0) {
        int size = len0;
        double[] back = new double[size];
        for (int i = 0; i < size; ++i) {
            back[i] = val;
        }
        return DDataSet.wrap(back, 1, len0, 1, 1);
    }

    public static WritableDataSet replicate(double val, int len0, int len1) {
        int size = len0 * len1;
        double[] back = new double[size];
        for (int i = 0; i < size; ++i) {
            back[i] = val;
        }
        return DDataSet.wrap(back, 2, len0, len1, 1);
    }

    public static WritableDataSet replicate(double val, int len0, int len1, int len2) {
        int size = len0 * len1 * len2;
        double[] back = new double[size];
        for (int i = 0; i < size; ++i) {
            back[i] = val;
        }
        return DDataSet.wrap(back, 3, len0, len1, len2);
    }

    public static WritableDataSet replicate(float val, int len0) {
        int size = len0;
        float[] back = new float[size];
        for (int i = 0; i < size; ++i) {
            back[i] = val;
        }
        return FDataSet.wrap(back, 1, len0, 1, 1);
    }

    public static WritableDataSet replicate(float val, int len0, int len1) {
        int size = len0 * len1;
        float[] back = new float[size];
        for (int i = 0; i < size; ++i) {
            back[i] = val;
        }
        return FDataSet.wrap(back, 2, len0, len1, 1);
    }

    public static WritableDataSet replicate(float val, int len0, int len1, int len2) {
        int size = len0 * len1 * len2;
        float[] back = new float[size];
        for (int i = 0; i < size; ++i) {
            back[i] = val;
        }
        return FDataSet.wrap(back, 3, len0, len1, len2);
    }

    public static WritableDataSet zeros(int len0) {
        return Ops.replicate(0.0, len0);
    }

    public static WritableDataSet zeros(int len0, int len1) {
        return Ops.replicate(0.0, len0, len1);
    }

    public static WritableDataSet zeros(int len0, int len1, int len2) {
        return Ops.replicate(0.0, len0, len1, len2);
    }

    public static WritableDataSet zeros(QDataSet ds) {
        return DDataSet.create(DataSetUtil.qubeDims(ds));
    }

    public static QDataSet ones(int len0) {
        return Ops.replicate(1.0, len0);
    }

    public static QDataSet ones(int len0, int len1) {
        return Ops.replicate(1.0, len0, len1);
    }

    public static QDataSet ones(int len0, int len1, int len2) {
        return Ops.replicate(1.0, len0, len1, len2);
    }

    public static QDataSet concatenate(QDataSet ds1, QDataSet ds2) {
        if (ds1 == null && ds2 != null) {
            return ds2;
        }
        if (ds1 == null && ds2 == null) {
            throw new NullPointerException("both ds1 and ds2 are null");
        }
        if (ds1 == null && ds2 == null) {
            throw new IllegalArgumentException("both ds1 and ds2 are null");
        }
        if (ds1 instanceof FDataSet && ds2 instanceof FDataSet) {
            FDataSet result = (FDataSet)ArrayDataSet.copy(ds1);
            if (ds2.rank() == 0 && ds1.rank() == 1) {
                FDataSet t = FDataSet.createRank1(1);
                t.putValue(ds2.value());
                DataSetUtil.putProperties(DataSetUtil.getProperties(ds2), t);
                ds2 = t;
            } else if (ds1.rank() == 0 && ds2.rank() == 1) {
                FDataSet t = FDataSet.createRank1(1);
                t.putValue(ds1.value());
                DataSetUtil.putProperties(DataSetUtil.getProperties(ds1), t);
                result = t;
            }
            return ArrayDataSet.append(result, FDataSet.maybeCopy(ds2));
        }
        DDataSet result = (DDataSet)DDataSet.copy(ds1);
        if (ds2.rank() == 0 && ds1.rank() == 1) {
            DDataSet t = DDataSet.createRank1(1);
            t.putValue(ds2.value());
            DataSetUtil.putProperties(DataSetUtil.getProperties(ds2), t);
            ds2 = t;
        } else if (ds1.rank() == 0 && ds2.rank() == 1) {
            DDataSet t = DDataSet.createRank1(1);
            t.putValue(ds1.value());
            DataSetUtil.putProperties(DataSetUtil.getProperties(ds1), t);
            result = t;
        }
        return ArrayDataSet.append(result, DDataSet.maybeCopy(ds2));
    }

    private static QDataSet rand(int[] qube, Random rand) {
        DDataSet result = DDataSet.create(qube);
        QubeDataSetIterator it = new QubeDataSetIterator(result);
        while (it.hasNext()) {
            it.next();
            it.putValue(result, rand.nextDouble());
        }
        return result;
    }

    private static QDataSet randn(int[] qube, Random rand) {
        DDataSet result = DDataSet.create(qube);
        QubeDataSetIterator it = new QubeDataSetIterator(result);
        while (it.hasNext()) {
            it.next();
            it.putValue(result, rand.nextGaussian());
        }
        return result;
    }

    public static QDataSet rand(int len0) {
        return Ops.rand(new int[]{len0}, new Random());
    }

    public static QDataSet rand(int len0, int len1) {
        return Ops.rand(new int[]{len0, len1}, new Random());
    }

    public static QDataSet rand(int len0, int len1, int len2) {
        return Ops.rand(new int[]{len0, len1, len2}, new Random());
    }

    public static QDataSet randn(int len0) {
        return Ops.randn(new int[]{len0}, new Random());
    }

    public static QDataSet randn(int len0, int len1) {
        return Ops.randn(new int[]{len0, len1}, new Random());
    }

    public static QDataSet randn(int len0, int len1, int len2) {
        return Ops.randn(new int[]{len0, len1, len2}, new Random());
    }

    public static QDataSet randomn(long seed, int len0) {
        double[] back = Ops.randomnBack(seed, len0);
        return DDataSet.wrap(back, 1, len0, 1, 1);
    }

    public static QDataSet randomn(long seed, int len0, int len1) {
        double[] back = Ops.randomnBack(seed, len0 * len1);
        return DDataSet.wrap(back, 2, len0, len1, 1);
    }

    public static QDataSet randomn(long seed, int len0, int len1, int len2) {
        double[] back = Ops.randomnBack(seed, len0 * len1 * len2);
        return DDataSet.wrap(back, 3, len0, len1, len2);
    }

    private static double[] randomnBack(long seed, int size) {
        double[] back = new double[size];
        Random r = new Random(seed);
        for (int i = 0; i < size; ++i) {
            back[i] = r.nextGaussian();
        }
        return back;
    }

    private static double[] randomuBack(long seed, int size) {
        double[] back = new double[size];
        Random r = new Random(seed);
        for (int i = 0; i < size; ++i) {
            back[i] = r.nextDouble();
        }
        return back;
    }

    public static QDataSet randomu(long seed, int len0) {
        double[] back = Ops.randomuBack(seed, len0);
        return DDataSet.wrap(back, 1, len0, 1, 1);
    }

    public static QDataSet randomu(long seed, int len0, int len1) {
        double[] back = Ops.randomuBack(seed, len0 * len1);
        return DDataSet.wrap(back, 2, len0, len1, 1);
    }

    public static QDataSet randomu(long seed, int len0, int len1, int len2) {
        double[] back = Ops.randomuBack(seed, len0 * len1 * len2);
        return DDataSet.wrap(back, 3, len0, len1, len2);
    }

    public static QDataSet ripples(int len0) {
        return new RipplesDataSet(len0);
    }

    public static QDataSet ripples(int len0, int len1) {
        return new RipplesDataSet(len0, len1);
    }

    public static QDataSet ripples(int len, int len0, int len1) {
        FDataSet result = FDataSet.createRank3(len, len0, len1);
        for (int i = 0; i < len; ++i) {
            double eps = 1.0f + (float)i / (float)len;
            double eps2 = 1.0f + (float)(i * 5) / (float)len;
            RipplesDataSet d2 = new RipplesDataSet((double)len0 * eps / 10.0, (double)len1 / 10.0, (double)len1 * eps2 / 20.0, (double)len0 * eps / 2.0, (double)len1 / 2.0, (double)len1 * eps / 10.0, len0, len1);
            QubeDataSetIterator it = new QubeDataSetIterator(d2);
            while (it.hasNext()) {
                it.next();
                result.putValue(i, it.index(0), it.index(1), it.getValue(d2));
            }
            if (i != 0) continue;
            result.putProperty("FILL_VALUE", d2.property("FILL_VALUE"));
        }
        return result;
    }

    public static QDataSet ripples(int len, int len0, int len1, int len4) {
        FDataSet result = FDataSet.createRank4(len, len0, len1, len4);
        Random r = new Random(0L);
        for (int j = 0; j < len4; ++j) {
            double d = r.nextDouble();
            for (int i = 0; i < len; ++i) {
                double eps = 1.0f + (float)i / (float)len;
                double eps2 = 1.0f + (float)(i * 5) / (float)len;
                RipplesDataSet d2 = new RipplesDataSet((double)len0 * eps / 10.0, (double)len1 / 10.0, (double)len1 * eps2 / 20.0, (double)len0 * eps / 2.0, (double)len1 / 2.0, (double)len1 * eps / 10.0, len0, len1);
                QubeDataSetIterator it = new QubeDataSetIterator(d2);
                while (it.hasNext()) {
                    it.next();
                    result.putValue(i, it.index(0), it.index(1), j, it.getValue(d2) + d);
                }
                if (i != 0) continue;
                result.putProperty("FILL_VALUE", d2.property("FILL_VALUE"));
            }
        }
        return result;
    }

    public static QDataSet ripplesTimeSeries(int len) {
        QDataSet rip = Ops.ripples(len, 100);
        ArrayDataSet result = ArrayDataSet.copy(DataSetOps.slice1(rip, 20));
        try {
            QDataSet t = Ops.timegen("2011-10-24", String.format("%f sec", 86400.0 / (double)len), len);
            result.putProperty("DEPEND_0", t);
            return result;
        }
        catch (ParseException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static QDataSet ripplesVectorTimeSeries(int len) {
        QDataSet rip = Ops.ripples(len, 100);
        ArrayDataSet x = ArrayDataSet.copy(DataSetOps.slice1(rip, 20));
        ArrayDataSet y = ArrayDataSet.copy(DataSetOps.slice1(rip, 30));
        ArrayDataSet z = ArrayDataSet.copy(DataSetOps.slice1(rip, 40));
        x.putProperty("NAME", "X");
        y.putProperty("NAME", "Y");
        z.putProperty("NAME", "Z");
        MutablePropertyDataSet result = (MutablePropertyDataSet)Ops.bundle(Ops.bundle(x, y), z);
        try {
            QDataSet t = Ops.timegen("2011-10-24", String.format("%f sec", 86400.0 / (double)len), len);
            result.putProperty("DEPEND_0", t);
            return result;
        }
        catch (ParseException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static QDataSet ripplesSpectrogramTimeSeries(int len) {
        QDataSet rip = Ops.ripples(len, 100);
        ArrayDataSet result = ArrayDataSet.copy(DataSetOps.leafTrim(rip, 0, 27));
        result.putProperty("NAME", "Flux");
        MutablePropertyDataSet y = DataSetOps.makePropertiesMutable(Ops.pow((QDataSet)DataSetUtil.asDataSet(10.0), Ops.linspace(1.0, 4.0, 27)));
        y.putProperty("LABEL", "Energy");
        result.putProperty("DEPEND_1", y);
        try {
            QDataSet t = Ops.timegen("2011-10-24", String.format("%f sec", 86400.0 / (double)len), len);
            result.putProperty("DEPEND_0", t);
            return result;
        }
        catch (ParseException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static QDataSet circle(QDataSet radius) {
        if (radius == null) {
            radius = DataSetUtil.asDataSet(1.0);
        }
        MutablePropertyDataSet result = (MutablePropertyDataSet)Ops.link(Ops.multiply(radius, Ops.sin(Ops.linspace(0.0, 6.2936572826915524, 601))), Ops.multiply(radius, Ops.cos(Ops.linspace(0.0, 6.2936572826915524, 601))));
        result.putProperty("RENDER_TYPE", "series");
        return result;
    }

    public static QDataSet circle(double dradius) {
        DRank0DataSet radius = DataSetUtil.asDataSet(dradius);
        return Ops.circle(radius);
    }

    public static QDataSet circle(String sradius) throws ParseException {
        DRank0DataSet radius;
        if (sradius == null) {
            radius = DataSetUtil.asDataSet(1.0);
        } else {
            Datum d;
            try {
                d = DatumUtil.parse((String)sradius);
            }
            catch (ParseException ex) {
                String[] ss = sradius.split(" ", 2);
                if (ss.length == 2) {
                    Units u = SemanticOps.lookupUnits(ss[1]);
                    d = u.parse(ss[0]);
                }
                throw new IllegalArgumentException("unable to parse: " + sradius);
            }
            radius = DataSetUtil.asDataSet(d);
        }
        return Ops.circle(radius);
    }

    public static WritableDataSet copy(QDataSet src) {
        return ArrayDataSet.copy(src);
    }

    public static QDataSet sin(QDataSet ds) {
        MutablePropertyDataSet result = Ops.applyUnaryOp(ds, new UnaryOp(){

            public double op(double d1) {
                return Math.sin(d1);
            }
        });
        result.putProperty("LABEL", Ops.maybeLabelUnaryOp(result, "sin"));
        return result;
    }

    public static QDataSet asin(QDataSet ds) {
        MutablePropertyDataSet result = Ops.applyUnaryOp(ds, new UnaryOp(){

            public double op(double d1) {
                return Math.asin(d1);
            }
        });
        result.putProperty("LABEL", Ops.maybeLabelUnaryOp(result, "asin"));
        return result;
    }

    public static QDataSet cos(QDataSet ds) {
        MutablePropertyDataSet result = Ops.applyUnaryOp(ds, new UnaryOp(){

            public double op(double d1) {
                return Math.cos(d1);
            }
        });
        result.putProperty("LABEL", Ops.maybeLabelUnaryOp(result, "cos"));
        return result;
    }

    public static QDataSet acos(QDataSet ds) {
        MutablePropertyDataSet result = Ops.applyUnaryOp(ds, new UnaryOp(){

            public double op(double d1) {
                return Math.acos(d1);
            }
        });
        result.putProperty("LABEL", Ops.maybeLabelUnaryOp(result, "acos"));
        return result;
    }

    public static QDataSet tan(QDataSet ds) {
        MutablePropertyDataSet result = Ops.applyUnaryOp(ds, new UnaryOp(){

            public double op(double a) {
                return Math.tan(a);
            }
        });
        result.putProperty("LABEL", Ops.maybeLabelUnaryOp(result, "tan"));
        return result;
    }

    public static QDataSet atan(QDataSet ds) {
        MutablePropertyDataSet result = Ops.applyUnaryOp(ds, new UnaryOp(){

            public double op(double a) {
                return Math.atan(a);
            }
        });
        result.putProperty("LABEL", Ops.maybeLabelUnaryOp(result, "atan"));
        return result;
    }

    public static QDataSet atan2(QDataSet dsy, QDataSet dsx) {
        MutablePropertyDataSet result = Ops.applyBinaryOp(dsy, dsx, new BinaryOp(){

            public double op(double y, double x) {
                return Math.atan2(y, x);
            }
        });
        result.putProperty("LABEL", Ops.maybeLabelBinaryOp(dsy, dsx, "cosh"));
        return result;
    }

    public static QDataSet cosh(QDataSet ds) {
        MutablePropertyDataSet result = Ops.applyUnaryOp(ds, new UnaryOp(){

            public double op(double a) {
                return Math.cosh(a);
            }
        });
        result.putProperty("LABEL", Ops.maybeLabelUnaryOp(result, "cosh"));
        return result;
    }

    public static QDataSet sinh(QDataSet ds) {
        MutablePropertyDataSet result = Ops.applyUnaryOp(ds, new UnaryOp(){

            public double op(double a) {
                return Math.sinh(a);
            }
        });
        result.putProperty("LABEL", Ops.maybeLabelUnaryOp(result, "sinh"));
        return result;
    }

    public static QDataSet tanh(QDataSet ds) {
        MutablePropertyDataSet result = Ops.applyUnaryOp(ds, new UnaryOp(){

            public double op(double a) {
                return Math.tanh(a);
            }
        });
        result.putProperty("LABEL", Ops.maybeLabelUnaryOp(result, "tanh"));
        return result;
    }

    public static QDataSet expm1(QDataSet ds) {
        MutablePropertyDataSet result = Ops.applyUnaryOp(ds, new UnaryOp(){

            public double op(double a) {
                return Math.expm1(a);
            }
        });
        result.putProperty("LABEL", Ops.maybeLabelUnaryOp(result, "expm1"));
        return result;
    }

    public static QDataSet toRadians(QDataSet ds) {
        return Ops.applyUnaryOp(ds, new UnaryOp(){

            public double op(double y) {
                return y * Math.PI / 180.0;
            }
        });
    }

    public static QDataSet toDegrees(QDataSet ds) {
        return Ops.applyUnaryOp(ds, new UnaryOp(){

            public double op(double y) {
                return y * 180.0 / Math.PI;
            }
        });
    }

    public static QDataSet where(QDataSet ds) {
        DataSetBuilder builder;
        QubeDataSetIterator iter = new QubeDataSetIterator(ds);
        QDataSet wds = DataSetUtil.weightsDataSet(ds);
        if (ds.rank() == 1) {
            builder = new DataSetBuilder(1, 100, 1, 1);
            while (iter.hasNext()) {
                iter.next();
                if (!(iter.getValue(wds) > 0.0) || iter.getValue(ds) == 0.0) continue;
                builder.putValue(-1, iter.index(0));
                builder.nextRecord();
            }
            builder.putProperty("MONOTONIC", Boolean.TRUE);
        } else {
            builder = new DataSetBuilder(2, 100, ds.rank(), 1);
            while (iter.hasNext()) {
                iter.next();
                if (!(iter.getValue(wds) > 0.0) || iter.getValue(ds) == 0.0) continue;
                builder.putValue(-1, 0, iter.index(0));
                if (ds.rank() > 1) {
                    builder.putValue(-1, 1, iter.index(1));
                }
                if (ds.rank() > 2) {
                    builder.putValue(-1, 2, iter.index(2));
                }
                if (ds.rank() > 3) {
                    builder.putValue(-1, 3, iter.index(3));
                }
                builder.nextRecord();
            }
            if (ds.rank() == 2) {
                builder.putProperty("DEPEND_1", Ops.labels(new String[]{"dim0", "dim1"}));
            } else if (ds.rank() == 3) {
                builder.putProperty("DEPEND_1", Ops.labels(new String[]{"dim0", "dim1", "dim2"}));
            } else if (ds.rank() == 4) {
                builder.putProperty("DEPEND_1", Ops.labels(new String[]{"dim0", "dim1", "dim2", "dim4"}));
            }
        }
        builder.putProperty("CADENCE", DataSetUtil.asDataSet(1.0));
        builder.putProperty("FORMAT", "%d");
        return builder.getDataSet();
    }

    public static QDataSet sort(QDataSet ds) {
        return DataSetOps.sort(ds);
    }

    public static QDataSet uniqValues(QDataSet ds, QDataSet sort) {
        double d;
        if (ds.rank() > 1) {
            throw new IllegalArgumentException("ds.rank()>1");
        }
        if (sort != null && sort.rank() > 1) {
            throw new IllegalArgumentException("sort.rank()>1");
        }
        DataSetBuilder builder = new DataSetBuilder(1, 100);
        builder.putProperty("UNITS", ds.property("UNITS"));
        if (sort == null) {
            QubeDataSetIterator it = new QubeDataSetIterator(ds);
            if (!it.hasNext()) {
                return builder.getDataSet();
            }
            it.next();
            d = it.getValue(ds);
            while (it.hasNext()) {
                it.next();
                double d1 = it.getValue(ds);
                if (d == d1) continue;
                builder.putValue(-1, d);
                builder.nextRecord();
                d = d1;
            }
        } else {
            QubeDataSetIterator it = new QubeDataSetIterator(sort);
            if (!it.hasNext()) {
                return builder.getDataSet();
            }
            it.next();
            int i = (int)it.getValue(sort);
            d = ds.value(i);
            while (it.hasNext()) {
                it.next();
                i = (int)it.getValue(sort);
                double d1 = ds.value(i);
                if (d == d1) continue;
                builder.putValue(-1, d);
                builder.nextRecord();
                d = d1;
            }
        }
        builder.putValue(-1, d);
        builder.nextRecord();
        return builder.getDataSet();
    }

    public static QDataSet reverse(QDataSet ds) {
        return new ReverseDataSet(ds);
    }

    public static QDataSet shuffle(QDataSet ds) {
        int size = ds.length();
        int[] back = new int[size];
        for (int i = 0; i < size; ++i) {
            back[i] = i;
        }
        IDataSet wds = IDataSet.wrap(back, 1, size, 1, 1);
        Random r = new Random();
        for (int i = 0; i < size; ++i) {
            int i1 = r.nextInt(size - i) + i;
            double t = wds.value(i1);
            wds.putValue(i1, wds.value(i));
            wds.putValue(i, t);
        }
        return wds;
    }

    public static QDataSet fftFilter(QDataSet ds, int len, FFTFilterType filt) {
        JoinDataSet result;
        NullProgressMonitor mon = null;
        if (mon == null) {
            mon = new NullProgressMonitor();
        }
        if (ds.rank() == 1) {
            QDataSet c = (QDataSet)ds.property("CONTEXT_0");
            QDataSet dep0ds = (QDataSet)ds.property("DEPEND_0");
            if (c == null && dep0ds != null) {
                c = dep0ds.slice(0);
            }
            JoinDataSet dep0 = null;
            Units dep0u = null;
            JoinDataSet jds = new JoinDataSet(ds);
            if (c != null && c.rank() == 0) {
                dep0u = (Units)c.property("UNITS");
                dep0 = new JoinDataSet(c);
                if (dep0u != null) {
                    dep0.putProperty("UNITS", dep0u);
                    jds.putProperty("DEPEND_0", dep0);
                    jds.putProperty("DEPEND_1", Ops.subtract(dep0ds, c));
                }
            }
            ds = jds;
        }
        if (ds.rank() == 3) {
            result = new JoinDataSet(3);
            mon.setTaskSize((long)(ds.length() * 10));
            mon.started();
            for (int i = 0; i < ds.length(); ++i) {
                mon.setTaskProgress((long)(i * 10));
                QDataSet pow1 = Ops.fftFilter(ds.slice(i), len, filt);
                result.join(pow1);
            }
            mon.finished();
            return result;
        }
        if (ds.rank() == 2) {
            result = new JoinDataSet(2);
            result.putProperty("JOIN_0", null);
            int nsam = ds.length() * (ds.length(0) / len);
            DataSetBuilder dep0b = new DataSetBuilder(1, nsam);
            QDataSet dep0 = (QDataSet)ds.property("DEPEND_0");
            QDataSet dep1 = (QDataSet)ds.property("DEPEND_1");
            UnitsConverter uc = UnitsConverter.IDENTITY;
            if (filt != FFTFilterType.Hanning) {
                throw new UnsupportedOperationException("unsupported op: " + (Object)((Object)filt));
            }
            QDataSet filter = FFTUtil.getWindowHanning(len);
            mon.setTaskSize((long)ds.length());
            mon.started();
            mon.setProgressMessage("performing fftFilter");
            for (int i = 0; i < ds.length(); ++i) {
                for (int j = 0; j < ds.length(i) / len; ++j) {
                    QDataSet wave = ds.slice(i).trim(j * len, (j + 1) * len);
                    QDataSet vds = Ops.multiply(wave, filter);
                    result.join(vds);
                    if (dep0 != null && dep1 != null) {
                        dep0b.putValue(-1, dep0.value(i) + uc.convert(dep1.value(j * len + len / 2)));
                        dep0b.nextRecord();
                        continue;
                    }
                    if (dep0 != null) {
                        dep0b.putValue(-1, dep0.value(i));
                        dep0b.nextRecord();
                        continue;
                    }
                    dep0b = null;
                }
                mon.setTaskProgress((long)i);
            }
            mon.finished();
            if (dep0 != null) {
                dep0b.putProperty("UNITS", dep0.property("UNITS"));
                result.putProperty("DEPEND_0", dep0b.getDataSet());
            }
            if (dep1 != null) {
                result.putProperty("DEPEND_1", dep1.trim(0, len));
            }
            return result;
        }
        throw new IllegalArgumentException("rank not supported: " + ds.rank());
    }

    public static QDataSet hanning(QDataSet ds, int len) {
        return Ops.fftFilter(ds, len, FFTFilterType.Hanning);
    }

    public static QDataSet fftPower(QDataSet ds, int len, ProgressMonitor mon) {
        JoinDataSet result;
        if (mon == null) {
            mon = new NullProgressMonitor();
        }
        if (ds.rank() == 1) {
            QDataSet c = (QDataSet)ds.property("CONTEXT_0");
            JoinDataSet dep0 = null;
            Units dep0u = null;
            JoinDataSet jds = new JoinDataSet(ds);
            if (c != null && c.rank() == 0) {
                dep0u = (Units)c.property("UNITS");
                dep0 = new JoinDataSet(c);
                if (dep0u != null) {
                    dep0.putProperty("UNITS", dep0u);
                    jds.putProperty("DEPEND_0", dep0);
                }
            }
            ds = jds;
        }
        if (ds.rank() == 3) {
            result = new JoinDataSet(3);
            mon.setTaskSize((long)(ds.length() * 10));
            mon.started();
            for (int i = 0; i < ds.length(); ++i) {
                mon.setTaskProgress((long)(i * 10));
                QDataSet pow1 = Ops.fftPower(ds.slice(i), len, (ProgressMonitor)SubTaskMonitor.create((ProgressMonitor)mon, (long)(i * 10), (long)((i + 1) * 10)));
                result.join(pow1);
            }
            mon.finished();
            return result;
        }
        if (ds.rank() == 2) {
            Map user;
            result = new JoinDataSet(2);
            result.putProperty("JOIN_0", null);
            int nsam = ds.length() * (ds.length(0) / len);
            DataSetBuilder dep0b = new DataSetBuilder(1, nsam);
            QDataSet dep0 = (QDataSet)ds.property("DEPEND_0");
            QDataSet dep1 = (QDataSet)ds.property("DEPEND_1");
            UnitsConverter uc = UnitsConverter.IDENTITY;
            QDataSet translation = null;
            if (dep1 != null && (user = (Map)dep1.property("USER_PROPERTIES")) != null && (translation = (QDataSet)user.get("FFT_Translation")).rank() == 1 && translation.length() != dep0.length()) {
                throw new IllegalArgumentException("rank 1 FFT_Translation should be the same length as depend_0");
            }
            if (dep1 != null && dep1.rank() == 1) {
                QDataSet ytags = FFTUtil.getFrequencyDomainTagsForPower(dep1.trim(0, len));
                if (translation == null) {
                    result.putProperty("DEPEND_1", ytags);
                }
                Units dep1Units = (Units)dep1.property("UNITS");
                Units dep0Units = (Units)dep0.property("UNITS");
                if (dep0Units != null && dep1Units != null) {
                    uc = dep1Units.getConverter(dep0Units.getOffsetUnits());
                }
            }
            mon.setTaskSize((long)ds.length());
            mon.started();
            mon.setProgressMessage("performing fftPower");
            for (int i = 0; i < ds.length(); ++i) {
                for (int j = 0; j < ds.length(i) / len; ++j) {
                    GeneralFFT fft = GeneralFFT.newDoubleFFT(len);
                    QDataSet wave = ds.slice(i).trim(j * len, (j + 1) * len);
                    QDataSet weig = DataSetUtil.weightsDataSet(wave);
                    boolean hasFill = false;
                    for (int k = 0; k < weig.length(); ++k) {
                        if (weig.value(k) != 0.0) continue;
                        hasFill = true;
                    }
                    if (hasFill) continue;
                    QDataSet vds = FFTUtil.fftPower(fft, wave);
                    if (translation != null) {
                        QDataSet fftDep1 = (QDataSet)vds.property("DEPEND_0");
                        if (translation.rank() == 0) {
                            fftDep1 = Ops.add(fftDep1, translation);
                        } else if (translation.rank() == 1) {
                            fftDep1 = Ops.add(fftDep1, translation.slice(i));
                        } else {
                            throw new IllegalArgumentException("bad rank on FFT_Translation, expected rank 0 or rank 1");
                        }
                        ((MutablePropertyDataSet)vds).putProperty("DEPEND_0", fftDep1);
                    }
                    result.join(vds);
                    if (dep0 != null && dep1 != null) {
                        dep0b.putValue(-1, dep0.value(i) + uc.convert(dep1.value(j * len + len / 2)));
                        dep0b.nextRecord();
                        continue;
                    }
                    if (dep0 != null) {
                        dep0b.putValue(-1, dep0.value(i));
                        dep0b.nextRecord();
                        continue;
                    }
                    dep0b = null;
                }
                mon.setTaskProgress((long)i);
            }
            mon.finished();
            if (dep0 != null) {
                dep0b.putProperty("UNITS", dep0.property("UNITS"));
                result.putProperty("DEPEND_0", dep0b.getDataSet());
            }
            return result;
        }
        throw new IllegalArgumentException("rank not supported: " + ds.rank());
    }

    private static QDataSet fftPowerRank2(QDataSet ds) {
        JoinDataSet result = new JoinDataSet(2);
        for (int i = 0; i < ds.length(); ++i) {
            GeneralFFT fft = GeneralFFT.newDoubleFFT(ds.length(i));
            QDataSet vds = FFTUtil.fftPower(fft, DataSetOps.slice0(ds, i));
            result.join(vds);
        }
        QDataSet dep1 = (QDataSet)ds.property("DEPEND_1");
        if (dep1 != null && dep1.rank() == 1) {
            QDataSet ytags = FFTUtil.getFrequencyDomainTagsForPower(dep1);
            result.putProperty("DEPEND_1", ytags);
        }
        result.putProperty("DEPEND_0", ds.property("DEPEND_0"));
        return result;
    }

    private static QDataSet fftPowerRank3(QDataSet ds) {
        JoinDataSet result = new JoinDataSet(3);
        for (int i = 0; i < ds.length(); ++i) {
            QDataSet vds = Ops.fftPowerRank2(DataSetOps.slice0(ds, i));
            result.join(vds);
        }
        result.putProperty("DEPEND_0", ds.property("DEPEND_0"));
        return result;
    }

    public static QDataSet fftPower(QDataSet ds) {
        RankZeroDataSet cadence;
        if (ds.rank() == 2) {
            return Ops.fftPowerRank2(ds);
        }
        if (ds.rank() == 3) {
            return Ops.fftPowerRank3(ds);
        }
        GeneralFFT fft = GeneralFFT.newDoubleFFT(ds.length());
        ComplexArray.Double ca = FFTUtil.fft(fft, ds);
        QDataSet dep0 = (QDataSet)ds.property("DEPEND_0");
        RankZeroDataSet rankZeroDataSet = cadence = dep0 == null ? DRank0DataSet.create(1.0) : DataSetUtil.guessCadenceNew(dep0, null);
        if (cadence == null) {
            throw new IllegalArgumentException("can't establish data cadence");
        }
        double[] xtags = FFTUtil.getFrequencyDomainTags(1.0 / cadence.value(), ds.length());
        double binsize = 2.0 * xtags[xtags.length / 2] / (double)ds.length();
        Units invUnits = null;
        try {
            invUnits = UnitsUtil.getInverseUnit((Units)SemanticOps.getUnits(cadence));
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
        DDataSet result = DDataSet.createRank1(ds.length() / 2);
        DDataSet resultDep0 = DDataSet.createRank1(ds.length() / 2);
        for (int i = 0; i < ds.length() / 2; ++i) {
            result.putValue(i, (double)(i == 0 ? 1 : 4) * ComplexArray.magnitude2(ca, i) / binsize);
            resultDep0.putValue(i, xtags[i]);
        }
        if (invUnits != null) {
            resultDep0.putProperty("UNITS", invUnits);
        }
        result.putProperty("DEPEND_0", resultDep0);
        return result;
    }

    public static QDataSet fft(QDataSet ds) {
        RankZeroDataSet cadence;
        GeneralFFT fft = GeneralFFT.newDoubleFFT(ds.length());
        ComplexArray.Double cc = FFTUtil.fft(fft, ds);
        DDataSet result = DDataSet.createRank2(ds.length(), 2);
        for (int i = 0; i < ds.length(); ++i) {
            result.putValue(i, 0, cc.getReal(i));
            result.putValue(i, 1, cc.getImag(i));
        }
        QDataSet dep0 = (QDataSet)ds.property("DEPEND_0");
        RankZeroDataSet rankZeroDataSet = cadence = dep0 == null ? DRank0DataSet.create(1.0) : DataSetUtil.guessCadenceNew(dep0, null);
        if (cadence == null) {
            throw new IllegalArgumentException("can't establish data cadence");
        }
        double[] tags = FFTUtil.getFrequencyDomainTags(1.0 / cadence.value(), ds.length());
        result.putProperty("DEPEND_0", DDataSet.wrap(tags));
        EnumerationUnits u1 = EnumerationUnits.create((Object)"complexCoordinates");
        DDataSet dep1 = DDataSet.createRank1(2);
        dep1.putValue(0, u1.createDatum((Object)"real").doubleValue((Units)u1));
        dep1.putValue(1, u1.createDatum((Object)"imag").doubleValue((Units)u1));
        dep1.putProperty("COORDINATE_FRAME", "ComplexNumber");
        dep1.putProperty("UNITS", u1);
        result.putProperty("DEPEND_1", dep1);
        return result;
    }

    public static QDataSet fftWindow(QDataSet ds, int len) {
        QDataSet result = WaveformToSpectrum.getTableDataSet(ds, len);
        return result;
    }

    public static QDataSet extent(QDataSet ds) {
        return Ops.extent(ds, null);
    }

    public static QDataSet extent(QDataSet ds, QDataSet range) {
        double[] result;
        QDataSet max = ds;
        QDataSet min = ds;
        QDataSet deltaplus = (QDataSet)ds.property("DELTA_PLUS");
        QDataSet deltaminus = (QDataSet)ds.property("DELTA_MINUS");
        QDataSet w = DataSetUtil.weightsDataSet(ds);
        int count = 0;
        double fill = ((Number)w.property("FILL_VALUE")).doubleValue();
        if (range == null) {
            result = new double[]{Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY};
        } else {
            result = new double[]{range.value(0), range.value(1)};
            if (range.value(0) == fill) {
                System.err.println("range passed into extent contained fill");
            }
        }
        if (ds.rank() == 1 && Boolean.TRUE.equals(ds.property("MONOTONIC")) && deltaplus == null) {
            int ifirst;
            int n = ds.length();
            int ilast = n - 1;
            for (ifirst = 0; ifirst < n && w.value(ifirst) == 0.0; ++ifirst) {
            }
            while (ilast >= 0 && w.value(ilast) == 0.0) {
                --ilast;
            }
            count = Math.max(0, ilast - ifirst + 1);
            if (count > 0) {
                result[0] = Math.min(result[0], ds.value(ifirst));
                result[1] = Math.max(result[1], ds.value(ilast));
            } else {
                result[0] = range == null ? fill : range.value(0);
                result[1] = range == null ? fill : range.value(1);
            }
        } else {
            if (deltaplus != null) {
                max = Ops.add(ds, deltaplus);
            }
            if (deltaminus != null) {
                min = Ops.subtract(ds, deltaminus);
            }
            QubeDataSetIterator it = new QubeDataSetIterator(ds);
            while (it.hasNext()) {
                it.next();
                if (!(it.getValue(w) > 0.0)) continue;
                ++count;
                result[0] = Math.min(result[0], it.getValue(min));
                result[1] = Math.max(result[1], it.getValue(max));
            }
            if (count == 0) {
                result[0] = fill;
                result[1] = fill;
            }
        }
        DDataSet qresult = DDataSet.wrap(result);
        qresult.putProperty("SCALE_TYPE", ds.property("SCALE_TYPE"));
        qresult.putProperty("USER_PROPERTIES", Collections.singletonMap("count", count));
        qresult.putProperty("BINS_0", "min,maxInclusive");
        qresult.putProperty("UNITS", ds.property("UNITS"));
        if (result[0] == fill) {
            qresult.putProperty("FILL_VALUE", fill);
        }
        return qresult;
    }

    public static QDataSet rescaleRange(QDataSet dr, double min, double max) {
        if (dr.rank() != 1) {
            throw new IllegalArgumentException("Rank must be 1");
        }
        double w = dr.value(1) - dr.value(0);
        if (Double.isInfinite(w) || Double.isNaN(w)) {
            throw new RuntimeException("width is not finite");
        }
        if (w == 0.0) {
            throw new RuntimeException("width is zero!");
        }
        DDataSet result = DDataSet.createRank1(2);
        result.putValue(0, dr.value(0) + w * min);
        result.putValue(1, dr.value(0) + w * max);
        DataSetUtil.copyDimensionProperties(dr, result);
        return result;
    }

    public static QDataSet histogram(QDataSet ds, double min, double max, double binSize) {
        return DataSetOps.histogram(ds, min, max, binSize);
    }

    public static QDataSet histogram(QDataSet ds, int binCount) {
        if ("log".equals(ds.property("SCALE_TYPE"))) {
            QDataSet linds = Ops.log10(ds);
            QDataSet range = Ops.extent(linds);
            double width = range.value(1) - range.value(0);
            MutablePropertyDataSet h = (MutablePropertyDataSet)Ops.histogram(linds, range.value(0), range.value(1), width / (double)binCount);
            MutablePropertyDataSet bins = (MutablePropertyDataSet)h.property("DEPEND_0");
            bins = (MutablePropertyDataSet)Ops.exp10(bins);
            bins.putProperty("SCALE_TYPE", "log");
            bins.putProperty("LABEL", ds.property("LABEL"));
            bins.putProperty("TITLE", ds.property("TITLE"));
            h.putProperty("DEPEND_0", bins);
            return h;
        }
        QDataSet range = Ops.extent(ds);
        double width = range.value(1) - range.value(0);
        return Ops.histogram(ds, range.value(0), range.value(1), width / (double)binCount);
    }

    public static QDataSet autoHistogram(QDataSet ds) {
        AutoHistogram ah = new AutoHistogram();
        return ah.doit(ds);
    }

    public static QDataSet outerProduct(QDataSet ds1, QDataSet ds2) {
        DDataSet result = DDataSet.createRank2(ds1.length(), ds2.length());
        for (int i = 0; i < ds1.length(); ++i) {
            for (int j = 0; j < ds2.length(); ++j) {
                result.putValue(i, j, ds1.value(i) * ds2.value(j));
            }
        }
        return result;
    }

    public static QDataSet floor(QDataSet ds1) {
        return Ops.applyUnaryOp(ds1, new UnaryOp(){

            public double op(double a) {
                return Math.floor(a);
            }
        });
    }

    public static QDataSet ceil(QDataSet ds1) {
        return Ops.applyUnaryOp(ds1, new UnaryOp(){

            public double op(double a) {
                return Math.ceil(a);
            }
        });
    }

    public static QDataSet signum(QDataSet ds1) {
        return Ops.applyUnaryOp(ds1, new UnaryOp(){

            public double op(double a) {
                return Math.signum(a);
            }
        });
    }

    public static QDataSet copysign(QDataSet magnitude, QDataSet sign) {
        return Ops.applyBinaryOp(magnitude, sign, new BinaryOp(){

            public double op(double m, double s) {
                double s1 = Math.signum(s);
                return Math.abs(m) * (s1 == 0.0 ? 1.0 : s1);
            }
        });
    }

    public static QDataSet findex(QDataSet uu, QDataSet vv) {
        if (!DataSetUtil.isMonotonic(uu)) {
            throw new IllegalArgumentException("u must be monotonic");
        }
        DDataSet result = DDataSet.create(DataSetUtil.qubeDims(vv));
        QubeDataSetIterator it = new QubeDataSetIterator(vv);
        int ic0 = 0;
        int ic1 = 1;
        double uc0 = uu.value(ic0);
        double uc1 = uu.value(ic1);
        int n = uu.length();
        Units vvunits = SemanticOps.getUnits(vv);
        Units uuunits = SemanticOps.getUnits(uu);
        UnitsConverter uc = UnitsConverter.getConverter((Units)vvunits, (Units)uuunits);
        while (it.hasNext()) {
            it.next();
            double d = uc.convert(it.getValue(vv));
            if (uc0 <= d && d <= uc1) {
                double ff = (d - uc0) / (uc1 - uc0);
                it.putValue(result, (double)ic0 + ff);
                continue;
            }
            int index = DataSetUtil.binarySearch(uu, d, 0, uu.length() - 1);
            if (index == -1) {
                index = 0;
                ic0 = 0;
                ic1 = 1;
            } else if (index < -n) {
                ic0 = n - 2;
                ic1 = n - 1;
            } else if (index < 0) {
                ic1 = ~index;
                ic0 = ic1 - 1;
            } else if (index >= n - 1) {
                ic0 = n - 2;
                ic1 = n - 1;
            } else {
                ic0 = index;
                ic1 = index + 1;
            }
            uc0 = uu.value(ic0);
            uc1 = uu.value(ic1);
            double ff = (d - uc0) / (uc1 - uc0);
            it.putValue(result, (double)ic0 + ff);
        }
        return result;
    }

    public static QDataSet interpolate(QDataSet vv, QDataSet findex) {
        DDataSet result = DDataSet.create(DataSetUtil.qubeDims(findex));
        QubeDataSetIterator it = new QubeDataSetIterator(findex);
        int n = vv.length();
        QDataSet wds = DataSetUtil.weightsDataSet(vv);
        double fill = (Double)wds.property("FILL_VALUE");
        result.putProperty("FILL_VALUE", fill);
        while (it.hasNext()) {
            int ic1;
            int ic0;
            it.next();
            double ff = it.getValue(findex);
            if (ff < 0.0) {
                ic0 = 0;
                ic1 = 1;
            } else if (ff >= (double)(n - 1)) {
                ic0 = n - 2;
                ic1 = n - 1;
            } else {
                ic0 = (int)Math.floor(ff);
                ic1 = ic0 + 1;
            }
            double alpha = ff - (double)ic0;
            if (wds.value(ic0) > 0.0 && wds.value(ic1) > 0.0) {
                double vv0 = vv.value(ic0);
                double vv1 = vv.value(ic1);
                it.putValue(result, vv0 + alpha * (vv1 - vv0));
                continue;
            }
            it.putValue(result, fill);
        }
        DataSetUtil.copyDimensionProperties(vv, result);
        return result;
    }

    public static QDataSet interpolate(QDataSet vv, QDataSet findex0, QDataSet findex1) {
        DDataSet result = DDataSet.create(DataSetUtil.qubeDims(findex0));
        QubeDataSetIterator it = new QubeDataSetIterator(findex0);
        int n0 = vv.length();
        int n1 = vv.length(0);
        while (it.hasNext()) {
            int ic11;
            int ic10;
            int ic01;
            int ic00;
            it.next();
            double ff0 = it.getValue(findex0);
            double ff1 = it.getValue(findex1);
            if (ff0 < 0.0) {
                ic00 = 0;
                ic01 = 1;
            } else if (ff0 >= (double)(n0 - 1)) {
                ic00 = n0 - 2;
                ic01 = n0 - 1;
            } else {
                ic00 = (int)Math.floor(ff0);
                ic01 = ic00 + 1;
            }
            if (ff1 < 0.0) {
                ic10 = 0;
                ic11 = 1;
            } else if (ff1 >= (double)(n1 - 1)) {
                ic10 = n1 - 2;
                ic11 = n1 - 1;
            } else {
                ic10 = (int)Math.floor(ff1);
                ic11 = ic10 + 1;
            }
            double alpha0 = ff0 - (double)ic00;
            double alpha1 = ff1 - (double)ic10;
            double vv00 = vv.value(ic00, ic10);
            double vv01 = vv.value(ic00, ic11);
            double vv10 = vv.value(ic01, ic10);
            double vv11 = vv.value(ic01, ic11);
            it.putValue(result, vv00 * (1.0 - alpha0) * (1.0 - alpha1) + vv01 * (1.0 - alpha0) * alpha1 + vv10 * alpha0 * (1.0 - alpha1) + vv11 * alpha0 * alpha1);
        }
        return result;
    }

    public static QDataSet valid(QDataSet ds) {
        return DataSetUtil.weightsDataSet(ds);
    }

    public static QDataSet smooth(QDataSet ds, int size) {
        if (ds.rank() > 1) {
            throw new IllegalArgumentException("only rank 1");
        }
        DDataSet result = BinAverage.boxcar(ds, size);
        DataSetUtil.copyDimensionProperties(ds, result);
        return result;
    }

    public static QDataSet contour(QDataSet tds, QDataSet vv) {
        QDataSet vds = Contour.contour(tds, vv);
        return vds;
    }

    public static QDataSet diff(QDataSet ds) {
        String label;
        if (ds.rank() > 1) {
            throw new IllegalArgumentException("only rank 1");
        }
        DDataSet result = DDataSet.createRank1(ds.length() - 1);
        QDataSet w1 = DataSetUtil.weightsDataSet(ds);
        QDataSet dep0ds = (QDataSet)ds.property("DEPEND_0");
        DDataSet dep0 = null;
        if (dep0ds != null) {
            dep0 = DDataSet.createRank1(ds.length() - 1);
            DataSetUtil.putProperties(DataSetUtil.getProperties(dep0ds), dep0);
        }
        double fill = ((Number)w1.property("FILL_VALUE")).doubleValue();
        for (int i = 0; i < result.length(); ++i) {
            if (w1.value(i) > 0.0 && w1.value(i + 1) > 0.0) {
                result.putValue(i, ds.value(i + 1) - ds.value(i));
            } else {
                result.putValue(i, fill);
            }
            if (dep0ds == null) continue;
            dep0.putValue(i, (dep0ds.value(i + 1) + dep0ds.value(i)) / 2.0);
        }
        result.putProperty("FILL_VALUE", new Double(fill));
        Units u = (Units)ds.property("UNITS");
        if (u != null) {
            result.putProperty("UNITS", u.getOffsetUnits());
        }
        result.putProperty("NAME", null);
        result.putProperty("MONOTONIC", null);
        if (dep0ds != null) {
            result.putProperty("DEPEND_0", dep0);
        }
        if ((label = (String)ds.property("LABEL")) != null) {
            result.putProperty("LABEL", "diff(" + label + ")");
        }
        return result;
    }

    public static QDataSet accum(QDataSet accumDs, QDataSet ds) {
        if (ds.rank() > 1) {
            throw new IllegalArgumentException("only rank 1");
        }
        double accum = 0.0;
        QDataSet accumDep0Ds = null;
        double accumDep0 = 0.0;
        QDataSet dep0ds = (QDataSet)ds.property("DEPEND_0");
        if (accumDs == null) {
            accumDep0 = dep0ds != null ? dep0ds.value(0) : 0.0;
        } else if (accumDs.rank() == 0) {
            accum = accumDs.value();
            accumDep0Ds = (QDataSet)accumDs.property("CONTEXT_0");
            accumDep0 = accumDep0Ds != null ? accumDep0Ds.value() : 0.0;
        } else if (accumDs.rank() == 1) {
            accum = accumDs.value(accumDs.length() - 1);
            accumDep0Ds = (QDataSet)accumDs.property("DEPEND_0");
            accumDep0 = accumDep0Ds != null ? accumDep0Ds.value(accumDs.length()) : 0.0;
        }
        WritableDataSet result = Ops.zeros(ds);
        DDataSet dep0 = null;
        if (dep0ds != null) {
            dep0 = DDataSet.createRank1(ds.length());
            DataSetUtil.putProperties(DataSetUtil.getProperties(dep0ds), dep0);
        }
        for (int i = 0; i < result.length(); ++i) {
            result.putValue(i, accum += ds.value(i));
            if (dep0ds == null) continue;
            dep0.putValue(i, (accumDep0 + dep0ds.value(i)) / 2.0);
            accumDep0 = dep0ds.value(i);
        }
        if (dep0 != null) {
            // empty if block
        }
        return result;
    }

    public static QDataSet accum(QDataSet ds) {
        return Ops.accum(null, ds);
    }

    public static QDataSet flatten(QDataSet ds) {
        if (ds.rank() == 0) {
            DDataSet result = DDataSet.createRank1(1);
            result.putValue(0, ds.value());
            DataSetUtil.copyDimensionProperties(ds, result);
            return result;
        }
        if (ds.rank() == 1) {
            return ds;
        }
        if (ds.rank() == 2) {
            return DataSetOps.flattenRank2(ds);
        }
        throw new UnsupportedOperationException("only rank 0,1,and 2 supported");
    }

    public static QDataSet labels(String[] labels, String context) {
        EnumerationUnits u;
        try {
            Units uu = Units.getByName((String)context);
            u = uu != null && uu instanceof EnumerationUnits ? (EnumerationUnits)uu : new EnumerationUnits(context);
        }
        catch (IllegalArgumentException ex) {
            u = new EnumerationUnits(context);
        }
        SDataSet result = SDataSet.createRank1(labels.length);
        for (int i = 0; i < labels.length; ++i) {
            Datum d = u.createDatum((Object)labels[i]);
            result.putValue(i, d.doubleValue((Units)u));
        }
        result.putProperty("UNITS", u);
        return result;
    }

    public static QDataSet labels(String[] labels) {
        return Ops.labels(labels, "default");
    }

    private static void sliceProperties(int removeDim, QDataSet ds, MutablePropertyDataSet result) {
        for (int i = 0; i < result.rank(); ++i) {
            if (i >= removeDim) {
                result.putProperty("DEPEND_" + i, ds.property("DEPEND_" + (i + 1)));
                continue;
            }
            result.putProperty("DEPEND_" + i, ds.property("DEPEND_" + i));
        }
    }

    public static QDataSet slices(QDataSet ds, Object ... args) {
        int cdim = 0;
        int sdim = 0;
        QDataSet result = ds;
        for (int i = 0; i < args.length; ++i) {
            String s;
            if (args[i] instanceof Integer) {
                int sliceIdx = (Integer)args[i];
                if (cdim == i) {
                    result = result.slice(sliceIdx);
                    ++cdim;
                } else {
                    switch (i - sdim) {
                        case 1: {
                            result = DataSetOps.slice1(result, sliceIdx);
                            break;
                        }
                        case 2: {
                            result = DataSetOps.slice2(result, sliceIdx);
                            break;
                        }
                        case 3: {
                            result = DataSetOps.slice3(result, sliceIdx);
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException("slice not implemented, too many slices follow non-slice");
                        }
                    }
                }
                ++sdim;
                continue;
            }
            if (!(args[i] instanceof String) || !(s = (String)args[i]).contains("=")) continue;
            throw new IllegalArgumentException("argument not supported in this version: " + s);
        }
        return result;
    }

    public static QDataSet reform(QDataSet ds) {
        int[] dsqube = DataSetUtil.qubeDims(ds);
        ArrayList<Integer> newQube = new ArrayList<Integer>();
        int[] dimMap = new int[dsqube.length];
        boolean foundDim = false;
        int removeDim = -1;
        for (int i = 0; i < dsqube.length; ++i) {
            if (dsqube[i] != 1 || foundDim) {
                newQube.add(dsqube[i]);
                dimMap[i] = foundDim ? i + 1 : i;
                continue;
            }
            foundDim = true;
            removeDim = i;
        }
        if (!foundDim) {
            throw new IllegalArgumentException("there were no dimensions with length 1");
        }
        int[] qube = new int[newQube.size()];
        for (int i = 0; i < newQube.size(); ++i) {
            qube[i] = (Integer)newQube.get(i);
        }
        MutablePropertyDataSet result = (MutablePropertyDataSet)Ops.reform(ds, qube);
        Ops.sliceProperties(removeDim, ds, result);
        return result;
    }

    public static QDataSet reform(QDataSet ds, int[] qube) {
        QubeDataSetIterator it0 = new QubeDataSetIterator(ds);
        DDataSet result = DDataSet.create(qube);
        QubeDataSetIterator it1 = new QubeDataSetIterator(result);
        while (it0.hasNext() && it1.hasNext()) {
            it0.next();
            it1.next();
            double v = it0.getValue(ds);
            it1.putValue(result, v);
        }
        if (it0.hasNext() != it1.hasNext()) {
            throw new IllegalArgumentException("reform fails because different number of elements: " + it0 + " -> " + it1);
        }
        DataSetUtil.copyDimensionProperties(ds, result);
        return result;
    }

    public static QDataSet bundle(QDataSet ds1, QDataSet ds2) {
        if (ds1 == null && ds2 == null) {
            throw new NullPointerException("both ds1 and ds2 are null");
        }
        if (ds1 == null && ds2 != null) {
            BundleDataSet ds = ds2.rank() == 0 ? BundleDataSet.createRank0Bundle() : new BundleDataSet();
            ds.bundle(ds2);
            return ds;
        }
        if (ds1.rank() == ds2.rank()) {
            BundleDataSet ds = new BundleDataSet();
            ds.bundle(ds1);
            ds.bundle(ds2);
            return ds;
        }
        if (ds1 instanceof BundleDataSet && ds1.rank() - 1 == ds2.rank()) {
            ((BundleDataSet)ds1).bundle(ds2);
            return ds1;
        }
        throw new IllegalArgumentException("not supported yet");
    }

    public static boolean isLegacyBundle(QDataSet zds) {
        QDataSet dep0;
        Units u;
        QDataSet dep1;
        return zds.rank() == 2 ? (dep1 = (QDataSet)zds.property("DEPEND_1")) != null && (u = (Units)dep1.property("UNITS")) instanceof EnumerationUnits : zds.rank() == 1 && (dep0 = (QDataSet)zds.property("DEPEND_0")) != null && (u = (Units)dep0.property("UNITS")) instanceof EnumerationUnits;
    }

    public static boolean isBundle(QDataSet zds) {
        if (zds.rank() == 1) {
            return zds.property("BUNDLE_0") != null;
        }
        if (zds.rank() == 2) {
            return zds.property("BUNDLE_1") != null;
        }
        return false;
    }

    public static QDataSet link(QDataSet x, QDataSet y) {
        ArrayList<String> problems;
        if (y.rank() == 1) {
            String xname = (String)x.property("NAME");
            String yname = (String)y.property("NAME");
            if (xname == null) {
                xname = "data0";
            }
            if (yname == null) {
                yname = "data1";
            }
            QDataSet result = Ops.bundle(x, y);
            BundleDataSet.BundleDescriptor bds = (BundleDataSet.BundleDescriptor)result.property("BUNDLE_1");
            bds.putProperty("CONTEXT_0", 1, xname);
            bds.putProperty("NAME", 0, xname);
            bds.putProperty("NAME", 1, yname);
            bds.putProperty("DEPEND_0", 1, xname);
            ArrayList<String> problems2 = new ArrayList<String>();
            if (DataSetUtil.validate(result, problems2)) {
                return result;
            }
            throw new IllegalArgumentException((String)problems2.get(0));
        }
        ArrayDataSet zds = ArrayDataSet.copy(y);
        if (x != null) {
            zds.putProperty("DEPEND_0", x);
        }
        if (!DataSetUtil.validate(zds, problems = new ArrayList<String>())) {
            throw new IllegalArgumentException((String)problems.get(0));
        }
        return zds;
    }

    public static QDataSet link(QDataSet x, QDataSet y, QDataSet z) {
        ArrayList<String> problems;
        if (z.rank() == 1) {
            String xname = (String)x.property("NAME");
            String yname = (String)y.property("NAME");
            String zname = (String)z.property("NAME");
            if (xname == null) {
                xname = "data0";
            }
            if (yname == null) {
                yname = "data1";
            }
            if (zname == null) {
                zname = "data2";
            }
            QDataSet result = Ops.bundle(Ops.bundle(x, y), z);
            BundleDataSet.BundleDescriptor bds = (BundleDataSet.BundleDescriptor)result.property("BUNDLE_1");
            bds.putProperty("CONTEXT_0", 2, xname + "," + yname);
            bds.putProperty("NAME", 0, xname);
            bds.putProperty("NAME", 1, yname);
            bds.putProperty("NAME", 2, zname);
            ArrayList<String> problems2 = new ArrayList<String>();
            if (DataSetUtil.validate(result, problems2)) {
                return result;
            }
            throw new IllegalArgumentException((String)problems2.get(0));
        }
        if (z.rank() == 2 && Ops.isBundle(z)) {
            MutablePropertyDataSet z1 = DataSetOps.slice1(z, z.length(0) - 1);
            return Ops.link(x, y, z1);
        }
        ArrayDataSet zds = ArrayDataSet.copy(z);
        if (x != null) {
            zds.putProperty("DEPEND_0", x);
        }
        if (y != null) {
            zds.putProperty("DEPEND_1", y);
        }
        if (!DataSetUtil.validate(zds, problems = new ArrayList<String>())) {
            throw new IllegalArgumentException((String)problems.get(0));
        }
        return zds;
    }

    public static QDataSet link(QDataSet d0, QDataSet d1, QDataSet d2, QDataSet z) {
        ArrayList<String> problems;
        if (z.rank() == 1) {
            String a1name = (String)d0.property("NAME");
            String a2name = (String)d1.property("NAME");
            String a3name = (String)d2.property("NAME");
            String a4name = (String)z.property("NAME");
            if (a1name == null) {
                a1name = "data0";
            }
            if (a2name == null) {
                a2name = "data1";
            }
            if (a3name == null) {
                a3name = "data2";
            }
            if (a4name == null) {
                a4name = "data3";
            }
            QDataSet result = Ops.bundle(Ops.bundle(Ops.bundle(d0, d1), d2), z);
            BundleDataSet.BundleDescriptor bds = (BundleDataSet.BundleDescriptor)result.property("BUNDLE_1");
            bds.putProperty("NAME", 0, a1name);
            bds.putProperty("NAME", 1, a2name);
            bds.putProperty("NAME", 2, a3name);
            bds.putProperty("NAME", 3, a4name);
            ArrayList<String> problems2 = new ArrayList<String>();
            if (DataSetUtil.validate(result, problems2)) {
                return result;
            }
            throw new IllegalArgumentException((String)problems2.get(0));
        }
        ArrayDataSet zds = ArrayDataSet.copy(z);
        if (d0 != null) {
            zds.putProperty("DEPEND_0", d0);
        }
        if (d1 != null) {
            zds.putProperty("DEPEND_1", d1);
        }
        if (d2 != null) {
            zds.putProperty("DEPEND_2", d2);
        }
        if (!DataSetUtil.validate(zds, problems = new ArrayList<String>())) {
            throw new IllegalArgumentException((String)problems.get(0));
        }
        return zds;
    }

    public static MutablePropertyDataSet dependsOn(QDataSet ds, int dim, QDataSet dep0) {
        MutablePropertyDataSet mds = DataSetOps.makePropertiesMutable(ds);
        if (dim == 0) {
            if (dep0 != null && ds.length() != dep0.length()) {
                throw new IllegalArgumentException(String.format("ds.length()!=dep.length() (%d!=%d)", ds.length(), dep0.length()));
            }
            mds.putProperty("DEPEND_0", dep0);
        } else if (dim == 1) {
            if (dep0 != null && ds.length(0) != dep0.length()) {
                throw new IllegalArgumentException(String.format("ds.length(0)!=dep.length() (%d!=%d)", ds.length(0), dep0.length()));
            }
            mds.putProperty("DEPEND_1", dep0);
        } else if (dim == 2) {
            if (dep0 != null && ds.length(0, 0) != dep0.length()) {
                throw new IllegalArgumentException(String.format("ds.length(0,0)!=dep.length() (%d!=%d)", ds.length(0, 0), dep0.length()));
            }
            mds.putProperty("DEPEND_2", dep0);
        }
        return mds;
    }

    public static QDataSet join(QDataSet ds1, QDataSet ds2) {
        if (ds1 == null && ds2 == null) {
            throw new NullPointerException("both ds1 and ds2 are null");
        }
        if (ds1 == null && ds2 != null) {
            JoinDataSet ds = new JoinDataSet(ds2.rank() + 1);
            ds.join(ds2);
            return ds;
        }
        if (ds1.rank() == ds2.rank()) {
            JoinDataSet ds = new JoinDataSet(ds1.rank() + 1);
            ds.join(ds1);
            ds.join(ds2);
            return ds;
        }
        if (ds1 instanceof JoinDataSet && ds1.rank() - 1 == ds2.rank()) {
            ((JoinDataSet)ds1).join(ds2);
            return ds1;
        }
        throw new IllegalArgumentException("not supported yet");
    }

    public static String guessName(QDataSet ds) {
        String label = (String)ds.property("NAME");
        if (label == null && (label = (String)ds.property("LABEL")) != null) {
            label = Ops.safeName(label);
        }
        if (label == null) {
            return null;
        }
        return label;
    }

    public static String saferName(String suggest) {
        return suggest.trim().replaceAll("\\|", "_");
    }

    public static String safeName(String suggest) {
        StringBuilder result;
        if (suggest.startsWith("|") && suggest.endsWith("|")) {
            suggest = suggest.substring(1, suggest.length() - 1) + "_mag";
        }
        if ((result = new StringBuilder(suggest.replaceAll(" ", "_"))).length() == 0) {
            return "ds";
        }
        if (!Character.isJavaIdentifierStart(result.charAt(0))) {
            if (!Character.isJavaIdentifierPart(result.charAt(0))) {
                result.replace(0, 1, "_");
            } else {
                result.insert(0, "_");
            }
        }
        for (int i = 1; i < result.length(); ++i) {
            if (result.charAt(i) == '.') {
                result.replace(i, i + 1, "pt");
                ++i;
                continue;
            }
            if (result.charAt(i) == '*') {
                result.replace(i, i + 1, "star");
                i += 3;
                continue;
            }
            if (result.charAt(i) == '/') {
                result.replace(i, i + 1, "div");
                i += 2;
                continue;
            }
            if (result.charAt(i) == '+') {
                result.replace(i, i + 1, "plus");
                i += 3;
                continue;
            }
            if (result.charAt(i) == '-') {
                result.replace(i, i + 1, "_");
                i += 0;
                continue;
            }
            if (result.length() > i + 1 && result.charAt(i) == '<' && result.charAt(i + 1) == '=') {
                result.replace(i, i + 2, "le");
                ++i;
                continue;
            }
            if (result.length() > i + 1 && result.charAt(i) == '>' && result.charAt(i + 1) == '=') {
                result.replace(i, i + 2, "ge");
                ++i;
                continue;
            }
            if (result.length() > i + 1 && result.charAt(i) == '<' && result.charAt(i + 1) == '>') {
                result.replace(i, i + 2, "ne");
                ++i;
                continue;
            }
            if (result.length() > i + 1 && result.charAt(i) == '!' && result.charAt(i + 1) == '=') {
                result.replace(i, i + 2, "ne");
                ++i;
                continue;
            }
            if (result.charAt(i) == '=') {
                result.replace(i, i + 1, "eq");
                ++i;
                continue;
            }
            if (result.charAt(i) == '>') {
                result.replace(i, i + 1, "gt");
                ++i;
                continue;
            }
            if (result.charAt(i) == '<') {
                result.replace(i, i + 1, "lt");
                ++i;
                continue;
            }
            if (Character.isJavaIdentifierPart(result.charAt(i))) continue;
            result.replace(i, i + 1, "_");
        }
        return result.toString();
    }

    public static QDataSet transpose(QDataSet ds) {
        return DDataSet.copy(new TransposeRank2DataSet(ds));
    }

    public static boolean equivalent(QDataSet ds1, QDataSet ds2) {
        QDataSet eq = Ops.eq(ds1, ds2);
        QubeDataSetIterator it = new QubeDataSetIterator(eq);
        while (it.hasNext()) {
            it.next();
            if (it.getValue(eq) != 0.0) continue;
            return false;
        }
        return true;
    }

    public static int dimensionCount(QDataSet dss) {
        return Ops.dimensionCount(dss, false);
    }

    private static int dimensionCount(QDataSet dss, boolean noImplicit) {
        int dim = 1;
        QDataSet ds = dss;
        while (ds.rank() > 0) {
            if (ds.property("JOIN_0") == null && ds.property("BINS_0") == null) {
                if (ds.property("DEPEND_0") != null) {
                    dim += Ops.dimensionCount((QDataSet)ds.property("DEPEND_0"), true);
                } else if (ds.property("BUNDLE_0") != null) {
                    dim += ((QDataSet)ds.property("BUNDLE_0")).length();
                } else if (!noImplicit) {
                    ++dim;
                }
            }
            if (ds.length() > 0) {
                ds = DataSetOps.slice0(ds, 0);
                continue;
            }
            throw new IllegalArgumentException("dataset is empty");
        }
        return dim;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum FFTFilterType {
        Hanning;

    }

    private static interface AverageOp {
        public void accum(double var1, double var3, double[] var5);

        public void initStore(double[] var1);

        public void normalize(double[] var1);
    }

    public static interface BinaryOp {
        public double op(double var1, double var3);
    }

    public static interface UnaryOp {
        public double op(double var1);
    }
}

