/*
 * Decompiled with CFR 0.152.
 */
package org.virbo.dsutil;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.das2.datum.Units;
import org.das2.datum.UnitsUtil;
import org.das2.util.DasMath;
import org.virbo.dataset.DDataSet;
import org.virbo.dataset.DRank0DataSet;
import org.virbo.dataset.DataSetUtil;
import org.virbo.dataset.IDataSet;
import org.virbo.dataset.QDataSet;
import org.virbo.dataset.QubeDataSetIterator;
import org.virbo.dataset.RankZeroDataSet;
import org.virbo.dataset.SemanticOps;
import org.virbo.dataset.TagGenDataSet;
import org.virbo.dsutil.DataSetBuilder;

public final class AutoHistogram {
    public static final String USER_PROP_BIN_START = "binStart";
    public static final String USER_PROP_BIN_WIDTH = "binWidth";
    public static final String USER_PROP_INVALID_COUNT = "invalidCount";
    public static final String USER_PROP_OUTLIERS = "outliers";
    public static final String USER_PROP_MIN_GT_ZERO = "minGtZero";
    public static final String USER_PROP_TOTAL = "total";
    public final int BIN_COUNT = 100;
    private final int INITIAL_BINW = 1;
    private final double INITIAL_BINW_DENOM = 1.0E30;
    private final double INITIAL_FIRST_BIN = -1.7976931348623157E308;
    private final double NEW_INITIAL_FIRST_BIN = 1.7976931348623157E278;
    int nbin;
    double binw;
    double binwDenom;
    double firstb;
    double firstBin;
    double[] ss;
    double[] vv;
    double[] nn;
    int zeroesRight;
    int zeroesLeft;
    DataSetBuilder timer;
    long t0;
    long total;
    boolean initialOutliers;
    long invalidCount;
    Units units;
    int rescaleCount;
    double minGtZero = Double.MAX_VALUE;
    QDataSet context;
    SortedMap<Double, Integer> outliers;
    private static final Logger logger = Logger.getLogger(AutoHistogram.class.getCanonicalName());
    private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);

    private static final void log(Level level, String message) {
        if (logger.isLoggable(level)) {
            logger.log(level, message);
        }
    }

    private static final void log(Level level, String message, Object ... args) {
        if (logger.isLoggable(level)) {
            logger.log(level, String.format(message, args));
        }
    }

    public AutoHistogram() {
        this.reset();
    }

    public void reset() {
        this.nbin = 100;
        this.binw = 1.0;
        this.binwDenom = 1.0E30;
        this.firstb = -1.7976931348623157E308;
        this.firstBin = 1.7976931348623157E278;
        this.ss = new double[this.nbin];
        this.vv = new double[this.nbin];
        this.nn = new double[this.nbin];
        this.zeroesRight = this.nbin / 2;
        this.zeroesLeft = this.nbin / 2;
        this.total = 0L;
        this.initialOutliers = true;
        this.outliers = new TreeMap<Double, Integer>();
        this.invalidCount = 0L;
        this.units = null;
        this.rescaleCount = 0;
    }

    private final void addToDistribution(int ibin, double d, int count) {
        if (ibin < this.zeroesLeft) {
            this.zeroesLeft = ibin;
        }
        if (ibin >= this.nbin - this.zeroesRight) {
            this.zeroesRight = this.nbin - ibin - 1;
        }
        for (int i = 0; i < count; ++i) {
            int n = ibin;
            this.nn[n] = this.nn[n] + 1.0;
            double muj = this.ss[ibin];
            double delta = d - this.ss[ibin];
            this.ss[ibin] = this.ss[ibin] + delta / this.nn[ibin];
            double j = this.nn[ibin] - 1.0;
            if (j > 0.0) {
                this.vv[ibin] = (1.0 - 1.0 / j) * this.vv[ibin] + (j + 1.0) * Math.pow(this.ss[ibin] - muj, 2.0);
            }
            ++this.total;
        }
    }

    public DDataSet getHistogram() {
        int ifirstBin;
        int nonZeroCount = this.nbin - this.zeroesLeft - this.zeroesRight + 2;
        if (UnitsUtil.isOrdinalMeasurement((Units)this.units)) {
            nonZeroCount -= 2;
            ifirstBin = this.zeroesLeft;
        } else {
            ifirstBin = this.zeroesLeft - 1;
        }
        if (ifirstBin < 0) {
            ifirstBin = 0;
        }
        if (nonZeroCount + ifirstBin > this.nbin) {
            nonZeroCount = this.nbin - ifirstBin;
        }
        double[] nn1 = new double[nonZeroCount];
        System.arraycopy(this.nn, ifirstBin, nn1, 0, nonZeroCount);
        double[] ss1 = new double[nonZeroCount];
        System.arraycopy(this.ss, ifirstBin, ss1, 0, nonZeroCount);
        double[] vv1 = new double[nonZeroCount];
        System.arraycopy(this.vv, ifirstBin, vv1, 0, nonZeroCount);
        for (int i = 0; i < vv1.length; ++i) {
            if (!(nn1[i] > 0.0)) continue;
            vv1[i] = Math.sqrt(vv1[i]);
        }
        DDataSet result = DDataSet.wrap(nn1);
        DDataSet means = DDataSet.wrap(ss1);
        if (this.units != null) {
            means.putProperty("UNITS", this.units);
        }
        DDataSet stddevs = DDataSet.wrap(vv1);
        if (this.units != null) {
            stddevs.putProperty("UNITS", this.units.getOffsetUnits());
        }
        means.putProperty("NAME", "means");
        stddevs.putProperty("NAME", "stddevs");
        if (!UnitsUtil.isOrdinalMeasurement((Units)this.units)) {
            result.putProperty("PLANE_0", means);
            result.putProperty("means", means);
            result.putProperty("PLANE_1", stddevs);
            result.putProperty("stddevs", stddevs);
        }
        result.putProperty("RENDER_TYPE", "stairSteps");
        double binWidth = this.binw / this.binwDenom;
        TagGenDataSet dep0 = new TagGenDataSet(nonZeroCount, binWidth, (this.firstBin + this.binw * ((double)ifirstBin + 0.5)) / this.binwDenom, this.units);
        result.putProperty("DEPEND_0", dep0);
        HashMap<String, Object> user = new HashMap<String, Object>();
        user.put(USER_PROP_BIN_START, this.firstBin / this.binwDenom);
        user.put(USER_PROP_BIN_WIDTH, this.binw / this.binwDenom);
        user.put(USER_PROP_TOTAL, this.total);
        user.put(USER_PROP_OUTLIERS, this.outliers);
        user.put(USER_PROP_INVALID_COUNT, this.invalidCount);
        int outlierCount = 0;
        for (int i : this.outliers.values()) {
            outlierCount += i;
        }
        user.put("outlierCount", outlierCount);
        result.putProperty("USER_PROPERTIES", user);
        return result;
    }

    public static int binOf(QDataSet hist, double d) {
        Map user = (Map)hist.property("USER_PROPERTIES");
        double binw = (Double)user.get(USER_PROP_BIN_WIDTH);
        double firstBin = (Double)user.get(USER_PROP_BIN_START);
        return (int)Math.floor((d - firstBin) / binw);
    }

    public QDataSet doit(QDataSet ds) {
        return this.doit(ds, null);
    }

    public QDataSet monoExtent(QDataSet dep0) {
        int imax;
        int imin;
        QDataSet wdsdep0 = DataSetUtil.weightsDataSet(dep0);
        for (imin = 0; imin < dep0.length() && !(wdsdep0.value(imin) > 0.0); ++imin) {
        }
        for (imax = dep0.length() - 1; imax >= 0 && !(wdsdep0.value(imax) > 0.0); --imax) {
        }
        if (imin < imax) {
            DDataSet result = DDataSet.createRank1(2);
            result.putProperty("BINS_0", "min,max");
            result.putProperty("UNITS", dep0.property("UNITS"));
            result.putValue(0, dep0.value(imin));
            result.putValue(1, dep0.value(imax));
            return result;
        }
        return null;
    }

    public QDataSet doit(QDataSet ds, QDataSet wds) {
        int limit;
        Units d1;
        if (wds == null) {
            wds = DataSetUtil.weightsDataSet(ds);
        }
        if ((d1 = (Units)ds.property("UNITS")) != null) {
            this.units = d1;
        }
        QubeDataSetIterator iter = new QubeDataSetIterator(ds);
        while (iter.hasNext()) {
            int shift;
            int ibin;
            iter.next();
            try {
                if (iter.getValue(wds) == 0.0) {
                    ++this.invalidCount;
                    continue;
                }
            }
            catch (IndexOutOfBoundsException ex) {
                System.err.println("Index out of bounds: " + iter);
                throw ex;
            }
            double d = iter.getValue(ds);
            if (d < this.minGtZero && d > 0.0) {
                this.minGtZero = d;
            }
            if (this.initialOutliers) {
                if (this.outliers.size() < 5) {
                    this.putOutlier(d);
                    continue;
                }
                this.initialDist();
                this.initialOutliers = false;
            }
            if ((ibin = this.binOf(d)) < 0) {
                if (ibin + this.zeroesRight >= 0) {
                    shift = (int)Math.ceil((double)(this.zeroesRight + -ibin) / 2.0);
                    ibin = this.shiftRight(ibin, shift);
                } else {
                    if (ibin < this.nbin * -3) {
                        this.putOutlier(d);
                        this.reduceOutliers(Math.max(30L, this.total / 100L));
                        continue;
                    }
                    while (ibin < 0) {
                        ibin = this.rescaleRight(ibin);
                    }
                }
            } else if (ibin >= this.nbin) {
                if (ibin - this.zeroesLeft < this.nbin) {
                    shift = (int)Math.ceil((double)(this.zeroesLeft + (ibin - this.nbin)) / 2.0);
                    ibin = this.shiftLeft(ibin, shift);
                } else {
                    if (ibin > this.nbin * 4) {
                        this.putOutlier(d);
                        this.reduceOutliers(Math.max(30L, this.total / 100L));
                        continue;
                    }
                    while (ibin >= this.nbin) {
                        ibin = this.rescaleLeft(ibin, true);
                    }
                }
            }
            this.addToDistribution(ibin, d, 1);
        }
        if (this.initialOutliers && this.outliers.size() > 0) {
            this.initialDist();
        }
        for (limit = 10; limit >= 0 && (long)this.outliers.size() > this.total; --limit) {
            this.initialRedist();
        }
        while (limit >= 0 && (long)this.outliers.size() > this.total / 10L) {
            this.initialRedist();
            --limit;
        }
        DDataSet result = this.getHistogram();
        return result;
    }

    private void checkOutliers() {
        ArrayList<Double> remove = new ArrayList<Double>();
        for (Map.Entry<Double, Integer> out : this.outliers.entrySet()) {
            int shift;
            int ibin = this.binOf(out.getKey());
            if (ibin >= 0 && ibin < this.nbin) {
                remove.add(out.getKey());
                this.addToDistribution(ibin, out.getKey(), out.getValue());
                continue;
            }
            if (ibin < 0 && ibin + this.zeroesRight >= 0) {
                shift = (int)Math.ceil((double)(this.zeroesRight + -ibin) / 2.0);
                ibin = this.shiftRight(ibin, shift);
                remove.add(out.getKey());
                this.addToDistribution(ibin, out.getKey(), out.getValue());
                continue;
            }
            if (ibin < this.nbin || ibin - this.zeroesLeft >= this.nbin) continue;
            shift = (int)Math.ceil((double)(this.zeroesLeft + (ibin - this.nbin)) / 2.0);
            ibin = this.shiftLeft(ibin, shift);
            remove.add(out.getKey());
            this.addToDistribution(ibin, out.getKey(), out.getValue());
        }
        for (Double d : remove) {
            this.outliers.remove(d);
        }
    }

    private void initialDist() {
        int ibin;
        double closestA;
        double lastD = closestA = this.outliers.firstKey().doubleValue();
        double closestB = Double.NaN;
        double closestDist = Double.MAX_VALUE;
        for (Double d : this.outliers.keySet()) {
            double dist = Math.abs(d - lastD);
            if (dist > 0.0 && dist < closestDist) {
                closestA = lastD;
                closestB = d;
                closestDist = dist;
            }
            lastD = d;
        }
        this.binw = Math.abs(closestB - closestA) / (double)(this.nbin / 100);
        if (this.binw < 1.0) {
            this.binwDenom = Math.pow(10.0, Math.ceil(Math.log10(1.0 / this.binw)));
            this.binw = 1.0;
        } else {
            this.binw = Math.pow(10.0, Math.floor(Math.log10(this.binw)));
            this.binwDenom = 1.0;
        }
        this.firstb = Math.floor(closestA * this.binwDenom / this.binw) * this.binw / this.binwDenom;
        this.firstBin = Math.floor(closestA * this.binwDenom / this.binw) * this.binw;
        int count = (Integer)this.outliers.remove(closestA);
        this.zeroesLeft = ibin = this.binOf(closestA);
        this.zeroesRight = this.nbin - ibin - 1;
        this.addToDistribution(ibin, closestA, count);
        this.checkOutliers();
    }

    private void initialRedist() {
        double closestA;
        double distCenter = this.firstb + this.binw / this.binwDenom * (double)(this.zeroesLeft + (this.nbin - this.zeroesRight - this.zeroesLeft) / 2);
        double lastD = closestA = this.outliers.firstKey().doubleValue();
        double closestDist = Double.MAX_VALUE;
        for (Double d : this.outliers.keySet()) {
            double dist = Math.abs(d - distCenter);
            if (dist > 0.0 && dist < closestDist) {
                closestA = lastD;
                closestDist = dist;
            }
            lastD = d;
        }
        int ibin = this.binOf(closestA);
        while (ibin < 0) {
            ibin = this.rescaleRight(ibin);
        }
        while (ibin > this.nbin) {
            ibin = this.rescaleLeft(ibin, false);
        }
        this.checkOutliers();
    }

    private void putOutlier(double d) {
        Integer count = (Integer)this.outliers.get(d);
        if (count == null) {
            this.outliers.put(d, 1);
        } else {
            this.outliers.put(d, count + 1);
        }
    }

    private void reduceOutliers(long limit) {
        while ((long)this.outliers.size() > limit) {
            double d0 = this.firstBin / this.binwDenom + this.binw / this.binwDenom * (double)this.zeroesLeft;
            SortedMap<Double, Integer> headmap = this.outliers.headMap(d0);
            double d1 = this.firstBin / this.binwDenom + this.binw / this.binwDenom * (double)(this.nbin - this.zeroesRight);
            SortedMap<Double, Integer> tailmap = this.outliers.tailMap(d1);
            if (headmap.size() == 0) {
                this.rescaleLeft(0, true);
            } else if (tailmap.size() == 0) {
                this.rescaleRight(0);
            } else if (d0 - headmap.lastKey() > tailmap.firstKey() - d1) {
                this.rescaleLeft(0, true);
            } else {
                this.rescaleRight(0);
            }
            this.checkOutliers();
        }
    }

    private void checkTotal() {
        long total1 = 0L;
        for (double d1 : this.nn) {
            total1 = (long)((double)total1 + d1);
        }
        if (this.total != total1) {
            throw new IllegalArgumentException("total check fails");
        }
        for (int i = 0; i < this.vv.length; ++i) {
            double d1 = this.vv[i];
            if (Double.isNaN(d1)) {
                throw new IllegalArgumentException("nan in variance");
            }
            if (!(this.nn[i] < 2.0) || !(this.vv[i] > 0.0)) continue;
            throw new IllegalArgumentException("non-zero variance in less than two bins in bin #" + i);
        }
        if (Math.abs(this.firstb - this.firstBin / this.binwDenom) > this.binwDenom / 1000.0) {
            // empty if block
        }
    }

    private void debugDump() {
        double d1;
        int i;
        DecimalFormat df = new DecimalFormat(" 00000");
        DecimalFormat nf = new DecimalFormat("00.000");
        System.err.println("-----------------------------");
        long total1 = 0L;
        for (i = 0; i < 20; ++i) {
            d1 = this.nn[i];
            System.err.print(" " + df.format(d1));
        }
        System.err.println();
        for (i = 0; i < 20; ++i) {
            d1 = this.ss[i];
            System.err.print(" " + nf.format(d1));
        }
        System.err.println();
        for (i = 0; i < 20; ++i) {
            d1 = this.vv[i];
            System.err.print(" " + nf.format(d1));
        }
        System.err.println();
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    private final int binOf(double d) {
        return (int)Math.floor((d * this.binwDenom - this.firstBin) / this.binw);
    }

    private final int shiftLeft(int ibin, int shift) {
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest(String.format("shiftLeft(%d)\n", shift));
        }
        this.checkTotal();
        System.arraycopy(this.ss, shift, this.ss, 0, this.nbin - shift - this.zeroesRight);
        System.arraycopy(this.nn, shift, this.nn, 0, this.nbin - shift - this.zeroesRight);
        System.arraycopy(this.vv, shift, this.vv, 0, this.nbin - shift - this.zeroesRight);
        this.zeroesRight += shift;
        this.zeroesLeft -= shift;
        ibin -= shift;
        Arrays.fill(this.ss, this.nbin - this.zeroesRight, this.nbin, 0.0);
        Arrays.fill(this.nn, this.nbin - this.zeroesRight, this.nbin, 0.0);
        Arrays.fill(this.vv, this.nbin - this.zeroesRight, this.nbin, 0.0);
        this.firstb += this.binw * (double)shift / this.binwDenom;
        this.firstBin += this.binw * (double)shift;
        this.checkTotal();
        return ibin;
    }

    private final int expandAndShiftRight(int ibin, int shift, int factor) {
        AutoHistogram.log(Level.FINEST, "expandAndShiftRight(%d,%d,%d)\n", ibin, shift, factor);
        this.checkTotal();
        int nbin1 = (int)Math.ceil((double)(this.nbin + (factor *= 2)) / (1.0 * (double)factor)) * factor;
        double[] nn1 = new double[nbin1];
        double[] ss1 = new double[nbin1];
        double[] vv1 = new double[nbin1];
        System.arraycopy(this.ss, this.zeroesLeft, ss1, shift + this.zeroesLeft, this.nbin - this.zeroesLeft);
        System.arraycopy(this.nn, this.zeroesLeft, nn1, shift + this.zeroesLeft, this.nbin - this.zeroesLeft);
        System.arraycopy(this.vv, this.zeroesLeft, vv1, shift + this.zeroesLeft, this.nbin - this.zeroesLeft);
        this.zeroesLeft += shift;
        this.zeroesRight -= shift;
        this.zeroesRight += nbin1 - this.nbin;
        ibin += shift;
        this.nbin = nbin1;
        this.ss = ss1;
        this.nn = nn1;
        this.vv = vv1;
        Arrays.fill(this.ss, 0, this.zeroesLeft, 0.0);
        Arrays.fill(this.nn, 0, this.zeroesLeft, 0.0);
        Arrays.fill(this.vv, 0, this.zeroesLeft, 0.0);
        Arrays.fill(this.ss, this.nbin - this.zeroesRight, this.nbin, 0.0);
        Arrays.fill(this.nn, this.nbin - this.zeroesRight, this.nbin, 0.0);
        Arrays.fill(this.vv, this.nbin - this.zeroesRight, this.nbin, 0.0);
        this.firstb -= this.binw * (double)shift / this.binwDenom;
        this.firstBin -= this.binw * (double)shift;
        this.checkTotal();
        return ibin;
    }

    private final int shiftRight(int ibin, int shift) {
        AutoHistogram.log(Level.FINEST, "shiftRight(%d)\n", shift);
        this.checkTotal();
        System.arraycopy(this.ss, this.zeroesLeft, this.ss, shift + this.zeroesLeft, this.nbin - this.zeroesLeft - shift);
        System.arraycopy(this.nn, this.zeroesLeft, this.nn, shift + this.zeroesLeft, this.nbin - this.zeroesLeft - shift);
        System.arraycopy(this.vv, this.zeroesLeft, this.vv, shift + this.zeroesLeft, this.nbin - this.zeroesLeft - shift);
        this.zeroesLeft += shift;
        this.zeroesRight -= shift;
        ibin += shift;
        Arrays.fill(this.ss, 0, this.zeroesLeft, 0.0);
        Arrays.fill(this.nn, 0, this.zeroesLeft, 0.0);
        Arrays.fill(this.vv, 0, this.zeroesLeft, 0.0);
        this.firstb -= this.binw * (double)shift / this.binwDenom;
        this.firstBin -= this.binw * (double)shift;
        this.checkTotal();
        return ibin;
    }

    private int nextFactor() {
        int factor;
        int exp = (int)Math.floor(Math.log10(this.binw) + 0.001);
        int mant = (int)Math.round(this.binw / Math.pow(10.0, exp));
        int expDenom = (int)Math.floor(Math.log10(this.binwDenom));
        int mantDenom = (int)Math.round(this.binwDenom / Math.pow(10.0, expDenom));
        if (mantDenom > 1) {
            mant = 10 / mantDenom;
        }
        if (mant == 1) {
            factor = 5;
        } else if (mant == 5) {
            factor = 2;
        } else {
            throw new IllegalArgumentException();
        }
        return factor;
    }

    private final int rescaleRight(int ibin) {
        int factor = this.nextFactor();
        ibin = this.rescaleLeft(ibin, false);
        try {
            ibin = this.shiftRight(ibin, this.nbin * (factor - 1) / factor);
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            ibin = this.shiftRight(ibin, this.nbin * (factor - 1) / factor);
        }
        this.checkOutliers();
        return ibin;
    }

    private final int rescaleLeft(int ibin, boolean checkOutliers) {
        ++this.rescaleCount;
        int factor = this.nextFactor();
        AutoHistogram.log(Level.FINEST, "rescaleLeft to " + this.binw / this.binwDenom + "*" + factor);
        this.checkTotal();
        int shift = (int)Math.round(DasMath.modp((double)this.firstBin, (double)(this.binw * (double)factor)) / this.binw);
        if (this.nbin % factor > 0) {
            ibin = this.expandAndShiftRight(ibin, shift, factor);
        } else if (shift > 0) {
            ibin = shift < this.zeroesRight ? this.shiftRight(ibin, shift) : this.expandAndShiftRight(ibin, shift, factor);
        }
        for (int i = 0; i < this.nbin / factor; ++i) {
            int j;
            this.nn[i] = this.nn[i * factor];
            double[] oldMeans = new double[factor];
            double[] oldWeights = new double[factor];
            double[] oldVariances = new double[factor];
            oldMeans[0] = this.ss[i * factor];
            oldWeights[0] = this.nn[i * factor];
            oldVariances[0] = this.vv[i * factor];
            this.ss[i] = this.ss[i * factor] * this.nn[i * factor];
            for (j = 1; j < factor; ++j) {
                int idx = i * factor + j;
                oldMeans[j] = this.ss[idx];
                oldWeights[j] = this.nn[idx];
                oldVariances[j] = this.vv[idx];
                int n = i;
                this.ss[n] = this.ss[n] + this.ss[idx] * this.nn[idx];
                int n2 = i;
                this.nn[n2] = this.nn[n2] + this.nn[idx];
            }
            if (this.nn[i] > 0.0) {
                int n = i;
                this.ss[n] = this.ss[n] / this.nn[i];
            }
            for (j = 0; j < factor; ++j) {
                oldVariances[j] = oldWeights[j] > 0.0 ? (oldWeights[j] - 1.0) * oldVariances[j] + oldWeights[j] * Math.pow(oldMeans[j] - this.ss[i], 2.0) : 0.0;
            }
            this.vv[i] = oldVariances[0];
            for (j = 1; j < factor; ++j) {
                int n = i;
                this.vv[n] = this.vv[n] + oldVariances[j];
            }
            if (!(this.nn[i] > 1.0)) continue;
            int n = i;
            this.vv[n] = this.vv[n] / (this.nn[i] - 1.0);
        }
        int nnew = this.nbin - this.nbin / factor;
        Arrays.fill(this.ss, this.nbin / factor, this.nbin, 0.0);
        Arrays.fill(this.nn, this.nbin / factor, this.nbin, 0.0);
        Arrays.fill(this.vv, this.nbin / factor, this.nbin, 0.0);
        if (this.binwDenom > 1.0) {
            this.binwDenom /= (double)factor;
            this.firstBin /= (double)factor;
        } else {
            this.binw *= (double)factor;
        }
        ibin /= factor;
        this.zeroesLeft /= factor;
        this.zeroesRight = this.zeroesRight / factor + nnew;
        this.checkTotal();
        if (checkOutliers) {
            this.checkOutliers();
        }
        return ibin;
    }

    public static RankZeroDataSet mean(QDataSet hist) {
        double SS = 0.0;
        double NN = 0.0;
        QDataSet means = (QDataSet)hist.property("means");
        for (int i = 0; i < hist.length(); ++i) {
            SS += means.value(i) * hist.value(i);
            NN += hist.value(i);
        }
        DRank0DataSet ds = DataSetUtil.asDataSet(SS / NN);
        ds.putProperty("UNITS", ((QDataSet)hist.property("DEPEND_0")).property("UNITS"));
        return ds;
    }

    public static RankZeroDataSet moments(QDataSet hist) {
        long total = (Long)((Map)hist.property("USER_PROPERTIES")).get(USER_PROP_TOTAL);
        if (UnitsUtil.isOrdinalMeasurement((Units)SemanticOps.getUnits((QDataSet)hist.property("DEPEND_0")))) {
            DRank0DataSet result = DataSetUtil.asDataSet(-1.0);
            result.putProperty("validCount", total);
            result.putProperty(USER_PROP_INVALID_COUNT, ((Map)hist.property("USER_PROPERTIES")).get(USER_PROP_INVALID_COUNT));
            return result;
        }
        double[] vvs = new double[hist.length()];
        double mean = AutoHistogram.mean(hist).value();
        QDataSet stddevs = (QDataSet)hist.property("stddevs");
        QDataSet means = (QDataSet)hist.property("means");
        for (int i = 0; i < stddevs.length(); ++i) {
            double var = Math.pow(stddevs.value(i), 2.0);
            vvs[i] = (hist.value(i) - 1.0) * var + hist.value(i) * Math.pow(means.value(i) - mean, 2.0);
        }
        double VV = 0.0;
        for (int i = 0; i < hist.length(); ++i) {
            VV += vvs[i];
        }
        double stddev = Math.sqrt(VV / (double)(total - 1L));
        Units u = (Units)((QDataSet)hist.property("DEPEND_0")).property("UNITS");
        DRank0DataSet result = DataSetUtil.asDataSet(mean);
        if (u != null) {
            result.putProperty("UNITS", u);
        }
        DRank0DataSet stddevds = DataSetUtil.asDataSet(stddev);
        if (u != null) {
            stddevds.putProperty("UNITS", u.getOffsetUnits());
        }
        result.putProperty("stddev", stddevds);
        result.putProperty("validCount", total);
        result.putProperty(USER_PROP_INVALID_COUNT, ((Map)hist.property("USER_PROPERTIES")).get(USER_PROP_INVALID_COUNT));
        return result;
    }

    public static QDataSet simpleRange(QDataSet hist2) {
        DDataSet result;
        int imin = -1;
        int imax = -1;
        for (int i = 0; i < hist2.length(); ++i) {
            if (!(hist2.value(i) > 0.0)) continue;
            if (imin == -1) {
                imin = i;
            }
            imax = i;
        }
        if (imin == -1) {
            result = DDataSet.wrap(new double[]{-1.0E31, -1.0E31});
            result.putProperty("BINS_0", "min,max");
            result.putProperty("FILL_VALUE", -1.0E31);
        } else {
            QDataSet dep0 = (QDataSet)hist2.property("DEPEND_0");
            QDataSet cadence = (QDataSet)dep0.property("CADENCE");
            if (cadence == null) {
                result = DDataSet.wrap(new double[]{dep0.value(imin), dep0.value(imax)});
                result.putProperty("BINS_0", "min,max");
            } else if (UnitsUtil.isOrdinalMeasurement((Units)SemanticOps.getUnits(dep0))) {
                result = DDataSet.wrap(new double[]{dep0.value(imin), dep0.value(imax)});
                result.putProperty("BINS_0", "min,maxInclusive");
            } else {
                result = DDataSet.wrap(new double[]{dep0.value(imin), dep0.value(imax) + cadence.value()});
                result.putProperty("BINS_0", "min,max");
            }
            result.putProperty("UNITS", dep0.property("UNITS"));
        }
        return result;
    }

    public static QDataSet peakIds(QDataSet hist) {
        int j;
        double peakHeight;
        int i;
        IDataSet peakId = IDataSet.createRank1(hist.length());
        peakId.putProperty("DEPEND_0", hist.property("DEPEND_0"));
        int ipeak = 1;
        int n = hist.length();
        if (n < 3) {
            throw new IllegalArgumentException("histogram has too few bins");
        }
        QDataSet means = (QDataSet)hist.property("means");
        QDataSet stddevs = (QDataSet)hist.property("stddevs");
        QDataSet bins = (QDataSet)hist.property("DEPEND_0");
        double binw = bins.value(1) - bins.value(0);
        for (i = 0; i < n - 2; ++i) {
            if (!(i >= 2 && !(hist.value(i - 2) <= hist.value(i)) || i >= 1 && !(hist.value(i - 1) <= hist.value(i)) || i <= n - 2 && !(hist.value(i) > hist.value(i + 1)) || i <= n - 1 && !(hist.value(i) > hist.value(i + 2)))) {
                peakId.putValue(i, ipeak);
                ++ipeak;
                continue;
            }
            if (i >= 2 && !(hist.value(i - 2) > hist.value(i)) || i >= 1 && !(hist.value(i - 1) > hist.value(i)) || i <= n - 2 && !(hist.value(i) <= hist.value(i + 1)) || i <= n - 1 && !(hist.value(i) <= hist.value(i + 2))) continue;
            peakId.putValue(i, -1.0);
        }
        for (i = n - 1; i >= 1; --i) {
            if (hist.value(i - 1) != hist.value(i) || peakId.value(i) == 0.0) continue;
            if (hist.value(i - 1) > 5.0) {
                if (means.value(i - 1) + 2.0 * stddevs.value(i - 1) > bins.value(i) - binw / 2.0) {
                    peakId.putValue(i - 1, peakId.value(i));
                    continue;
                }
                peakId.putValue(i - 1, ipeak);
                ++ipeak;
                continue;
            }
            peakId.putValue(i - 1, peakId.value(i));
        }
        for (i = 1; i < n; ++i) {
            if (!(peakId.value(i) > 0.0)) continue;
            peakHeight = hist.value(i);
            for (j = i - 1; j >= 0 && peakId.value(j) == 0.0 && hist.value(j) > peakHeight / 10.0 && means.value(j) + 2.0 * stddevs.value(j) > bins.value(j + 1) - binw / 2.0; --j) {
                peakId.putValue(j, peakId.value(i));
            }
        }
        for (i = n - 2; i >= 0; --i) {
            if (!(peakId.value(i) > 0.0)) continue;
            peakHeight = hist.value(i);
            for (j = i + 1; j < n && peakId.value(j) == 0.0 && hist.value(j) > peakHeight / 10.0 && means.value(j) - 2.0 * stddevs.value(j) < bins.value(j - 1) + binw / 2.0; ++j) {
                peakId.putValue(j, peakId.value(i));
            }
        }
        return peakId;
    }

    public static QDataSet peaks(QDataSet hist) {
        int ipeak;
        int ipeak2;
        QDataSet peakIds = AutoHistogram.peakIds(hist);
        QDataSet stddevs = (QDataSet)hist.property("stddevs");
        QDataSet means = (QDataSet)hist.property("means");
        int maxPeak = 0;
        for (int i = 0; i < peakIds.length(); ++i) {
            if (!(peakIds.value(i) > (double)maxPeak)) continue;
            maxPeak = (int)peakIds.value(i);
        }
        int npeak = maxPeak;
        double[] vvs = new double[hist.length()];
        double[] SS = new double[hist.length()];
        double[] NN = new double[hist.length()];
        for (int i = 0; i < hist.length(); ++i) {
            ipeak2 = (int)(peakIds.value(i) - 1.0);
            if (ipeak2 < 0) continue;
            int n = ipeak2;
            SS[n] = SS[n] + means.value(i) * hist.value(i);
            int n2 = ipeak2;
            NN[n2] = NN[n2] + hist.value(i);
        }
        double[] mean = new double[npeak];
        for (ipeak2 = 0; ipeak2 < npeak; ++ipeak2) {
            mean[ipeak2] = SS[ipeak2] / NN[ipeak2];
        }
        for (int i = 0; i < stddevs.length(); ++i) {
            double var = Math.pow(stddevs.value(i), 2.0);
            ipeak = (int)(peakIds.value(i) - 1.0);
            if (ipeak < 0) continue;
            vvs[i] = (hist.value(i) - 1.0) * var + hist.value(i) * Math.pow(means.value(i) - mean[ipeak], 2.0);
        }
        double[] VV = new double[npeak];
        int[] nbin = new int[npeak];
        for (int i = 0; i < hist.length(); ++i) {
            ipeak = (int)(peakIds.value(i) - 1.0);
            if (ipeak < 0) continue;
            int n = ipeak;
            VV[n] = VV[n] + vvs[i];
            int n3 = ipeak;
            nbin[n3] = nbin[n3] + 1;
        }
        double[] stddev = new double[npeak];
        for (ipeak = 0; ipeak < npeak; ++ipeak) {
            stddev[ipeak] = Math.sqrt(VV[ipeak] / (NN[ipeak] - 1.0));
        }
        Units u = (Units)((QDataSet)hist.property("DEPEND_0")).property("UNITS");
        DDataSet result = DDataSet.wrap(mean);
        if (u != null) {
            result.putProperty("UNITS", u);
        }
        DDataSet stddevds = DDataSet.wrap(stddev);
        if (u != null) {
            stddevds.putProperty("UNITS", u.getOffsetUnits());
        }
        result.putProperty("DELTA_PLUS", stddevds);
        result.putProperty("DELTA_MINUS", stddevds);
        return result;
    }
}

