/*
 * Decompiled with CFR 0.152.
 */
package org.virbo.dsutil;

import org.das2.datum.Units;
import org.das2.datum.UnitsConverter;
import org.virbo.dataset.DDataSet;
import org.virbo.dataset.DataSetUtil;
import org.virbo.dataset.QDataSet;
import org.virbo.dsutil.DataSetBuilder;

public class Reduction {
    private static UnitsConverter getDifferencesConverter(QDataSet src, QDataSet dst, Units dstUnits) {
        Units unitsOut;
        Units unitsIn = (Units)dst.property("UNITS");
        if (unitsIn == null) {
            unitsIn = Units.dimensionless;
        }
        if ((unitsOut = (Units)src.property("UNITS")) == null) {
            unitsOut = Units.dimensionless;
        }
        UnitsConverter xuc = dstUnits != null ? unitsOut.getConverter(dstUnits) : unitsOut.getConverter(unitsIn.getOffsetUnits());
        return xuc;
    }

    public static QDataSet reduce2D(QDataSet ds, QDataSet xLimit, QDataSet yLimit) {
        double dyLimit;
        double dxLimit;
        UnitsConverter uc;
        boolean ylog;
        DataSetBuilder xbuilder = new DataSetBuilder(1, 1000);
        DataSetBuilder ybuilder = new DataSetBuilder(1, 1000);
        DataSetBuilder wbuilder = new DataSetBuilder(1, 1000);
        QDataSet x = (QDataSet)ds.property("DEPEND_0");
        QDataSet y = ds;
        double x0 = 3.4028234663852886E38;
        double y0 = 3.4028234663852886E38;
        double sx0 = 0.0;
        double sy0 = 0.0;
        double nn0 = 0.0;
        double ax0 = Double.NaN;
        double ay0 = Double.NaN;
        boolean xlog = xLimit != null && "log".equals(xLimit.property("SCALE_TYPE"));
        boolean bl = ylog = yLimit != null && "log".equals(yLimit.property("SCALE_TYPE"));
        if (xLimit != null) {
            uc = Reduction.getDifferencesConverter(xLimit, x, (Units)(xlog ? Units.logERatio : null));
            dxLimit = uc.convert(xLimit.value());
        } else {
            dxLimit = Double.MAX_VALUE;
        }
        if (yLimit != null) {
            uc = Reduction.getDifferencesConverter(yLimit, y, (Units)(ylog ? Units.logERatio : null));
            dyLimit = uc.convert(yLimit.value());
        } else {
            dyLimit = Double.MAX_VALUE;
        }
        int points = 0;
        int inCount = 0;
        QDataSet wds = DataSetUtil.weightsDataSet(y);
        int i = 0;
        while (i < x.length()) {
            ++inCount;
            double xx = x.value(i);
            double yy = y.value(i);
            double ww = wds.value(i);
            if (ww == 0.0) continue;
            double p0 = xlog ? Math.log(xx) : xx;
            double p1 = ylog ? Math.log(yy) : yy;
            double dx = p0 - x0;
            double dy = p1 - y0;
            if (Math.abs(dx) < dxLimit && Math.abs(dy) < dyLimit) {
                sx0 += p0;
                sy0 += p1;
                nn0 += ww;
                ++i;
                continue;
            }
            if (nn0 > 0.0) {
                ax0 = sx0 / nn0;
                ay0 = sy0 / nn0;
                xbuilder.putValue(points, xlog ? Math.exp(ax0) : ax0);
                ybuilder.putValue(points, ylog ? Math.exp(ay0) : ay0);
                wbuilder.putValue(points, nn0);
                ++points;
            }
            ++i;
            x0 = dxLimit * (0.5 + (double)((int)Math.floor(p0 / dxLimit)));
            y0 = dyLimit * (0.5 + (double)((int)Math.floor(p1 / dyLimit)));
            sx0 = p0;
            sy0 = p1;
            nn0 = ww;
        }
        if (nn0 > 0.0) {
            ax0 = sx0 / nn0;
            ay0 = sy0 / nn0;
            xbuilder.putValue(points, xlog ? Math.exp(ax0) : ax0);
            ybuilder.putValue(points, ylog ? Math.exp(ay0) : ay0);
            wbuilder.putValue(points, nn0);
            ++points;
        }
        DDataSet yds = ybuilder.getDataSet();
        DDataSet xds = xbuilder.getDataSet();
        DataSetUtil.putProperties(DataSetUtil.getProperties(y), yds);
        DataSetUtil.putProperties(DataSetUtil.getProperties(x), xds);
        if (xds.property("CADENCE") != null) {
            xds.putProperty("CADENCE", xLimit);
        }
        yds.putProperty("DEPEND_0", xds);
        yds.putProperty("WEIGHTS", wbuilder.getDataSet());
        return yds;
    }
}

