/*
 * Decompiled with CFR 0.152.
 */
package org.virbo.dsutil;

import org.virbo.dataset.AbstractDataSet;
import org.virbo.dataset.DataSetUtil;
import org.virbo.dataset.QDataSet;

public class TransposeRankNDataSet
extends AbstractDataSet {
    QDataSet source;
    int[] order;
    int[] qube;
    final int shuffleType;
    private static final int SHUFFLE_123 = 0;
    private static final int SHUFFLE_132 = 1;
    private static final int SHUFFLE_213 = 2;
    private static final int SHUFFLE_231 = 3;
    private static final int SHUFFLE_312 = 4;
    private static final int SHUFFLE_321 = 5;

    public TransposeRankNDataSet(QDataSet source, int[] order) {
        this.source = source;
        this.order = new int[order.length];
        System.arraycopy(order, 0, this.order, 0, order.length);
        this.qube = DataSetUtil.qubeDims(source);
        for (int i = 0; i < source.rank(); ++i) {
            QDataSet depi = (QDataSet)source.property("DEPEND_" + order[i]);
            if (depi == null) continue;
            this.properties.put("DEPEND_" + i, depi);
        }
        this.shuffleType = order[0] == 0 ? (order[1] == 1 ? 0 : 1) : (order[0] == 1 ? (order[1] == 0 ? 2 : 3) : (order[1] == 0 ? 4 : 5));
    }

    public int rank() {
        return this.source.rank();
    }

    public double value(int i) {
        return super.value(i);
    }

    public double value(int i0, int i1) {
        return this.source.value(i0, i1);
    }

    public double value(int i1, int i2, int i3) {
        switch (this.shuffleType) {
            case 0: {
                return this.source.value(i1, i2, i3);
            }
            case 1: {
                return this.source.value(i1, i3, i2);
            }
            case 2: {
                return this.source.value(i2, i1, i3);
            }
            case 3: {
                return this.source.value(i2, i3, i1);
            }
            case 4: {
                return this.source.value(i3, i1, i2);
            }
            case 5: {
                return this.source.value(i3, i2, i1);
            }
        }
        throw new RuntimeException("implementation error");
    }

    public Object property(String name) {
        Object v = this.properties.get(name);
        return v == null ? this.source.property(name) : v;
    }

    public Object property(String name, int i) {
        Object v = this.properties.get(name);
        return v == null ? this.source.property(name, i) : v;
    }

    public int length() {
        return this.qube[this.order[0]];
    }

    public int length(int i) {
        return this.qube[this.order[1]];
    }

    public int length(int i, int j) {
        return this.qube[this.order[2]];
    }
}

