/*
 * Decompiled with CFR 0.152.
 */
package org.virbo.math.fft;

import org.das2.datum.DatumVector;
import org.das2.datum.Units;
import org.das2.datum.UnitsUtil;
import org.virbo.dataset.DDataSet;
import org.virbo.dataset.DataSetUtil;
import org.virbo.dataset.QDataSet;
import org.virbo.dataset.SemanticOps;
import org.virbo.dsutil.DataSetBuilder;
import org.virbo.math.fft.FFTUtil;
import org.virbo.math.fft.GeneralFFT;

public class WaveformToSpectrum {
    private static final double LOG_2 = Math.log(2.0);

    static DatumVector getFrequencyDomainTags(DatumVector timeDomainTags) {
        Units frequencyUnit;
        int i;
        Units timeUnit = timeDomainTags.getUnits();
        double[] x = timeDomainTags.toDoubleArray(timeUnit);
        double[] result = new double[x.length];
        result[0] = 0.0;
        double T = x[1] - x[0];
        int n = x.length;
        int n21 = n / 2 + 1;
        for (i = 0; i < n21; ++i) {
            result[i] = (double)i / ((double)n * T);
        }
        for (i = 0; i < n21 - 2; ++i) {
            result[i + n21] = (double)(n21 - n + i) / ((double)n * T);
        }
        double unitMult = 1.0;
        if (timeUnit.isConvertableTo(Units.seconds)) {
            unitMult = timeUnit.getConverter(Units.seconds).convert(1.0);
            frequencyUnit = Units.hertz;
            for (int i2 = 0; i2 < result.length; ++i2) {
                result[i2] = result[i2] / unitMult;
            }
        } else {
            frequencyUnit = UnitsInverter.getInverseUnit(timeUnit);
        }
        return DatumVector.newDatumVector((double[])result, (Units)frequencyUnit);
    }

    private static boolean checkXTagsGrid(QDataSet ds, int st, int en) {
        if (ds.length() < 1) {
            return false;
        }
        double base = ds.value(st);
        double delta = (ds.value(en - 1) - base) / (double)(en - st - 1);
        for (int i = st; i < en; ++i) {
            double rr = (ds.value(i) - base) / delta % 1.0;
            if (!(rr > 0.01) || !(rr < 0.09)) continue;
            return false;
        }
        return true;
    }

    public static double[][] fft(double[][] array) {
        double t_i;
        double t_r;
        int i;
        int n = array[0].length;
        int ln = (int)(Math.log(n) / LOG_2 + 0.5);
        if (Math.pow(2.0, ln) != (double)n) {
            throw new IllegalArgumentException("input array ([" + array.length + "][" + n + "]) is not [2][2^k]");
        }
        int nv2 = n / 2;
        int j = 1;
        for (i = 1; i < n; ++i) {
            int k;
            if (i < j) {
                t_r = array[0][i - 1];
                t_i = array[1][i - 1];
                array[0][i - 1] = array[0][j - 1];
                array[1][i - 1] = array[1][j - 1];
                array[0][j - 1] = t_r;
                array[1][j - 1] = t_i;
            }
            for (k = nv2; k < j; j -= k, k /= 2) {
            }
            j += k;
        }
        for (int l = 1; l <= ln; ++l) {
            int le = (int)(Math.exp((double)l * LOG_2) + 0.5);
            int le1 = le / 2;
            double u_r = 1.0;
            double u_i = 0.0;
            double w_r = Math.cos(Math.PI / (double)le1);
            double w_i = -Math.sin(Math.PI / (double)le1);
            for (j = 1; j <= le1; ++j) {
                for (i = j; i <= n; i += le) {
                    int ip = i + le1;
                    t_r = array[0][ip - 1] * u_r - u_i * array[1][ip - 1];
                    t_i = array[1][ip - 1] * u_r + u_i * array[0][ip - 1];
                    array[0][ip - 1] = array[0][i - 1] - t_r;
                    array[1][ip - 1] = array[1][i - 1] - t_i;
                    array[0][i - 1] = array[0][i - 1] + t_r;
                    array[1][i - 1] = array[1][i - 1] + t_i;
                }
                t_r = u_r * w_r - w_i * u_i;
                u_i = w_r * u_i + w_i * u_r;
                u_r = t_r;
            }
        }
        return array;
    }

    public static QDataSet getTableDataSet2(QDataSet vds, int windowSize) {
        GeneralFFT fft = GeneralFFT.newDoubleFFT(windowSize);
        QDataSet xvds = (QDataSet)vds.property("DEPEND_0");
        if (!WaveformToSpectrum.checkXTagsGrid(xvds, 0, xvds.length())) {
            throw new IllegalArgumentException("xtags don't appear to be gridded");
        }
        Units xUnits = SemanticOps.getUnits(xvds);
        double[] yt = FFTUtil.getFrequencyDomainTags(1.0 / (xvds.value(1) - xvds.value(0)), windowSize / 2);
        DatumVector yTags = DatumVector.newDatumVector((double[])yt, (Units)UnitsUtil.getInverseUnit((Units)xUnits.getOffsetUnits()));
        DataSetBuilder tdsb = new DataSetBuilder(2, 100, yTags.getLength());
        DataSetBuilder xdsb = new DataSetBuilder(1, 100);
        xdsb.putProperty("UNITS", xUnits);
        int nTableXTags = xvds.length() / windowSize;
        for (int i = 0; i < nTableXTags; ++i) {
            QDataSet ds = FFTUtil.fftPower(fft, vds.trim(i * windowSize, (i + 1) * windowSize));
            for (int k = 0; k < ds.length(); ++k) {
                tdsb.putValue(-1, k, ds.value(k));
            }
            xdsb.putValue(-1, xvds.value((int)(((double)i + 0.5) * (double)windowSize)));
            tdsb.nextRecord();
            xdsb.nextRecord();
        }
        DDataSet ytagds = DDataSet.createRank1(yTags.getLength());
        for (int i = 0; i < ytagds.length(); ++i) {
            ytagds.putValue(i, yTags.doubleValue(i, yTags.getUnits()));
        }
        ytagds.putProperty("UNITS", yTags.getUnits());
        tdsb.putProperty("DEPEND_1", ytagds);
        tdsb.putProperty("DEPEND_0", xdsb.getDataSet());
        return tdsb.getDataSet();
    }

    public static QDataSet getTableDataSet(QDataSet vds, int windowSize) {
        Units xOffsetUnits;
        if (vds.rank() != 1) {
            throw new IllegalArgumentException("input dataset should be rank 1");
        }
        int n21 = windowSize / 2 + 1;
        QDataSet xvds = SemanticOps.xtagsDataSet(vds);
        Units xUnits = SemanticOps.getUnits(xvds);
        Units timeDomainUnits = xOffsetUnits = xUnits.getOffsetUnits();
        double[] ybuf = new double[windowSize];
        double base = xvds.value(0);
        for (int i = 0; i < windowSize; ++i) {
            ybuf[i] = xOffsetUnits.convertDoubleTo(timeDomainUnits, xvds.value(i) - base);
        }
        DatumVector yTags = WaveformToSpectrum.getFrequencyDomainTags(DatumVector.newDatumVector((double[])ybuf, (Units)timeDomainUnits)).getSubVector(1, n21);
        Units zUnits = SemanticOps.getUnits(vds);
        DataSetBuilder tdsb = new DataSetBuilder(2, 100, yTags.getLength());
        QDataSet wvds = DataSetUtil.weightsDataSet(vds);
        DataSetBuilder xdsb = new DataSetBuilder(1, 100);
        xdsb.putProperty("UNITS", xUnits);
        double[][] buf = new double[2][windowSize];
        int ngood = 0;
        int nTableXTags = vds.length() / windowSize;
        for (int i = 0; i < nTableXTags; ++i) {
            int j;
            boolean fill = false;
            if (!WaveformToSpectrum.checkXTagsGrid(xvds, i * windowSize, (i + 1) * windowSize)) continue;
            ++ngood;
            for (int j2 = 0; j2 < windowSize; ++j2) {
                buf[0][j2] = vds.value(i * windowSize + j2);
                if (wvds.value(i * windowSize + j2) == 0.0) {
                    fill = true;
                }
                buf[1][j2] = 0.0;
            }
            double[] zBuf = new double[n21 - 1];
            if (fill) {
                for (j = 1; j < n21; ++j) {
                    zBuf[j - 1] = zUnits.getFillDouble();
                }
            } else {
                WaveformToSpectrum.fft(buf);
                for (j = 1; j < n21; ++j) {
                    zBuf[j - 1] = Math.sqrt(buf[0][j] * buf[0][j] + buf[1][j] * buf[1][j]);
                }
            }
            for (int k = 0; k < zBuf.length; ++k) {
                tdsb.putValue(-1, k, zBuf[k]);
            }
            tdsb.nextRecord();
            xdsb.putValue(-1, xvds.value((int)(((double)i + 0.5) * (double)windowSize)));
            xdsb.nextRecord();
        }
        if (ngood == 0) {
            throw new IllegalArgumentException("xtags don't appear to be gridded");
        }
        DDataSet ytagds = DDataSet.createRank1(yTags.getLength());
        for (int i = 0; i < ytagds.length(); ++i) {
            ytagds.putValue(i, yTags.doubleValue(i, yTags.getUnits()));
        }
        ytagds.putProperty("UNITS", yTags.getUnits());
        tdsb.putProperty("DEPEND_0", xdsb.getDataSet());
        tdsb.putProperty("DEPEND_1", ytagds);
        return tdsb.getDataSet();
    }

    static class UnitsInverter {
        UnitsInverter() {
        }

        static Units getInverseUnit(Units unit) {
            if (unit == Units.seconds) {
                return Units.hertz;
            }
            if (unit == Units.dimensionless) {
                return Units.dimensionless;
            }
            throw new IllegalArgumentException("units not supported: " + unit);
        }
    }
}

