/*
 * Decompiled with CFR 0.152.
 */
package org.virbo.math.fft.jnt;

import org.virbo.math.fft.ComplexArray;
import org.virbo.math.fft.jnt.ComplexFloatFFT_Mixed;

public abstract class ComplexFloatFFT {
    int n;

    public ComplexFloatFFT(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("The transform length must be >=0 : " + n);
        }
        this.n = n;
    }

    public ComplexFloatFFT getInstance(int n) {
        return new ComplexFloatFFT_Mixed(n);
    }

    protected void checkData(ComplexArray.Float data, int i0, int stride) {
        if (i0 < 0) {
            throw new IllegalArgumentException("The offset must be >=0 : " + i0);
        }
        if (stride < 1) {
            throw new IllegalArgumentException("The stride must be >=2 : " + stride);
        }
        if (i0 + stride * (this.n - 1) + 2 > data.length()) {
            throw new IllegalArgumentException("The data array is too small for " + this.n + ":" + "i0=" + i0 + " stride=" + stride + " data.length=" + data.length());
        }
    }

    public void transform(ComplexArray.Float data) {
        this.transform(data, 0, 1);
    }

    public abstract void transform(ComplexArray.Float var1, int var2, int var3);

    public void backtransform(ComplexArray.Float data) {
        this.backtransform(data, 0, 2);
    }

    public abstract void backtransform(ComplexArray.Float var1, int var2, int var3);

    public float normalization() {
        return 1.0f / (float)this.n;
    }

    public void inverse(ComplexArray.Float data) {
        this.inverse(data, 0, 2);
    }

    public void inverse(ComplexArray.Float data, int i0, int stride) {
        this.backtransform(data, 0, 2);
        float norm = this.normalization();
        for (int i = 0; i < this.n; ++i) {
            data.setReal(i, data.getReal(i) * norm);
            data.setImag(i, data.getImag(i) * norm);
        }
    }
}

