/*
 * Decompiled with CFR 0.152.
 */
package test;

import java.util.HashMap;
import org.das2.datum.Units;
import org.virbo.dataset.DDataSet;
import org.virbo.dataset.DataSetOps;
import org.virbo.dataset.DataSetUtil;
import org.virbo.dataset.IndexGenDataSet;
import org.virbo.dataset.MutablePropertyDataSet;
import org.virbo.dataset.QDataSet;
import org.virbo.dataset.SortDataSet;
import org.virbo.dsops.Ops;

public class TestDataSetOps {
    public TestDataSetOps() {
        this.test1();
        this.test2();
        this.test3();
        this.test4();
    }

    private void test4() {
        MutablePropertyDataSet tags = DataSetUtil.tagGenDataSet(10, 0.0, 1.0);
        System.err.println(DataSetUtil.closest(tags, 5.5, -1));
    }

    private void test3() {
        System.err.println("DDataSet.version=20110217");
    }

    private void test2() {
        DDataSet tags = DDataSet.wrap(new double[]{4.0, 8.0, 9.0, 10.0, 5.0, 6.0, 7.0, 1.0, 2.0, 3.0});
        DDataSet data = DDataSet.wrap(new double[]{24.0, 28.0, 29.0, 30.0, 25.0, 26.0, 27.0, 28.0, 29.0, 30.0});
        data.putProperty("DEPEND_0", tags);
        QDataSet sort = DataSetOps.sort(tags);
        SortDataSet sortData = new SortDataSet(data, sort);
        QDataSet depend0 = (QDataSet)sortData.property("DEPEND_0");
        for (int i = 0; i < data.length(); ++i) {
            System.err.println("" + depend0.value(i) + "  " + sortData.value(i));
        }
    }

    private void test1() {
        System.out.println("sort");
        IndexGenDataSet ds = new IndexGenDataSet(8){
            double[] data;
            {
                this.data = new double[]{3.0, 5.0, 7.0, 1.0, 2.0, -1.0E31, 5.0, 9.0};
            }

            public double value(int i) {
                return this.data[i];
            }
        };
        QDataSet result = DataSetOps.sort(ds);
        for (int i = 0; i < result.length(); ++i) {
            System.err.println("  " + ds.value((int)result.value(i)));
        }
        assert (result.value(0) == 3.0 && result.value(2) == 4.0);
    }

    public static void testSliceIndexProps() {
        HashMap<String, Object> m = new HashMap<String, Object>();
        m.put("UNITS__0", Units.hertz);
        m.put("UNITS__1", Units.eV);
        m.put("UNITS__1_100", Units.eV);
        m.put("UNITS__2", Units.seconds);
        System.err.println(DataSetOps.sliceProperties0(1, m));
    }

    public static void testUnbundleRank1() {
        QDataSet bundle = Ops.bundle(null, DataSetUtil.asDataSet(0.0, Units.dB));
        bundle = Ops.bundle(bundle, DataSetUtil.asDataSet(1.0, Units.dB));
        bundle = Ops.bundle(bundle, DataSetUtil.asDataSet(2.0, Units.dB));
        bundle = Ops.bundle(bundle, DataSetUtil.asDataSet(3.0, Units.bytesPerSecond));
        bundle = Ops.bundle(bundle, DataSetUtil.asDataSet(4.0, Units.dB));
        System.err.println(DataSetOps.unbundle(bundle, 2));
    }

    public static void main(String[] args) {
        TestDataSetOps.testUnbundleRank1();
    }
}

