/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import org.python.core.Py;
import org.python.core.PyIterator;
import org.python.core.PyObject;
import org.python.core.PyTuple;

class PyStringMapIter
extends PyIterator {
    String[] keyTable;
    PyObject[] valTable;
    private int idx;
    private int type;
    public static final int KEYS = 0;
    public static final int VALUES = 1;
    public static final int ITEMS = 2;

    public PyStringMapIter(String[] keys, PyObject[] values) {
        this(keys, values, 0);
    }

    public PyStringMapIter(String[] keys, PyObject[] values, int type) {
        this.keyTable = keys;
        this.valTable = values;
        this.idx = 0;
        this.type = type;
    }

    public PyObject __iternext__() {
        int n = this.keyTable.length;
        while (this.idx < n) {
            String key = this.keyTable[this.idx];
            PyObject val = this.valTable[this.idx];
            if (key != null && key != "<deleted key>" && val != null) {
                ++this.idx;
                switch (this.type) {
                    case 1: {
                        return val;
                    }
                    case 2: {
                        return new PyTuple(new PyObject[]{Py.newString(key), val});
                    }
                }
                return Py.newString(key);
            }
            ++this.idx;
        }
        return null;
    }
}

