/*
 * Decompiled with CFR 0.152.
 */
package org.virbo.netCDF;

import java.io.IOException;
import java.nio.channels.WritableByteChannel;
import org.das2.util.monitor.NullProgressMonitor;
import org.das2.util.monitor.ProgressMonitor;
import org.virbo.dataset.DataSetUtil;
import org.virbo.dataset.QDataSet;
import org.virbo.datasource.DataSetURI;
import org.virbo.netCDF.AbstractIOSP;
import ucar.ma2.Array;
import ucar.ma2.DataType;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.Section;
import ucar.nc2.Dimension;
import ucar.nc2.NetcdfFile;
import ucar.nc2.ParsedSectionSpec;
import ucar.nc2.Variable;
import ucar.nc2.iosp.IOServiceProvider;
import ucar.nc2.util.CancelTask;
import ucar.unidata.io.RandomAccessFile;

public class APIOServiceProvider
extends AbstractIOSP
implements IOServiceProvider {
    QDataSet result;
    String dep0name;

    public boolean isValidFile(RandomAccessFile arg0) throws IOException {
        return false;
    }

    public void open(RandomAccessFile raf, NetcdfFile ncfile, CancelTask arg2) throws IOException {
        try {
            Variable var;
            String suri = this.getProperty("vapuri");
            if (suri == null) {
                throw new IllegalArgumentException("vapuri must be specified in iospParams");
            }
            this.result = DataSetURI.getDataSource((String)suri).getDataSet((ProgressMonitor)new NullProgressMonitor());
            Dimension dim = null;
            String name = (String)this.result.property("NAME");
            if (name == null) {
                name = "data";
            }
            int n = this.result.length();
            dim = new Dimension(name, n, true, true, false);
            ncfile.addDimension(null, dim);
            QDataSet dep0 = (QDataSet)this.result.property("DEPEND_0");
            this.dep0name = null;
            if (dep0 != null) {
                this.dep0name = (String)dep0.property("NAME");
                if (name == null) {
                    this.dep0name = "dep0";
                }
                dim = new Dimension(this.dep0name, n, true, true, false);
                ncfile.addDimension(null, dim);
            }
            if (dep0 != null) {
                var = new Variable(ncfile, null, null, this.dep0name);
                var.setDataType(DataType.DOUBLE);
                var.setDimensionsAnonymous(DataSetUtil.qubeDims((QDataSet)this.result));
                ncfile.addVariable(null, var);
            }
            var = new Variable(ncfile, null, null, name);
            var.setDataType(DataType.DOUBLE);
            var.setDimensionsAnonymous(DataSetUtil.qubeDims((QDataSet)this.result));
            ncfile.addVariable(null, var);
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw new IOException("APIOSP.open() failed: " + t.getMessage());
        }
    }

    public Array readData(Variable variable, Section section) throws IOException, InvalidRangeException {
        String vname = variable.getName();
        DataType type = variable.getDataType();
        double[] data = null;
        Object sdata = null;
        QDataSet co = this.result;
        if (vname.equals(this.dep0name)) {
            co = (QDataSet)this.result.property("DEPEND_0");
        }
        if (type.isString()) {
            Array array = Array.factory((DataType)type, (int[])DataSetUtil.qubeDims((QDataSet)this.result), sdata);
            throw new RuntimeException("whoops");
        }
        data = new double[this.result.length()];
        for (int i = 0; i < this.result.length(); ++i) {
            data[i] = this.result.value(i);
        }
        Array array = Array.factory((DataType)type, (int[])DataSetUtil.qubeDims((QDataSet)this.result), (Object)data);
        return array;
    }

    public String getFileTypeId() {
        return "Autoplot-URI";
    }

    public String getFileTypeDescription() {
        return "Autoplot Data Access URI.  Autoplot's libraries are used to access an Autoplot URI via QDataSet, whichis then copied into NetCDF";
    }

    public long readToByteChannel(Variable arg0, Section arg1, WritableByteChannel arg2) throws IOException, InvalidRangeException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Array readSection(ParsedSectionSpec arg0) throws IOException, InvalidRangeException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void close() throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public boolean syncExtend() throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public boolean sync() throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public String toStringDebug(Object arg0) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public String getDetailInfo() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public String getFileTypeVersion() {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

