/*
 * Decompiled with CFR 0.152.
 */
package org.virbo.netCDF;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.das2.datum.Units;
import org.das2.datum.UnitsUtil;
import org.das2.util.monitor.ProgressMonitor;
import org.virbo.dataset.DataSetUtil;
import org.virbo.dataset.QDataSet;
import org.virbo.dataset.SemanticOps;
import org.virbo.datasource.AbstractDataSourceFormat;
import ucar.ma2.DataType;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.NetcdfFileWriteable;
import ucar.nc2.Variable;

public class HDF5DataSourceFormat
extends AbstractDataSourceFormat {
    Map<QDataSet, String> names = new HashMap<QDataSet, String>();

    private synchronized String nameFor(QDataSet dep0) {
        String name = this.names.get(dep0);
        if (name == null) {
            name = (String)dep0.property("NAME");
        }
        Units units = (Units)dep0.property("UNITS");
        if (name == null) {
            name = units != null && UnitsUtil.isTimeLocation((Units)units) ? "Epoch" : "Variable_" + this.names.size();
        }
        this.names.put(dep0, name);
        return name;
    }

    private synchronized DataType typeFor(QDataSet dep0, String suggest) {
        Units units = (Units)dep0.property("UNITS");
        if (units != null && UnitsUtil.isTimeLocation((Units)units)) {
            return DataType.DOUBLE;
        }
        if (suggest.equals("double")) {
            return DataType.DOUBLE;
        }
        if (suggest.equals("float")) {
            return DataType.FLOAT;
        }
        return DataType.DOUBLE;
    }

    private static Object getProperty(QDataSet src, String name, Object deft) {
        Object o = src.property(name);
        if (o == null) {
            return deft;
        }
        return o;
    }

    public void formatData(String uri, QDataSet data, ProgressMonitor mon) throws Exception {
        this.setUri(uri);
        String typeSuggest = this.getParam("type", "double");
        NetcdfFileWriteable ncfile = NetcdfFileWriteable.createNew((String)this.getResourceURI().toURL().toString());
        String varName = this.nameFor(data);
        int[] qube = DataSetUtil.qubeDims((QDataSet)data);
        if (qube == null) {
            throw new IllegalArgumentException("data is not a qube");
        }
        ArrayList<Dimension> dims = new ArrayList<Dimension>();
        for (int i = 0; i < data.rank(); ++i) {
            String namei = "dim" + i;
            QDataSet depi = (QDataSet)data.property("DEPEND_" + i);
            if (depi != null) {
                namei = this.nameFor(depi);
            }
            dims.add(new Dimension(namei, qube[i]));
        }
        Variable var = ncfile.addVariable(varName, this.typeFor(data, typeSuggest), dims);
        String meta = this.getParam("metadata", "");
        if (meta.equals("istp")) {
            var.addAttribute(new Attribute("UNITS", SemanticOps.getUnits((QDataSet)data).toString()));
            var.addAttribute(new Attribute("VAR_TYPE", "data"));
            var.addAttribute(new Attribute("VALIDMIN", (Number)((Double)HDF5DataSourceFormat.getProperty(data, "VALID_MIN", -1.0E38))));
            var.addAttribute(new Attribute("VALIDMAX", (Number)((Double)HDF5DataSourceFormat.getProperty(data, "VALID_MAX", 1.0E38))));
            var.addAttribute(new Attribute("FILLVAL", (Number)((Double)HDF5DataSourceFormat.getProperty(data, "FILL_VALUE", -1.0E31))));
        }
        ncfile.finish();
        ncfile.close();
    }
}

