/*
 * Decompiled with CFR 0.152.
 */
package org.virbo.netCDF;

import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jdesktop.layout.GroupLayout;
import org.virbo.datasource.DataSourceFormatEditorPanel;
import org.virbo.datasource.URISplit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HDF5DataSourceFormatEditorPanel
extends JPanel
implements DataSourceFormatEditorPanel {
    String file;
    private JCheckBox istpMetadata;
    private JLabel jLabel1;
    private JComboBox typeComboBox;

    public HDF5DataSourceFormatEditorPanel() {
        this.initComponents();
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.typeComboBox = new JComboBox();
        this.istpMetadata = new JCheckBox();
        this.jLabel1.setText("Type:");
        this.typeComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"double", "float", "byte"}));
        this.istpMetadata.setText("Use ISTP Metadata Conventions");
        this.istpMetadata.setToolTipText("Use ISTP metadata conventions for the data, like LABLAXIS, UNITS and VALIDMIN");
        this.istpMetadata.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                HDF5DataSourceFormatEditorPanel.this.istpMetadataActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jLabel1).addPreferredGap(0).add((Component)this.typeComboBox, -2, 123, -2).addContainerGap()).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.istpMetadata, -1, 364, Short.MAX_VALUE).add(24, 24, 24)))));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel1).add((Component)this.typeComboBox, -2, -1, -2)).addPreferredGap(0).add((Component)this.istpMetadata).addContainerGap(233, Short.MAX_VALUE)));
    }

    private void istpMetadataActionPerformed(ActionEvent evt) {
    }

    public JPanel getPanel() {
        return this;
    }

    private String getParam(Map<String, String> args, String name, String defl) {
        String s = args.get(name);
        if (s == null) {
            return defl;
        }
        return s;
    }

    public void setURI(String uri) {
        URISplit split = URISplit.parse((String)uri);
        LinkedHashMap args = URISplit.parseParams((String)split.params);
        String s = this.getParam(args, "type", "double");
        this.typeComboBox.setSelectedItem(s);
        this.file = split.file;
    }

    public String getURI() {
        String result = this.file;
        HashMap<String, String> args = new HashMap<String, String>();
        String s = (String)this.typeComboBox.getSelectedItem();
        if (!s.equals("double")) {
            args.put("type", s);
        }
        String sargs = URISplit.formatParams(args);
        String params = URISplit.formatParams(args);
        if (result == null) {
            result = "file:///";
        }
        URISplit ss = URISplit.parse((String)result);
        if (params.length() > 0) {
            ss.params = params;
        }
        return URISplit.format((URISplit)ss);
    }
}

