/*
 * Decompiled with CFR 0.152.
 */
package org.virbo.netCDF;

import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.das2.datum.Units;
import org.das2.datum.UnitsConverter;
import org.das2.util.monitor.NullProgressMonitor;
import org.das2.util.monitor.ProgressMonitor;
import org.virbo.dataset.AbstractDataSet;
import org.virbo.dataset.DataSetUtil;
import org.virbo.dataset.QDataSet;
import org.virbo.dataset.SemanticOps;
import org.virbo.dsops.Ops;
import org.virbo.metatree.IstpMetadataModel;
import ucar.ma2.Array;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.Range;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.Variable;
import ucar.nc2.dataset.NetcdfDataset;

public class NetCdfVarDataSet
extends AbstractDataSet {
    Variable v;
    double[] data;
    int[] shape;
    private static final Logger logger = Logger.getLogger("virbo.netcdf");

    public static NetCdfVarDataSet create(Variable variable, String constraint, NetcdfDataset ncfile, ProgressMonitor mon) throws IOException {
        NetCdfVarDataSet result = new NetCdfVarDataSet();
        result.read(variable, ncfile, constraint, mon);
        return result;
    }

    private NetCdfVarDataSet() {
    }

    public static String sliceConstraints(String constraints, int i) {
        String[] cc;
        if (constraints == null) {
            return null;
        }
        if (constraints.startsWith("[") && constraints.endsWith("]")) {
            constraints = constraints.substring(1, constraints.length() - 1);
        }
        if (i >= (cc = constraints.split(",")).length) {
            return null;
        }
        if (cc[i].equals(":")) {
            return null;
        }
        return cc[i];
    }

    public static long[] parseConstraint(String constraint, long recCount) throws ParseException {
        long[] result = new long[]{0L, recCount, 1L};
        if (constraint == null) {
            return result;
        }
        if (constraint.startsWith("[") && constraint.endsWith("]")) {
            constraint = constraint.substring(1, constraint.length() - 1);
        }
        try {
            String[] ss = constraint.split(":", -2);
            if (ss.length > 0 && ss[0].length() > 0) {
                result[0] = Integer.parseInt(ss[0]);
                if (result[0] < 0L) {
                    result[0] = recCount + result[0];
                }
            }
            if (ss.length > 1 && ss[1].length() > 0) {
                result[1] = Integer.parseInt(ss[1]);
                if (result[1] < 0L) {
                    result[1] = recCount + result[1];
                }
            }
            if (ss.length > 2 && ss[2].length() > 0) {
                result[2] = Integer.parseInt(ss[2]);
            }
            if (ss.length == 1) {
                result[1] = -1L;
                result[2] = -1L;
            }
        }
        catch (NumberFormatException ex) {
            throw new ParseException("expected integer: " + ex.toString(), 0);
        }
        return result;
    }

    private int sliceCount(boolean[] slice, int idim) {
        int result = 0;
        for (int i = 0; i < idim; ++i) {
            if (!slice[i]) continue;
            ++result;
        }
        return result;
    }

    private void read(Variable variable, NetcdfDataset ncfile, String constraints, ProgressMonitor mon) throws IOException {
        int i;
        String unitsString;
        Array a;
        this.v = variable;
        if (!mon.isStarted()) {
            mon.started();
        }
        mon.setProgressMessage("reading " + this.v.getNameAndDimensions());
        this.shape = this.v.getShape();
        boolean[] slice = new boolean[this.shape.length];
        if (constraints != null) {
            if (constraints.startsWith("[") && constraints.endsWith("]")) {
                constraints = constraints.substring(1, constraints.length() - 1);
            }
            try {
                String[] cc = constraints.split(",");
                ArrayList<Range> ranges = new ArrayList<Range>(this.v.getRanges());
                for (int i2 = 0; i2 < cc.length; ++i2) {
                    long[] ir = NetCdfVarDataSet.parseConstraint(cc[i2], ((Range)ranges.get(i2)).last() + 1);
                    if (ir[1] == -1L) {
                        ranges.set(i2, new Range((int)ir[0], (int)ir[0]));
                        this.shape[i2] = 1;
                        slice[i2] = true;
                        continue;
                    }
                    ranges.set(i2, new Range((int)ir[0], (int)ir[1] - 1, (int)ir[2]));
                    this.shape[i2] = (int)((ir[1] - ir[0]) / ir[2]);
                }
                a = this.v.read(ranges);
            }
            catch (ParseException ex) {
                throw new RuntimeException(ex);
            }
            catch (InvalidRangeException ex) {
                throw new RuntimeException(ex);
            }
        } else {
            a = this.v.read();
        }
        char[] cdata = null;
        try {
            if (a.getElementType() == Character.TYPE) {
                cdata = (char[])a.get1DJavaArray(Character.TYPE);
            } else {
                this.data = (double[])a.get1DJavaArray(Double.class);
            }
        }
        catch (ClassCastException ex) {
            throw new IllegalArgumentException("data cannot be converted to numbers", ex);
        }
        this.properties.put("NAME", Ops.safeName((String)variable.getName()));
        if (this.shape.length > 1) {
            this.properties.put("QUBE", Boolean.TRUE);
        }
        boolean isCoordinateVariable = false;
        for (int ir = 0; ir < a.getRank(); ++ir) {
            Dimension d;
            Variable cv;
            if (slice[ir] || (cv = ncfile.findVariable((d = this.v.getDimension(ir)).getName())) == null || !cv.isCoordinateVariable()) continue;
            Variable dv = cv;
            if (dv != variable && dv.getRank() == 1) {
                mon.setProgressMessage("reading " + dv.getNameAndDimensions());
                NetCdfVarDataSet dependi = NetCdfVarDataSet.create(dv, NetCdfVarDataSet.sliceConstraints(constraints, ir), ncfile, (ProgressMonitor)new NullProgressMonitor());
                this.properties.put("DEPEND_" + (ir - this.sliceCount(slice, ir)), dependi);
                continue;
            }
            isCoordinateVariable = true;
        }
        HashMap<String, String> attributes = new HashMap<String, String>();
        mon.setProgressMessage("reading attributes");
        List attrs = this.v.getAttributes();
        for (Attribute attr : attrs) {
            if (attr.isArray()) continue;
            if (attr.isString()) {
                attributes.put(attr.getName(), attr.getStringValue());
                continue;
            }
            attributes.put(attr.getName(), String.valueOf(attr.getNumericValue()));
        }
        if (attributes.containsKey("units") && (unitsString = (String)attributes.get("units")).contains(" since ")) {
            Units u;
            try {
                u = SemanticOps.lookupTimeUnits((String)unitsString);
            }
            catch (ParseException ex) {
                throw new RuntimeException(ex);
            }
            this.properties.put("UNITS", u);
            this.properties.put("MONOTONIC", Boolean.TRUE);
        }
        if (this.data == null) {
            if (cdata == null) {
                throw new RuntimeException("Either data or cdata should be defined at this point");
            }
            if (this.shape.length == 2 && this.shape[1] >= 14 && this.shape[1] <= 30) {
                logger.fine("parsing times formatted in char arrays");
                this.data = new double[this.shape[0]];
                String ss = new String(cdata);
                for (int i3 = 0; i3 < this.shape[0]; ++i3) {
                    int n = i3 * this.shape[1];
                    String s = ss.substring(n, n + this.shape[1]);
                    try {
                        this.data[i3] = Units.us2000.parse(s).doubleValue((Units)Units.us2000);
                        continue;
                    }
                    catch (ParseException ex) {
                        this.data[i3] = Units.us2000.getFillDouble();
                    }
                }
                this.properties.put("UNITS", Units.us2000);
                this.shape = new int[]{this.shape[0]};
            } else {
                this.data = (double[])a.get1DJavaArray(Double.class);
            }
        }
        if (attributes.containsKey("_FillValue")) {
            double fill = Double.parseDouble((String)attributes.get("_FillValue"));
            for (int i4 = 0; i4 < this.data.length; ++i4) {
                if (this.data[i4] != fill) continue;
                this.data[i4] = -1.0E31;
            }
        }
        if (attributes.containsKey("VAR_TYPE")) {
            this.properties.put("METADATA_MODEL", "ISTP-CDF");
            Map istpProps = new IstpMetadataModel().properties(attributes);
            if (this.properties.get("UNITS") == Units.us2000) {
                UnitsConverter uc = UnitsConverter.getConverter((Units)Units.cdfEpoch, (Units)Units.us2000);
                if (istpProps.containsKey("VALID_MIN")) {
                    istpProps.put("VALID_MIN", uc.convert((Number)istpProps.get("VALID_MIN")));
                }
                if (istpProps.containsKey("VALID_MAX")) {
                    istpProps.put("VALID_MAX", uc.convert((Number)istpProps.get("VALID_MAX")));
                }
                if (istpProps.containsKey("TYPICAL_MIN")) {
                    istpProps.put("TYPICAL_MIN", uc.convert((Number)istpProps.get("TYPICAL_MIN")));
                }
                if (istpProps.containsKey("TYPICAL_MAX")) {
                    istpProps.put("TYPICAL_MAX", uc.convert((Number)istpProps.get("TYPICAL_MAX")));
                }
                istpProps.put("UNITS", Units.us2000);
            }
            this.properties.putAll(istpProps);
            for (int ir = 0; ir < a.getRank(); ++ir) {
                Variable dv;
                String s = (String)attributes.get("DEPEND_" + ir);
                if (s == null || (dv = ncfile.findVariable(s)) == null || dv == variable) continue;
                NetCdfVarDataSet dependi = NetCdfVarDataSet.create(dv, NetCdfVarDataSet.sliceConstraints(constraints, ir), ncfile, (ProgressMonitor)new NullProgressMonitor());
                this.properties.put("DEPEND_" + (ir - this.sliceCount(slice, ir)), dependi);
            }
        }
        ArrayList<Integer> newShape = new ArrayList<Integer>(this.shape.length);
        for (i = 0; i < this.shape.length; ++i) {
            if (slice[i]) continue;
            newShape.add(this.shape[i]);
        }
        this.shape = new int[newShape.size()];
        for (i = 0; i < newShape.size(); ++i) {
            this.shape[i] = (Integer)newShape.get(i);
        }
        if (this.properties.get("FILL_VALUE") == null && this.properties.get("VALID_MIN") == null) {
            this.properties.put("VALID_MIN", -1.0E90);
        }
        if (isCoordinateVariable) {
            this.properties.put("CADENCE", DataSetUtil.guessCadenceNew((QDataSet)this, null));
        }
        mon.finished();
    }

    public int rank() {
        return this.shape.length;
    }

    public double value(int i) {
        return this.data[i];
    }

    public double value(int i, int j) {
        int index = j + this.shape[1] * i;
        return this.data[index];
    }

    public double value(int i, int j, int k) {
        int index = k + this.shape[2] * j + this.shape[2] * this.shape[1] * i;
        if (index >= this.data.length) {
            throw new IllegalArgumentException("how");
        }
        return this.data[index];
    }

    public double value(int i, int j, int k, int l) {
        int index = l + this.shape[3] * k + this.shape[3] * this.shape[2] * j + this.shape[3] * this.shape[2] * this.shape[1] * i;
        if (index >= this.data.length) {
            throw new IllegalArgumentException("how");
        }
        return this.data[index];
    }

    public int length() {
        return this.shape[0];
    }

    public int length(int dim) {
        return this.shape[1];
    }

    public int length(int dim0, int dim1) {
        return this.shape[2];
    }

    public int length(int dim0, int dim1, int dim2) {
        return this.shape[3];
    }
}

