/*
 * Decompiled with CFR 0.152.
 */
package org.tsds.datasource;

import java.net.URI;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import org.das2.util.monitor.ProgressMonitor;
import org.tsds.datasource.TsdsDataSource;
import org.tsds.datasource.TsdsTimeSeriesBrowse;
import org.virbo.datasource.CompletionContext;
import org.virbo.datasource.DataSource;
import org.virbo.datasource.DataSourceFactory;
import org.virbo.datasource.URISplit;
import org.virbo.datasource.capability.TimeSeriesBrowse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TsdsDataSourceFactory
implements DataSourceFactory {
    public DataSource getDataSource(URI uri) throws Exception {
        return new TsdsDataSource(uri);
    }

    public List<CompletionContext> getCompletions(CompletionContext cc, ProgressMonitor mon) throws Exception {
        String paramName;
        ArrayList<CompletionContext> result = new ArrayList<CompletionContext>();
        if (cc.context == CompletionContext.CONTEXT_PARAMETER_NAME) {
            result.add(new CompletionContext(CompletionContext.CONTEXT_PARAMETER_NAME, "param1=", "dataset identifier"));
            result.add(new CompletionContext(CompletionContext.CONTEXT_PARAMETER_NAME, "StartDate=", "YYYYMMDD start time"));
            result.add(new CompletionContext(CompletionContext.CONTEXT_PARAMETER_NAME, "EndTime=", "YYYYMMDD end time"));
            result.add(new CompletionContext(CompletionContext.CONTEXT_PARAMETER_NAME, "ppd=", "number of points per day"));
            result.add(new CompletionContext(CompletionContext.CONTEXT_PARAMETER_NAME, "filter=", "data reduction filter"));
        } else if (cc.context == CompletionContext.CONTEXT_PARAMETER_VALUE && (paramName = CompletionContext.get((Object)CompletionContext.CONTEXT_PARAMETER_NAME, (CompletionContext)cc)).equals("filter")) {
            result.add(new CompletionContext(CompletionContext.CONTEXT_PARAMETER_VALUE, "numbervalid", "number of points in each bin"));
            result.add(new CompletionContext(CompletionContext.CONTEXT_PARAMETER_VALUE, "max", "maximum value in bin"));
            result.add(new CompletionContext(CompletionContext.CONTEXT_PARAMETER_VALUE, "min", "minimum value in bin"));
        }
        return result;
    }

    public boolean reject(String surl, ProgressMonitor mon) {
        URISplit split = URISplit.parse((String)surl);
        LinkedHashMap params = URISplit.parseParams((String)split.params);
        if (split.params.equals("")) {
            return !surl.contains("tf_") || !surl.contains("to_");
        }
        return !params.containsKey("StartDate") || !params.containsKey("EndDate") || !params.containsKey("param1");
    }

    public <T> T getCapability(Class<T> clazz) {
        if (clazz.isInstance(TimeSeriesBrowse.class)) {
            return (T)new TsdsTimeSeriesBrowse();
        }
        return null;
    }
}

