/*
 * Decompiled with CFR 0.152.
 */
package org.virbo.dataset;

import java.util.HashMap;
import org.virbo.dataset.DataSetUtil;
import org.virbo.dataset.MutablePropertyDataSet;
import org.virbo.dataset.QDataSet;
import org.virbo.dataset.Slice0DataSet;
import org.virbo.dataset.TrimDataSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractDataSet
implements QDataSet,
MutablePropertyDataSet {
    protected HashMap<String, Object> properties = new HashMap();

    @Override
    public abstract int rank();

    @Override
    public double value() {
        throw new IllegalArgumentException("rank error, expected " + this.rank());
    }

    @Override
    public double value(int i0) {
        throw new IllegalArgumentException("rank error, expected " + this.rank());
    }

    @Override
    public double value(int i0, int i1) {
        throw new IllegalArgumentException("rank error, expected " + this.rank());
    }

    @Override
    public double value(int i0, int i1, int i2) {
        throw new IllegalArgumentException("rank error, expected " + this.rank());
    }

    @Override
    public double value(int i0, int i1, int i2, int i3) {
        throw new IllegalArgumentException("rank error, expected " + this.rank());
    }

    @Override
    public Object property(String name) {
        return this.properties.get(name);
    }

    @Override
    public Object property(String name, int i) {
        String pname = name + "__" + i;
        Object r = this.properties.get(pname);
        if (r != null) {
            return r;
        }
        if (DataSetUtil.isInheritedProperty(name)) {
            return this.properties.get(name);
        }
        return null;
    }

    private void checkPropertyType(String name, Object value) {
        if ((name.equals("DELTA_MINUS") || name.equals("DELTA_PLUS") || name.equals("DEPEND_0")) && value != null && !(value instanceof QDataSet)) {
            System.err.println(String.format("AbstractDataSet.checkPropertyType: %s is not a QDataSet (%s)", name, value.toString()));
        }
    }

    @Override
    public void putProperty(String name, Object value) {
        this.checkPropertyType(name, value);
        this.properties.put(name, value);
        if (name.equals("DEPEND_0") && value != null) {
            if (value instanceof QDataSet) {
                QDataSet dep0 = (QDataSet)value;
                if (this.rank() > 0 && dep0.length() != this.length()) {
                    System.err.println("DEPEND_0 is incorrect length, its length is " + dep0.length() + " should be " + this.length());
                }
            } else if (value instanceof String) {
                System.err.println("Use DEPENDNAME_0 instead of DEPEND_0");
            }
        } else if (name.equals("DEPEND_1") && value != null) {
            if (this.rank() <= 1) {
                System.err.println("DEPEND_1 was set on dataset of rank 0 or rank 1.  Ignoring...");
            } else if (value instanceof QDataSet) {
                QDataSet dep1 = (QDataSet)value;
                if (this.rank() > 0 && this.length() > 0 && dep1.rank() == 1 && dep1.length() != this.length(0)) {
                    System.err.println("DEPEND_1 is incorrect length, its length is " + dep1.length() + " should be " + this.length(0));
                }
            } else if (value instanceof String) {
                System.err.println("Use DEPENDNAME_1 instead of DEPEND_1");
            }
        }
    }

    @Override
    public void putProperty(String name, int index, Object value) {
        this.properties.put(name + "__" + index, value);
    }

    @Override
    public int length() {
        throw new IllegalArgumentException("rank error, expected " + this.rank());
    }

    @Override
    public int length(int i) {
        throw new IllegalArgumentException("rank error, expected " + this.rank());
    }

    @Override
    public int length(int i, int j) {
        throw new IllegalArgumentException("rank error, expected " + this.rank());
    }

    @Override
    public int length(int i, int j, int k) {
        throw new IllegalArgumentException("rank error, expected " + this.rank() + ", NAME=" + this.property("NAME"));
    }

    @Override
    public <T> T capability(Class<T> clazz) {
        return null;
    }

    @Override
    public QDataSet slice(int i) {
        return new Slice0DataSet(this, i);
    }

    @Override
    public QDataSet trim(int start, int end) {
        return new TrimDataSet(this, start, end);
    }

    public String toString() {
        return DataSetUtil.toString(this);
    }
}

