/*
 * Decompiled with CFR 0.152.
 */
package org.virbo.dataset;

import java.lang.reflect.Array;
import java.util.HashMap;
import java.util.Map;
import org.das2.datum.Units;
import org.das2.datum.UnitsConverter;
import org.virbo.dataset.AbstractDataSet;
import org.virbo.dataset.BDataSet;
import org.virbo.dataset.DDataSet;
import org.virbo.dataset.DataSetUtil;
import org.virbo.dataset.FDataSet;
import org.virbo.dataset.IDataSet;
import org.virbo.dataset.JoinDataSet;
import org.virbo.dataset.LDataSet;
import org.virbo.dataset.QDataSet;
import org.virbo.dataset.RankZeroDataSet;
import org.virbo.dataset.SDataSet;
import org.virbo.dataset.SemanticOps;
import org.virbo.dataset.WritableDataSet;

public abstract class ArrayDataSet
extends AbstractDataSet
implements WritableDataSet {
    int rank;
    int len0;
    int len1;
    int len2;
    int len3;
    float fill = Float.NaN;
    double dfill = Double.NaN;

    protected static ArrayDataSet create(int rank, int len0, int len1, int len2, int len3, Object back) {
        Class<?> c = back.getClass().getComponentType();
        if (c == Double.TYPE) {
            return new DDataSet(rank, len0, len1, len2, len3, (double[])back);
        }
        if (c == Float.TYPE) {
            return new FDataSet(rank, len0, len1, len2, len3, (float[])back);
        }
        if (c == Long.TYPE) {
            return new LDataSet(rank, len0, len1, len2, len3, (long[])back);
        }
        if (c == Integer.TYPE) {
            return new IDataSet(rank, len0, len1, len2, len3, (int[])back);
        }
        if (c == Short.TYPE) {
            return new SDataSet(rank, len0, len1, len2, len3, (short[])back);
        }
        if (c == Byte.TYPE) {
            return new BDataSet(rank, len0, len1, len2, len3, (byte[])back);
        }
        throw new IllegalArgumentException("class not supported: " + c);
    }

    public static ArrayDataSet createRank1(Class c, int len0) {
        if (c == Double.TYPE) {
            return new DDataSet(1, len0, 1, 1, 1);
        }
        if (c == Float.TYPE) {
            return new FDataSet(1, len0, 1, 1, 1);
        }
        if (c == Long.TYPE) {
            return new LDataSet(1, len0, 1, 1, 1);
        }
        if (c == Integer.TYPE) {
            return new IDataSet(1, len0, 1, 1, 1);
        }
        if (c == Short.TYPE) {
            return new SDataSet(1, len0, 1, 1, 1);
        }
        if (c == Byte.TYPE) {
            return new BDataSet(1, len0, 1, 1, 1);
        }
        throw new IllegalArgumentException("class not supported: " + c);
    }

    public static ArrayDataSet createRank2(Class c, int len0, int len1) {
        if (c == Double.TYPE) {
            return new DDataSet(2, len0, len1, 1, 1);
        }
        if (c == Float.TYPE) {
            return new FDataSet(2, len0, len1, 1, 1);
        }
        if (c == Long.TYPE) {
            return new LDataSet(2, len0, len1, 1, 1);
        }
        if (c == Integer.TYPE) {
            return new IDataSet(2, len0, len1, 1, 1);
        }
        if (c == Short.TYPE) {
            return new SDataSet(2, len0, len1, 1, 1);
        }
        if (c == Byte.TYPE) {
            return new BDataSet(2, len0, len1, 1, 1);
        }
        throw new IllegalArgumentException("class not supported: " + c);
    }

    public static ArrayDataSet createRank3(Class c, int len0, int len1, int len2) {
        if (c == Double.TYPE) {
            return new DDataSet(3, len0, len1, len2, 1);
        }
        if (c == Float.TYPE) {
            return new FDataSet(3, len0, len1, len2, 1);
        }
        if (c == Long.TYPE) {
            return new LDataSet(3, len0, len1, len2, 1);
        }
        if (c == Integer.TYPE) {
            return new IDataSet(3, len0, len1, len2, 1);
        }
        if (c == Short.TYPE) {
            return new SDataSet(3, len0, len1, len2, 1);
        }
        if (c == Byte.TYPE) {
            return new BDataSet(3, len0, len1, len2, 1);
        }
        throw new IllegalArgumentException("class not supported: " + c);
    }

    public static ArrayDataSet createRank4(Class c, int len0, int len1, int len2, int len3) {
        if (c == Double.TYPE) {
            return new DDataSet(4, len0, len1, len2, len3);
        }
        if (c == Float.TYPE) {
            return new FDataSet(4, len0, len1, len2, len3);
        }
        if (c == Long.TYPE) {
            return new LDataSet(4, len0, len1, len2, len3);
        }
        if (c == Integer.TYPE) {
            return new IDataSet(4, len0, len1, len2, len3);
        }
        if (c == Short.TYPE) {
            return new SDataSet(4, len0, len1, len2, len3);
        }
        if (c == Byte.TYPE) {
            return new BDataSet(4, len0, len1, len2, len3);
        }
        throw new IllegalArgumentException("class not supported: " + c);
    }

    public static ArrayDataSet wrap(Object array, int[] qube, boolean copy) {
        Object arr;
        if (!array.getClass().isArray()) {
            throw new IllegalArgumentException("input must be an array");
        }
        Class<?> c = array.getClass().getComponentType();
        if (c.isArray()) {
            throw new IllegalArgumentException("input must be 1-D array");
        }
        if (copy) {
            arr = Array.newInstance(c, Array.getLength(array));
            System.arraycopy(array, 0, arr, 0, Array.getLength(array));
        } else {
            arr = array;
        }
        if (c == Double.TYPE) {
            return DDataSet.wrap((double[])arr, qube);
        }
        if (c == Float.TYPE) {
            return FDataSet.wrap((float[])arr, qube);
        }
        if (c == Long.TYPE) {
            return LDataSet.wrap((long[])arr, qube);
        }
        if (c == Integer.TYPE) {
            return IDataSet.wrap((int[])arr, qube);
        }
        if (c == Short.TYPE) {
            return SDataSet.wrap((short[])arr, qube);
        }
        if (c == Byte.TYPE) {
            return BDataSet.wrap((byte[])arr, qube);
        }
        throw new IllegalArgumentException("component type not supported: " + c);
    }

    public int rank() {
        return this.rank;
    }

    public int length() {
        return this.len0;
    }

    public int length(int i) {
        if (i >= this.len0) {
            throw new IndexOutOfBoundsException("length(" + i + ") when dim 0 length=" + this.len0);
        }
        return this.len1;
    }

    public int length(int i0, int i1) {
        if (i0 >= this.len0) {
            throw new IndexOutOfBoundsException("length(" + i0 + "," + i1 + ") when dim 0 length=" + this.len0);
        }
        if (i1 >= this.len1) {
            throw new IndexOutOfBoundsException("length(" + i0 + "," + i1 + ") when dim 1 length=" + this.len1);
        }
        return this.len2;
    }

    public int length(int i0, int i1, int i2) {
        if (i0 >= this.len0) {
            throw new IndexOutOfBoundsException("length(" + i0 + "," + i1 + "," + i2 + ") when dim 0 length=" + this.len0);
        }
        if (i1 >= this.len1) {
            throw new IndexOutOfBoundsException("length(" + i0 + "," + i1 + "," + i2 + ") when dim 1 length=" + this.len1);
        }
        if (i2 >= this.len2) {
            throw new IndexOutOfBoundsException("length(" + i0 + "," + i1 + "," + i2 + ") when dim 2 length=" + this.len2);
        }
        return this.len3;
    }

    public Class getComponentType() {
        return this.getBack().getClass().getComponentType();
    }

    public void putLength(int len) {
        int limit = Array.getLength(this.getBack()) / (this.len1 * this.len2 * this.len3);
        if (len > limit) {
            throw new IllegalArgumentException("dataset cannot be lengthened");
        }
        this.len0 = len;
    }

    public void grow(int newRecCount) {
        Object[] newBack;
        if (newRecCount < this.len0) {
            throw new IllegalArgumentException("new recsize for grow smaller than old");
        }
        int newSize = newRecCount * this.len1 * this.len2 * this.len3;
        Object back = this.getBack();
        int oldSize = Array.getLength(back);
        if (newSize < oldSize) {
            return;
        }
        if (back instanceof double[]) {
            newBack = new double[newSize];
        } else if (back instanceof float[]) {
            newBack = new float[newSize];
        } else if (back instanceof long[]) {
            newBack = new long[newSize];
        } else if (back instanceof int[]) {
            newBack = new int[newSize];
        } else if (back instanceof short[]) {
            newBack = new short[newSize];
        } else if (back instanceof byte[]) {
            newBack = new byte[newSize];
        } else {
            throw new IllegalArgumentException("shouldn't happen bad type");
        }
        System.arraycopy(back, 0, newBack, 0, Array.getLength(back));
        this.setBack(newBack);
    }

    public synchronized void append(ArrayDataSet ds) {
        if (ds.rank() != this.rank) {
            throw new IllegalArgumentException("rank mismatch");
        }
        if (ds.len1 != this.len1) {
            throw new IllegalArgumentException("len1 mismatch");
        }
        if (ds.len2 != this.len2) {
            throw new IllegalArgumentException("len2 mismatch");
        }
        if (ds.len3 != this.len3) {
            throw new IllegalArgumentException("len3 mismatch");
        }
        if (this.getBack().getClass() != ds.getBack().getClass()) {
            throw new IllegalArgumentException("backing type mismatch");
        }
        int myLength = this.len0 * this.len1 * this.len2 * this.len3;
        int dsLength = ds.len0 * ds.len1 * ds.len2 * ds.len3;
        if (Array.getLength(this.getBack()) < myLength + dsLength) {
            throw new IllegalArgumentException("unable to append dataset, not enough room");
        }
        int srcPos = myLength;
        System.arraycopy(ds.getBack(), 0, this.getBack(), myLength, dsLength);
        this.len0 += ds.len0;
        this.properties.putAll(ArrayDataSet.joinProperties(this, ds));
    }

    public boolean canAppend(ArrayDataSet ds) {
        if (ds.rank() != this.rank) {
            throw new IllegalArgumentException("rank mismatch");
        }
        if (ds.len1 != this.len1) {
            throw new IllegalArgumentException("len1 mismatch");
        }
        if (ds.len2 != this.len2) {
            throw new IllegalArgumentException("len2 mismatch");
        }
        if (ds.len3 != this.len3) {
            throw new IllegalArgumentException("len3 mismatch");
        }
        if (this.getBack().getClass() != ds.getBack().getClass()) {
            Class<?> a1 = ds.getBack().getClass();
            Class<?> a2 = this.getBack().getClass();
            String s1 = "" + a1.getComponentType();
            String s2 = "" + a2.getComponentType();
            throw new IllegalArgumentException("backing type mismatch: " + s2 + "[" + ds.length() + ",*] can't be appended to " + s1 + "[" + this.length() + ",*]");
        }
        int trec = Array.getLength(this.getBack()) / this.len1 / this.len2 / this.len3;
        return trec - this.len0 > ds.length();
    }

    private static Map copyProperties(QDataSet ds) {
        QDataSet plane0;
        int i;
        HashMap<String, Object> result = new HashMap<String, Object>();
        Map<String, Object> srcProps = DataSetUtil.getProperties(ds);
        result.putAll(srcProps);
        for (i = 0; i < ds.rank(); ++i) {
            QDataSet dep = (QDataSet)ds.property("DEPEND_" + i);
            if (dep == ds) {
                throw new IllegalArgumentException("dataset is dependent on itsself!");
            }
            if (dep == null) continue;
            result.put("DEPEND_" + i, ArrayDataSet.copy(dep));
        }
        for (i = 0; i < 50 && (plane0 = (QDataSet)ds.property("PLANE_" + i)) != null; ++i) {
            result.put("PLANE_" + i, ArrayDataSet.copy(plane0));
        }
        return result;
    }

    public static ArrayDataSet maybeCopy(QDataSet ds) {
        if (ds instanceof ArrayDataSet) {
            return (ArrayDataSet)ds;
        }
        return ArrayDataSet.copy(ds);
    }

    public static ArrayDataSet maybeCopy(Class c, QDataSet ds) {
        if (ds instanceof ArrayDataSet && ((ArrayDataSet)ds).getComponentType() == c) {
            return (ArrayDataSet)ds;
        }
        return ArrayDataSet.copy(ds);
    }

    protected abstract Object getBack();

    protected abstract void setBack(Object var1);

    private static ArrayDataSet ddcopy(ArrayDataSet ds) {
        int dsLength = ds.len0 * ds.len1 * ds.len2 * ds.len3;
        Object newback = Array.newInstance(ds.getBack().getClass().getComponentType(), dsLength);
        System.arraycopy(ds.getBack(), 0, newback, 0, dsLength);
        ArrayDataSet result = ArrayDataSet.create(ds.rank, ds.len0, ds.len1, ds.len2, ds.len3, newback);
        result.properties.putAll(ArrayDataSet.copyProperties(ds));
        return result;
    }

    public static ArrayDataSet copy(Class c, QDataSet ds) {
        ArrayDataSet result;
        if (ds instanceof ArrayDataSet && ((ArrayDataSet)ds).getBack().getClass().getComponentType() == c) {
            return ArrayDataSet.ddcopy((ArrayDataSet)ds);
        }
        int rank = ds.rank();
        switch (rank) {
            case 1: {
                result = ArrayDataSet.createRank1(c, ds.length());
                for (int i = 0; i < ds.length(); ++i) {
                    result.putValue(i, ds.value(i));
                }
                break;
            }
            case 2: {
                result = ArrayDataSet.createRank2(c, ds.length(), ds.length(0));
                int i0 = ds.length() > 0 ? ds.length(0) : -1;
                for (int i = 0; i < ds.length(); ++i) {
                    if (ds.length(i) != i0) {
                        throw new IllegalArgumentException("Attempt to copy non-qube into ArrayDataSet which must be qube: " + ds);
                    }
                    for (int j = 0; j < ds.length(i); ++j) {
                        result.putValue(i, j, ds.value(i, j));
                    }
                }
                break;
            }
            case 3: {
                result = ArrayDataSet.createRank3(c, ds.length(), ds.length(0), ds.length(0, 0));
                int i0_ = ds.length() > 0 ? ds.length(0) : -1;
                for (int i = 0; i < ds.length(); ++i) {
                    if (ds.length(i) != i0_) {
                        throw new IllegalArgumentException("Attempt to copy non-qube into ArrayDataSet which must be qube: " + ds);
                    }
                    for (int j = 0; j < ds.length(i); ++j) {
                        for (int k = 0; k < ds.length(i, j); ++k) {
                            result.putValue(i, j, k, ds.value(i, j, k));
                        }
                    }
                }
                break;
            }
            case 4: {
                result = ArrayDataSet.createRank4(c, ds.length(), ds.length(0), ds.length(0, 0), ds.length(0, 0, 0));
                for (int i = 0; i < ds.length(); ++i) {
                    for (int j = 0; j < ds.length(i); ++j) {
                        for (int k = 0; k < ds.length(i, j); ++k) {
                            for (int l = 0; l < ds.length(i, j, k); ++l) {
                                result.putValue(i, j, k, l, ds.value(i, j, k, l));
                            }
                        }
                    }
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("bad rank");
            }
        }
        result.properties.putAll(ArrayDataSet.copyProperties(ds));
        result.checkFill();
        return result;
    }

    public static ArrayDataSet copy(QDataSet ds) {
        if (ds instanceof ArrayDataSet) {
            return ArrayDataSet.ddcopy((ArrayDataSet)ds);
        }
        if (ds instanceof JoinDataSet && ds.length() > 0) {
            QDataSet ds1 = ds.slice(0);
            if (ds1 instanceof ArrayDataSet) {
                Class<?> c = ((ArrayDataSet)ds1).getBack().getClass().getComponentType();
                return ArrayDataSet.copy(c, ds);
            }
            return ArrayDataSet.copy(Double.TYPE, ds);
        }
        return ArrayDataSet.copy(Double.TYPE, ds);
    }

    protected void checkFill() {
        Number f = (Number)this.properties.get("FILL_VALUE");
        if (f != null) {
            this.fill = f.floatValue();
            this.dfill = f.doubleValue();
        } else {
            this.fill = Float.NaN;
            this.dfill = Double.NaN;
        }
    }

    public static ArrayDataSet append(ArrayDataSet ths, ArrayDataSet ds) {
        if (ds.rank() != ths.rank) {
            throw new IllegalArgumentException("rank mismatch");
        }
        if (ds.len1 != ths.len1) {
            throw new IllegalArgumentException("len1 mismatch");
        }
        if (ds.len2 != ths.len2) {
            throw new IllegalArgumentException("len2 mismatch");
        }
        if (ds.len3 != ths.len3) {
            throw new IllegalArgumentException("len3 mismatch");
        }
        if (ths.getBack().getClass() != ds.getBack().getClass()) {
            throw new IllegalArgumentException("backing type mismatch");
        }
        int myLength = ths.len0 * ths.len1 * ths.len2 * ths.len3;
        int dsLength = ds.len0 * ds.len1 * ds.len2 * ds.len3;
        Object newback = Array.newInstance(ths.getBack().getClass().getComponentType(), myLength + dsLength);
        System.arraycopy(ths.getBack(), 0, newback, 0, myLength);
        System.arraycopy(ds.getBack(), 0, newback, myLength, dsLength);
        int len0 = ths.len0 + ds.len0;
        ArrayDataSet result = ArrayDataSet.create(ths.rank, len0, ths.len1, ths.len2, ths.len3, newback);
        result.properties.putAll(ArrayDataSet.joinProperties(ths, ds));
        return result;
    }

    protected static Map joinProperties(ArrayDataSet ths, ArrayDataSet ds) {
        Boolean m;
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (int i = 0; i < ds.rank(); ++i) {
            QDataSet thatDep = (QDataSet)ds.property("DEPEND_" + i);
            if (thatDep != null && (i == 0 || thatDep.rank() > 1)) {
                QDataSet thisDep = (QDataSet)ths.property("DEPEND_" + i);
                ArrayDataSet djoin = ArrayDataSet.copy(thisDep);
                ArrayDataSet ddep1 = thatDep instanceof ArrayDataSet ? (ArrayDataSet)thatDep : ArrayDataSet.maybeCopy(thatDep);
                djoin = ArrayDataSet.append(djoin, ddep1);
                result.put("DEPEND_" + i, djoin);
                continue;
            }
            if (thatDep == null || thatDep.rank() != 1) continue;
            result.put("DEPEND_" + i, thatDep);
        }
        QDataSet dep1 = (QDataSet)ds.property("PLANE_0");
        if (dep1 != null) {
            QDataSet dep0 = (QDataSet)ths.property("PLANE_0");
            ArrayDataSet djoin = ArrayDataSet.copy(dep0);
            ArrayDataSet dd1 = ArrayDataSet.maybeCopy(dep1);
            ArrayDataSet.append(djoin, dd1);
            result.put("PLANE_0", djoin);
        }
        String[] props = DataSetUtil.dimensionProperties();
        for (int i = 0; i < props.length; ++i) {
            String prop = props[i];
            Object value = ths.property(prop);
            if (value == null || !value.equals(ds.property(prop))) continue;
            result.put(prop, ths.property(prop));
        }
        RankZeroDataSet o = (RankZeroDataSet)ths.property("CADENCE");
        if (o != null && o.equals(ds.property("CADENCE"))) {
            result.put("CADENCE", o);
        }
        if ((m = (Boolean)ths.property("MONOTONIC")) != null && m.equals(Boolean.TRUE) && m.equals(ds.property("MONOTONIC"))) {
            int[] fl1 = DataSetUtil.rangeOfMonotonic(ths);
            int[] fl2 = DataSetUtil.rangeOfMonotonic(ds);
            Units u1 = SemanticOps.getUnits(ds);
            Units u2 = SemanticOps.getUnits(ths);
            UnitsConverter uc = u2.getConverter(u1);
            if (ds.value(fl2[0]) - uc.convert(ths.value(fl1[1])) >= 0.0) {
                result.put("MONOTONIC", Boolean.TRUE);
            }
        }
        return result;
    }

    public QDataSet setUnits(Units units) {
        this.putProperty("UNITS", units);
        return this;
    }

    public String toString() {
        return DataSetUtil.toString(this);
    }

    public int jvmMemory() {
        int sizePer;
        Class component = this.getComponentType();
        if (component == Double.TYPE) {
            sizePer = 8;
        } else if (component == Float.TYPE) {
            sizePer = 4;
        } else if (component == Long.TYPE) {
            sizePer = 8;
        } else if (component == Integer.TYPE) {
            sizePer = 4;
        } else if (component == Short.TYPE) {
            sizePer = 2;
        } else if (component == Byte.TYPE) {
            sizePer = 1;
        } else {
            throw new IllegalArgumentException("not supported " + component);
        }
        return Array.getLength(this.getBack()) * sizePer;
    }
}

