/*
 * Decompiled with CFR 0.152.
 */
package org.virbo.dataset;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.IllegalFormatConversionException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.das2.datum.Datum;
import org.das2.datum.DatumRange;
import org.das2.datum.Units;
import org.das2.datum.UnitsConverter;
import org.das2.datum.UnitsUtil;
import org.das2.datum.format.DatumFormatter;
import org.das2.datum.format.DefaultDatumFormatter;
import org.das2.datum.format.FormatStringFormatter;
import org.virbo.dataset.ArrayDataSet;
import org.virbo.dataset.BDataSet;
import org.virbo.dataset.DDataSet;
import org.virbo.dataset.DRank0DataSet;
import org.virbo.dataset.DataSetOps;
import org.virbo.dataset.FDataSet;
import org.virbo.dataset.IDataSet;
import org.virbo.dataset.IndexGenDataSet;
import org.virbo.dataset.LDataSet;
import org.virbo.dataset.LengthsDataSet;
import org.virbo.dataset.MutablePropertyDataSet;
import org.virbo.dataset.QDataSet;
import org.virbo.dataset.QubeDataSetIterator;
import org.virbo.dataset.RankZeroDataSet;
import org.virbo.dataset.SDataSet;
import org.virbo.dataset.SemanticOps;
import org.virbo.dataset.WeightsDataSet;
import org.virbo.dataset.WritableDataSet;
import org.virbo.dsops.Ops;
import org.virbo.dsutil.AutoHistogram;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataSetUtil {
    public static MutablePropertyDataSet indexGenDataSet(int n) {
        return new IndexGenDataSet(n);
    }

    public static MutablePropertyDataSet tagGenDataSet(int n, final double start, final double cadence) {
        IndexGenDataSet result = new IndexGenDataSet(n){

            public double value(int i) {
                return (double)i * cadence + start;
            }
        };
        result.putProperty("CADENCE", DRank0DataSet.create(cadence));
        if (cadence < 0.0) {
            result.putProperty("MONOTONIC", Boolean.FALSE);
        }
        return result;
    }

    public static MutablePropertyDataSet tagGenDataSet(int n, final double start, final double cadence, Units units) {
        IndexGenDataSet result = new IndexGenDataSet(n){

            public double value(int i) {
                return (double)i * cadence + start;
            }
        };
        if (units != null) {
            result.putProperty("CADENCE", DRank0DataSet.create(cadence, units.getOffsetUnits()));
            result.putProperty("UNITS", units);
        } else {
            result.putProperty("CADENCE", DRank0DataSet.create(cadence));
        }
        if (cadence < 0.0) {
            result.putProperty("MONOTONIC", Boolean.FALSE);
        }
        return result;
    }

    public static MutablePropertyDataSet replicateDataSet(int n, final double value) {
        IndexGenDataSet result = new IndexGenDataSet(n){

            public double value(int i) {
                return value;
            }
        };
        return result;
    }

    public static boolean isMonotonic(QDataSet ds) {
        if (ds.rank() != 1) {
            return false;
        }
        if (ds.length() == 0) {
            return false;
        }
        if (Boolean.TRUE.equals(ds.property("MONOTONIC"))) {
            return true;
        }
        QDataSet wds = DataSetUtil.weightsDataSet(ds);
        int i = 0;
        for (i = 0; i < ds.length() && wds.value(i) == 0.0; ++i) {
        }
        if (i == ds.length()) {
            return false;
        }
        double last = ds.value(i);
        ++i;
        while (i < ds.length()) {
            double d = ds.value(i);
            double w = wds.value(i);
            if (w != 0.0) {
                if (d < last) {
                    return false;
                }
                last = d;
            }
            ++i;
        }
        return true;
    }

    public static int binarySearch(QDataSet ds, double key, int low, int high) {
        while (low <= high) {
            int cmp;
            int mid = low + high >> 1;
            double midVal = ds.value(mid);
            if (midVal < key) {
                cmp = -1;
            } else if (midVal > key) {
                cmp = 1;
            } else {
                long keyBits;
                long midBits = Double.doubleToLongBits(midVal);
                int n = midBits == (keyBits = Double.doubleToLongBits(key)) ? 0 : (cmp = midBits < keyBits ? -1 : 1);
            }
            if (cmp < 0) {
                low = mid + 1;
                continue;
            }
            if (cmp > 0) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    public static int closest(QDataSet ds, double d, int guess) {
        int result = DataSetUtil.binarySearch(ds, d, 0, ds.length() - 1);
        if (result == -1) {
            result = 0;
        } else if (result < 0) {
            double x1;
            double x0;
            double x;
            result = (result ^= 0xFFFFFFFF) >= ds.length() - 1 ? ds.length() - 1 : (((x = d) - (x0 = ds.value(result - 1))) / ((x1 = ds.value(result)) - x0) < 0.5 ? result - 1 : result);
        }
        return result;
    }

    public static Object getUserProperty(QDataSet ds, String name) {
        Map userProps = (Map)ds.property("USER_PROPERTIES");
        if (userProps == null) {
            return null;
        }
        return userProps.get(name);
    }

    public static String[] propertyNames() {
        return new String[]{"UNITS", "VALID_MIN", "VALID_MAX", "FILL_VALUE", "FORMAT", "CADENCE", "MONOTONIC", "SCALE_TYPE", "TYPICAL_MIN", "TYPICAL_MAX", "RENDER_TYPE", "QUBE", "NAME", "LABEL", "TITLE", "CACHE_TAG", "COORDINATE_FRAME", "DELTA_MINUS", "DELTA_PLUS", "WEIGHTS", "USER_PROPERTIES", "METADATA", "METADATA_MODEL"};
    }

    public static void copyDimensionProperties(QDataSet source, MutablePropertyDataSet dest) {
        String[] names;
        for (String n : names = DataSetUtil.dimensionProperties()) {
            Object p = source.property(n);
            if (p == null) continue;
            dest.putProperty(n, p);
        }
    }

    public static String[] dimensionProperties() {
        return new String[]{"UNITS", "FORMAT", "SCALE_TYPE", "TYPICAL_MIN", "TYPICAL_MAX", "VALID_MIN", "VALID_MAX", "FILL_VALUE", "NAME", "LABEL", "TITLE", "USER_PROPERTIES"};
    }

    public static String[] globalProperties() {
        return new String[]{"USER_PROPERTIES", "VERSION", "METADATA", "METADATA_MODEL", "SOURCE"};
    }

    public static boolean isInheritedProperty(String prop) {
        boolean indexProp = prop.startsWith("DEPEND_") || prop.startsWith("BUNDLE_") || prop.startsWith("BINS_") || prop.startsWith("JOIN_") || prop.startsWith("PLANE_") || prop.equals("START_INDEX") || prop.equals("RENDER_TYPE");
        return !indexProp;
    }

    public static Map<String, Object> sliceProperties(QDataSet ds, int index, Map<String, Object> result) {
        if (result == null) {
            result = new LinkedHashMap<String, Object>();
        }
        String[] names = DataSetUtil.dimensionProperties();
        for (int i = 0; i < names.length; ++i) {
            Object val = ds.property(names[i], index);
            if (val == null) continue;
            result.put(names[i], val);
        }
        return result;
    }

    public static Map<String, Object> getDimensionProperties(QDataSet ds, Map<String, Object> def) {
        return DataSetUtil.getProperties(ds, DataSetUtil.dimensionProperties(), def);
    }

    public static Map<String, Object> getProperties(QDataSet ds, String[] names, Map def) {
        def = def == null ? new LinkedHashMap<String, Object>() : new LinkedHashMap(def);
        for (int i = 0; i < names.length; ++i) {
            Object val = ds.property(names[i]);
            if (val == null) continue;
            def.put(names[i], val);
        }
        return def;
    }

    public static Map<String, Object> getProperties(QDataSet ds, Map def) {
        Object cds;
        Object plane;
        Object dep;
        int i;
        Map result = def;
        for (i = 0; i <= ds.rank(); ++i) {
            dep = ds.property("DEPEND_" + i);
            if (dep == null) continue;
            result.put("DEPEND_" + i, dep);
        }
        for (i = 0; i <= ds.rank(); ++i) {
            dep = ds.property("BUNDLE_" + i);
            if (dep == null) continue;
            result.put("BUNDLE_" + i, dep);
        }
        for (i = 0; i <= ds.rank(); ++i) {
            dep = ds.property("BINS_" + i);
            if (dep == null) continue;
            result.put("BINS_" + i, dep);
        }
        for (i = 0; i <= ds.rank(); ++i) {
            dep = ds.property("JOIN_" + i);
            if (dep == null) continue;
            result.put("JOIN_" + i, dep);
        }
        for (i = 0; i < 50 && (plane = ds.property("PLANE_" + i)) != null; ++i) {
            result.put("PLANE_" + i, plane);
        }
        for (i = 0; i < 50 && (cds = ds.property("CONTEXT_" + i)) != null; ++i) {
            result.put("CONTEXT_" + i, cds);
        }
        String[] names = DataSetUtil.propertyNames();
        for (int i2 = 0; i2 < names.length; ++i2) {
            if (ds.property(names[i2]) == null) continue;
            result.put(names[i2], ds.property(names[i2]));
        }
        return result;
    }

    public static Map<String, Object> getProperties(QDataSet ds) {
        return DataSetUtil.getProperties(ds, new LinkedHashMap());
    }

    public static void putProperties(Map<String, Object> properties, MutablePropertyDataSet ds) {
        for (Map.Entry<String, Object> e : properties.entrySet()) {
            MutablePropertyDataSet mdep;
            QDataSet dep;
            if (e.getKey().startsWith("DEPEND_") && e.getValue() instanceof Map) {
                dep = (QDataSet)ds.property(e.getKey());
                if (!(dep instanceof MutablePropertyDataSet)) continue;
                mdep = (MutablePropertyDataSet)dep;
                DataSetUtil.putProperties((Map)e.getValue(), mdep);
                continue;
            }
            if (e.getKey().startsWith("PLANE_") && e.getValue() instanceof Map) {
                dep = (QDataSet)ds.property(e.getKey());
                if (!(dep instanceof MutablePropertyDataSet)) continue;
                mdep = (MutablePropertyDataSet)dep;
                DataSetUtil.putProperties((Map)e.getValue(), mdep);
                continue;
            }
            if (e.getKey().startsWith("BUNDLE_") && e.getValue() instanceof Map) {
                dep = (QDataSet)ds.property(e.getKey());
                if (!(dep instanceof MutablePropertyDataSet)) continue;
                mdep = (MutablePropertyDataSet)dep;
                DataSetUtil.putProperties((Map)e.getValue(), mdep);
                continue;
            }
            if (e.getKey().startsWith("CONTEXT_") && e.getValue() instanceof Map) {
                dep = (QDataSet)ds.property(e.getKey());
                if (!(dep instanceof MutablePropertyDataSet)) continue;
                mdep = (MutablePropertyDataSet)dep;
                DataSetUtil.putProperties((Map)e.getValue(), mdep);
                continue;
            }
            if (e.getValue() == null) continue;
            ds.putProperty(e.getKey(), e.getValue());
        }
    }

    public static String toString(QDataSet ds) {
        int[] qubeDims;
        String name;
        if (ds == null) {
            throw new IllegalArgumentException("null dataset");
        }
        Units u = (Units)ds.property("UNITS");
        if (u == null) {
            u = Units.dimensionless;
        }
        if ((name = (String)ds.property("NAME")) == null) {
            name = "dataSet";
        }
        if (ds.rank() == 0) {
            if (name.equals("dataSet")) {
                return String.valueOf(DataSetUtil.asDatum(ds));
            }
            return name + "=" + DataSetUtil.asDatum(ds);
        }
        if (ds.rank() == 1 && "min,max".equals(ds.property("BINS_0"))) {
            DatumRange dr = new DatumRange(ds.value(0), ds.value(1), u);
            return dr.toString();
        }
        if (ds.rank() == 1 && "min,maxInclusive".equals(ds.property("BINS_0"))) {
            DatumRange dr = new DatumRange(ds.value(0), ds.value(1), u);
            return dr.toString() + "  (inclusive)";
        }
        if (ds.rank() == 2 && ds.length() == 2 && ds.length(0) == 2 && "min,maxInclusive".equals(ds.property("BINS_1"))) {
            Units u1 = (Units)ds.property("UNITS", 0);
            Units u2 = (Units)ds.property("UNITS", 1);
            DatumRange dr1 = new DatumRange(ds.value(0, 0), ds.value(0, 1), u1 == null ? Units.dimensionless : u1);
            DatumRange dr2 = new DatumRange(ds.value(1, 0), ds.value(1, 1), u2 == null ? Units.dimensionless : u2);
            return dr1.toString() + "; " + dr2.toString() + "  (inclusive)";
        }
        String qubeStr = DataSetUtil.isQube(ds) ? "" : "*";
        String[] depNames = new String[4];
        for (int i = 0; i < 4; ++i) {
            depNames[i] = "";
            Object dep0o = ds.property("DEPEND_" + i);
            if (dep0o == null) continue;
            String dname = null;
            if (dep0o instanceof QDataSet) {
                QDataSet dep0 = (QDataSet)dep0o;
                if (dep0 != null) {
                    dname = (String)dep0.property("NAME");
                }
            } else {
                dname = String.valueOf(dep0o) + "(Str)";
            }
            if (dname != null) {
                if (dname.length() > 6) {
                    dname = dname.substring(0, 6) + "...";
                }
                depNames[i] = dname + "=";
                continue;
            }
            depNames[i] = "DEPEND_" + i + "=";
        }
        if (ds.property("BINS_0") != null) {
            depNames[0] = (String)ds.property("BINS_0");
        }
        if (ds.property("BINS_1") != null) {
            depNames[1] = (String)ds.property("BINS_1");
        }
        if (ds.property("JOIN_0") != null) {
            // empty if block
        }
        if (ds.property("BUNDLE_0") != null) {
            depNames[0] = "BUNDLE_0=";
        }
        if (ds.property("BUNDLE_1") != null) {
            depNames[1] = "BUNDLE_1=";
        }
        if (DataSetUtil.isQube(ds)) {
            qubeDims = DataSetUtil.qubeDims(ds);
        } else {
            qubeDims = new int[ds.rank()];
            qubeDims[0] = ds.length();
            if (ds.rank() > 1) {
                qubeDims[1] = ds.length(0);
            }
            if (ds.rank() > 2) {
                qubeDims[2] = ds.length(0, 0);
            }
            if (ds.rank() > 3) {
                qubeDims[3] = ds.length(0, 0, 0);
            }
        }
        StringBuilder dimStr = new StringBuilder("" + depNames[0] + ds.length());
        for (int i = 1; i < ds.rank(); ++i) {
            dimStr.append(",").append(depNames[i]).append(qubeDims[i]).append(qubeStr);
        }
        String su = String.valueOf(u);
        if (su.equals("")) {
            su = "dimensionless";
        }
        return name + "[" + dimStr.toString() + "] (" + su + ")";
    }

    public static QDataSet firstValidPoint(QDataSet ds) {
        Units u = (Units)ds.property("UNITS");
        if (u == null) {
            u = Units.dimensionless;
        }
        double offset = u.getFillDouble();
        QDataSet wds = DataSetUtil.weightsDataSet(ds);
        QubeDataSetIterator iter = new QubeDataSetIterator(ds);
        while (iter.hasNext()) {
            iter.next();
            double w = iter.getValue(wds);
            if (!(w > 0.0)) continue;
            offset = iter.getValue(ds);
            break;
        }
        if (offset == u.getFillDouble()) {
            return null;
        }
        return DataSetUtil.asDataSet(offset, u);
    }

    public static QDataSet validPoints(QDataSet ds) {
        Units u = (Units)ds.property("UNITS");
        if (u == null) {
            u = Units.dimensionless;
        }
        double offset = u.getFillDouble();
        int lenmax = DataSetUtil.totalLength(ds);
        DDataSet result = DDataSet.createRank1(lenmax);
        int i = 0;
        QDataSet wds = DataSetUtil.weightsDataSet(ds);
        QubeDataSetIterator iter = new QubeDataSetIterator(ds);
        while (iter.hasNext()) {
            iter.next();
            double w = iter.getValue(wds);
            if (!(w > 0.0)) continue;
            result.putValue(i, iter.getValue(ds));
            ++i;
        }
        for (String s : DataSetUtil.propertyNames()) {
            result.putProperty(s, ds.property(s));
        }
        return result;
    }

    public static QDataSet gcd(QDataSet ds, QDataSet d, QDataSet limit) {
        while (true) {
            int lastNonZeroPeakIndex;
            QDataSet r = Ops.mod(ds, d);
            QDataSet hist = Ops.autoHistogram(r);
            QDataSet peaks = AutoHistogram.peaks(hist);
            double stop = d.property("DELTA_MINUS") != null ? ((QDataSet)d.property("DELTA_MINUS")).value() : 0.0;
            stop = Math.max(stop, DataSetUtil.value((RankZeroDataSet)limit, (Units)peaks.property("UNITS")));
            double top = d.value() - stop;
            int nonZeroPeakIndex = peaks.value(0) - stop < 0.0 ? 1 : 0;
            for (lastNonZeroPeakIndex = peaks.length() - 1; lastNonZeroPeakIndex >= 0 && peaks.value(lastNonZeroPeakIndex) > top; --lastNonZeroPeakIndex) {
            }
            if (lastNonZeroPeakIndex < nonZeroPeakIndex) break;
            d = DataSetOps.slice0(peaks, nonZeroPeakIndex);
        }
        return d;
    }

    public static QDataSet gcd(QDataSet ds, QDataSet limit) {
        QDataSet ds1 = DataSetUtil.validPoints(ds);
        if (ds1.length() == 0) {
            throw new IllegalArgumentException("no valid points");
        }
        if (ds1.length() == 1) {
            return DataSetOps.slice0(ds, 0);
        }
        MutablePropertyDataSet guess = DataSetOps.slice0(ds, 1);
        return DataSetUtil.gcd(ds, guess, limit);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static RankZeroDataSet guessCadenceNew(QDataSet xds, QDataSet yds) {
        int i;
        boolean log;
        Units xunits;
        int peakv;
        QDataSet hist;
        block42: {
            double mean;
            int t;
            int linMedian;
            int linHighestPeak;
            int ipeak;
            int everIncreasingLimit;
            AutoHistogram ah;
            double everIncreasing;
            block41: {
                long total;
                QDataSet r;
                double sp;
                Object o = xds.property("CADENCE");
                Units u = (Units)xds.property("UNITS");
                if (UnitsUtil.isNominalMeasurement((Units)u)) {
                    return null;
                }
                if (o != null) {
                    if (o instanceof RankZeroDataSet) {
                        return (RankZeroDataSet)o;
                    }
                    return DataSetUtil.asDataSet(((Number)o).doubleValue(), u.getOffsetUnits());
                }
                if (yds == null) {
                    yds = DataSetUtil.replicateDataSet(xds.length(), 1.0);
                }
                assert (xds.length() == yds.length());
                if (yds.rank() > 1) {
                    yds = DataSetUtil.replicateDataSet(xds.length(), 1.0);
                }
                if (xds.length() < 2) {
                    return null;
                }
                QDataSet wds = DataSetUtil.weightsDataSet(xds);
                int monoDecreasing = 0;
                int monoIncreasing = 0;
                int count = 0;
                boolean xHasFill = false;
                int repeatValues = 0;
                double last = Double.NaN;
                for (int i2 = 0; i2 < xds.length(); ++i2) {
                    if (wds.value(i2) == 0.0) {
                        xHasFill = true;
                        continue;
                    }
                    if (Double.isNaN(last)) {
                        last = xds.value(i2);
                        continue;
                    }
                    ++count;
                    sp = xds.value(i2) - last;
                    if (sp < 0.0) {
                        ++monoDecreasing;
                        continue;
                    }
                    if (sp > 0.0) {
                        ++monoIncreasing;
                        continue;
                    }
                    ++repeatValues;
                }
                double monoMag = repeatValues + monoIncreasing > 9 * count / 10 ? 1.0 : (repeatValues + monoDecreasing > 9 * count / 10 ? -1.0 : 0.0);
                if (xHasFill && monoMag == 0.0) {
                    return null;
                }
                if (monoMag == 0.0) {
                    return null;
                }
                everIncreasing = 0.0;
                if (xds.length() > 2) {
                    sp = monoMag * (xds.value(2) - xds.value(0));
                    everIncreasing = xds.value(2) / xds.value(0);
                    double sp0 = sp;
                    if (xds.value(2) <= 0.0 || xds.value(0) <= 0.0 || xds.value(1) > xds.value(0) + xds.value(2)) {
                        everIncreasing = 0.0;
                    }
                    for (int i3 = 3; everIncreasing > 0.0 && i3 < xds.length(); ++i3) {
                        if (wds.value(i3) == 0.0 || wds.value(i3 - 2) == 0.0) continue;
                        if (xds.value(i3) <= 0.0 || xds.value(i3 - 2) <= 0.0) {
                            everIncreasing = 0.0;
                            continue;
                        }
                        double sp1 = monoMag * (xds.value(i3) - xds.value(i3 - 2));
                        if (sp1 > sp0 * 1.00001) {
                            everIncreasing = xds.value(i3) / xds.value(0);
                            sp0 = sp1;
                            continue;
                        }
                        everIncreasing = 0.0;
                    }
                }
                if (everIncreasing > 0.0 && monoMag == -1.0) {
                    everIncreasing = 1.0 / everIncreasing;
                }
                boolean logScaleType = "log".equals(xds.property("SCALE_TYPE"));
                QDataSet extent = Ops.extent(xds);
                ah = new AutoHistogram();
                QDataSet diffs = yds.rank() == 1 && xds.rank() == 1 ? ((r = Ops.where(Ops.valid(yds))).length() < 2 ? Ops.diff(xds) : Ops.diff(DataSetOps.applyIndex(xds, 0, r, false))) : Ops.diff(xds);
                if (monoDecreasing > 9 * count / 10) {
                    diffs = Ops.multiply(diffs, DataSetUtil.asDataSet(-1.0));
                }
                if ((total = ((Long)((Map)(hist = ah.doit(diffs)).property("USER_PROPERTIES")).get("total")).longValue()) == 0L) {
                    return null;
                }
                everIncreasingLimit = total < 10L ? 25 : 100;
                ipeak = 0;
                peakv = (int)hist.value(0);
                linHighestPeak = 0;
                linMedian = -1;
                t = 0;
                mean = AutoHistogram.mean(hist).value();
                int imean = AutoHistogram.binOf(hist, mean);
                for (int i4 = 0; i4 < hist.length(); ++i4) {
                    t = (int)((double)t + hist.value(i4));
                    if (hist.value(i4) > (double)peakv) {
                        ipeak = i4;
                        peakv = (int)hist.value(i4);
                    }
                    if (hist.value(i4) > (double)peakv / 10.0) {
                        linHighestPeak = i4;
                    }
                    if (linMedian != -1 || (long)t <= total / 2L) continue;
                    linMedian = i4;
                }
                int linLowestPeak = 0;
                for (int i5 = 0; i5 < hist.length(); ++i5) {
                    if (!(hist.value(i5) > (double)peakv / 10.0)) continue;
                    linLowestPeak = i5;
                    break;
                }
                if ((xunits = (Units)xds.property("UNITS")) == null) {
                    xunits = Units.dimensionless;
                }
                log = false;
                double firstBin = ((Number)((Map)hist.property("USER_PROPERTIES")).get("binStart")).doubleValue();
                double binWidth = ((Number)((Map)hist.property("USER_PROPERTIES")).get("binWidth")).doubleValue();
                if (UnitsUtil.isRatioMeasurement((Units)xunits) && (logScaleType || everIncreasing > (double)everIncreasingLimit || ipeak == 0 && extent.value(0) - Math.abs(mean) < 0.0 && (total < 10L || (firstBin -= binWidth) <= 0.0))) break block41;
                if (peakv < 20) {
                    ipeak = linHighestPeak;
                    peakv = (int)hist.value(ipeak);
                    break block42;
                } else if (ipeak < linHighestPeak && hist.value(linHighestPeak) > Math.max(Math.ceil(hist.value(linLowestPeak) / 10.0), 1.0)) {
                    ipeak = linHighestPeak;
                    peakv = (int)hist.value(ipeak);
                }
                break block42;
            }
            ah = new AutoHistogram();
            QDataSet loghist = ah.doit(Ops.diff(Ops.log(xds)), DataSetUtil.weightsDataSet(yds));
            long ltotal = (Long)((Map)loghist.property("USER_PROPERTIES")).get("total");
            int logPeak = 0;
            int logPeakv = (int)loghist.value(0);
            int logMedian = -1;
            int logHighestPeak = 0;
            t = 0;
            mean = AutoHistogram.mean(loghist).value();
            int lmean = AutoHistogram.binOf(loghist, mean);
            for (int i6 = 0; i6 < loghist.length(); ++i6) {
                t = (int)((double)t + loghist.value(i6));
                if (loghist.value(i6) > (double)logPeakv) {
                    logPeak = i6;
                    logPeakv = (int)loghist.value(i6);
                }
                if (loghist.value(i6) > (double)logPeakv / 100.0) {
                    logHighestPeak = i6;
                }
                if (logMedian != -1 || (long)t <= ltotal / 2L) continue;
                logMedian = i6;
            }
            int logLowestPeak = 0;
            for (int i7 = 0; i7 < hist.length(); ++i7) {
                if (!(loghist.value(i7) > (double)logPeakv / 10.0)) continue;
                logLowestPeak = i7;
                break;
            }
            int highestPeak = linHighestPeak;
            if (everIncreasing > (double)everIncreasingLimit || logPeak > 1 && 1.0 * (double)logMedian / (double)loghist.length() > 1.0 * (double)linMedian / (double)hist.length()) {
                hist = loghist;
                ipeak = logPeak;
                peakv = logPeakv;
                highestPeak = logHighestPeak;
                log = true;
            }
            if (peakv < 20) {
                ipeak = highestPeak;
                peakv = (int)hist.value(ipeak);
            } else if (ipeak >= logHighestPeak) {
                // empty if block
            }
        }
        double ss = 0.0;
        double nn = 0.0;
        QDataSet sss = (QDataSet)hist.property("PLANE_0");
        for (i = ipeak; i >= 0 && hist.value(i) > (double)(peakv / 4); ss += sss.value(i) * hist.value(i), nn += hist.value(i), --i) {
        }
        for (i = ipeak + 1; i < hist.length() && hist.value(i) > (double)(peakv / 4); ss += sss.value(i) * hist.value(i), nn += hist.value(i), ++i) {
        }
        if (log) {
            DRank0DataSet result = DRank0DataSet.create(ss / nn);
            result.putProperty("UNITS", Units.logERatio);
            result.putProperty("SCALE_TYPE", "log");
            return result;
        }
        DRank0DataSet result = DRank0DataSet.create(ss / nn);
        result.putProperty("UNITS", xunits.getOffsetUnits());
        return result;
    }

    public static Double guessCadence(QDataSet xds, QDataSet yds) {
        int i;
        Units u;
        RankZeroDataSet d = (RankZeroDataSet)xds.property("CADENCE");
        if (d != null) {
            if ("log".equals(xds.property("SCALE_TYPE"))) {
                return DataSetUtil.asDatum(d).doubleValue(Units.logERatio);
            }
            return d.value();
        }
        if (yds == null) {
            yds = DataSetUtil.replicateDataSet(xds.length(), 1.0);
        }
        assert (xds.length() == yds.length());
        if (yds.rank() > 1) {
            yds = DataSetUtil.replicateDataSet(xds.length(), 1.0);
        }
        if ((u = (Units)yds.property("UNITS")) == null) {
            u = Units.dimensionless;
        }
        double cadence = Double.MAX_VALUE;
        if (xds.length() < 2) {
            return cadence;
        }
        double cadenceSMax = 0.0;
        int cadenceNMax = 1;
        double cadenceSMin = Double.MAX_VALUE;
        int cadenceNMin = 1;
        double x0 = 0.0;
        for (i = 0; i < xds.length() && !u.isValid(yds.value(i)); ++i) {
        }
        if (i >= yds.length()) {
            return Double.MAX_VALUE;
        }
        x0 = xds.value(i);
        boolean log = "log".equals(xds.property("SCALE_TYPE"));
        ++i;
        while (i < xds.length() && i < 10000000) {
            if (u.isValid(yds.value(i))) {
                double cadenceAvgMin = cadenceSMin / (double)cadenceNMin;
                double cadenceAvgMax = cadenceSMax / (double)cadenceNMax;
                cadence = log ? Math.abs(Math.log(xds.value(i) / x0)) : Math.abs(xds.value(i) - x0);
                if (cadence < 0.5 * cadenceAvgMin && cadenceNMin < 10) {
                    cadenceSMin = cadence;
                    cadenceNMin = 1;
                    cadenceAvgMin = cadence;
                } else if (cadence > 0.5 * cadenceAvgMin && cadence < 1.5 * cadenceAvgMin) {
                    cadenceSMin += cadence;
                    ++cadenceNMin;
                }
                if (cadence > 1.5 * cadenceAvgMax && cadenceNMax < 10 && cadence < 100.0 * cadenceAvgMin) {
                    cadenceSMax = cadence;
                    cadenceNMax = 1;
                } else if (cadence > 0.5 * cadenceAvgMax && cadence < 1.5 * cadenceAvgMax) {
                    cadenceSMax += cadence;
                    ++cadenceNMax;
                }
                x0 = xds.value(i);
            }
            ++i;
        }
        double avgMin = cadenceSMin / (double)cadenceNMin;
        double avgMax = cadenceSMax / (double)cadenceNMax;
        QDataSet hist = Ops.histogram(Ops.diff(xds), 0.0, avgMin * 10.0, avgMin * 10.0 / 99.0);
        int maxPeak = -1;
        int minPeak = -1;
        int peakHeight = Math.max(1, xds.length() / 100);
        for (i = 0; i < hist.length(); ++i) {
            if (!(hist.value(i) >= (double)peakHeight)) continue;
            if (minPeak == -1) {
                minPeak = i;
            }
            maxPeak = i;
            peakHeight = (int)hist.value(i);
        }
        if (maxPeak > minPeak) {
            return avgMax * 2.0;
        }
        return avgMin;
    }

    public static Double guessCadence(QDataSet xds) {
        return DataSetUtil.guessCadence(xds, null);
    }

    public static boolean isQube(QDataSet ds) {
        if (ds.rank() <= 1) {
            return true;
        }
        Boolean q = (Boolean)ds.property("QUBE");
        if (q == null || q.equals(Boolean.FALSE)) {
            QDataSet dep1 = (QDataSet)ds.property("DEPEND_1");
            return ds.rank() == 2 && dep1 != null && dep1.rank() == 1;
        }
        return true;
    }

    public static int[] qubeDims(QDataSet ds) {
        Boolean q;
        if (ds.rank() > 4) {
            throw new IllegalArgumentException("rank limit");
        }
        if (ds.rank() == 2) {
            QDataSet dep1 = (QDataSet)ds.property("DEPEND_1");
            if (dep1 != null && dep1.rank() == 1) {
                return new int[]{ds.length(), dep1.length()};
            }
        } else {
            if (ds.rank() == 1) {
                return new int[]{ds.length()};
            }
            if (ds.rank() == 0) {
                return new int[0];
            }
        }
        if ((q = (Boolean)ds.property("QUBE")) == null || q.equals(Boolean.FALSE)) {
            return null;
        }
        int[] qube = new int[ds.rank()];
        qube[0] = ds.length();
        if (ds.rank() > 1) {
            qube[1] = ds.length(0);
            if (ds.rank() > 2) {
                qube[2] = ds.length(0, 0);
                if (ds.rank() > 3) {
                    qube[3] = ds.length(0, 0, 0);
                    if (ds.rank() > 4) {
                        throw new IllegalArgumentException("rank limit");
                    }
                }
            }
        }
        return qube;
    }

    public static int product(int[] qube) {
        switch (qube.length) {
            case 0: {
                return 1;
            }
            case 1: {
                return qube[0];
            }
            case 2: {
                return qube[0] * qube[1];
            }
            case 3: {
                return qube[0] * qube[1] * qube[2];
            }
            case 4: {
                return qube[0] * qube[1] * qube[2] * qube[3];
            }
        }
        throw new IllegalArgumentException("qube is too long");
    }

    public static void addQube(MutablePropertyDataSet ds) throws IllegalArgumentException {
        int[] qube = null;
        switch (ds.rank()) {
            case 0: {
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                qube = new int[]{ds.length(), ds.length(0)};
                if (ds.length() <= 0) break;
                for (int i = 1; i < ds.length(); ++i) {
                    if (ds.length(i) == ds.length(0)) continue;
                    throw new IllegalArgumentException("dataset is not a qube");
                }
                break;
            }
            case 3: {
                qube = new int[]{ds.length(), ds.length(0), ds.length(0, 0)};
                if (ds.length() <= 0 || ds.length(0) <= 0) break;
                for (int i = 1; i < ds.length(); ++i) {
                    if (ds.length(i) != ds.length(0)) {
                        throw new IllegalArgumentException("dataset is not a qube");
                    }
                    for (int j = 1; j < ds.length(0); ++j) {
                        if (ds.length(i, j) == ds.length(0, 0)) continue;
                        throw new IllegalArgumentException("dataset is not a qube");
                    }
                }
                break;
            }
            case 4: {
                qube = new int[]{ds.length(), ds.length(0), ds.length(0, 0), ds.length(0, 0, 0)};
                if (ds.length() <= 0 || ds.length(0) <= 0 || ds.length(0, 0) <= 0) break;
                for (int i = 1; i < ds.length(); ++i) {
                    if (ds.length(i) != ds.length(0)) {
                        throw new IllegalArgumentException("dataset is not a qube");
                    }
                    for (int j = 1; j < ds.length(0); ++j) {
                        if (ds.length(i, j) != ds.length(0, 0)) {
                            throw new IllegalArgumentException("dataset is not a qube");
                        }
                        for (int k = 1; k < ds.length(0, 0); ++k) {
                            if (ds.length(i, j, k) == ds.length(0, 0, 0)) continue;
                            throw new IllegalArgumentException("dataset is not a qube");
                        }
                    }
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("rank not supported");
            }
        }
        if (qube != null) {
            ds.putProperty("QUBE", Boolean.TRUE);
        }
    }

    public static String format(QDataSet ds) {
        return DataSetUtil.format(ds, true);
    }

    public static String format(QDataSet ds, boolean showContext) {
        int i;
        if (ds.property("BUNDLE_0") != null) {
            StringBuilder result = new StringBuilder();
            for (int i2 = 0; i2 < ds.length(); ++i2) {
                MutablePropertyDataSet cds = DataSetOps.slice0(ds, i2);
                result.append(DataSetUtil.format(cds));
                if (i2 >= ds.length() - 1) continue;
                result.append(", ");
            }
            return result.toString();
        }
        if ("min,max".equals(ds.property("BINS_0")) && ds.rank() == 1) {
            StringBuilder result = new StringBuilder();
            Units u = (Units)ds.property("UNITS");
            if (u == null) {
                u = Units.dimensionless;
            }
            result.append(new DatumRange(ds.value(0), ds.value(1), u).toString());
            String[] ss = ((String)ds.property("BINS_0")).split(",", -2);
            if (ss.length != ds.length()) {
                throw new IllegalArgumentException("bins count != length in ds");
            }
            return result.toString();
        }
        if ("min,maxInclusive".equals(ds.property("BINS_0")) && ds.rank() == 1) {
            StringBuilder result = new StringBuilder();
            Units u = (Units)ds.property("UNITS");
            if (u == null) {
                u = Units.dimensionless;
            }
            result.append(new DatumRange(ds.value(0), ds.value(1), u).toString());
            result.append("(inclusive)");
            String[] ss = ((String)ds.property("BINS_0")).split(",", -2);
            if (ss.length != ds.length()) {
                throw new IllegalArgumentException("bins count != length in ds");
            }
            return result.toString();
        }
        if (ds.property("BINS_0") != null && ds.rank() == 1) {
            String[] ss;
            StringBuilder result = new StringBuilder();
            Units u = (Units)ds.property("UNITS");
            if (u == null) {
                u = Units.dimensionless;
            }
            if ((ss = ((String)ds.property("BINS_0")).split(",", -2)).length != ds.length()) {
                throw new IllegalArgumentException("bins count != length in ds");
            }
            for (int i3 = 0; i3 < ds.length(); ++i3) {
                result.append(ss[i3]).append("=").append(u.createDatum(ds.value(i3)));
                if (i3 >= ds.length() - 1) continue;
                result.append(", ");
            }
            if (ds.property("SCALE_TYPE") != null) {
                result.append("SCALE_TYPE=").append(ds.property("SCALE_TYPE"));
            }
            return result.toString();
        }
        if (ds.rank() == 0) {
            QDataSet context0;
            String name = (String)ds.property("NAME");
            Units u = (Units)ds.property("UNITS");
            String format = (String)ds.property("FORMAT");
            StringBuilder result = new StringBuilder();
            if (name != null) {
                result.append(name).append("=");
            }
            if (format != null) {
                if (u != null) {
                    if (UnitsUtil.isTimeLocation((Units)u)) {
                        double millis = u.convertDoubleTo((Units)Units.t1970, ds.value());
                        Calendar cal = Calendar.getInstance();
                        cal.setTimeInMillis((long)millis);
                        result.append(String.format(Locale.US, format, cal));
                    } else {
                        result.append(String.format(Locale.US, format, ds.value()));
                        if (u != Units.dimensionless) {
                            result.append(" ").append(u.toString());
                        }
                    }
                } else {
                    result.append(String.format(Locale.US, format, ds.value()));
                }
            } else if (u != null) {
                result.append(u.createDatum(ds.value()).toString());
            } else {
                result.append(ds.value());
            }
            if (showContext && (context0 = (QDataSet)ds.property("CONTEXT_0")) != null) {
                result.append(" @ ").append(DataSetUtil.format(context0));
            }
            return result.toString();
        }
        StringBuilder buf = new StringBuilder(ds.toString() + ":\n");
        if (ds.rank() == 1) {
            for (i = 0; i < Math.min(40, ds.length()); ++i) {
                buf.append(" ").append(ds.value(i));
            }
            if (ds.length() >= 40) {
                buf.append(" ...");
            }
        }
        if (ds.rank() == 2) {
            for (i = 0; i < Math.min(10, ds.length()); ++i) {
                for (int j = 0; j < Math.min(20, ds.length(i)); ++j) {
                    buf.append(" ").append(ds.value(i, j));
                }
                if (ds.length() >= 40) {
                    buf.append(" ...");
                }
                buf.append("\n");
            }
            if (ds.length() >= 10) {
                buf.append(" ... ... ... \n");
            }
        }
        return buf.toString();
    }

    public static String statsString(QDataSet ds) {
        RankZeroDataSet stats = DataSetOps.moment(ds);
        return "" + stats.value() + "+/-" + stats.property("stddev") + " N=" + stats.property("validCount");
    }

    public static boolean validate(QDataSet ds, List<String> problems) {
        if (problems == null) {
            problems = new ArrayList<String>();
        }
        return DataSetUtil.validate(ds, problems, 0);
    }

    public static boolean validate(QDataSet xds, QDataSet yds, List<String> problems) {
        if (xds.length() != yds.length()) {
            if (problems == null) {
                problems = new ArrayList<String>();
            }
            problems.add(String.format("DEPEND_%d length is %d, should be %d.", 0, xds.length(), yds.length()));
            return false;
        }
        return DataSetUtil.validate(Ops.link(xds, yds), problems, 0);
    }

    public static boolean validate(QDataSet xds, QDataSet yds, QDataSet zds, List<String> problems) {
        if (xds.length() != yds.length()) {
            if (problems == null) {
                problems = new ArrayList<String>();
            }
            problems.add(String.format("DEPEND_%d length is %d, should be %d.", 0, xds.length(), yds.length()));
            return false;
        }
        return DataSetUtil.validate(Ops.link(xds, yds, zds), problems, 0);
    }

    public static int totalLength(QDataSet ds) {
        if (ds.rank() == 0) {
            return 1;
        }
        int[] qube = DataSetUtil.qubeDims(ds);
        qube = null;
        if (qube == null) {
            LengthsDataSet lds = new LengthsDataSet(ds);
            QubeDataSetIterator it = new QubeDataSetIterator(lds);
            int total = 0;
            while (it.hasNext()) {
                it.next();
                total = (int)((double)total + it.getValue(lds));
            }
            return total;
        }
        int total = qube[0];
        for (int i = 1; i < qube.length; ++i) {
            total *= qube[i];
        }
        return total;
    }

    private static boolean validate(QDataSet ds, List<String> problems, int dimOffset) {
        QDataSet plane0;
        QDataSet bds;
        QDataSet dep;
        if (problems == null) {
            problems = new ArrayList<String>();
        }
        if ((dep = (QDataSet)ds.property("DEPEND_0")) != null) {
            if (dep.length() != ds.length()) {
                problems.add(String.format("DEPEND_%d length is %d while data length is %d.", dimOffset, dep.length(), ds.length()));
            }
            if (ds.rank() > 1 && ds.length() > 0) {
                QDataSet dep1 = (QDataSet)ds.property("DEPEND_1");
                if (dep1 != null && dep1.rank() > 1 && dep1.length() != ds.length()) {
                    problems.add(String.format("rank 2 DEPEND_1 length is %d while data length is %d.", dep1.length(), ds.length()));
                }
                DataSetUtil.validate((QDataSet)DataSetOps.slice0(ds, 0), problems, dimOffset + 1);
            }
        }
        if (ds.property("JOIN_0") != null) {
            if (dimOffset > 0) {
                problems.add("JOIN_0 must only be on zeroth dimension: " + dimOffset);
            } else {
                Units u = null;
                boolean onceNotify = false;
                for (int i = 0; i < ds.length(); ++i) {
                    MutablePropertyDataSet ds1 = DataSetOps.slice0(ds, i);
                    if (!DataSetUtil.validate((QDataSet)ds1, problems, dimOffset + 1)) {
                        problems.add("join(" + i + ") not valid JOINED dataset.");
                    }
                    if (u == null) {
                        u = SemanticOps.getUnits(ds1);
                        continue;
                    }
                    if (u == SemanticOps.getUnits(ds1) || onceNotify) continue;
                    problems.add("units change in joined datasets");
                    onceNotify = true;
                }
            }
        }
        if ((bds = (QDataSet)ds.property("BUNDLE_1")) != null) {
            for (int i = 0; i < bds.length(); ++i) {
                QDataSet bds1 = DataSetOps.unbundle(ds, i, true);
                Object o = bds1.property("DEPEND_1");
                if (o == null || o instanceof QDataSet) continue;
                DataSetUtil.validate(bds1, problems, 1);
            }
        }
        if ((plane0 = (QDataSet)ds.property("PLANE_0")) != null && plane0.rank() > 0 && plane0.length() != ds.length()) {
            problems.add(String.format("PLANE_0 length is %d, should be %d", plane0.length(), ds.length()));
        }
        return problems.isEmpty();
    }

    public static void makeValid(MutablePropertyDataSet ds) {
        int[] qubeDims = null;
        if (DataSetUtil.isQube(ds)) {
            qubeDims = DataSetUtil.qubeDims(ds);
        }
        int i = 0;
        QDataSet dep = (QDataSet)ds.property("DEPEND_" + i);
        if (dep != null && dep.length() != ds.length()) {
            ds.putProperty("DEPEND_" + i, null);
        }
        if (qubeDims != null) {
            for (i = 1; i < qubeDims.length; ++i) {
                dep = (QDataSet)ds.property("DEPEND_" + i);
                if (dep == null || dep.length() == qubeDims[i]) continue;
                ds.putProperty("DEPEND_" + i, null);
            }
        }
    }

    public static QDataSet weightsDataSet(QDataSet ds) {
        QDataSet result = (QDataSet)ds.property("WEIGHTS");
        if (result == null) {
            boolean check;
            Number validMax;
            Number validMin = (Number)ds.property("VALID_MIN");
            if (validMin == null) {
                validMin = Double.NEGATIVE_INFINITY;
            }
            if ((validMax = (Number)ds.property("VALID_MAX")) == null) {
                validMax = Double.POSITIVE_INFINITY;
            }
            Units u = (Units)ds.property("UNITS");
            Number ofill = (Number)ds.property("FILL_VALUE");
            double fill = ofill == null ? Double.NaN : ofill.doubleValue();
            boolean bl = check = validMin.doubleValue() > -1.7976931348623157E308 || validMax.doubleValue() < Double.MAX_VALUE || !Double.isNaN(fill);
            result = check ? new WeightsDataSet.ValidRangeFillFinite(ds) : (u != null ? new WeightsDataSet.FillFinite(ds) : new WeightsDataSet.Finite(ds));
        }
        return result;
    }

    public static WritableDataSet canonizeFill(QDataSet ds) {
        if (!(ds instanceof WritableDataSet)) {
            ds = DDataSet.copy(ds);
        }
        WritableDataSet wrds = (WritableDataSet)ds;
        QubeDataSetIterator it = new QubeDataSetIterator(ds);
        QDataSet wds = DataSetUtil.weightsDataSet(ds);
        double fill = -1.0E31;
        while (it.hasNext()) {
            it.next();
            if (it.getValue(wds) != 0.0) continue;
            it.putValue(wrds, fill);
        }
        wrds.putProperty("FILL_VALUE", fill);
        return wrds;
    }

    public static QDataSet convertTo(QDataSet ds, Units u) {
        Number fill;
        Number vmax;
        Units su = (Units)ds.property("UNITS");
        if (su == null) {
            su = Units.dimensionless;
        }
        UnitsConverter uc = su.getConverter(u);
        DDataSet result = (DDataSet)ArrayDataSet.copy(ds);
        QubeDataSetIterator it = new QubeDataSetIterator(ds);
        while (it.hasNext()) {
            it.next();
            it.putValue(result, uc.convert(it.getValue(ds)));
        }
        Number vmin = (Number)ds.property("VALID_MIN");
        if (vmin != null) {
            result.putProperty("VALID_MIN", uc.convert(vmin));
        }
        if ((vmax = (Number)ds.property("VALID_MAX")) != null) {
            result.putProperty("VALID_MAX", uc.convert(vmax));
        }
        if ((fill = (Number)ds.property("FILL_VALUE")) != null) {
            result.putProperty("FILL_VALUE", uc.convert(fill));
        }
        result.putProperty("UNITS", u);
        return result;
    }

    public static double value(RankZeroDataSet ds, Units tu) {
        Units u = (Units)ds.property("UNITS");
        if (tu == null && u == null) {
            return ds.value();
        }
        return u.convertDoubleTo(tu, ds.value());
    }

    public static Datum asDatum(RankZeroDataSet ds) {
        return DataSetUtil.asDatum((QDataSet)ds);
    }

    public static Datum asDatum(QDataSet ds) {
        if (ds.rank() > 0) {
            throw new IllegalArgumentException("dataset is not rank 0");
        }
        Units u = (Units)ds.property("UNITS");
        String format = (String)ds.property("FORMAT");
        if (u == null) {
            u = Units.dimensionless;
        }
        if (format == null) {
            return Datum.create((double)ds.value(), (Units)u);
        }
        return Datum.create((double)ds.value(), (Units)u, (DatumFormatter)new FormatStringFormatter(format, true));
    }

    public static DatumRange asDatumRange(QDataSet ds, boolean sloppy) {
        Units u = SemanticOps.getUnits(ds);
        if (!sloppy && !ds.property("BINS_0").equals("min,max")) {
            throw new IllegalArgumentException("expected min,max for BINS_0 because we are not allowing sloppy.");
        }
        return new DatumRange(ds.value(0), ds.value(1), u);
    }

    public static QDataSet asDataSet(DatumRange dr) {
        DDataSet result = DDataSet.createRank1(2);
        Units u = dr.getUnits();
        result.putValue(0, dr.min().doubleValue(u));
        result.putValue(1, dr.max().doubleValue(u));
        result.putProperty("UNITS", u);
        result.putProperty("BINS_0", "min,max");
        return result;
    }

    public static DRank0DataSet asDataSet(double d, Units u) {
        return DRank0DataSet.create(d, u);
    }

    public static DRank0DataSet asDataSet(double d) {
        return DRank0DataSet.create(d);
    }

    public static DRank0DataSet asDataSet(Datum d) {
        return DRank0DataSet.create(d);
    }

    public static double[] asArrayOfDoubles(QDataSet d) {
        if (d.rank() != 1) {
            throw new IllegalArgumentException("only rank 1 supported");
        }
        DDataSet ds = (DDataSet)ArrayDataSet.maybeCopy(DDataSet.class, d);
        double[] back = ds.back;
        double[] result = new double[d.length()];
        System.arraycopy(back, 0, result, 0, d.length());
        return result;
    }

    public static double[][] as2DArrayOfDoubles(QDataSet d) {
        double[][] result;
        if (d.rank() == 2) {
            DDataSet ds = (DDataSet)ArrayDataSet.maybeCopy(DDataSet.class, d);
            double[] back = ds.back;
            int l1 = d.length(0);
            result = new double[d.length()][l1];
            for (int i = 0; i < ds.length(); ++i) {
                System.arraycopy(back, i * l1, result[i], 0, l1);
            }
        } else {
            throw new IllegalArgumentException("only rank 2 supported");
        }
        return result;
    }

    private static void flatten(double[][] data, double[] back, int offset, int nx, int ny) {
        for (int i = 0; i < nx; ++i) {
            double[] dd = data[i];
            System.arraycopy(dd, 0, back, offset + i * ny, ny);
        }
    }

    private static void flatten(float[][] data, float[] back, int offset, int nx, int ny) {
        for (int i = 0; i < nx; ++i) {
            float[] dd = data[i];
            System.arraycopy(dd, 0, back, offset + i * ny, ny);
        }
    }

    private static void flatten(long[][] data, long[] back, int offset, int nx, int ny) {
        for (int i = 0; i < nx; ++i) {
            long[] dd = data[i];
            System.arraycopy(dd, 0, back, offset + i * ny, ny);
        }
    }

    private static void flatten(int[][] data, int[] back, int offset, int nx, int ny) {
        for (int i = 0; i < nx; ++i) {
            int[] dd = data[i];
            System.arraycopy(dd, 0, back, offset + i * ny, ny);
        }
    }

    private static void flatten(short[][] data, short[] back, int offset, int nx, int ny) {
        for (int i = 0; i < nx; ++i) {
            short[] dd = data[i];
            System.arraycopy(dd, 0, back, offset + i * ny, ny);
        }
    }

    private static void flatten(byte[][] data, byte[] back, int offset, int nx, int ny) {
        for (int i = 0; i < nx; ++i) {
            byte[] dd = data[i];
            System.arraycopy(dd, 0, back, offset + i * ny, ny);
        }
    }

    public static QDataSet asDataSet(Object arr) {
        if (arr.getClass().isArray()) {
            Class<?> c = arr.getClass().getComponentType();
            if (c.isArray()) {
                if ((c = c.getComponentType()).isArray()) {
                    throw new IllegalArgumentException("3-D arrays not supported");
                }
                int ny = Array.getLength(Array.get(arr, 0));
                int nx = Array.getLength(arr);
                if (c == Double.TYPE) {
                    double[] dd = new double[nx * ny];
                    DataSetUtil.flatten((double[][])arr, dd, 0, nx, ny);
                    return DDataSet.wrap(dd, nx, ny);
                }
                if (c == Float.TYPE) {
                    float[] dd = new float[nx * ny];
                    DataSetUtil.flatten((float[][])arr, dd, 0, nx, ny);
                    return FDataSet.wrap(dd, nx, ny);
                }
                if (c == Long.TYPE) {
                    long[] dd = new long[nx * ny];
                    DataSetUtil.flatten((long[][])arr, dd, 0, nx, ny);
                    return LDataSet.wrap(dd, nx, ny);
                }
                if (c == Integer.TYPE) {
                    int[] dd = new int[nx * ny];
                    DataSetUtil.flatten((int[][])arr, dd, 0, nx, ny);
                    return IDataSet.wrap(dd, nx, ny);
                }
                if (c == Short.TYPE) {
                    short[] dd = new short[nx * ny];
                    DataSetUtil.flatten((short[][])arr, dd, 0, nx, ny);
                    return SDataSet.wrap(dd, nx, ny);
                }
                if (c == Byte.TYPE) {
                    byte[] dd = new byte[nx * ny];
                    DataSetUtil.flatten((byte[][])arr, dd, 0, nx, ny);
                    return BDataSet.wrap(dd, nx, ny);
                }
                throw new IllegalArgumentException("Array component type not supported: " + c);
            }
            if (c == Double.TYPE) {
                return DDataSet.wrap((double[])arr);
            }
            if (c == Float.TYPE) {
                return FDataSet.wrap((float[])arr);
            }
            if (c == Long.TYPE) {
                return LDataSet.wrap((long[])arr);
            }
            if (c == Integer.TYPE) {
                return IDataSet.wrap((int[])arr);
            }
            if (c == Short.TYPE) {
                return SDataSet.wrap((short[])arr);
            }
            if (c == Byte.TYPE) {
                return BDataSet.wrap((byte[])arr);
            }
            throw new IllegalArgumentException("unsupported type: " + arr.getClass());
        }
        if (arr instanceof QDataSet) {
            return (QDataSet)arr;
        }
        if (arr instanceof Datum) {
            return DataSetUtil.asDataSet((Datum)arr);
        }
        if (arr.getClass().isPrimitive()) {
            return DataSetUtil.asDataSet((Double)arr);
        }
        throw new IllegalArgumentException("unsupported type: " + arr.getClass());
    }

    public static QDataSet asDataSet(Object x, Object y) {
        QDataSet xds = DataSetUtil.asDataSet(x);
        QDataSet yds = DataSetUtil.asDataSet(y);
        return Ops.link(xds, yds);
    }

    public static QDataSet asDataSet(Object x, Object y, Object z) {
        QDataSet xds = DataSetUtil.asDataSet(x);
        QDataSet yds = DataSetUtil.asDataSet(y);
        QDataSet zds = DataSetUtil.asDataSet(z);
        return Ops.link(xds, yds, zds);
    }

    public static void addContext(MutablePropertyDataSet ds, QDataSet cds) {
        int idx = 0;
        while (ds.property("CONTEXT_" + idx) != null) {
            ++idx;
        }
        ds.putProperty("CONTEXT_" + idx, cds);
    }

    public static void addContext(Map<String, Object> props, QDataSet cds) {
        int idx = 0;
        while (props.get("CONTEXT_" + idx) != null) {
            ++idx;
        }
        props.put("CONTEXT_" + idx, cds);
    }

    public static String contextAsString(QDataSet ds) {
        StringBuilder result = new StringBuilder();
        QDataSet cds = (QDataSet)ds.property("CONTEXT_0");
        int idx = 0;
        while (cds != null) {
            if (cds.rank() > 0) {
                if (cds.rank() == 1 && cds.property("BINS_0") != null) {
                    result.append(DataSetUtil.format(cds, false));
                } else {
                    QDataSet extent = Ops.extent(cds);
                    if (extent.value(1) == extent.value(0)) {
                        result.append(DataSetUtil.format(cds.slice(0), false));
                    } else {
                        result.append(DataSetUtil.format(extent, false)).append(" ").append(cds.length()).append(" different values");
                    }
                }
            } else {
                result.append(DataSetUtil.format(cds, false));
            }
            if ((cds = (QDataSet)ds.property("CONTEXT_" + ++idx)) == null) continue;
            result.append(", ");
        }
        return result.toString();
    }

    public static int[] rangeOfMonotonic(QDataSet ds) {
        if (ds.rank() != 1) {
            throw new IllegalArgumentException("must be rank 1");
        }
        if (DataSetUtil.isMonotonic(ds)) {
            int lastValid;
            int firstValid;
            QDataSet wds = DataSetUtil.weightsDataSet(ds);
            for (firstValid = 0; firstValid < wds.length() && wds.value(firstValid) == 0.0; ++firstValid) {
            }
            if (firstValid == wds.length()) {
                throw new IllegalArgumentException("data contains no valid measurements");
            }
            for (lastValid = wds.length() - 1; lastValid >= 0 && wds.value(lastValid) == 0.0; --lastValid) {
            }
            if (lastValid - firstValid + 1 == 0) {
                throw new IllegalArgumentException("special case where monotonic dataset contains no valid data");
            }
            return new int[]{firstValid, lastValid};
        }
        throw new IllegalArgumentException("expected monotonic dataset");
    }

    public static int xTagBinarySearch(QDataSet ds, Datum datum, int low, int high) {
        Units units = datum.getUnits();
        Units toUnits = SemanticOps.getUnits(ds);
        UnitsConverter uc = units.getConverter(toUnits);
        double key = datum.doubleValue(toUnits);
        while (low <= high) {
            int cmp;
            int mid = low + high >> 1;
            double midVal = ds.value(mid);
            if (midVal < key) {
                cmp = -1;
            } else if (midVal > key) {
                cmp = 1;
            } else {
                long keyBits;
                long midBits = Double.doubleToLongBits(midVal);
                int n = midBits == (keyBits = Double.doubleToLongBits(key)) ? 0 : (cmp = midBits < keyBits ? -1 : 1);
            }
            if (cmp < 0) {
                low = mid + 1;
                continue;
            }
            if (cmp > 0) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    public static int closestIndex(QDataSet ds, Datum datum) {
        if (!DataSetUtil.isMonotonic(ds)) {
            System.err.println("dataset is not monotonic");
            DataSetUtil.isMonotonic(ds);
            throw new IllegalArgumentException("dataset is not monotonic");
        }
        int result = DataSetUtil.xTagBinarySearch(ds, datum, 0, ds.length() - 1);
        double ddatum = datum.doubleValue(SemanticOps.getUnits(ds));
        if (result == -1) {
            result = 0;
        } else if (result < 0) {
            double x1;
            double x0;
            double x;
            result = (result ^= 0xFFFFFFFF) >= ds.length() - 1 ? ds.length() - 1 : (((x = ddatum) - (x0 = ds.value(result - 1))) / ((x1 = ds.value(result)) - x0) < 0.5 ? result - 1 : result);
        }
        return result;
    }

    public static int closestIndex(QDataSet table, double x, Units units) {
        return DataSetUtil.closestIndex(table, units.createDatum(x));
    }

    public static int getPreviousIndex(QDataSet ds, Datum datum) {
        int i = DataSetUtil.closestIndex(ds, datum);
        Units dsUnits = SemanticOps.getUnits(ds);
        if (i > 0 && ds.value(i) >= datum.doubleValue(dsUnits)) {
            return i - 1;
        }
        return i;
    }

    public static int getNextIndex(QDataSet ds, Datum datum) {
        int i = DataSetUtil.closestIndex(ds, datum);
        Units dsUnits = SemanticOps.getUnits(ds);
        if (i < ds.length() - 1 && ds.value(i) <= datum.doubleValue(dsUnits)) {
            return i + 1;
        }
        return i;
    }

    public static String getStringValue(QDataSet yds, double value) {
        String s;
        block8: {
            Units u = SemanticOps.getUnits(yds);
            String form = (String)yds.property("FORMAT");
            if (!u.isValid(value)) {
                return "fill (" + value + ")";
            }
            Datum d = u.createDatum(value);
            DatumFormatter df = d.getFormatter();
            if (df instanceof DefaultDatumFormatter) {
                if (form == null) {
                    s = "log".equals(yds.property("SCALE_TYPE")) ? String.format(Locale.US, "%9.3e", value).trim() : String.format(Locale.US, "%9.3f", value).trim();
                } else {
                    try {
                        s = String.format(Locale.US, form, value);
                    }
                    catch (IllegalFormatConversionException ex) {
                        char c = ex.getConversion();
                        if (c == 'X' || c == 'x' || c == 'd' || c == 'o' || c == 'c' || c == 'C') {
                            s = String.format(Locale.US, form, (long)value);
                            break block8;
                        }
                        s = df.format(d);
                    }
                }
            } else {
                s = df.format(d, u);
            }
        }
        return s;
    }
}

