/*
 * Decompiled with CFR 0.152.
 */
package org.virbo.dataset;

import java.util.HashMap;
import java.util.Map;
import org.virbo.dataset.ArrayDataSet;
import org.virbo.dataset.DDataSet;
import org.virbo.dataset.DataSetOps;
import org.virbo.dataset.DataSetUtil;
import org.virbo.dataset.FDataSet;
import org.virbo.dataset.QDataSet;
import org.virbo.dataset.WritableDataSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class IDataSet
extends ArrayDataSet {
    int[] back;
    public static final String version = "20070529";

    public static IDataSet createRank1(int len0) {
        return new IDataSet(1, len0, 1, 1, 1);
    }

    public static IDataSet createRank2(int len0, int len1) {
        return new IDataSet(2, len0, len1, 1, 1);
    }

    public static IDataSet createRank3(int len0, int len1, int len2) {
        return new IDataSet(3, len0, len1, len2, 1);
    }

    public static IDataSet createRank4(int len0, int len1, int len2, int len3) {
        return new IDataSet(4, len0, len1, len2, len3);
    }

    public static IDataSet wrap(int[] data, int[] qube) {
        if (qube.length == 1) {
            return new IDataSet(1, qube[0], 1, 1, 1, data);
        }
        if (qube.length == 2) {
            return new IDataSet(2, qube[0], qube[1], 1, 1, data);
        }
        if (qube.length == 3) {
            return new IDataSet(3, qube[0], qube[1], qube[2], 1, data);
        }
        if (qube.length == 4) {
            return new IDataSet(3, qube[0], qube[1], qube[2], qube[3], data);
        }
        throw new IllegalArgumentException("bad qube");
    }

    public static IDataSet wrap(int[] back, int rank, int len0, int len1, int len2) {
        return new IDataSet(rank, len0, len1, len2, 1, back);
    }

    protected IDataSet(int rank, int len0, int len1, int len2, int len3) {
        this(rank, len0, len1, len2, len3, new int[len0 * len1 * len2 * len3]);
    }

    protected IDataSet(int rank, int len0, int len1, int len2, int len3, int[] back) {
        this.back = back;
        this.rank = rank;
        this.len0 = len0;
        this.len1 = len1;
        this.len2 = len2;
        this.len3 = len3;
        if (rank > 1) {
            this.putProperty("QUBE", Boolean.TRUE);
        }
    }

    @Override
    protected Object getBack() {
        return this.back;
    }

    @Override
    protected void setBack(Object back) {
        this.back = (int[])back;
    }

    @Override
    public double value() {
        return this.back[0];
    }

    @Override
    public double value(int i0) {
        return this.back[i0];
    }

    @Override
    public double value(int i0, int i1) {
        return this.back[i0 * this.len1 + i1];
    }

    @Override
    public double value(int i0, int i1, int i2) {
        return this.back[i0 * this.len1 * this.len2 + i1 * this.len2 + i2];
    }

    @Override
    public double value(int i0, int i1, int i2, int i3) {
        return this.back[i0 * this.len1 * this.len2 * this.len3 + i1 * this.len2 * this.len3 + i2 * this.len3 + i3];
    }

    @Override
    public void putValue(double value) {
        this.back[0] = (int)value;
    }

    @Override
    public void putValue(int i0, double value) {
        this.back[i0] = (int)value;
    }

    @Override
    public void putValue(int i0, int i1, double value) {
        this.back[i0 * this.len1 + i1] = (int)value;
    }

    @Override
    public void putValue(int i0, int i1, int i2, double value) {
        this.back[i0 * this.len1 * this.len2 + i1 * this.len2 + i2] = (int)value;
    }

    @Override
    public void putValue(int i0, int i1, int i2, int i3, double value) {
        this.back[i0 * this.len1 * this.len2 * this.len3 + i1 * this.len2 * this.len3 + i2 * this.len3 + i3] = (int)value;
    }

    @Override
    public void putLength(int len) {
        if (len > this.len0) {
            throw new IllegalArgumentException("dataset cannot be lengthened");
        }
        this.len0 = len;
    }

    @Override
    public String toString() {
        return DataSetUtil.toString(this);
    }

    private static Map copyProperties(QDataSet ds) {
        QDataSet plane0;
        int i;
        HashMap<String, Object> result = new HashMap<String, Object>();
        Map<String, Object> srcProps = DataSetUtil.getProperties(ds);
        result.putAll(srcProps);
        for (i = 0; i < ds.rank(); ++i) {
            QDataSet dep = (QDataSet)ds.property("DEPEND_" + i);
            if (dep == ds) {
                throw new IllegalArgumentException("dataset is dependent on itsself!");
            }
            if (dep == null) continue;
            if (dep instanceof FDataSet) {
                result.put("DEPEND_" + i, FDataSet.copy(dep));
                continue;
            }
            if (dep instanceof DDataSet) {
                result.put("DEPEND_" + i, DDataSet.copy(dep));
                continue;
            }
            result.put("DEPEND_" + i, IDataSet.copy(dep));
        }
        for (i = 0; i < 50 && (plane0 = (QDataSet)ds.property("PLANE_" + i)) != null; ++i) {
            result.put("PLANE_" + i, IDataSet.copy(plane0));
        }
        return result;
    }

    private static IDataSet ddcopy(IDataSet ds) {
        int dsLength = ds.len0 * ds.len1 * ds.len2 * ds.len3;
        int[] newback = new int[dsLength];
        System.arraycopy(ds.back, 0, newback, 0, dsLength);
        IDataSet result = new IDataSet(ds.rank, ds.len0, ds.len1, ds.len2, ds.len3, newback);
        result.properties.putAll(IDataSet.copyProperties(ds));
        return result;
    }

    public static IDataSet copy(QDataSet ds) {
        IDataSet result;
        if (ds instanceof IDataSet) {
            return IDataSet.ddcopy((IDataSet)ds);
        }
        int rank = ds.rank();
        switch (rank) {
            case 1: {
                result = IDataSet.createRank1(ds.length());
                for (int i = 0; i < ds.length(); ++i) {
                    result.putValue(i, ds.value(i));
                }
                break;
            }
            case 2: {
                result = IDataSet.createRank2(ds.length(), ds.length(0));
                for (int i = 0; i < ds.length(); ++i) {
                    for (int j = 0; j < ds.length(i); ++j) {
                        result.putValue(i, j, ds.value(i, j));
                    }
                }
                break;
            }
            case 3: {
                result = IDataSet.createRank3(ds.length(), ds.length(0), ds.length(0, 0));
                for (int i = 0; i < ds.length(); ++i) {
                    for (int j = 0; j < ds.length(i); ++j) {
                        for (int k = 0; k < ds.length(i, j); ++k) {
                            result.putValue(i, j, k, ds.value(i, j, k));
                        }
                    }
                }
                break;
            }
            case 4: {
                result = IDataSet.createRank4(ds.length(), ds.length(0), ds.length(0, 0), ds.length(0, 0, 0));
                for (int i = 0; i < ds.length(); ++i) {
                    for (int j = 0; j < ds.length(i); ++j) {
                        for (int k = 0; k < ds.length(i, j); ++k) {
                            for (int l = 0; l < ds.length(i, j, k); ++l) {
                                result.putValue(i, j, k, l, ds.value(i, j, k, l));
                            }
                        }
                    }
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("bad rank");
            }
        }
        result.properties.putAll(IDataSet.copyProperties(ds));
        return result;
    }

    public static IDataSet wrap(int[] back) {
        return new IDataSet(1, back.length, 1, 1, 1, back);
    }

    public static IDataSet wrap(int[] back, int nx, int ny) {
        return new IDataSet(2, nx, ny, 1, 1, back);
    }

    public static IDataSet wrap(int[] back, int nx, int ny, int nz) {
        return new IDataSet(3, nx, ny, nz, 1, back);
    }

    private void joinProperties(IDataSet ds) {
        HashMap<String, IDataSet> result = new HashMap<String, IDataSet>();
        for (int i = 0; i < ds.rank(); ++i) {
            QDataSet dep1 = (QDataSet)ds.property("DEPEND_" + i);
            if (dep1 == null) continue;
            QDataSet dep0 = (QDataSet)this.property("DEPEND_" + i);
            IDataSet djoin = IDataSet.copy(dep0);
            IDataSet ddep1 = dep1 instanceof IDataSet ? (IDataSet)dep1 : IDataSet.copy(dep1);
            djoin.join(ddep1);
            result.put("DEPEND_" + i, djoin);
        }
        QDataSet dep1 = (QDataSet)ds.property("PLANE_0");
        if (dep1 != null) {
            QDataSet dep0 = (QDataSet)this.property("PLANE_0");
            IDataSet djoin = IDataSet.copy(dep0);
            IDataSet dd1 = dep1 instanceof IDataSet ? (IDataSet)dep1 : IDataSet.copy(dep1);
            djoin.join(dd1);
            result.put("PLANE_0", djoin);
        }
        this.properties.putAll(result);
    }

    public void join(IDataSet ds) {
        this.append(ds);
    }

    public void append(IDataSet ds) {
        if (ds.rank() != this.rank) {
            throw new IllegalArgumentException("rank mismatch");
        }
        if (ds.len1 != this.len1) {
            throw new IllegalArgumentException("len1 mismatch");
        }
        if (ds.len2 != this.len2) {
            throw new IllegalArgumentException("len2 mismatch");
        }
        if (ds.len3 != this.len3) {
            throw new IllegalArgumentException("len3 mismatch");
        }
        int myLength = this.len0 * this.len1 * this.len2 * this.len3;
        int dsLength = ds.len0 * ds.len1 * ds.len2 * ds.len3;
        int[] newback = new int[myLength + dsLength];
        System.arraycopy(this.back, 0, newback, 0, myLength);
        System.arraycopy(ds.back, 0, newback, myLength, dsLength);
        this.len0 += ds.len0;
        this.back = newback;
        this.joinProperties(ds);
    }

    @Override
    public QDataSet slice(int i) {
        int nrank = this.rank - 1;
        int noff1 = i * this.len1 * this.len2 * this.len3;
        int noff2 = (i + 1) * this.len1 * this.len2 * this.len3;
        int[] newback = new int[noff2 - noff1];
        System.arraycopy(this.back, noff1, newback, 0, noff2 - noff1);
        Map<String, Object> props = DataSetOps.sliceProperties0(i, DataSetUtil.getProperties(this));
        props = DataSetUtil.sliceProperties(this, i, props);
        IDataSet result = new IDataSet(nrank, this.len1, this.len2, this.len3, 1, newback);
        DataSetUtil.putProperties(props, result);
        return result;
    }

    @Override
    public QDataSet trim(int start, int end) {
        int nrank = this.rank;
        int noff1 = start * this.len1 * this.len2 * this.len3;
        int noff2 = end * this.len1 * this.len2 * this.len3;
        int[] newback = new int[noff2 - noff1];
        System.arraycopy(this.back, noff1, newback, 0, noff2 - noff1);
        IDataSet result = new IDataSet(nrank, end - start, this.len1, this.len2, this.len3, newback);
        Map<String, Object> props = DataSetUtil.getProperties(this);
        props.remove("DEPEND_0");
        DataSetUtil.putProperties(props, result);
        QDataSet dep0 = (QDataSet)this.property("DEPEND_0");
        if (dep0 != null) {
            result.putProperty("DEPEND_0", dep0.trim(start, end));
        }
        return result;
    }

    @Override
    public <T> T capability(Class<T> clazz) {
        if (clazz == WritableDataSet.class) {
            return (T)this;
        }
        return super.capability(clazz);
    }
}

