/*
 * Decompiled with CFR 0.152.
 */
package org.virbo.dataset;

import java.text.ParseException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.das2.datum.Basis;
import org.das2.datum.Datum;
import org.das2.datum.DatumRange;
import org.das2.datum.EnumerationUnits;
import org.das2.datum.NumberUnits;
import org.das2.datum.TimeLocationUnits;
import org.das2.datum.TimeUtil;
import org.das2.datum.Units;
import org.das2.datum.UnitsConverter;
import org.virbo.dataset.DataSetOps;
import org.virbo.dataset.DataSetUtil;
import org.virbo.dataset.IndexGenDataSet;
import org.virbo.dataset.JoinDataSet;
import org.virbo.dataset.QDataSet;
import org.virbo.dataset.RankZeroDataSet;
import org.virbo.dataset.SubsetDataSet;
import org.virbo.dsops.Ops;

public class SemanticOps {
    public static final Units getUnits(QDataSet ds) {
        Units u = (Units)ds.property("UNITS");
        if (u == null && SemanticOps.isJoin(ds)) {
            u = (Units)ds.slice(0).property("UNITS");
        }
        return u == null ? Units.dimensionless : u;
    }

    public static final UnitsConverter getUnitsConverter(QDataSet src, QDataSet dst) {
        Units usrc = SemanticOps.getUnits(src);
        Units udst = SemanticOps.getUnits(dst);
        return usrc.getConverter(udst);
    }

    public static final String[] getComponentLabels(QDataSet ds) {
        int n = ds.length(0);
        QDataSet bdesc = (QDataSet)ds.property("BUNDLE_1");
        if (bdesc != null && bdesc.rank() == 2) {
            String[] result = new String[n];
            for (int i = 0; i < n; ++i) {
                result[i] = (String)bdesc.property("NAME", i);
                if (result[i] != null) continue;
                result[i] = "ch_" + i;
            }
            return result;
        }
        QDataSet labels = bdesc != null && bdesc.rank() == 1 ? bdesc : (QDataSet)ds.property("DEPEND_1");
        if (labels == null) {
            String[] result = new String[n];
            for (int i = 0; i < n; ++i) {
                result[i] = "ch_" + i;
            }
            return result;
        }
        Units u = SemanticOps.getUnits(labels);
        String[] slabels = new String[n];
        for (int i = 0; i < n; ++i) {
            slabels[i] = labels == null ? String.valueOf(i) : String.valueOf(u.createDatum(labels.value(i)));
        }
        return slabels;
    }

    public static synchronized Units lookupUnits(String sunits) {
        Units stdUnit;
        Units result;
        sunits = sunits.trim();
        try {
            result = Units.getByName((String)sunits);
        }
        catch (IllegalArgumentException ex) {
            if (sunits.contains(" since ")) {
                try {
                    result = SemanticOps.lookupTimeUnits(sunits);
                }
                catch (ParseException ex1) {
                    result = new NumberUnits(sunits);
                }
            }
            if (sunits.equals("sec")) {
                result = Units.seconds;
            }
            if (sunits.equals("msec")) {
                result = Units.milliseconds;
            }
            if (sunits.contains("(All Qs)")) {
                result = new NumberUnits(sunits);
                Units targetUnits = SemanticOps.lookupUnits(sunits.replace("(All Qs)", "").trim());
                result.registerConverter(targetUnits, UnitsConverter.IDENTITY);
            }
            Pattern multPattern = Pattern.compile("([.0-9]+)\\s*([a-zA-Z]+)");
            Matcher m = multPattern.matcher(sunits);
            if (m.matches()) {
                try {
                    Units convTo = SemanticOps.lookupUnits(m.group(2));
                    if (convTo != null) {
                        double fact = Double.parseDouble(m.group(1));
                        result = new NumberUnits(sunits);
                        result.registerConverter(convTo, (UnitsConverter)new UnitsConverter.ScaleOffset(fact, 0.0));
                    }
                    result = SemanticOps.lookupUnits(sunits);
                }
                catch (NumberFormatException ex2) {
                    result = SemanticOps.lookupUnits(sunits);
                }
            }
            result = new NumberUnits(sunits);
        }
        String stdunits = sunits;
        if (stdunits.startsWith("[") && stdunits.endsWith("]")) {
            stdunits = stdunits.substring(1, stdunits.length() - 1);
        }
        if (stdunits.startsWith("(") && stdunits.endsWith(")")) {
            stdunits = stdunits.substring(1, stdunits.length() - 1);
        }
        if (!stdunits.equals(sunits) && !(stdUnit = SemanticOps.lookupUnits(stdunits)).isConvertableTo(result)) {
            System.err.println("registering identity converter " + stdUnit + " -> " + result);
            stdUnit.registerConverter(result, UnitsConverter.IDENTITY);
            stdUnit.getConverter(result);
        }
        return result;
    }

    public static Units lookupTimeLengthUnit(String s) throws ParseException {
        if ((s = s.toLowerCase().trim()).startsWith("sec") || s.equals("s")) {
            return Units.seconds;
        }
        if (s.startsWith("ms") || s.startsWith("millisec")) {
            return Units.milliseconds;
        }
        if (s.equals("hr") || s.startsWith("hour")) {
            return Units.hours;
        }
        if (s.equals("mn") || s.startsWith("min")) {
            return Units.minutes;
        }
        if (s.startsWith("us") || s.startsWith("\u00b5s") || s.startsWith("micros")) {
            return Units.microseconds;
        }
        if (s.startsWith("ns") || s.startsWith("nanos")) {
            return Units.nanoseconds;
        }
        if (s.startsWith("d")) {
            return Units.days;
        }
        throw new ParseException("failed to identify unit: " + s, 0);
    }

    public static synchronized Units lookupTimeUnits(String units) throws ParseException {
        try {
            Units result = Units.getByName((String)units);
            return result;
        }
        catch (IllegalArgumentException ex) {
            String[] ss = units.split("since");
            Units offsetUnits = SemanticOps.lookupTimeLengthUnit(ss[0]);
            if (ss[1].equals(" 1-1-1 00:00:00")) {
                ss[1] = "1901-01-01 00:00:00";
            }
            if (ss[1].contains("1970-01-01 00:00:00.0 0:00")) {
                ss[1] = "1970-01-01 00:00:00";
            }
            if (ss[1].endsWith(" UTC")) {
                ss[1] = ss[1].substring(0, ss[1].length() - 4);
            }
            Datum datum = TimeUtil.create((String)ss[1]);
            String canonicalName = "" + offsetUnits + " since " + datum;
            try {
                Units result = Units.getByName((String)canonicalName);
                return result;
            }
            catch (IllegalArgumentException ex2) {
                Basis basis = new Basis("since " + datum, "since " + datum, Basis.since2000, datum.doubleValue((Units)Units.us2000), Units.us2000.getOffsetUnits());
                TimeLocationUnits result = new TimeLocationUnits(canonicalName, canonicalName, offsetUnits, basis);
                result.registerConverter((Units)Units.us2000, (UnitsConverter)new UnitsConverter.ScaleOffset(offsetUnits.convertDoubleTo(Units.microseconds, 1.0), datum.doubleValue((Units)Units.us2000)));
                return result;
            }
        }
    }

    public static boolean isRank1Bundle(QDataSet ds) {
        if (ds.rank() != 1) {
            return false;
        }
        if (ds.property("BUNDLE_0") != null) {
            return true;
        }
        QDataSet dep = (QDataSet)ds.property("DEPEND_0");
        if (dep == null) {
            return false;
        }
        Units depu = SemanticOps.getUnits(dep);
        return depu instanceof EnumerationUnits;
    }

    public static boolean isBundle(QDataSet ds) {
        return ds.rank() == 2 && ds.property("BUNDLE_1") != null;
    }

    public static boolean isLegacyBundle(QDataSet zds) {
        Units u;
        QDataSet dep1;
        return zds.rank() == 2 && (dep1 = (QDataSet)zds.property("DEPEND_1")) != null && (u = (Units)dep1.property("UNITS")) instanceof EnumerationUnits;
    }

    public static boolean isBins(QDataSet ds) {
        String binsProp = (String)ds.property("BINS_" + (ds.rank() - 1));
        boolean bins = binsProp != null && ("min,max".equals(binsProp) || "min,maxInclusive".equals(binsProp));
        return bins;
    }

    public static boolean isMonotonic(QDataSet ds) {
        return DataSetUtil.isMonotonic(ds);
    }

    public static boolean isJoin(QDataSet ds) {
        return ds.rank() > 1 && ds.property("JOIN_0") != null;
    }

    public static QDataSet getPlanarView(QDataSet ds, String name) {
        if (ds.property("PLANE_0") == null) {
            return null;
        }
        if (name.equals("")) {
            throw new IllegalArgumentException("empty name");
        }
        if (name.charAt(0) == 'P' && Pattern.matches("PLANE_(\\d|\\d\\d)", name)) {
            return (QDataSet)ds.property(name);
        }
        for (int i = 0; i < 50; ++i) {
            QDataSet plane = (QDataSet)ds.property("PLANE_" + i);
            if (plane == null) {
                return null;
            }
            String tname = (String)plane.property("NAME");
            if (tname == null) {
                System.err.println("unnamed plane in " + ds);
                continue;
            }
            if (!name.equals(tname)) continue;
            return plane;
        }
        return null;
    }

    public static QDataSet weightsDataSet(QDataSet ds) {
        return DataSetUtil.weightsDataSet(ds);
    }

    public static Datum guessXTagWidth(QDataSet ds, QDataSet yds) {
        RankZeroDataSet cadence = DataSetUtil.guessCadenceNew(ds, yds);
        return cadence == null ? null : DataSetUtil.asDatum(cadence);
    }

    public static QDataSet xtagsDataSet(QDataSet ds) {
        QDataSet dep0 = (QDataSet)ds.property("DEPEND_0");
        if (dep0 != null) {
            return dep0;
        }
        if (SemanticOps.isBundle(ds)) {
            return DataSetOps.unbundle(ds, 0);
        }
        if (SemanticOps.isLegacyBundle(ds)) {
            return DataSetOps.unbundle(ds, 0);
        }
        if (SemanticOps.isJoin(ds)) {
            QDataSet xds = SemanticOps.xtagsDataSet(ds.slice(0));
            JoinDataSet result = new JoinDataSet(xds);
            for (int i = 1; i < ds.length(); ++i) {
                result.join(SemanticOps.xtagsDataSet(ds.slice(i)));
            }
            return result;
        }
        return new IndexGenDataSet(ds.length());
    }

    public static QDataSet ytagsDataSet(QDataSet ds) {
        QDataSet dep1 = (QDataSet)ds.property("DEPEND_1");
        if (dep1 != null) {
            if (SemanticOps.getUnits(dep1) instanceof EnumerationUnits) {
                if (dep1.length() == 1) {
                    return DataSetOps.slice1(ds, 0);
                }
                return DataSetOps.slice1(ds, 1);
            }
            return dep1;
        }
        if (SemanticOps.isBundle(ds)) {
            return DataSetOps.unbundle(ds, 1);
        }
        if (SemanticOps.isLegacyBundle(ds)) {
            return DataSetOps.unbundle(ds, 1);
        }
        if (SemanticOps.isJoin(ds)) {
            QDataSet yds = SemanticOps.ytagsDataSet(ds.slice(0));
            JoinDataSet result = new JoinDataSet(yds);
            for (int i = 1; i < ds.length(); ++i) {
                result.join(SemanticOps.ytagsDataSet(ds.slice(i)));
            }
            return result;
        }
        if (ds.length() > 0 && ds.property("DEPEND_1") == null && ds.property("DEPEND_0", 0) != null) {
            QDataSet yds = SemanticOps.xtagsDataSet(ds.slice(0));
            JoinDataSet result = new JoinDataSet(yds);
            for (int i = 1; i < ds.length(); ++i) {
                result.join(SemanticOps.xtagsDataSet(ds.slice(i)));
            }
            result.putProperty("UNITS", yds.slice(0).property("UNITS"));
            return result;
        }
        QDataSet result = (QDataSet)ds.property("DEPEND_1");
        if (result == null) {
            return new IndexGenDataSet(ds.length(0));
        }
        return result;
    }

    public static QDataSet getSimpleTableContaining(QDataSet tds, Datum x, Datum y) {
        if (tds.rank() == 2) {
            return tds;
        }
        for (int i = 0; i < tds.length(); ++i) {
            QDataSet tds1 = tds.slice(i);
            QDataSet bounds = SemanticOps.bounds(tds1);
            Units xunits = SemanticOps.getUnits(SemanticOps.xtagsDataSet(tds1));
            Units yunits = SemanticOps.getUnits(SemanticOps.ytagsDataSet(tds1));
            if (yunits instanceof EnumerationUnits) {
                return DataSetOps.slice2(tds, 0);
            }
            if (!(bounds.value(0, 0) <= x.doubleValue(xunits)) || !(x.doubleValue(xunits) < bounds.value(0, 1)) || !(bounds.value(1, 0) <= y.doubleValue(yunits)) || !(y.doubleValue(yunits) < bounds.value(1, 1))) continue;
            return tds1;
        }
        return null;
    }

    public static QDataSet getDependentDataSet(QDataSet ds) {
        if (!SemanticOps.isTableDataSet(ds)) {
            QDataSet vds = ds.rank() == 2 && SemanticOps.isBundle(ds) ? DataSetOps.unbundleDefaultDataSet(ds) : ds;
            return vds;
        }
        return ds;
    }

    public static QDataSet bounds(QDataSet ds) {
        QDataSet yrange;
        QDataSet xrange;
        if (ds.rank() == 2) {
            if (ds.property("BUNDLE_1") != null) {
                throw new IllegalArgumentException("scheme not supported: " + ds);
            }
            xrange = Ops.extent(SemanticOps.xtagsDataSet(ds), null);
            yrange = Ops.extent(SemanticOps.ytagsDataSet(ds), null);
        } else if (ds.rank() == 3) {
            QDataSet ds1 = ds.slice(0);
            xrange = Ops.extent(SemanticOps.xtagsDataSet(ds1), null);
            yrange = Ops.extent(SemanticOps.ytagsDataSet(ds1), null);
            for (int i = 1; i < ds.length(); ++i) {
                ds1 = ds.slice(i);
                xrange = Ops.extent(SemanticOps.xtagsDataSet(ds1), xrange);
                yrange = Ops.extent(SemanticOps.ytagsDataSet(ds1), yrange);
            }
        } else if (ds.rank() == 1) {
            if (ds.property("BUNDLE_0") != null) {
                throw new IllegalArgumentException("scheme not supported: " + ds);
            }
            xrange = Ops.extent(SemanticOps.xtagsDataSet(ds), null);
            yrange = Ops.extent(SemanticOps.ytagsDataSet(ds), null);
        } else {
            throw new IllegalArgumentException("scheme not supported: " + ds);
        }
        JoinDataSet jds = (JoinDataSet)Ops.join(xrange, yrange);
        jds.putProperty("BINS_1", "min,maxInclusive");
        return jds;
    }

    public static boolean isTableDataSet(QDataSet ds) {
        return ds.rank() == 3 || SemanticOps.isSimpleTableDataSet(ds);
    }

    public static boolean isSimpleTableDataSet(QDataSet ds) {
        QDataSet dep1 = (QDataSet)ds.property("DEPEND_1");
        return ds.rank() == 2 && (dep1 != null || !Ops.isBundle(ds)) && !Ops.isLegacyBundle(ds);
    }

    public static boolean isSimpleBundleDataSet(QDataSet ds) {
        return ds.rank() == 2 && ds.property("BUNDLE_1") != null;
    }

    public static Datum getDatum(QDataSet ds, double d) {
        Units u = SemanticOps.getUnits(ds);
        Double vmin = (Double)ds.property("VALID_MIN");
        Double vmax = (Double)ds.property("VALID_MAX");
        Double fill = (Double)ds.property("FILL_VALUE");
        if (vmin != null && vmin > d) {
            return u.getFillDatum();
        }
        if (vmax != null && vmax < d) {
            return u.getFillDatum();
        }
        if (fill != null && fill == d) {
            return u.getFillDatum();
        }
        return u.createDatum(d);
    }

    public static QDataSet trim(QDataSet ds, DatumRange xrange, DatumRange yrange) {
        int rank = ds.rank();
        if (ds.rank() == 0) {
            return ds;
        }
        if (xrange == null && yrange == null) {
            return ds;
        }
        if (rank == 3 && SemanticOps.isJoin(ds)) {
            JoinDataSet jds = new JoinDataSet(ds.rank());
            for (int i = 0; i < ds.length(); ++i) {
                jds.join(SemanticOps.trim(ds.slice(i), xrange, yrange));
            }
            DataSetUtil.putProperties(DataSetUtil.getProperties(ds), jds);
            return jds;
        }
        if (rank == 2) {
            if (SemanticOps.isBundle(ds)) {
                QDataSet yinside;
                QDataSet xds = SemanticOps.xtagsDataSet(ds);
                QDataSet yds = SemanticOps.getDependentDataSet(ds);
                QDataSet xinside = xrange == null ? null : Ops.and(Ops.ge(xds, DataSetUtil.asDataSet(xrange.min())), Ops.le(xds, DataSetUtil.asDataSet(xrange.max())));
                QDataSet qDataSet = yinside = yrange == null ? null : Ops.and(Ops.ge(yds, DataSetUtil.asDataSet(yrange.min())), Ops.le(yds, DataSetUtil.asDataSet(yrange.max())));
                QDataSet ok = xrange == null ? Ops.where(yinside) : (yrange == null ? Ops.where(xinside) : Ops.where(Ops.and(xinside, yinside)));
                SubsetDataSet sds = new SubsetDataSet(ds);
                sds.applyIndex(1, ok);
                return sds;
            }
            QDataSet xds = SemanticOps.xtagsDataSet(ds);
            QDataSet yds = SemanticOps.ytagsDataSet(ds);
            QDataSet xinside = xrange == null ? null : Ops.and(Ops.ge(xds, DataSetUtil.asDataSet(xrange.min())), Ops.le(xds, DataSetUtil.asDataSet(xrange.max())));
            QDataSet yinside = yrange == null ? null : Ops.and(Ops.ge(yds, DataSetUtil.asDataSet(yrange.min())), Ops.le(yds, DataSetUtil.asDataSet(yrange.max())));
            SubsetDataSet sds = new SubsetDataSet(ds);
            if (xinside != null) {
                sds.applyIndex(0, Ops.where(xinside));
            }
            if (yinside != null) {
                sds.applyIndex(1, Ops.where(yinside));
            }
            return sds;
        }
        if (rank == 1) {
            QDataSet yinside;
            QDataSet xds = SemanticOps.xtagsDataSet(ds);
            QDataSet yds = SemanticOps.getDependentDataSet(ds);
            QDataSet xinside = xrange == null ? null : Ops.and(Ops.ge(xds, DataSetUtil.asDataSet(xrange.min())), Ops.le(xds, DataSetUtil.asDataSet(xrange.max())));
            QDataSet qDataSet = yinside = yrange == null ? null : Ops.and(Ops.ge(yds, DataSetUtil.asDataSet(yrange.min())), Ops.le(yds, DataSetUtil.asDataSet(yrange.max())));
            QDataSet ok = xrange == null ? Ops.where(yinside) : (yrange == null ? Ops.where(xinside) : Ops.where(Ops.and(xinside, yinside)));
            SubsetDataSet sds = new SubsetDataSet(ds);
            sds.applyIndex(0, ok);
            return sds;
        }
        throw new IllegalArgumentException("not supported: " + ds);
    }
}

