/*
 * Decompiled with CFR 0.152.
 */
package org.virbo.dataset;

import org.das2.datum.Units;
import org.virbo.dataset.QDataSet;
import org.virbo.dataset.Slice0DataSet;
import org.virbo.dataset.TrimDataSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class WeightsDataSet
implements QDataSet {
    final double fill;
    final double vmin;
    final double vmax;
    final boolean check;
    QDataSet ds;

    protected WeightsDataSet(QDataSet ds) {
        Number ofill;
        Units u;
        Number validMax;
        this.ds = ds;
        Number validMin = (Number)ds.property("VALID_MIN");
        if (validMin == null) {
            validMin = Double.NEGATIVE_INFINITY;
        }
        if ((validMax = (Number)ds.property("VALID_MAX")) == null) {
            validMax = Double.POSITIVE_INFINITY;
        }
        if ((u = (Units)ds.property("UNITS")) == null) {
            u = Units.dimensionless;
        }
        this.fill = (ofill = (Number)ds.property("FILL_VALUE")) == null ? u.getFillDouble() : ofill.doubleValue();
        this.vmin = validMin.doubleValue();
        this.vmax = validMax.doubleValue();
        this.check = this.vmin > -1.7976931348623157E308 || this.vmax < Double.MAX_VALUE || !Double.isNaN(this.fill);
    }

    @Override
    public int rank() {
        return this.ds.rank();
    }

    @Override
    public abstract double value();

    @Override
    public abstract double value(int var1);

    @Override
    public abstract double value(int var1, int var2);

    @Override
    public abstract double value(int var1, int var2, int var3);

    @Override
    public abstract double value(int var1, int var2, int var3, int var4);

    @Override
    public Object property(String name) {
        return name.equals("FILL_VALUE") ? Double.valueOf(this.fill) : null;
    }

    @Override
    public Object property(String name, int i) {
        return this.property(name);
    }

    public Object property(String name, int i0, int i1) {
        return this.property(name);
    }

    public Object property(String name, int i0, int i1, int i2) {
        return this.property(name);
    }

    public Object property(String name, int i0, int i1, int i2, int i3) {
        return this.property(name);
    }

    @Override
    public int length() {
        return this.ds.length();
    }

    @Override
    public int length(int i) {
        return this.ds.length(i);
    }

    @Override
    public int length(int i, int j) {
        return this.ds.length(i, j);
    }

    @Override
    public int length(int i, int j, int k) {
        return this.ds.length(i, j, k);
    }

    @Override
    public <T> T capability(Class<T> clazz) {
        return null;
    }

    @Override
    public QDataSet slice(int i) {
        return new Slice0DataSet(this, i);
    }

    @Override
    public QDataSet trim(int start, int end) {
        return new TrimDataSet(this, start, end);
    }

    public final class AllValid
    extends WeightsDataSet {
        public AllValid(QDataSet ds) {
            super(ds);
        }

        private final double weight(double v) {
            return 1.0;
        }

        public double value() {
            return this.weight(this.ds.value());
        }

        public double value(int i) {
            return this.weight(this.ds.value(i));
        }

        public double value(int i0, int i1) {
            return this.weight(this.ds.value(i0, i1));
        }

        public double value(int i0, int i1, int i2) {
            return this.weight(this.ds.value(i0, i1, i2));
        }

        public double value(int i0, int i1, int i2, int i3) {
            return this.weight(this.ds.value(i0, i1, i2, i3));
        }
    }

    public static final class Finite
    extends WeightsDataSet {
        public Finite(QDataSet ds) {
            super(ds);
        }

        private final double weight(double v) {
            return Double.isNaN(v) ? 0.0 : 1.0;
        }

        public double value() {
            return this.weight(this.ds.value());
        }

        public double value(int i) {
            return this.weight(this.ds.value(i));
        }

        public double value(int i0, int i1) {
            return this.weight(this.ds.value(i0, i1));
        }

        public double value(int i0, int i1, int i2) {
            return this.weight(this.ds.value(i0, i1, i2));
        }

        public double value(int i0, int i1, int i2, int i3) {
            return this.weight(this.ds.value(i0, i1, i2, i3));
        }
    }

    public static final class FillFinite
    extends WeightsDataSet {
        public FillFinite(QDataSet ds) {
            super(ds);
        }

        public final double weight(double v) {
            return v == this.fill || v == (double)((float)this.fill) || Double.isNaN(v) ? 0.0 : 1.0;
        }

        public double value() {
            return this.weight(this.ds.value());
        }

        public double value(int i) {
            return this.weight(this.ds.value(i));
        }

        public double value(int i0, int i1) {
            return this.weight(this.ds.value(i0, i1));
        }

        public double value(int i0, int i1, int i2) {
            return this.weight(this.ds.value(i0, i1, i2));
        }

        public double value(int i0, int i1, int i2, int i3) {
            return this.weight(this.ds.value(i0, i1, i2, i3));
        }
    }

    public static final class ValidRangeFillFinite
    extends WeightsDataSet {
        public ValidRangeFillFinite(QDataSet ds) {
            super(ds);
        }

        private final double weight(double v) {
            return v == this.fill || Double.isNaN(v) || v > this.vmax || v < this.vmin ? 0.0 : 1.0;
        }

        public double value() {
            return this.weight(this.ds.value());
        }

        public double value(int i) {
            return this.weight(this.ds.value(i));
        }

        public double value(int i0, int i1) {
            return this.weight(this.ds.value(i0, i1));
        }

        public double value(int i0, int i1, int i2) {
            return this.weight(this.ds.value(i0, i1, i2));
        }

        public double value(int i0, int i1, int i2, int i3) {
            return this.weight(this.ds.value(i0, i1, i2, i3));
        }
    }
}

