/*
 * Decompiled with CFR 0.152.
 */
package org.virbo.dsutil;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.virbo.dataset.ArrayDataSet;
import org.virbo.dataset.DDataSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataSetBuilder {
    int rank;
    ArrayList<DDataSet> finished;
    DDataSet current;
    int recCount;
    int dim1;
    int dim2;
    int recElements;
    int index;
    int offset;
    int length;
    HashMap<String, Object> properties;
    private double fillValue = -1.0E31;
    private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    protected double validMin = Double.NEGATIVE_INFINITY;
    public static final String PROP_VALIDMIN = "validMin";
    protected double validMax = Double.POSITIVE_INFINITY;
    public static final String PROP_VALIDMAX = "validMax";

    public DataSetBuilder(int rank, int guessRecCount) {
        this(rank, guessRecCount, 1, 1);
    }

    public DataSetBuilder(int rank, int guessRecCount, int dim1) {
        this(rank, guessRecCount, dim1, 1);
    }

    public DataSetBuilder(int rank, int guessRecCount, int dim1, int dim2) {
        this.rank = rank;
        this.recCount = guessRecCount;
        this.dim1 = dim1;
        this.dim2 = dim2;
        this.recElements = dim1 * dim2;
        this.newCurrent();
        this.index = 0;
        this.properties = new HashMap();
    }

    private void checkStreamIndex(int index0) throws IllegalArgumentException {
        if (index0 > -1 && index0 != this.index + this.offset) {
            if (index0 == this.index + this.offset + 1) {
                this.nextRecord();
            } else {
                throw new IllegalArgumentException("index0 must only increment by one");
            }
        }
        this.length = this.index + this.offset + 1;
    }

    private void newCurrent() {
        if (this.rank == 1) {
            this.current = DDataSet.createRank1(this.recCount);
        } else if (this.rank == 2) {
            this.current = DDataSet.createRank2(this.recCount, this.dim1);
        } else if (this.rank == 3) {
            this.current = DDataSet.createRank3(this.recCount, this.dim1, this.dim2);
        }
    }

    public double getValue(int index0) {
        if (index0 == -1) {
            if (this.index == 0) {
                throw new IllegalArgumentException("nothing written to builder yet");
            }
            return this.current.value(this.index - 1);
        }
        throw new IllegalArgumentException("index must be -1");
    }

    public void putValue(int index0, double d) {
        this.checkStreamIndex(index0);
        this.current.putValue(this.index, d);
    }

    public void putValue(int index0, int index1, double d) {
        this.checkStreamIndex(index0);
        this.current.putValue(this.index, index1, d);
    }

    public void putValue(int index0, int index1, int index2, double d) {
        this.checkStreamIndex(index0);
        this.current.putValue(this.index, index1, index2, d);
    }

    public void putValues(int index0, DDataSet values, int count) {
        this.checkStreamIndex(index0);
        DDataSet.copyElements(values, 0, this.current, this.index, count, false);
    }

    public void nextRecord() {
        ++this.index;
        if (this.index == this.current.length()) {
            if (this.finished == null) {
                this.finished = new ArrayList(4);
            }
            this.finished.add(this.current);
            this.offset += this.current.length();
            this.index -= this.current.length();
            this.newCurrent();
        }
    }

    public int getLength() {
        return this.length;
    }

    public int getRecordElements() {
        return this.recElements;
    }

    public DDataSet getDataSet() {
        DDataSet result;
        switch (this.rank) {
            case 1: {
                result = DDataSet.createRank1(this.length);
                break;
            }
            case 2: {
                result = DDataSet.createRank2(this.length, this.dim1);
                break;
            }
            case 3: {
                result = DDataSet.createRank3(this.length, this.dim1, this.dim2);
                break;
            }
            default: {
                throw new RuntimeException("bad rank");
            }
        }
        int dsindex = 0;
        if (this.finished != null) {
            for (int i = 0; i < this.finished.size(); ++i) {
                DDataSet f1 = this.finished.get(i);
                DDataSet.copyElements(f1, 0, result, dsindex, f1.length());
                dsindex += f1.length();
            }
            DDataSet.copyElements(this.current, 0, result, dsindex, this.length - dsindex);
        } else {
            result = (DDataSet)ArrayDataSet.copy(Double.TYPE, this.current);
        }
        result.putLength(this.length);
        for (String key : this.properties.keySet()) {
            result.putProperty(key, this.properties.get(key));
        }
        return result;
    }

    public void putProperty(String string, Object o) {
        this.properties.put(string, o);
    }

    public Map<String, Object> getProperties() {
        return Collections.unmodifiableMap(this.properties);
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.propertyChangeSupport.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.propertyChangeSupport.removePropertyChangeListener(l);
    }

    public double getFillValue() {
        return this.fillValue;
    }

    public void setFillValue(double fillValue) {
        double oldFillValue = this.fillValue;
        this.fillValue = fillValue;
        if (!Double.isNaN(fillValue)) {
            this.properties.put("FILL_VALUE", fillValue);
        }
        this.propertyChangeSupport.firePropertyChange("fillValue", new Double(oldFillValue), new Double(fillValue));
    }

    public double getValidMin() {
        return this.validMin;
    }

    public void setValidMin(double validMin) {
        double oldValidMin = this.validMin;
        this.validMin = validMin;
        if (validMin > Double.NEGATIVE_INFINITY) {
            this.properties.put("VALID_MIN", validMin);
        }
        this.propertyChangeSupport.firePropertyChange(PROP_VALIDMIN, oldValidMin, validMin);
    }

    public double getValidMax() {
        return this.validMax;
    }

    public void setValidMax(double validMax) {
        double oldValidMax = this.validMax;
        this.validMax = validMax;
        if (validMax < Double.POSITIVE_INFINITY) {
            this.properties.put("VALID_MAX", validMax);
        }
        this.propertyChangeSupport.firePropertyChange(PROP_VALIDMAX, oldValidMax, validMax);
    }

    public String toString() {
        String dims = null;
        switch (this.rank) {
            case 1: {
                dims = "*";
                break;
            }
            case 2: {
                dims = "*," + this.dim1;
                break;
            }
            case 3: {
                dims = "*," + this.dim1 + "," + this.dim2;
            }
        }
        return "DataSetBuilder rank=" + this.rank + "(" + dims + ") reccount=" + (this.index + this.offset);
    }

    public int rank() {
        return this.rank;
    }
}

