/*
 * Decompiled with CFR 0.152.
 */
package org.virbo.dsutil;

import org.das2.datum.Units;
import org.virbo.dataset.DDataSet;
import org.virbo.dataset.DRank0DataSet;
import org.virbo.dataset.DataSetUtil;
import org.virbo.dataset.QDataSet;

public class LSpec {
    private LSpec() {
    }

    private static QDataSet identifySweeps(QDataSet lds) {
        DDataSet result = DDataSet.createRank2(lds.length(), 2);
        double slope0 = lds.value(1) - lds.value(0);
        int start = 0;
        int index = 0;
        int end = 0;
        Units u = (Units)lds.property("UNITS");
        for (int i = 1; i < lds.length(); ++i) {
            if (u.isFill(lds.value(i)) || u.isFill(lds.value(i - 1))) continue;
            double slope1 = lds.value(i) - lds.value(i - 1);
            if (slope0 * slope1 <= 0.0) {
                if (slope0 != 0.0) {
                    result.putValue(index, 0, start);
                    result.putValue(index, 1, end);
                    ++index;
                }
                if (slope1 != 0.0) {
                    start = i - 1;
                }
            } else {
                end = i + 1;
            }
            slope0 = slope1;
        }
        result.putLength(index);
        return result;
    }

    private static final int findIndex(QDataSet datax, int start, int end, double x, int guess, int dir) {
        int index;
        if (dir > 0) {
            for (index = Math.max(Math.min(guess, end - 1), start); index < end && datax.value(index + 1) < x; ++index) {
            }
            while (index > start && datax.value(index) > x) {
                --index;
            }
        } else {
            while (index < end && datax.value(index + 1) > x) {
                ++index;
            }
            while (index > start && datax.value(index) < x) {
                --index;
            }
        }
        if (index == end) {
            --index;
        }
        return index;
    }

    private static void interpolate(QDataSet lds, QDataSet zds, int start, int end, int col, QDataSet lgrid, DDataSet ds) {
        Units u = (Units)ds.property("UNITS");
        double fill = u.getFillDouble();
        if (!u.equals((Units)zds.property("UNITS"))) {
            throw new IllegalArgumentException("zds units must be the same as ds units!");
        }
        int index = start;
        int dir = (int)Math.signum(lds.value(end - 1) - lds.value(start));
        index = dir > 0 ? start : end - 1;
        for (int i = 0; i < lgrid.length(); ++i) {
            double ll = lgrid.value(i);
            double alpha = (ll - lds.value(index = LSpec.findIndex(lds, start, end, ll, index, dir))) / (lds.value(index + 1) - lds.value(index));
            if (alpha < 0.0) {
                ds.putValue(col, i, fill);
                continue;
            }
            if (alpha > 1.0) {
                ds.putValue(col, i, fill);
                continue;
            }
            if (alpha == 0.0) {
                ds.putValue(col, i, zds.value(index));
                continue;
            }
            if (u.isFill(zds.value(index)) || u.isFill(zds.value(index + 1))) {
                ds.putValue(col, i, fill);
                continue;
            }
            ds.putValue(col, i, zds.value(index) * (1.0 - alpha) + zds.value(index + 1) * alpha);
        }
    }

    private static double guessCadence(QDataSet xds, int skip) {
        double cadence = Double.MAX_VALUE;
        double cadenceS = Double.MAX_VALUE;
        int cadenceN = 1;
        for (int i = skip; i < xds.length(); ++i) {
            double cadenceAvg = cadenceS / (double)cadenceN;
            cadence = xds.value(i) - xds.value(i - skip);
            if (cadence < 0.5 * cadenceAvg) {
                cadenceS = cadence;
                cadenceN = 1;
                continue;
            }
            if (!(cadence < 1.5 * cadenceAvg)) continue;
            cadenceS += cadence;
            ++cadenceN;
        }
        return cadenceS / (double)cadenceN;
    }

    public static QDataSet rebin(QDataSet lds, QDataSet zds, QDataSet lgrid) {
        QDataSet sweeps = LSpec.identifySweeps(lds);
        DDataSet result = DDataSet.createRank2(sweeps.length(), lgrid.length());
        result.putProperty("UNITS", lds.property("UNITS"));
        for (int i = 0; i < sweeps.length(); ++i) {
            LSpec.interpolate(lds, zds, (int)sweeps.value(i, 0), (int)sweeps.value(i, 1), i, lgrid, result);
        }
        DDataSet xtags = DDataSet.createRank1(sweeps.length());
        for (int i = 0; i < sweeps.length(); ++i) {
            xtags.putValue(i, (sweeps.value(i, 0) + sweeps.value(i, 1)) / 2.0);
        }
        QDataSet dep0 = (QDataSet)lds.property("DEPEND_0");
        if (dep0 != null) {
            for (int i = 0; i < sweeps.length(); ++i) {
                xtags.putValue(i, (dep0.value((int)sweeps.value(i, 0)) + dep0.value((int)sweeps.value(i, 1))) / 2.0);
            }
            xtags.putProperty("UNITS", dep0.property("UNITS"));
            xtags.putProperty("MONOTONIC", DataSetUtil.isMonotonic(dep0));
            xtags.putProperty("CADENCE", DRank0DataSet.create(1.5 * LSpec.guessCadence(xtags, 2)));
        }
        result.putProperty("sweeps", sweeps);
        result.putProperty("DEPEND_1", lgrid);
        result.putProperty("DEPEND_0", xtags);
        return result;
    }
}

