/*
 * Decompiled with CFR 0.152.
 */
package org.virbo.fits;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.das2.util.monitor.ProgressMonitor;
import org.eso.fits.FitsException;
import org.eso.fits.FitsFile;
import org.eso.fits.FitsHDUnit;
import org.virbo.datasource.AbstractDataSourceFactory;
import org.virbo.datasource.CompletionContext;
import org.virbo.datasource.DataSetURI;
import org.virbo.datasource.DataSource;
import org.virbo.datasource.DataSourceFactory;
import org.virbo.fits.FitsDataSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FitsDataSourceFactory
extends AbstractDataSourceFactory {
    public DataSource getDataSource(URI uri) throws Exception {
        return new FitsDataSource(uri);
    }

    public List<CompletionContext> getCompletions(CompletionContext cc, ProgressMonitor mon) throws FitsException {
        ArrayList<CompletionContext> result = new ArrayList<CompletionContext>();
        if (cc.context.equals(CompletionContext.CONTEXT_PARAMETER_NAME)) {
            try {
                String surl = CompletionContext.get((Object)CompletionContext.CONTEXT_FILE, (CompletionContext)cc);
                Set<String> plottable = FitsDataSourceFactory.getPlottable(DataSetURI.toUri((String)surl), mon).keySet();
                for (String s : plottable) {
                    result.add(new CompletionContext(CompletionContext.CONTEXT_PARAMETER_NAME, s, (DataSourceFactory)this, "arg_0"));
                }
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }
        return result;
    }

    protected static Map<String, Integer> getPlottable(URI uri, ProgressMonitor mon) throws IOException, FitsException {
        File f = DataSetURI.getFile((URI)uri, (ProgressMonitor)mon);
        FitsFile file = new FitsFile(f);
        LinkedHashMap<String, Integer> result = new LinkedHashMap<String, Integer>();
        int nhdu = file.getNoHDUnits();
        for (int i = 0; i < nhdu; ++i) {
            FitsHDUnit hdu = file.getHDUnit(i);
            result.put(hdu.getHeader().getName(), i);
        }
        return result;
    }
}

