/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.pngwalk;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import org.autoplot.pngwalk.PngWalkTool1;
import org.autoplot.pngwalk.PngWalkView;
import org.autoplot.pngwalk.ScalePerspectiveImageOp;
import org.autoplot.pngwalk.WalkImage;
import org.autoplot.pngwalk.WalkImageSequence;

public class ContextFlowView
extends PngWalkView {
    List<Rectangle> imageBounds;
    int firstIndexPainted;
    int lastIndexPainted;
    boolean useSquashedThumbs = true;

    public ContextFlowView(WalkImageSequence s) {
        super(s);
        this.sequenceChanged();
        this.addMouseWheelListener(new MouseWheelListener(){

            public void mouseWheelMoved(MouseWheelEvent e) {
                if (ContextFlowView.this.seq != null && ContextFlowView.this.seq.size() != 0) {
                    ContextFlowView.this.seq.skipBy(e.getWheelRotation());
                }
            }
        });
        this.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (ContextFlowView.this.imageBounds == null) {
                    return;
                }
                for (int i = ContextFlowView.this.firstIndexPainted; i < ContextFlowView.this.lastIndexPainted; ++i) {
                    if (!ContextFlowView.this.imageBounds.get(i).contains(e.getPoint())) continue;
                    ContextFlowView.this.seq.setIndex(i);
                    break;
                }
            }
        });
    }

    protected void sequenceChanged() {
        if (this.seq == null) {
            this.imageBounds = null;
        } else {
            this.imageBounds = new ArrayList<Rectangle>(this.seq.size());
            for (int i = 0; i < this.seq.size(); ++i) {
                this.imageBounds.add(i, null);
            }
        }
        this.repaint();
    }

    private static Rectangle bounds(int xpos, int ypos, int width, int height, int targetWidth, int targetHeight, double aspectFactor, boolean debug) {
        int h;
        int w;
        boolean heightIsLimiting;
        double aspect = 1.0 * (double)width / (double)height;
        boolean bl = heightIsLimiting = 1.0 * (double)targetWidth / (double)targetHeight > aspect * aspectFactor;
        if (debug) {
            System.err.printf("tw=%d th=%d rat=%5.2f asp=%5.2f  heightIsLimiting=%s\n", targetWidth, targetHeight, 1.0 * (double)targetWidth / (double)targetHeight, aspect, "" + heightIsLimiting);
        }
        if (heightIsLimiting) {
            w = (int)((double)targetHeight * (aspect * aspectFactor));
            h = targetHeight;
        } else {
            w = targetWidth;
            h = (int)((double)targetWidth / (aspect * aspectFactor));
        }
        int x = xpos - w / 2;
        int y = ypos - h / 2;
        return new Rectangle(x, y, w, h);
    }

    synchronized BufferedImage getRightImage(Image image, int width, int height, Rectangle bounds) {
        BufferedImage im;
        double magp = this.useSquashedThumbs ? 0.5 : 0.05;
        BufferedImage cacheImage = null;
        if (image instanceof BufferedImage) {
            im = (BufferedImage)image;
        } else {
            im = new BufferedImage(width, height, 2);
            if (!im.getGraphics().drawImage(image, 0, 0, this)) {
                return null;
            }
        }
        ScalePerspectiveImageOp op = new ScalePerspectiveImageOp(im.getWidth(), im.getHeight(), 0, 0, bounds.width, bounds.height, bounds.height / 4, 1, 1, magp, true);
        cacheImage = op.filter(im, null);
        return cacheImage;
    }

    synchronized BufferedImage getLeftImage(Image image, int width, int height, Rectangle bounds) {
        BufferedImage im;
        double magp = this.useSquashedThumbs ? 0.5 : 0.05;
        BufferedImage cacheImage = null;
        if (image instanceof BufferedImage) {
            im = (BufferedImage)image;
        } else {
            im = new BufferedImage(width, height, 2);
            if (!im.getGraphics().drawImage(image, 0, 0, this)) {
                return null;
            }
        }
        ScalePerspectiveImageOp op = new ScalePerspectiveImageOp(im.getWidth(), im.getHeight(), 0, 0, bounds.width, bounds.height, bounds.height / 4, 1, 1, -1.0 * magp, true);
        cacheImage = op.filter(im, null);
        return cacheImage;
    }

    private synchronized void maybeTimeStamp(Graphics2D g, Rectangle bounds, String s) {
        int fmh = 14;
        if (s != null) {
            g.drawString(s, bounds.x, bounds.y + bounds.height + fmh);
        }
    }

    protected synchronized void paintComponent(Graphics g1) {
        if (this.seq == null) {
            return;
        }
        Graphics2D g = (Graphics2D)g1;
        g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        Rectangle clip = g.getClipBounds();
        Color color0 = g.getColor();
        g.setColor(this.getBackground());
        g.fillRect(clip.x, clip.y, clip.width, clip.height);
        g.setColor(color0);
        int shelfWidth = 40;
        int currentWidth = 400;
        int xm = this.getWidth() / 2;
        int y = Math.max(200, this.getHeight() / 2);
        int columns = (xm - currentWidth / 2) / shelfWidth;
        int currentIndex = this.seq.getIndex();
        this.firstIndexPainted = Math.max(0, currentIndex - columns);
        this.lastIndexPainted = Math.min(this.seq.size(), currentIndex + columns + 1);
        double sh = this.useSquashedThumbs ? 1.0 : 10.0;
        for (int i = 0; i < columns * 2 + 1; ++i) {
            BufferedImage cacheImage;
            Rectangle bounds;
            int x;
            BufferedImage image;
            int d = columns - i / 2;
            int index = i % 2 == 0 ? currentIndex - d : currentIndex + d;
            if (index < 0 || index >= this.seq.size()) continue;
            boolean usedLastImage = false;
            BufferedImage bufferedImage = image = this.useSquashedThumbs ? this.seq.imageAt(index).getSquishedThumbnail() : this.seq.imageAt(index).getThumbnail();
            if (image == null || index != currentIndex && this.seq.imageAt(index).getStatus() == WalkImage.Status.MISSING) continue;
            int height = image.getHeight();
            int width = image.getWidth();
            if (index < currentIndex) {
                x = xm - currentWidth / 2 + (index - currentIndex) * shelfWidth;
                bounds = ContextFlowView.bounds(x, y, width, height, shelfWidth, Math.min(height, shelfWidth * 10), 1.0 / sh, false);
                cacheImage = this.getRightImage(image, width, height, bounds);
                if (cacheImage == null) continue;
                g.drawImage((Image)cacheImage, bounds.x, bounds.y, this);
                if (PngWalkTool1.isQualityControlEnabled() && this.seq.getQualityControlSequence() != null) {
                    this.paintQualityControlIcon(index, g, bounds.x + bounds.width / 2 - 4, bounds.y - 10, false);
                }
            } else if (index == currentIndex) {
                x = xm;
                image = this.seq.imageAt(index).getImage();
                if (image == null) {
                    image = this.seq.imageAt(index).getThumbnail();
                    height = image.getHeight();
                    width = image.getWidth();
                    bounds = width > height ? ContextFlowView.bounds(x, y, width, height, currentWidth, 10000, 1.0, false) : ContextFlowView.bounds(x, y, width, height, currentWidth, height, 1.0, false);
                    BufferedImage im = new BufferedImage(bounds.width, bounds.height, 2);
                    im.getGraphics().drawImage(image, 0, 0, bounds.width + 1, bounds.height + 1, this);
                    image = im;
                    height = image.getHeight();
                    width = image.getWidth();
                } else {
                    height = image.getHeight();
                    width = image.getWidth();
                    bounds = ContextFlowView.bounds(x, y, width, height, currentWidth, height, 1.0, false);
                }
                ScalePerspectiveImageOp op = new ScalePerspectiveImageOp(width, height, 0, 0, bounds.width, bounds.height, 100, -1, -1, 0.0, true);
                g.drawImage(image, op, bounds.x, bounds.y);
                if (PngWalkTool1.isQualityControlEnabled() && this.seq.getQualityControlSequence() != null) {
                    this.paintQualityControlIcon(index, g, bounds.x, bounds.y, true);
                }
                this.maybeTimeStamp(g, bounds, this.seq.imageAt(index).getCaption());
            } else {
                x = xm + currentWidth / 2 + (index - currentIndex) * shelfWidth;
                bounds = ContextFlowView.bounds(x, y, width, height, shelfWidth, Math.min(height, shelfWidth * 10), 1.0 / sh, false);
                cacheImage = this.getLeftImage(image, width, height, bounds);
                if (cacheImage == null) continue;
                g.drawImage((Image)cacheImage, bounds.x, bounds.y, this);
                if (PngWalkTool1.isQualityControlEnabled() && this.seq.getQualityControlSequence() != null) {
                    this.paintQualityControlIcon(index, g, bounds.x + bounds.width / 2 - 4, bounds.y - 10, false);
                }
            }
            this.imageBounds.set(index, bounds);
        }
    }
}

