/*
 * Decompiled with CFR 0.152.
 */
package org.virbo.autoplot;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.autoplot.help.AutoplotHelpSystem;
import org.das2.components.DatumRangeEditor;
import org.das2.datum.DatumRange;
import org.das2.datum.Units;
import org.das2.datum.UnitsUtil;
import org.das2.graph.DasColorBar;
import org.das2.graph.DasPlot;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Binding;
import org.jdesktop.beansbinding.BindingGroup;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.ELProperty;
import org.jdesktop.beansbinding.Property;
import org.jdesktop.layout.GroupLayout;
import org.virbo.autoplot.ApplicationModel;
import org.virbo.autoplot.dom.Application;
import org.virbo.autoplot.dom.ApplicationController;
import org.virbo.autoplot.dom.DataSourceFilter;
import org.virbo.autoplot.dom.Plot;
import org.virbo.autoplot.dom.PlotElement;

public class AxisPanel
extends JPanel {
    ApplicationModel applicationModel;
    Application dom;
    ApplicationController applicationController;
    DatumRangeEditor xredit;
    DatumRangeEditor yredit;
    DatumRangeEditor zredit;
    PropertyChangeListener dsfListener;
    DataSourceFilter dsf;
    private static final Logger logger = Logger.getLogger("virbo.autoplot");
    BindingGroup plotBindingGroup;
    BindingGroup panelBindingGroup;
    PlotElement panel;
    private JCheckBox cbVisibleCB;
    private JCheckBox isotropicCheckBox;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel6;
    private JPanel jPanel1;
    private JCheckBox legendEnableCheckbox;
    private JTextField legendTextField;
    private JTextField titleTextField;
    private JPanel xAxisPanel;
    private JPanel xAxisRangePanel;
    private JCheckBox xLog;
    private JTextField xTitleTextField;
    private JPanel yAxisPanel;
    private JPanel yAxisRangePanel;
    private JCheckBox yLog;
    private JTextField yTitleTextField;
    private JPanel zAxisPanel;
    private JPanel zAxisRangePanel;
    private JCheckBox zLog;
    private JTextField zTitleTextField;
    private BindingGroup bindingGroup;

    public AxisPanel(ApplicationModel applicationModel) {
        this.applicationModel = applicationModel;
        this.dom = applicationModel.dom;
        this.applicationController = this.dom.getController();
        this.applicationController.addPropertyChangeListener("plot", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                AxisPanel.this.doPlotBindings();
            }
        });
        this.applicationController.addPropertyChangeListener("plotElement", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                AxisPanel.this.doPanelBindings();
            }
        });
        this.initComponents();
        DasPlot plot = this.applicationController.getPlot().getController().getDasPlot();
        DasColorBar colorbar = this.applicationController.getPlot().getController().getDasColorBar();
        this.xredit = new DatumRangeEditor();
        this.xredit.setValue((Object)plot.getXAxis().getDatumRange());
        this.xredit.addFocusListener(this.createDatumRangeEditorListener(this.xredit));
        this.xredit.setToolTipText("X axis range");
        this.xAxisRangePanel.add((Component)this.xredit, "Center");
        this.yredit = new DatumRangeEditor();
        this.yredit.setValue((Object)plot.getYAxis().getDatumRange());
        this.yredit.addFocusListener(this.createDatumRangeEditorListener(this.yredit));
        this.yredit.setToolTipText("Y axis range");
        this.yAxisRangePanel.add((Component)this.yredit, "Center");
        this.zredit = new DatumRangeEditor();
        this.zredit.setValue((Object)colorbar.getDatumRange());
        this.zredit.addFocusListener(this.createDatumRangeEditorListener(this.zredit));
        this.zredit.setToolTipText("Z axis range");
        this.zAxisRangePanel.add((Component)this.zredit, "Center");
        this.xredit.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent ev) {
                DatumRange dr = (DatumRange)AxisPanel.this.xredit.getValue();
                AxisPanel.this.xLog.setEnabled(UnitsUtil.isRatioMeasurement((Units)dr.getUnits()));
                if (!AxisPanel.this.xLog.isEnabled()) {
                    AxisPanel.this.xLog.setSelected(false);
                }
            }
        });
        this.yredit.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent ev) {
                DatumRange dr = (DatumRange)AxisPanel.this.yredit.getValue();
                AxisPanel.this.yLog.setEnabled(UnitsUtil.isRatioMeasurement((Units)dr.getUnits()));
                if (!AxisPanel.this.yLog.isEnabled()) {
                    AxisPanel.this.yLog.setSelected(false);
                }
            }
        });
        this.zredit.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent ev) {
                DatumRange dr = (DatumRange)AxisPanel.this.zredit.getValue();
                AxisPanel.this.zLog.setEnabled(UnitsUtil.isRatioMeasurement((Units)dr.getUnits()));
                if (!AxisPanel.this.zLog.isEnabled()) {
                    AxisPanel.this.zLog.setSelected(false);
                }
            }
        });
        Runnable run = new Runnable(){

            public void run() {
                AxisPanel.this.doPlotBindings();
                AxisPanel.this.doPanelBindings();
                AxisPanel.this.doApplicationBindings();
            }
        };
        SwingUtilities.invokeLater(run);
        AutoplotHelpSystem.getHelpSystem().registerHelpID((Component)this, "axisPanel");
    }

    private FocusListener createDatumRangeEditorListener(final DatumRangeEditor edit) {
        return new FocusListener(){

            public void focusGained(FocusEvent e) {
            }

            public void focusLost(FocusEvent e) {
                edit.setValue(edit.getValue());
            }
        };
    }

    private void doApplicationBindings() {
    }

    private BindingGroup doPlotBindings() {
        BindingGroup bc = new BindingGroup();
        Plot p = this.applicationController.getPlot();
        if (this.plotBindingGroup != null) {
            this.plotBindingGroup.unbind();
        }
        bc.addBinding((Binding)Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)p, (Property)BeanProperty.create((String)"xaxis.label"), (Object)this.xTitleTextField, (Property)BeanProperty.create((String)"text_ON_ACTION_OR_FOCUS_LOST")));
        bc.addBinding((Binding)Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)p, (Property)BeanProperty.create((String)"xaxis.range"), (Object)this.xredit, (Property)BeanProperty.create((String)"value")));
        bc.addBinding((Binding)Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)p, (Property)BeanProperty.create((String)"xaxis.log"), (Object)this.xLog, (Property)BeanProperty.create((String)"selected")));
        bc.addBinding((Binding)Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)p, (Property)BeanProperty.create((String)"yaxis.label"), (Object)this.yTitleTextField, (Property)BeanProperty.create((String)"text_ON_ACTION_OR_FOCUS_LOST")));
        bc.addBinding((Binding)Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)p, (Property)BeanProperty.create((String)"yaxis.range"), (Object)this.yredit, (Property)BeanProperty.create((String)"value")));
        bc.addBinding((Binding)Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)p, (Property)BeanProperty.create((String)"yaxis.log"), (Object)this.yLog, (Property)BeanProperty.create((String)"selected")));
        bc.addBinding((Binding)Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)p, (Property)BeanProperty.create((String)"zaxis.label"), (Object)this.zTitleTextField, (Property)BeanProperty.create((String)"text_ON_ACTION_OR_FOCUS_LOST")));
        bc.addBinding((Binding)Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)p, (Property)BeanProperty.create((String)"zaxis.range"), (Object)this.zredit, (Property)BeanProperty.create((String)"value")));
        bc.addBinding((Binding)Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)p, (Property)BeanProperty.create((String)"zaxis.log"), (Object)this.zLog, (Property)BeanProperty.create((String)"selected")));
        bc.addBinding((Binding)Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)p, (Property)BeanProperty.create((String)"zaxis.visible"), (Object)this.cbVisibleCB, (Property)BeanProperty.create((String)"selected")));
        bc.addBinding((Binding)Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)p, (Property)BeanProperty.create((String)"title"), (Object)this.titleTextField, (Property)BeanProperty.create((String)"text_ON_ACTION_OR_FOCUS_LOST")));
        bc.addBinding((Binding)Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)p, (Property)BeanProperty.create((String)"isotropic"), (Object)this.isotropicCheckBox, (Property)BeanProperty.create((String)"selected")));
        this.plotBindingGroup = bc;
        bc.bind();
        return bc;
    }

    private void doPanelBindings() {
        PlotElement p;
        BindingGroup bc = new BindingGroup();
        if (this.panelBindingGroup != null) {
            this.panelBindingGroup.unbind();
        }
        this.panel = p = this.applicationController.getPlotElement();
        bc.addBinding((Binding)Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)p, (Property)BeanProperty.create((String)"legendLabel"), (Object)this.legendTextField, (Property)BeanProperty.create((String)"text_ON_ACTION_OR_FOCUS_LOST")));
        bc.addBinding((Binding)Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)p, (Property)BeanProperty.create((String)"displayLegend"), (Object)this.legendEnableCheckbox, (Property)BeanProperty.create((String)"selected")));
        this.panelBindingGroup = bc;
        bc.bind();
    }

    private void initComponents() {
        this.bindingGroup = new BindingGroup();
        this.xAxisPanel = new JPanel();
        this.xLog = new JCheckBox();
        this.xAxisRangePanel = new JPanel();
        this.xTitleTextField = new JTextField();
        this.jLabel1 = new JLabel();
        this.zAxisPanel = new JPanel();
        this.zLog = new JCheckBox();
        this.zAxisRangePanel = new JPanel();
        this.zTitleTextField = new JTextField();
        this.cbVisibleCB = new JCheckBox();
        this.jLabel3 = new JLabel();
        this.yAxisPanel = new JPanel();
        this.yAxisRangePanel = new JPanel();
        this.yLog = new JCheckBox();
        this.isotropicCheckBox = new JCheckBox();
        this.yTitleTextField = new JTextField();
        this.jLabel2 = new JLabel();
        this.jPanel1 = new JPanel();
        this.titleTextField = new JTextField();
        this.jLabel6 = new JLabel();
        this.legendEnableCheckbox = new JCheckBox();
        this.legendTextField = new JTextField();
        this.xAxisPanel.setBorder(BorderFactory.createTitledBorder("X Axis [?]"));
        this.xAxisPanel.setToolTipText("click title for help");
        this.xLog.setText("Log");
        this.xLog.setToolTipText("X axis logarithmic scale");
        this.xLog.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.xAxisRangePanel.setLayout(new BorderLayout());
        this.xTitleTextField.setText("jTextField1");
        this.xTitleTextField.setToolTipText("X axis title");
        this.xTitleTextField.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent evt) {
                AxisPanel.this.axisMouseAction(evt);
            }

            public void mouseReleased(MouseEvent evt) {
                AxisPanel.this.axisMouseAction(evt);
            }
        });
        this.jLabel1.setText("Label:");
        GroupLayout xAxisPanelLayout = new GroupLayout((Container)this.xAxisPanel);
        this.xAxisPanel.setLayout((LayoutManager)xAxisPanelLayout);
        xAxisPanelLayout.setHorizontalGroup((GroupLayout.Group)xAxisPanelLayout.createParallelGroup(1).add((GroupLayout.Group)xAxisPanelLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)xAxisPanelLayout.createParallelGroup(1).add((Component)this.xAxisRangePanel, -1, 227, Short.MAX_VALUE).add((Component)this.xLog).add((GroupLayout.Group)xAxisPanelLayout.createSequentialGroup().add((Component)this.jLabel1).addPreferredGap(0).add((Component)this.xTitleTextField, -1, 177, Short.MAX_VALUE))).addContainerGap()));
        xAxisPanelLayout.setVerticalGroup((GroupLayout.Group)xAxisPanelLayout.createParallelGroup(1).add((GroupLayout.Group)xAxisPanelLayout.createSequentialGroup().add((GroupLayout.Group)xAxisPanelLayout.createParallelGroup(3).add((Component)this.xTitleTextField, -2, -1, -2).add((Component)this.jLabel1)).addPreferredGap(0).add((Component)this.xAxisRangePanel, -2, 27, -2).addPreferredGap(0).add((Component)this.xLog).addContainerGap(-1, Short.MAX_VALUE)));
        this.zAxisPanel.setBorder(BorderFactory.createTitledBorder("Colorbar [?]"));
        this.zAxisPanel.setToolTipText("click title for help");
        this.zLog.setText("Log");
        this.zLog.setToolTipText("colorbar logarithmic scale");
        this.zLog.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.zAxisRangePanel.setLayout(new BorderLayout());
        this.zTitleTextField.setText("jTextField1");
        this.zTitleTextField.setToolTipText("Colorbar title");
        this.zTitleTextField.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent evt) {
                AxisPanel.this.axisMouseAction(evt);
            }

            public void mouseReleased(MouseEvent evt) {
                AxisPanel.this.axisMouseAction(evt);
            }
        });
        this.cbVisibleCB.setText("Visible");
        this.cbVisibleCB.setToolTipText("hide/show colorbar");
        this.jLabel3.setText("Label:");
        GroupLayout zAxisPanelLayout = new GroupLayout((Container)this.zAxisPanel);
        this.zAxisPanel.setLayout((LayoutManager)zAxisPanelLayout);
        zAxisPanelLayout.setHorizontalGroup((GroupLayout.Group)zAxisPanelLayout.createParallelGroup(1).add((GroupLayout.Group)zAxisPanelLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)zAxisPanelLayout.createParallelGroup(1).add((Component)this.zAxisRangePanel, -1, 302, Short.MAX_VALUE).add((GroupLayout.Group)zAxisPanelLayout.createSequentialGroup().add((Component)this.zLog).add(18, 18, 18).add((Component)this.cbVisibleCB)).add((GroupLayout.Group)zAxisPanelLayout.createSequentialGroup().add((Component)this.jLabel3).addPreferredGap(0).add((Component)this.zTitleTextField, -1, 252, Short.MAX_VALUE))).addContainerGap()));
        zAxisPanelLayout.setVerticalGroup((GroupLayout.Group)zAxisPanelLayout.createParallelGroup(1).add((GroupLayout.Group)zAxisPanelLayout.createSequentialGroup().add((GroupLayout.Group)zAxisPanelLayout.createParallelGroup(3).add((Component)this.zTitleTextField, -2, -1, -2).add((Component)this.jLabel3)).addPreferredGap(0).add((Component)this.zAxisRangePanel, -2, 27, -2).addPreferredGap(0).add((GroupLayout.Group)zAxisPanelLayout.createParallelGroup(3).add((Component)this.zLog).add((Component)this.cbVisibleCB)).addContainerGap(22, Short.MAX_VALUE)));
        this.yAxisPanel.setBorder(BorderFactory.createTitledBorder("Y Axis [?]"));
        this.yAxisPanel.setToolTipText("click title for help");
        this.yAxisRangePanel.setLayout(new BorderLayout());
        this.yLog.setText("Log");
        this.yLog.setToolTipText("Y axis logarithmic scale");
        this.yLog.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.isotropicCheckBox.setText("Isotropic");
        this.isotropicCheckBox.setToolTipText("When units are convertable to X Axis units, automatically set y axis to ensure pixel:data ratio is the same.");
        this.isotropicCheckBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.yTitleTextField.setText("jTextField1");
        this.yTitleTextField.setToolTipText("Y axis title");
        this.yTitleTextField.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent evt) {
                AxisPanel.this.axisMouseAction(evt);
            }

            public void mouseReleased(MouseEvent evt) {
                AxisPanel.this.axisMouseAction(evt);
            }
        });
        this.jLabel2.setText("Label:");
        GroupLayout yAxisPanelLayout = new GroupLayout((Container)this.yAxisPanel);
        this.yAxisPanel.setLayout((LayoutManager)yAxisPanelLayout);
        yAxisPanelLayout.setHorizontalGroup((GroupLayout.Group)yAxisPanelLayout.createParallelGroup(1).add((GroupLayout.Group)yAxisPanelLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)yAxisPanelLayout.createParallelGroup(1).add((Component)this.yAxisRangePanel, -1, 227, Short.MAX_VALUE).add((Component)this.yLog).add((Component)this.isotropicCheckBox).add((GroupLayout.Group)yAxisPanelLayout.createSequentialGroup().add((Component)this.jLabel2).addPreferredGap(0).add((Component)this.yTitleTextField, -1, 177, Short.MAX_VALUE))).addContainerGap()));
        yAxisPanelLayout.setVerticalGroup((GroupLayout.Group)yAxisPanelLayout.createParallelGroup(1).add((GroupLayout.Group)yAxisPanelLayout.createSequentialGroup().add((GroupLayout.Group)yAxisPanelLayout.createParallelGroup(3).add((Component)this.yTitleTextField, -2, -1, -2).add((Component)this.jLabel2)).addPreferredGap(0).add((Component)this.yAxisRangePanel, -2, 27, -2).addPreferredGap(0).add((Component)this.yLog).addPreferredGap(0).add((Component)this.isotropicCheckBox).addContainerGap(14, Short.MAX_VALUE)));
        this.jPanel1.setBorder(BorderFactory.createTitledBorder("Plot [?]"));
        this.jPanel1.setToolTipText("click title for help");
        this.titleTextField.setText("title will go here");
        this.titleTextField.setToolTipText("title for the selected plot.\n");
        this.jLabel6.setText("Title:");
        this.legendEnableCheckbox.setText("Legend Label:");
        this.legendEnableCheckbox.setToolTipText("when selected, the label is added to the legend of the plot.\n\n");
        this.legendTextField.setText("label will go here");
        this.legendTextField.setToolTipText("a short label indentifying the selected panel");
        AutoBinding binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.legendEnableCheckbox, (Property)ELProperty.create((String)"${selected}"), (Object)this.legendTextField, (Property)BeanProperty.create((String)"enabled"));
        this.bindingGroup.addBinding((Binding)binding);
        this.legendTextField.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent evt) {
                AxisPanel.this.legendTextFieldMousePressed(evt);
            }

            public void mouseReleased(MouseEvent evt) {
                AxisPanel.this.legendTextFieldMouseReleased(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout((Container)this.jPanel1);
        this.jPanel1.setLayout((LayoutManager)jPanel1Layout);
        jPanel1Layout.setHorizontalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanel1Layout.createParallelGroup(2).add(1, (GroupLayout.Group)jPanel1Layout.createSequentialGroup().add((Component)this.jLabel6).addPreferredGap(0).add((Component)this.titleTextField, -1, 260, Short.MAX_VALUE)).add(1, (GroupLayout.Group)jPanel1Layout.createSequentialGroup().add((Component)this.legendEnableCheckbox).addPreferredGap(0).add((Component)this.legendTextField, -1, 183, Short.MAX_VALUE))).addContainerGap()));
        jPanel1Layout.setVerticalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().add((GroupLayout.Group)jPanel1Layout.createParallelGroup(3).add((Component)this.jLabel6).add((Component)this.titleTextField, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)jPanel1Layout.createParallelGroup(3).add((Component)this.legendEnableCheckbox).add((Component)this.legendTextField, -2, -1, -2)).addContainerGap(48, Short.MAX_VALUE)));
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.yAxisPanel, -1, -1, Short.MAX_VALUE).add(2, (Component)this.xAxisPanel, -1, -1, Short.MAX_VALUE)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.zAxisPanel, -1, -1, Short.MAX_VALUE).add((Component)this.jPanel1, 0, -1, Short.MAX_VALUE))));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createParallelGroup(2, false).add(1, (GroupLayout.Group)layout.createSequentialGroup().add((Component)this.xAxisPanel, -2, -1, -2).addPreferredGap(0).add((Component)this.yAxisPanel, -1, -1, Short.MAX_VALUE)).add(1, (GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jPanel1, -2, -1, -2).addPreferredGap(0).add((Component)this.zAxisPanel, -2, -1, -2))));
        this.bindingGroup.bind();
    }

    private void legendTextFieldMousePressed(MouseEvent evt) {
        if (evt.isPopupTrigger()) {
            this.showLabelMenu(evt);
        }
    }

    private void legendTextFieldMouseReleased(MouseEvent evt) {
        if (evt.isPopupTrigger()) {
            this.showLabelMenu(evt);
        }
    }

    private void axisMouseAction(MouseEvent evt) {
        if (evt.isPopupTrigger()) {
            this.showAxisMenu(evt);
        }
    }

    private JMenuItem createMenuItem(final JTextField componentTextField, final String insert, String doc) {
        JMenuItem result = new JMenuItem(new AbstractAction(insert){

            public void actionPerformed(ActionEvent e) {
                String v = componentTextField.getText();
                int i = componentTextField.getCaretPosition();
                componentTextField.setText(v.substring(0, i) + insert + v.substring(i));
            }
        });
        result.setToolTipText(doc);
        return result;
    }

    JPopupMenu initLabelMenu(JTextField tf) {
        JPopupMenu processMenu = new JPopupMenu();
        processMenu.add(this.createMenuItem(tf, "%{COMPONENT}", "Component property from the plot element"));
        processMenu.add(this.createMenuItem(tf, "%{CONTEXT}", "Context from the dataset"));
        processMenu.add(this.createMenuItem(tf, "%{TIMERANGE}", "Special timerange property from the plot element controller"));
        return processMenu;
    }

    void showLabelMenu(MouseEvent ev) {
        JPopupMenu processMenu = this.initLabelMenu((JTextField)ev.getSource());
        processMenu.show(ev.getComponent(), ev.getX(), ev.getY());
    }

    JPopupMenu initAxisMenu(JTextField tf) {
        JPopupMenu processMenu = new JPopupMenu();
        processMenu.add(this.createMenuItem(tf, "%{UNITS}", "Units of the axis"));
        processMenu.add(this.createMenuItem(tf, "%{RANGE}", "Range of the axis"));
        processMenu.add(this.createMenuItem(tf, "%{SCAN_RANGE}", "Range of the axis scan buttons"));
        return processMenu;
    }

    void showAxisMenu(MouseEvent ev) {
        JPopupMenu processMenu = this.initAxisMenu((JTextField)ev.getSource());
        processMenu.show(ev.getComponent(), ev.getX(), ev.getY());
    }
}

