/*
 * Decompiled with CFR 0.152.
 */
package org.virbo.autoplot;

import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.autoplot.help.AutoplotHelpSystem;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Binding;
import org.jdesktop.beansbinding.BindingGroup;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.Property;
import org.jdesktop.layout.GroupLayout;
import org.virbo.autoplot.dom.Application;
import org.virbo.autoplot.dom.ApplicationController;
import org.virbo.autoplot.dom.DataSourceFilter;
import org.virbo.autoplot.dom.PlotElement;
import org.virbo.autoplot.util.TickleTimer;
import org.virbo.datasource.DataSetSelector;

public class DataPanel
extends JPanel {
    Application dom;
    ApplicationController applicationController;
    DataSourceFilter dsf;
    BindingGroup dataSourceFilterBindingGroup;
    PlotElement element;
    DataSetSelector dataSetSelector;
    PropertyChangeListener compListener;
    private static final Logger logger = Logger.getLogger("virbo.autoplot");
    private long lastIncrUp = 0L;
    private int incrUpCount = 0;
    TickleTimer tt = new TickleTimer(100L, new PropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent evt) {
            if (DataPanel.this.incrUpCount != 0) {
                DataPanel.this.doIncrUp(DataPanel.this.incrUpCount);
                DataPanel.this.incrUpCount = 0;
                DataPanel.this.lastIncrUp = System.currentTimeMillis();
            }
        }
    });
    protected boolean adjusting = false;
    public static final String PROP_ADJUSTING = "adjusting";
    private BindingGroup elementBindingGroup;
    transient PropertyChangeListener dsfListener = new PropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equals("depnames")) {
                DataPanel.this.updateSliceTypeComboBox(DataPanel.this.applicationController.getDataSourceFilter(), false);
            }
        }
    };
    transient MouseWheelListener sliceIndexListener = null;
    transient MouseWheelListener sliceIndexListener2 = null;
    private JPopupMenu processMenu;
    private JTextField componentTextField;
    private JCheckBox doSliceCheckBox;
    private JComboBox fillValueComboBox;
    private JLabel fillValueLabel;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JLabel operationsLabel;
    private JCheckBox sliceAutorangesCB;
    private JLabel sliceIndexLabel;
    private JSpinner sliceIndexSpinner;
    private JComboBox sliceTypeComboBox;
    private JCheckBox transposeCheckBox;
    private JTextField uriTextField;
    private JComboBox validRangeComboBox;
    private JLabel validRangeLabel;

    public DataPanel(Application dom) {
        this.initComponents();
        this.dom = dom;
        this.applicationController = this.dom.getController();
        this.applicationController.addPropertyChangeListener("plotElement", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                DataPanel.this.doPlotElementBindings();
            }
        });
        this.applicationController.addPropertyChangeListener("dataSourceFilter", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                DataPanel.this.doDataSourceFilterBindings();
            }
        });
        if (this.sliceIndexListener == null) {
            this.sliceIndexListener = new MouseWheelListener(){

                public void mouseWheelMoved(MouseWheelEvent e) {
                    int maxpos;
                    int pos = (Integer)DataPanel.this.sliceIndexSpinner.getValue();
                    if ((pos -= e.getWheelRotation()) < 0) {
                        pos = 0;
                    }
                    if ((maxpos = ((Integer)((SpinnerNumberModel)DataPanel.this.sliceIndexSpinner.getModel()).getMaximum()).intValue()) == 0) {
                        return;
                    }
                    if (pos >= maxpos) {
                        pos = maxpos;
                    }
                    DataPanel.this.sliceIndexSpinner.setValue(pos);
                }
            };
            this.sliceIndexSpinner.addMouseWheelListener(this.sliceIndexListener);
        }
        if (this.sliceIndexListener2 == null) {
            this.sliceIndexListener2 = new MouseWheelListener(){

                public void mouseWheelMoved(MouseWheelEvent e) {
                    DataPanel.this.doIncrUp(-1 * e.getWheelRotation());
                }
            };
            this.componentTextField.addMouseWheelListener(this.sliceIndexListener2);
        }
        this.componentTextField.getInputMap().put(KeyStroke.getKeyStroke(38, 0), "INCREMENT_UP");
        this.componentTextField.getInputMap().put(KeyStroke.getKeyStroke(40, 0), "INCREMENT_DOWN");
        ActionMap am = this.componentTextField.getActionMap();
        am.put("INCREMENT_UP", new AbstractAction("incr_up"){

            public void actionPerformed(ActionEvent e) {
                DataPanel.this.incrUpCount++;
                if (System.currentTimeMillis() - DataPanel.this.lastIncrUp > 300L) {
                    DataPanel.this.doIncrUp(DataPanel.this.incrUpCount);
                    DataPanel.this.incrUpCount = 0;
                    DataPanel.this.lastIncrUp = System.currentTimeMillis();
                } else {
                    DataPanel.this.tt.tickle("incr");
                }
            }
        });
        am.put("INCREMENT_DOWN", new AbstractAction("incr_down"){

            public void actionPerformed(ActionEvent e) {
                DataPanel.this.incrUpCount--;
                if (System.currentTimeMillis() - DataPanel.this.lastIncrUp > 300L) {
                    DataPanel.this.doIncrUp(DataPanel.this.incrUpCount);
                    DataPanel.this.incrUpCount = 0;
                    DataPanel.this.lastIncrUp = System.currentTimeMillis();
                } else {
                    DataPanel.this.tt.tickle("incr");
                }
            }
        });
        this.compListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                DataPanel.this.componentChanged();
            }
        };
        AutoplotHelpSystem.getHelpSystem().registerHelpID((Component)this.jPanel1, "dataPanel_1");
        AutoplotHelpSystem.getHelpSystem().registerHelpID((Component)this.jPanel2, "dataPanel_2");
    }

    protected void setExpertMode(boolean expert) {
        this.componentTextField.setVisible(expert);
        this.operationsLabel.setVisible(expert);
    }

    private void doIncrUp(int amount) {
        String s = this.componentTextField.getText();
        int cp = this.componentTextField.getCaretPosition();
        String match = ".*\\|slice\\d\\(\\d*";
        String match2 = ".*\\|slices\\((\\d+,)*\\d*";
        if (cp < s.length()) {
            Matcher m = Pattern.compile(match).matcher(s.substring(0, cp));
            if (m.matches()) {
                s = this.doAdjust(s, cp, amount);
            } else {
                Matcher m2 = Pattern.compile(match2).matcher(s.substring(0, cp));
                if (m2.matches()) {
                    s = this.doAdjust(s, cp, amount);
                }
            }
        } else {
            return;
        }
        this.componentTextField.setText(s);
        this.applicationController.getPlotElement().setComponent(this.componentTextField.getText());
        this.componentTextField.setCaretPosition(cp);
    }

    public void doBindings() {
        this.doPlotElementBindings();
        this.doDataSourceFilterBindings();
        this.componentChanged();
    }

    private String doAdjust(String s, int cp, int add) {
        int i1;
        int i0;
        for (i0 = cp; i0 >= 0 && !Character.isDigit(s.charAt(i0)); --i0) {
        }
        while (i0 >= 0 && Character.isDigit(s.charAt(i0))) {
            --i0;
        }
        ++i0;
        for (i1 = cp; i1 < s.length() && Character.isDigit(s.charAt(i1)); ++i1) {
        }
        int ch = Integer.parseInt(s.substring(i0, i1));
        if ((ch += add) < 0) {
            ch = 0;
        }
        return s.substring(0, i0) + ch + s.substring(i1);
    }

    private void updateComponent() {
        if (this.adjusting) {
            return;
        }
        String sprocess = "";
        if (this.doSliceCheckBox.isSelected()) {
            sprocess = sprocess + "|slice" + this.sliceTypeComboBox.getSelectedIndex() + "(" + this.sliceIndexSpinner.getValue() + ")";
        }
        if (this.transposeCheckBox.isSelected()) {
            sprocess = sprocess + "|transpose";
        }
        if (this.element != null) {
            this.element.setComponentAutomatically(sprocess);
        } else {
            new Exception("who entered this code").printStackTrace();
        }
    }

    private void componentChanged() {
        if (this.adjusting) {
            return;
        }
        if (this.element == null) {
            return;
        }
        String scomp = this.element.getComponent();
        Pattern slicePattern = Pattern.compile("\\|slice(\\d+)\\((\\d+)\\)(\\|transpose)?");
        Matcher m = slicePattern.matcher(scomp);
        if (m.matches()) {
            this.setAdjusting(true);
            this.doSliceCheckBox.setSelected(true);
            this.sliceTypeComboBox.setSelectedIndex(Integer.parseInt(m.group(1)));
            if (this.dsf != null) {
                int max = this.dsf.getController().getMaxSliceIndex(this.sliceTypeComboBox.getSelectedIndex());
                if (max > 0) {
                    --max;
                }
                this.sliceIndexSpinner.setModel(new SpinnerNumberModel(0, 0, max, 1));
                this.sliceIndexSpinner.setValue(Integer.parseInt(m.group(2)));
            }
            this.transposeCheckBox.setSelected(m.group(3) != null);
            this.setAdjusting(false);
        }
        boolean canSlice = m.matches();
        this.doSliceCheckBox.setEnabled(canSlice);
        this.sliceIndexSpinner.setEnabled(canSlice);
        this.sliceIndexLabel.setEnabled(canSlice);
        this.sliceAutorangesCB.setEnabled(canSlice);
        this.sliceTypeComboBox.setEnabled(canSlice);
        this.transposeCheckBox.setEnabled(canSlice);
    }

    public boolean isAdjusting() {
        return this.adjusting;
    }

    public void setAdjusting(boolean adjusting) {
        boolean oldAdjusting = this.adjusting;
        this.adjusting = adjusting;
        this.firePropertyChange(PROP_ADJUSTING, oldAdjusting, adjusting);
    }

    private void updateSliceTypeComboBox(DataSourceFilter dsf, boolean immediately) {
        final String[] depNames1 = new String[4];
        String[] depNames = dsf.getController().getDepnames().toArray(new String[dsf.getController().getDepnames().size()]);
        for (int i = 0; i < depNames.length; ++i) {
            depNames1[i] = depNames[i] + " (" + dsf.getController().getMaxSliceIndex(i) + " bins)";
        }
        if (immediately) {
            this.sliceTypeComboBox.setModel(new DefaultComboBoxModel<String>(depNames1));
            if (this.element != null && !this.componentTextField.getText().equals(this.element.getComponent())) {
                this.componentTextField.setText(this.element.getComponent());
                this.componentChanged();
            }
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    DataPanel.this.sliceTypeComboBox.setModel(new DefaultComboBoxModel<String>(depNames1));
                    if (DataPanel.this.element != null && !DataPanel.this.componentTextField.getText().equals(DataPanel.this.element.getComponent())) {
                        DataPanel.this.componentTextField.setText(DataPanel.this.element.getComponent());
                        DataPanel.this.componentChanged();
                    }
                }
            });
        }
    }

    private synchronized void doPlotElementBindings() {
        PlotElement p;
        BindingGroup bc = new BindingGroup();
        if (this.elementBindingGroup != null) {
            this.elementBindingGroup.unbind();
        }
        if (this.element != null) {
            this.element.removePropertyChangeListener("component", this.compListener);
        }
        this.element = p = this.applicationController.getPlotElement();
        this.componentTextField.setText(p.getComponent());
        this.componentChanged();
        this.element.addPropertyChangeListener("component", this.compListener);
        bc.addBinding((Binding)Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.element, (Property)BeanProperty.create((String)"component"), (Object)this.componentTextField, (Property)BeanProperty.create((String)"text_ON_ACTION_OR_FOCUS_LOST")));
        bc.addBinding((Binding)Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.element.getController(), (Property)BeanProperty.create((String)"sliceAutoranges"), (Object)this.sliceAutorangesCB, (Property)BeanProperty.create((String)"selected")));
        this.elementBindingGroup = bc;
        bc.bind();
    }

    private synchronized void doDataSourceFilterBindings() {
        DataSourceFilter newDsf;
        if (this.dataSourceFilterBindingGroup != null) {
            this.dataSourceFilterBindingGroup.unbind();
        }
        if (this.dsf != null) {
            this.dsf.getController().removePropertyChangeListener(this.dsfListener);
        }
        if ((newDsf = this.applicationController.getDataSourceFilter()) == null) {
            this.dataSourceFilterBindingGroup = null;
            return;
        }
        this.updateSliceTypeComboBox(newDsf, true);
        BindingGroup bc = new BindingGroup();
        bc.addBinding((Binding)Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)newDsf, (Property)BeanProperty.create((String)"fill"), (Object)this.fillValueComboBox, (Property)BeanProperty.create((String)"selectedItem")));
        bc.addBinding((Binding)Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)newDsf, (Property)BeanProperty.create((String)"validRange"), (Object)this.validRangeComboBox, (Property)BeanProperty.create((String)"selectedItem")));
        bc.addBinding((Binding)Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)newDsf, (Property)BeanProperty.create((String)"uri"), (Object)this.uriTextField, (Property)BeanProperty.create((String)"text")));
        bc.bind();
        this.dataSourceFilterBindingGroup = bc;
        if (newDsf != null) {
            int sliceDimension = this.sliceTypeComboBox.getSelectedIndex();
            int max = newDsf.getController().getMaxSliceIndex(sliceDimension);
            if (max > 0) {
                this.sliceIndexSpinner.setModel(new SpinnerNumberModel(0, 0, max - 1, 1));
            }
        }
        this.dsfListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName().equals("depnames")) {
                    DataPanel.this.updateSliceTypeComboBox(newDsf, false);
                }
            }
        };
        this.dsf = newDsf;
        newDsf.getController().addPropertyChangeListener(this.dsfListener);
    }

    private JMenuItem createMenuItem(final String insert, String doc) {
        JMenuItem result = new JMenuItem(new AbstractAction(insert){

            public void actionPerformed(ActionEvent e) {
                String v = DataPanel.this.componentTextField.getText();
                int i = DataPanel.this.componentTextField.getCaretPosition();
                DataPanel.this.componentTextField.setText(v.substring(0, i) + insert + v.substring(i));
            }
        });
        result.setToolTipText(doc);
        return result;
    }

    void initProcessMenu() {
        this.processMenu = new JPopupMenu();
        this.processMenu.add(this.createMenuItem("|histogram()", "perform an \"auto\" histogram of the data that automatically sets bins. "));
        this.processMenu.add(this.createMenuItem("|logHistogram()", "perform the auto histogram in the log space."));
        this.processMenu.add(this.createMenuItem("|log10()", "take the base-10 log of the data."));
        this.processMenu.add(this.createMenuItem("|exp10()", "plot pow(10,ds)"));
        this.processMenu.add(this.createMenuItem("|slice0(0)", "slice the data on the zeroth dimension (often time) at the given index."));
        this.processMenu.add(this.createMenuItem("|slice1(0)", "slice the data on the first dimension at the given index."));
        this.processMenu.add(this.createMenuItem("|slices(':',2,3))", "slice the data on the first and second dimensions, leaving the zeroth alone."));
        this.processMenu.add(this.createMenuItem("|collapse0()", "average over the zeroth dimension to reduce the dimensionality."));
        this.processMenu.add(this.createMenuItem("|collapse1()", "average over the first dimension to reduce the dimensionality."));
        this.processMenu.add(this.createMenuItem("|transpose()", "transpose the rank 2 dataset."));
        this.processMenu.add(this.createMenuItem("|fftPower(128)", "plot power spectrum by breaking waveform data in windows of length size (experimental, not for publication)."));
        this.processMenu.add(this.createMenuItem("|smooth(5)", "boxcar average over the rank 1 data"));
        this.processMenu.add(this.createMenuItem("|diff()", "finite differences between adjacent elements in the rank 1 data."));
        this.processMenu.add(this.createMenuItem("|accum()", "running sum of the rank 1 data. (opposite of diff)."));
        this.processMenu.add(this.createMenuItem("|grid()", "grid the rank2 buckshot but gridded data into a rank 2 table."));
        this.processMenu.add(this.createMenuItem("|flatten()", "flatten a rank 2 dataset. The result is a n,3 dataset of [x,y,z]. (opposite of grid)"));
        this.processMenu.add(this.createMenuItem("|negate()", "flip the sign on the data."));
        this.processMenu.add(this.createMenuItem("|cos()", "cos of the data in radians. (No units check)"));
        this.processMenu.add(this.createMenuItem("|sin()", "sin of the data in radians. (No units check)"));
        this.processMenu.add(this.createMenuItem("|toDegrees()", "convert the data to degrees. (No units check)"));
        this.processMenu.add(this.createMenuItem("|toRadians()", "convert the data to radians. (No units check) "));
        this.processMenu.add(this.createMenuItem("|magnitude()", "calculate the magnitude of the vectors "));
        this.processMenu.add(this.createMenuItem("|unbundle('Bx')", "unbundle a component "));
    }

    void showProcessMenu(MouseEvent ev) {
        this.initProcessMenu();
        this.processMenu.show(ev.getComponent(), ev.getX(), ev.getY());
    }

    private void initComponents() {
        this.jPanel2 = new JPanel();
        this.sliceTypeComboBox = new JComboBox();
        this.sliceIndexSpinner = new JSpinner();
        this.sliceIndexLabel = new JLabel();
        this.transposeCheckBox = new JCheckBox();
        this.operationsLabel = new JLabel();
        this.componentTextField = new JTextField();
        this.doSliceCheckBox = new JCheckBox();
        this.sliceAutorangesCB = new JCheckBox();
        this.jPanel1 = new JPanel();
        this.validRangeLabel = new JLabel();
        this.validRangeComboBox = new JComboBox();
        this.fillValueLabel = new JLabel();
        this.fillValueComboBox = new JComboBox();
        this.jPanel3 = new JPanel();
        this.uriTextField = new JTextField();
        this.jPanel2.setBorder(BorderFactory.createTitledBorder("Data Post Processing [?]\n"));
        this.jPanel2.setToolTipText("When the operations field starts with the pipe (|) character, it is a list of filters that are to be applied to the data.  Otherwise it is the component of the dataset to plot, such as \"Bx\".  GUI controls for slicing are provided as well, and these simply control the string.");
        this.sliceTypeComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"first", "second", "last"}));
        this.sliceTypeComboBox.setSelectedIndex(2);
        this.sliceTypeComboBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                DataPanel.this.sliceTypeComboBoxItemStateChanged(evt);
            }
        });
        this.sliceTypeComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DataPanel.this.sliceTypeComboBoxActionPerformed(evt);
            }
        });
        this.sliceIndexSpinner.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                DataPanel.this.sliceIndexSpinnerStateChanged(evt);
            }
        });
        this.sliceIndexLabel.setText("Slice Index:");
        this.transposeCheckBox.setText("Transpose");
        this.transposeCheckBox.setToolTipText("Transpose the rank 2 dataset after slicing.\n");
        this.transposeCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DataPanel.this.transposeCheckBoxActionPerformed(evt);
            }
        });
        this.operationsLabel.setText("Operations:");
        this.operationsLabel.setToolTipText("Process string that specifies component to plot, or how a data set's dimensionality should be reduced before display.");
        this.componentTextField.setText(" ");
        this.componentTextField.setToolTipText("Process string that specifies component to plot, or how a data set's dimensionality should be reduced before display.");
        this.componentTextField.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent evt) {
                DataPanel.this.componentTextFieldMousePressed(evt);
            }

            public void mouseReleased(MouseEvent evt) {
                DataPanel.this.componentTextFieldMouseReleased(evt);
            }
        });
        this.componentTextField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DataPanel.this.componentTextFieldActionPerformed(evt);
            }
        });
        this.componentTextField.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent evt) {
                DataPanel.this.componentTextFieldFocusGained(evt);
            }

            public void focusLost(FocusEvent evt) {
                DataPanel.this.componentTextFieldFocusLost(evt);
            }
        });
        this.doSliceCheckBox.setText("Slice Dimension");
        this.doSliceCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DataPanel.this.doSliceCheckBoxActionPerformed(evt);
            }
        });
        this.sliceAutorangesCB.setText("Slice Autoranges");
        this.sliceAutorangesCB.setToolTipText("Changing the slice index will re-autorange the data");
        GroupLayout jPanel2Layout = new GroupLayout((Container)this.jPanel2);
        this.jPanel2.setLayout((LayoutManager)jPanel2Layout);
        jPanel2Layout.setHorizontalGroup((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel2Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel2Layout.createSequentialGroup().add((Component)this.operationsLabel).add(18, 18, 18).add((Component)this.componentTextField, -1, 318, Short.MAX_VALUE)).add((GroupLayout.Group)jPanel2Layout.createSequentialGroup().add((Component)this.doSliceCheckBox).addPreferredGap(0).add((Component)this.sliceTypeComboBox, 0, 260, Short.MAX_VALUE).add(18, 18, 18)).add((GroupLayout.Group)jPanel2Layout.createSequentialGroup().add(12, 12, 12).add((Component)this.sliceIndexLabel).addPreferredGap(0).add((Component)this.sliceIndexSpinner, -2, 104, -2).addPreferredGap(0).add((Component)this.sliceAutorangesCB)).add((Component)this.transposeCheckBox)).addContainerGap()));
        jPanel2Layout.setVerticalGroup((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel2Layout.createSequentialGroup().add((GroupLayout.Group)jPanel2Layout.createParallelGroup(3).add((Component)this.operationsLabel).add((Component)this.componentTextField, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)jPanel2Layout.createParallelGroup(3).add((Component)this.doSliceCheckBox).add((Component)this.sliceTypeComboBox, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)jPanel2Layout.createParallelGroup(3).add((Component)this.sliceIndexLabel).add((Component)this.sliceIndexSpinner, -2, -1, -2).add((Component)this.sliceAutorangesCB)).addPreferredGap(0).add((Component)this.transposeCheckBox).addContainerGap(86, Short.MAX_VALUE)));
        this.jPanel1.setBorder(BorderFactory.createTitledBorder("Data Source [?]"));
        this.jPanel1.setToolTipText("Additional processes applied to the data after loading.  For example, data source typically identifies fill, but in case this is done improperly, the value can be set here.");
        this.validRangeLabel.setText("Valid Range:");
        this.validRangeLabel.setToolTipText("Measurements within this range are considered valid.  This field may be changed to exclude outliers or data that has not automatically been detected as fill.\n");
        this.validRangeComboBox.setEditable(true);
        this.validRangeComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"", "-1e30 to 1e30", "-1 to 101", "0 to 1e38"}));
        this.validRangeComboBox.setToolTipText("Measurements within this range are considered valid.  This field may be changed to exclude outliers or data that has not automatically been detected as fill. ");
        this.validRangeComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DataPanel.this.validRangeComboBoxActionPerformed(evt);
            }
        });
        this.fillValueLabel.setText("Fill Value:");
        this.fillValueLabel.setToolTipText("This value is used to identify invalid data that should not be plotted.");
        this.fillValueComboBox.setEditable(true);
        this.fillValueComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"", "-1e31", "0.0", "-1"}));
        this.fillValueComboBox.setToolTipText("This value is used to identify invalid data that should not be plotted.");
        this.fillValueComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DataPanel.this.fillValueComboBoxActionPerformed(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout((Container)this.jPanel1);
        this.jPanel1.setLayout((LayoutManager)jPanel1Layout);
        jPanel1Layout.setHorizontalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((Component)this.validRangeLabel).add((Component)this.fillValueLabel)).addPreferredGap(0).add((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((Component)this.fillValueComboBox, -2, -1, -2).add((Component)this.validRangeComboBox, -2, -1, -2)).addContainerGap(177, Short.MAX_VALUE)));
        jPanel1Layout.setVerticalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().add((GroupLayout.Group)jPanel1Layout.createParallelGroup(3).add((Component)this.validRangeLabel).add((Component)this.validRangeComboBox, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)jPanel1Layout.createParallelGroup(3).add((Component)this.fillValueLabel).add((Component)this.fillValueComboBox, -2, -1, -2)).addContainerGap(23, Short.MAX_VALUE)));
        this.jPanel3.setBorder(BorderFactory.createTitledBorder("Data Address (URI)"));
        this.jPanel3.setToolTipText("The Data Address, or URI, identifies the data that is loaded.  Plug-in data sources, resolved from this address, are used to load in the data for the given URI.  (This is not editable, but will be soon.)");
        this.uriTextField.setEditable(false);
        this.uriTextField.setFont(this.uriTextField.getFont().deriveFont((float)this.uriTextField.getFont().getSize() - 2.0f));
        this.uriTextField.setText("This will be the current focus URI");
        this.uriTextField.setToolTipText("After the data is loaded, the plot element can apply additional operations before displaying the data.  ");
        GroupLayout jPanel3Layout = new GroupLayout((Container)this.jPanel3);
        this.jPanel3.setLayout((LayoutManager)jPanel3Layout);
        jPanel3Layout.setHorizontalGroup((GroupLayout.Group)jPanel3Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel3Layout.createSequentialGroup().addContainerGap().add((Component)this.uriTextField, -1, 410, Short.MAX_VALUE).addContainerGap()));
        jPanel3Layout.setVerticalGroup((GroupLayout.Group)jPanel3Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel3Layout.createSequentialGroup().add((Component)this.uriTextField, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (Component)this.jPanel3, -1, -1, Short.MAX_VALUE).add(2, (Component)this.jPanel2, -1, -1, Short.MAX_VALUE).add((Component)this.jPanel1, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jPanel3, -2, -1, -2).addPreferredGap(0).add((Component)this.jPanel1, -2, -1, -2).addPreferredGap(0).add((Component)this.jPanel2, -2, -1, -2)));
    }

    private void sliceTypeComboBoxItemStateChanged(ItemEvent evt) {
        this.updateComponent();
    }

    private synchronized void sliceTypeComboBoxActionPerformed(ActionEvent evt) {
        if (this.adjusting) {
            return;
        }
        logger.log(Level.FINE, "set slice dimension {0}", this.sliceTypeComboBox.getSelectedIndex());
        int max = this.dsf.getController().getMaxSliceIndex(this.sliceTypeComboBox.getSelectedIndex());
        if (max > 0) {
            --max;
        }
        this.sliceIndexSpinner.setModel(new SpinnerNumberModel(0, 0, max, 1));
        this.updateComponent();
    }

    private void sliceIndexSpinnerStateChanged(ChangeEvent evt) {
        this.updateComponent();
    }

    private void transposeCheckBoxActionPerformed(ActionEvent evt) {
        this.updateComponent();
    }

    private void componentTextFieldActionPerformed(ActionEvent evt) {
        this.applicationController.getPlotElement().setComponentAutomatically(this.componentTextField.getText());
        this.setAdjusting(false);
        this.componentChanged();
        this.setAdjusting(true);
    }

    private void doSliceCheckBoxActionPerformed(ActionEvent evt) {
        this.updateComponent();
    }

    private void validRangeComboBoxActionPerformed(ActionEvent evt) {
        String s = (String)this.validRangeComboBox.getSelectedItem();
        if (s.equals("(none)")) {
            s = "";
        }
        this.applicationController.getDataSourceFilter().setValidRange(s);
    }

    private void fillValueComboBoxActionPerformed(ActionEvent evt) {
        String s = (String)this.fillValueComboBox.getSelectedItem();
        if (s.equals("(none)")) {
            s = "";
        }
        this.applicationController.getDataSourceFilter().setFill(s);
    }

    private void componentTextFieldFocusGained(FocusEvent evt) {
        this.setAdjusting(true);
    }

    private void componentTextFieldFocusLost(FocusEvent evt) {
        this.setAdjusting(false);
        this.componentChanged();
    }

    private void componentTextFieldMousePressed(MouseEvent evt) {
        if (evt.isPopupTrigger()) {
            this.showProcessMenu(evt);
        }
    }

    private void componentTextFieldMouseReleased(MouseEvent evt) {
        if (evt.isPopupTrigger()) {
            this.showProcessMenu(evt);
        }
    }
}

